<?php
/**
 * The Template for displaying all single posts.
 *
 * @package WordPress
 * @subpackage classiera
 * @since classiera 1.0
 */
get_header(); ?>
	
	<?php while ( have_posts() ) : the_post(); ?>


<?php 

global $redux_demo; 
global $current_user; wp_get_current_user(); $user_ID == $current_user->ID;

$profileLink = get_the_author_meta( 'user_url', $user_ID );
$contact_email = get_the_author_meta('user_email');
$classieraContactEmailError = $redux_demo['contact-email-error'];
$classieraContactNameError = $redux_demo['contact-name-error'];
$classieraConMsgError = $redux_demo['contact-message-error'];
$classieraContactThankyou = $redux_demo['contact-thankyou-message'];
$classieraRelatedCount = $redux_demo['classiera_related_ads_count'];
$category_icon_code = "";
$category_icon_color = "";
$your_image_url = "";

global $nameError;
global $emailError;
global $commentError;
global $subjectError;
global $humanTestError;
global $hasError;

//If the form is submitted
if(isset($_POST['submitted'])) {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST['contactName']) === '') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		} elseif(trim($_POST['contactName']) === 'Name*') {
			$nameError = $classieraContactNameError;
			$hasError = true;
		}	else {
			$name = trim($_POST['contactName']);
		}

		//Check to make sure that the subject field is not empty
		if(trim($_POST['subject']) === '') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		} elseif(trim($_POST['subject']) === 'Subject*') {
			$subjectError = $classiera_contact_subject_error;
			$hasError = true;
		}	else {
			$subject = trim($_POST['subject']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['email']) === ''){
			$emailError = $classieraContactEmailError;
			$hasError = true;		
		}else{
			$email = trim($_POST['email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST['comments']) === '') {
			$commentError = $classieraConMsgError;
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = trim($_POST['comments']);
			}
		}

		//Check to make sure that the human test field is not empty
		$classieraCheckAnswer = $_POST['humanAnswer'];
		if(trim($_POST['humanTest']) != $classieraCheckAnswer) {
			$humanTestError = esc_html__('Not Human', 'classiera');			
			$hasError = true;
		}
		$classieraPostTitle = $_POST['classiera_post_title'];	
		$classieraPostURL = $_POST['classiera_post_url'];
		
		//If there is no error, send the email		
		if(!isset($hasError)) {

			$emailTo = $contact_email;
			$subject = $subject;	
			$body = "Name: $name \n\nEmail: $email \n\nMessage: $comments";
			$headers = 'From <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			//wp_mail($emailTo, $subject, $body, $headers);
			contactToAuthor($emailTo, $subject, $name, $email, $comments, $headers, $classieraPostTitle, $classieraPostURL);
			$emailSent = true;			

		}
}
if(isset($_POST['favorite'])){
	$author_id = $_POST['author_id'];
	$post_id = $_POST['post_id'];
	echo classiera_favorite_insert($author_id, $post_id);
}

?>
<!-- page Heading -->
<?php 
	$titleBg = $redux_demo['title-bg']['url'];
?>
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<div class="post-private">
		<?php
		if ( get_post_status ( $post->ID ) == 'private' ) {
		
			$congMSG =  __( 'Congratulation! Your Ad has submitted and pending for review. After review your Ad will be live for all users. You may not preview it more than once.', 'classiera' );			
			echo do_shortcode( '[notification_box]' . $congMSG . '[/notification_box]' );
		}
		?>
		</div>
		<?php global $current_user; wp_get_current_user(); ?>
		<h3>
		<?php
			if($post->post_author == $current_user->ID && get_post_status ( $post->ID ) == 'publish'){ ?>
			<?php 
				$edit_post_page_id = $redux_demo['edit_post'];
				$postID = $post->ID;

				global $wp_rewrite;
				if ($wp_rewrite->permalink_structure == '')
					//we are using ?page_id
				$edit_post = $edit_post_page_id."&post=".$postID;
				else
				//we are using permalinks
				$edit_post = $edit_post_page_id."?post=".$postID;
				?>	
				<a href="<?php echo $edit_post; ?>"><?php esc_html_e( 'Edit', 'classiera' ); ?></a>						
			<?php }elseif( current_user_can('administrator') ) { ?> 
				<?php 
					$edit_post_page_id = $redux_demo['edit_post'];
					$postID = $post->ID;
					global $wp_rewrite;
					if ($wp_rewrite->permalink_structure == '')
						//we are using ?page_id
					$edit_post = $edit_post_page_id."&post=".$postID;
					else
						//we are using permalinks
					$edit_post = $edit_post_page_id."?post=".$postID;
				?>
					<a href="<?php echo $edit_post; ?>"><?php _e( 'Edit', 'classiera' ); ?></a>
			<?php } ?>
			<?php the_title(); ?>
		</h3>
		<span class="ad-page-price">
			<?php $category = get_the_category();				
			if ($category) {
				echo '<a href="' . get_category_link( $category[0]->term_id ) . '" title="' . sprintf( __( "View all posts in %s", "classiera" ), $category[0]->name ) . '" ' . '>' . $category[0]->name.'</a> ';
				}
				?>
		</span>
	</div><!-- Heading ROW -->
</section><!-- End page Heading -->
<section id="advertisement">
	<div class="row">
		<!-- image slider -->
		<div class="large-8 medium-12 columns">
			<?php 
				$attachments = get_children(array('post_parent' => $post->ID,
							'post_status' => 'inherit',
							'post_type' => 'attachment',
							'post_mime_type' => 'image',
							'order' => 'ASC',
							'orderby' => 'menu_order ID'));
			?>
			<?php if ( has_post_thumbnail()) { ?>
			<section class="imageSlider">				
				<div class="example-orbit" data-orbit>
					<?php $fetIMG = get_post_meta($post->ID, 'featured_img', true); ?>
					
					<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; 
					$params = array( 'width' => 770, 'height' => 480, 'crop' => true );
					$params2 = array( 'width' => 770, 'height' => 480, 'crop' => true );
					$params_small = array( 'width' => 100, 'height' => 70, 'crop' => true );
					
					if(empty($attachments)){						
						if ( has_post_thumbnail()) {
							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
							if(!empty($image[0])){
								echo "<div data-orbit-slide='headline-1'><img src='" . bfi_thumb( $image[0], $params2 ) . "' /></div>";
							}	
						}	
					}
					$count = 0;
					foreach($attachments as $att_id => $attachment) {							
						$full_img_url = wp_get_attachment_url($attachment->ID);
						if($fetIMG == $count){
							set_post_thumbnail( $post->ID, $attachment->ID );
							echo "<div data-orbit-slide='headline-$count'><img src='" .$full_img_url. "', data-big='" . $full_img_url . "'' /></div>";
						}
						$count++;
					} 
					$count = 0;					
					foreach($attachments as $att_id => $attachment) {
						$full_img_url = wp_get_attachment_url($attachment->ID);
						if($fetIMG != $count){	
							echo "<div data-orbit-slide='headline-$count'><img src='" .$full_img_url. "', data-big='" . $full_img_url . "'' /></div>";
						}
						$count++;
					}
					?>
				</div>
				<div class="orbitSlide"><!--Small thumb -->
					<?php require_once get_template_directory() . '/inc/BFI_Thumb.php';
					$params = array( 'width' => 470, 'height' => 350, 'crop' => true );
					$params2 = array( 'width' => 470, 'height' => 350, 'crop' => true );
					$params_small = array( 'width' => 100, 'height' => 70, 'crop' => true );
					if(empty($attachments)){
						if ( has_post_thumbnail()) {
							$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
							if(!empty($image[0])){
								echo "<div data-orbit-slide='headline-1'><img src='" . bfi_thumb( $image[0], $params2 ) . "' /></div>";
							}	
						}	
					}
					$count = 0;
					foreach($attachments as $att_id => $attachment) {
						$full_img_url = wp_get_attachment_url($attachment->ID);
						if($fetIMG == $count){
							set_post_thumbnail( $post->ID, $attachment->ID );
							echo "<a data-orbit-link='headline-$count'><img src='" . bfi_thumb( $full_img_url, $params ) . "', data-big='" . $full_img_url . "'' /></a>";
						}
						$count++;
					} 
					$count = 0;
					foreach($attachments as $att_id => $attachment) {
						$full_img_url = wp_get_attachment_url($attachment->ID);
						if($fetIMG != $count){								
							echo "<a data-orbit-link='headline-$count'><img src='" . bfi_thumb( $full_img_url, $params ) . "', data-big='" . $full_img_url . "'' /></a>";
						}
						$count++;
					}
					?>
				</div><!--Small thumb -->
			</section><!--end image slider-->
			<?php }?>
			<?php $postVideo = get_post_meta($post->ID, 'post_video', true); ?>
			<?php if(!empty($postVideo)) { ?>
			<?php 
			if(preg_match("/youtu.be\/[a-z1-9.-_]+/", $postVideo)) {
				preg_match("/youtu.be\/([a-z1-9.-_]+)/", $postVideo, $matches);
				if(isset($matches[1])) {
					$url = 'http://www.youtube.com/embed/'.$matches[1];
					$video = '<iframe width="710" height="400" src="'.$url.'" frameborder="0" allowfullscreen></iframe>';
				}
			}elseif(preg_match("/youtube.com(.+)v=([^&]+)/", $postVideo)) {
				preg_match("/v=([^&]+)/", $postVideo, $matches);
				if(isset($matches[1])) {
					$url = 'http://www.youtube.com/embed/'.$matches[1];
					$video = '<iframe width="710" height="400" src="'.$url.'" frameborder="0" allowfullscreen></iframe>';
				}
			}elseif(preg_match("#https?://(?:www\.)?vimeo\.com/(\w*/)*(([a-z]{0,2}-)?\d+)#", $postVideo)) {
				preg_match("/vimeo.com\/([1-9.-_]+)/", $postVideo, $matches);
				//print_r($matches); exit();
				if(isset($matches[1])) {
					$url = 'https://player.vimeo.com/video/'.$matches[1];
					$video = '<iframe width="710" height="400" src="'.$url.'" frameborder="0" allowfullscreen webkitallowfullscreen mozallowfullscreen></iframe>';
				}
			}else{
				$video = $postVideo;
			}
			?>
			<section class="videoDetail boxPad">
				<div class="adHeading">
					<i class="fa fa-video-camera"></i>
					<h4><?php esc_html_e('Video', 'classiera') ?></h4>
                </div>
				<div class="row">
					<div class="large-12 medium-12 columns">
						<div id="ab-video"><?php echo $video; ?></div>
					</div>
				</div>
			</section>
			<?php } ?>
			<!-- Ad Deatil -->
			<section class="adDetail boxPad">
				<?php 						
						
						$category = get_the_category();
							if ($category[0]->category_parent == 0) {
								$tag = $category[0]->cat_ID;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
							}else{
								$tag = $category[0]->category_parent;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
							}	
						if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;
							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}	
					?>
				<div class="adHeading">
					<i style="background:<?php echo $category_icon_color; ?>;" class="<?php echo $category_icon_code; ?>"></i>
					<h4><?php esc_html_e('Ad Detail', 'classiera') ?></h4>
                </div>
				<div class="adDetails">
					<ul class="inline-list">
						<?php $post_price = get_post_meta($post->ID, 'post_price', true);  ?>
						<?php if(!empty($post_price)) {?>
							<li><span><?php esc_html_e( 'Sale Price', 'classiera' ); ?></span><?php echo $post_price; ?></li>
						<?php }?>
						<?php global $redux_demo;?>
						<?php $saleprice= $redux_demo['regularpriceon']; ?>
						<?php if($saleprice == 1){?>
						<?php $post_old_price = get_post_meta($post->ID, 'post_old_price', true);  ?>
							<?php if(!empty($post_old_price)) {?>
								<li><span><?php esc_html_e( 'Regular Price', 'classiera' ); ?></span><?php echo $post_old_price; ?></li>
							<?php }?>
						<?php }?>
						
						<li><span>
						<?php $dateFormat = get_option( 'date_format' );?>
						<?php esc_html_e( 'Added', 'classiera' ); ?></span>
						<?php echo get_the_date($dateFormat, $post->ID); ?>
						</li>
						
						<!--Item Condition-->
						<?php global $redux_demo; ?>
						<?php $adpostCondition= $redux_demo['adpost-condition']; ?>
						<?php if($adpostCondition == 1){ ?>
						<?php $itemCondition = get_post_meta($post->ID, 'item-condition', true); ?>
							<?php if(!empty($itemCondition)) {?>
							<li><span><?php esc_html_e( 'Condition', 'classiera' ); ?></span><?php echo $itemCondition; ?></li>
							<?php }?>
						<?php }?>
						<!--Item Condition-->
						
						<?php $post_location = get_post_meta($post->ID, 'post_location', true);
						
						?>
							<?php if(!empty($post_location)) {?>
								<li><span><?php esc_html_e( 'Location', 'classiera' ); ?></span><?php echo $post_location; ?></li>
							<?php }?>
						
						
						<?php $locationsStateOn= $redux_demo['location_states_on']; ?>
						<?php if($locationsStateOn == 1){?>
							<?php $post_state = get_post_meta($post->ID, 'post_state', true);  ?>
							<?php if(!empty($post_state)) {?>
							<li><span><?php esc_html_e( 'State', 'classiera' ); ?></span><?php echo $post_state; ?></li>
							<?php }?>
						<?php }?>
						
						<?php $locationsCityOn= $redux_demo['location_city_on']; ?>
						<?php if($locationsCityOn == 1){ ?>
							<?php $post_city = get_post_meta($post->ID, 'post_city', true);  ?>
							<?php if(!empty($post_city)) {?>
							<li><span><?php esc_html_e( 'City', 'classiera' ); ?></span><?php echo $post_city; ?></li>
							<?php }?>
						<?php }?>
						
						<?php global $redux_demo;?>
						<?php $phoneon= $redux_demo['phoneon']; ?>
						<?php if($phoneon == 1){?>
							<?php $post_phone = get_post_meta($post->ID, 'post_phone', true);  ?>
							<?php if(!empty($post_phone)) {?>
							<li><span><?php esc_html_e( 'Phone', 'classiera' ); ?></span><?php echo $post_phone; ?></li>
							<?php }?>	
						<?php }?>
						<!--Custom Fields -->
						<?php
						$pID = $post->ID;
						if(function_exists('classiera_show_CF_FE')){
							echo classiera_show_CF_FE($pID);
						}
									$classieraCustomFields = get_post_meta($post->ID, 'custom_field', true);
									//print_r($classieraCustomFields);

									if(!empty($classieraCustomFields)) {
										for ($i = 0; $i < count($classieraCustomFields); $i++) {
											
											if($classieraCustomFields[$i][2] != 'dropdown' && $classieraCustomFields[$i][2] != 'checkbox'){
												
												?>
												<?php if(!empty($classieraCustomFields[$i][1]) && !empty($classieraCustomFields[$i][0]) ) { ?>
												<li>
													<span>
														<?php echo $classieraCustomFields[$i][0]; ?>
													</span>
													<?php echo $classieraCustomFields[$i][1]; ?>
												</li>

												<?php }  ?>
											<?php } ?>
										<?php }
										
										for ($i = 0; $i < count($classieraCustomFields); $i++) {
											
											if($classieraCustomFields[$i][2] == 'dropdown'){
												?>
												<?php if(!empty($classieraCustomFields[$i][1]) && !empty($classieraCustomFields[$i][0]) ) { ?>
												<li>
													<span>
														<?php echo $classieraCustomFields[$i][0]; ?>
													</span>
														<?php echo $classieraCustomFields[$i][1]; ?>
												</li>

												<?php }  ?>
											<?php } ?>
										<?php }  ?>	
											<!--CheckBox-->
											<?php for ($i = 0; $i < count($classieraCustomFields); $i++) {
											
											if($classieraCustomFields[$i][2] == 'checkbox'){
												?>
												<?php if(!empty($classieraCustomFields[$i][1]) && !empty($classieraCustomFields[$i][0]) ) { ?>
												<li>
													<span>
														<?php echo $classieraCustomFields[$i][0]; ?>
													</span>
														<?php esc_html_e( 'Yes', 'classiera' ); ?>
												</li>

												<?php }  ?>
											<?php } ?>
										<?php }  ?>	
											<!--Checkbox-->
										
									<?php } ?>
						<!--Custom Fields -->
						<li><span><?php esc_html_e( 'Views', 'classiera' ); ?></span><?php echo classiera_get_post_views(get_the_ID()); ?></li>
						
					</ul>
					<div class="classiera-rating">
						<?php if(function_exists('the_ratings')) { ?>
						<span><?php esc_html_e( 'Rating', 'classiera' ); ?></span>
						<?php the_ratings(); ?>
						<?php } ?>
					</div><!-- End classiera-rating -->
				</div><!-- End adDetails -->
				<div class="follow-btn">
					<?php if ( is_user_logged_in() ) { 
						global $current_user;
						wp_get_current_user();
						$user_id = $current_user->ID;
						if(isset($user_id)){
							if($user_ID != $user_id){							
							echo classiera_authors_follower_check($user_ID, $user_id);
							}
						}
					} ?>
					<?php 
					if(isset($user_id)){
						echo classiera_authors_favorite_check($user_id,$post->ID); 
					}
					?>
				</div>
				<div class="adDescription">
					<h4><?php esc_html_e( 'Description', 'classiera' ); ?></h4>					
						<?php echo the_content(); ?>
						<?php //echo appply_filters('the_content', substr(get_the_content(), 0, 500) ); ?>
				</div><!-- End adDescription -->
				<div class="share">
					<div class="row collapse">
						<div class="large-6 medium-6 columns">
							<div class="tags">	
								<span class="shareIcon"><i class="fa fa-tags"></i><?php esc_html_e( 'Tags', 'classiera' ); ?> : </span>									
								<?php the_tags('','',''); ?>
							</div>
						</div><!-- End Tags Section -->
						<div class="large-6 medium-6 columns line">
							<span class="shareIcon">
								<i class="fa fa-share-alt"></i>
								<?php esc_html_e( 'Share', 'classiera' ); ?>&nbsp;:&nbsp;
                            </span>
							<ul class="rrssb-buttons inline-list">
								<li class="rrssb-facebook">
									<a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" class="popup">
										<i class="fa fa-facebook"></i>
                                    </a>
								</li>
								<li class="rrssb-twitter">
									<a href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>"
                                        class="popup">
                                        <i class="fa fa-twitter"></i>
                                     </a>
								</li>
								<li class="rrssb-googleplus">                                    
                                    <a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" class="popup">
                                          <i class="fa fa-google-plus"></i>
                                    </a>
                                </li>								
								<li class="rrssb-linkedin">
									<a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink(); ?>&title=<?php the_title(); ?>&summary=<?php //the_content(); ?>&source=<?php the_permalink(); ?>" class="popup">
                                        <i class="fa fa-linkedin"></i>
                                    </a>
								</li>
								<li class="rrssb-email" data-initwidth="10">
									<a href="mailto:<?php echo bloginfo('admin_email'); ?>?&subject=<?php the_title(); ?>&body=<?php //the_content(0,20); ?>">
                                        <i class="fa fa-paper-plane"></i>
                                    </a>
								</li>
							</ul>
						</div><!-- End share icon -->
					</div>
				</div><!-- End share -->
			</section><!-- End Ad Deatil -->
			<?php 
			global $redux_demo;
			$googleMapadPost = $redux_demo['google-map-adpost'];
			$locShownBy = $redux_demo['location-shown-by'];	
			if($googleMapadPost == 1){
			?>
			<!-- location Map -->
			<section class="location boxPad">
			<?php $post_location = get_post_meta($post->ID, $locShownBy, true);  ?>
			<?php if(!empty($post_location)) {?>
				<div class="locHeading">
					<i class="fa fa-map-marker"></i>
					<h4><?php echo $post_location; ?></h4>
                </div>
			<?php } ?>	
				<div class="googleMap">
                        <?php 
						$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
						$post_longitude = get_post_meta($post->ID, 'post_longitude', true);
						$post_address = get_post_meta($post->ID, 'post_address', true);
						if(!empty($post_latitude)) {
						?>
					<div id="single-page-map">
						<div id="single-page-main-map"></div>

						<script type="text/javascript">
						var mapDiv,
							map,
							infobox;
						jQuery(document).ready(function($) {

							mapDiv = $("#single-page-main-map");
							mapDiv.height(400).gmap3({
								map: {
									options: {
										"center": [<?php echo $post_latitude; ?>,<?php echo $post_longitude; ?>]
										,"zoom": 16
										,"draggable": true
										,"mapTypeControl": true
										,"mapTypeId": google.maps.MapTypeId.ROADMAP
										,"scrollwheel": false
										,"panControl": true
										,"rotateControl": false
										,"scaleControl": true
										,"streetViewControl": true
										,"zoomControl": true
										<?php global $redux_demo; $map_style = $redux_demo['map-style']; if(!empty($map_style)) { ?>,"styles": <?php echo $map_style; ?> <?php } ?>
									}
								}
								,marker: {
									values: [

									<?php

										$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
										$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

										$theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 40) ? substr($theTitle,0,37).'...' : $theTitle;

										$post_price = get_post_meta($post->ID, 'post_price', true);

						
						$category = get_the_category();
							if ($category[0]->category_parent == 0) {
								$tag = $category[0]->cat_ID;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}else{
								$tag = $category[0]->category_parent;
								$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
								if (isset($tag_extra_fields[$tag])) {
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}
						
						if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}
										if(!empty($your_image_url)) {

											$iconPath = $your_image_url;

										} else {

											$iconPath = get_template_directory_uri() .'/images/icon-services.png';

										}
										$postCatgory = get_the_category( $post->ID );

										?>

												{
													<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; ?>
													<?php 
													$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-grid');
													$thumb_id = get_post_thumbnail_id($post->id);
													$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
													?>

													latLng: [<?php echo $post_latitude; ?>,<?php echo $post_longitude; ?>],
													options: {
														icon: "<?php echo $iconPath; ?>",
														shadow: "<?php echo get_template_directory_uri() ?>/images/shadow.png",
													},
													data: '<section id="advertisement" class="removePad removeMargin noBorder"><div class="row"><div class="advContent"><div class="tabs-content removeMargin"><div class="large-12 medium-12 columns advItems end removeMargin"><div class="advItem"> <div class="advItem-img" id="AdvMapImg"><img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>" /></div><span class="price"><?php echo $post_price; ?></span><a class="hover" href="<?php the_permalink(); ?>"></a><div class="info"><a href="<?php the_permalink(); ?>"><i class="<?php echo $category_icon_code; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i><span class="title"><?php echo $theTitle; ?></span><span class="cat">category &nbsp;:&nbsp;<?php echo $postCatgory[0]->name; ?><span></a></div></div></div></div><div class="close"></div></div></div></section>'
												}	
										
									],
									options:{
										draggable: false
									},
									cluster:{
										radius: 20,
										// This style will be used for clusters with more than 0 markers
										0: {
											content: "<div class='cluster cluster-1'>CLUSTER_COUNT</div>",
											width: 62,
											height: 62
										},
										// This style will be used for clusters with more than 20 markers
										20: {
											content: "<div class='cluster cluster-2'>CLUSTER_COUNT</div>",
											width: 82,
											height: 82
										},
										// This style will be used for clusters with more than 50 markers
										50: {
											content: "<div class='cluster cluster-3'>CLUSTER_COUNT</div>",
											width: 102,
											height: 102
										},
										events: {
											click: function(cluster) {
												map.panTo(cluster.main.getPosition());
												map.setZoom(map.getZoom() + 2);
											}
										}
									},
									events: {
										click: function(marker, event, context){
											map.panTo(marker.getPosition());

											var ibOptions = {
												pixelOffset: new google.maps.Size(-125, -88),
												alignBottom: true
											};

											infobox.setOptions(ibOptions)

											infobox.setContent(context.data);
											infobox.open(map,marker);

											// if map is small
											var iWidth = 560;
											var iHeight = 560;
											if((mapDiv.width() / 2) < iWidth ){
												var offsetX = iWidth - (mapDiv.width() / 2);
												map.panBy(offsetX,0);
											}
											if((mapDiv.height() / 2) < iHeight ){
												var offsetY = -(iHeight - (mapDiv.height() / 2));
												map.panBy(0,offsetY);
											}

										}
									}
								}
											});

							map = mapDiv.gmap3("get");

							infobox = new InfoBox({
								pixelOffset: new google.maps.Size(-50, -65),
								closeBoxURL: '',
								enableEventPropagation: true
							});
							mapDiv.delegate('.infoBox .close','click',function () {
								infobox.close();
							});

							if (Modernizr.touch){
								map.setOptions({ draggable : false });
								var draggableClass = 'inactive';
								var draggableTitle = "Activate map";
								var draggableButton = $('<div class="draggable-toggle-button '+draggableClass+'">'+draggableTitle+'</div>').appendTo(mapDiv);
								draggableButton.click(function () {
									if($(this).hasClass('active')){
										$(this).removeClass('active').addClass('inactive').text("Activate map");
										map.setOptions({ draggable : false });
									} else {
										$(this).removeClass('inactive').addClass('active').text("Deactivate map");
										map.setOptions({ draggable : true });
									}
								});
							}

						});
						</script>
					<!--<div id="ad-address"><span><i class="fa fa-map-marker"></i><?php //echo $post_address; ?></span></div>-->
					<div id="ad-address"><span><i class="fa fa-map-marker"></i><a href="http://maps.google.com/maps?saddr=&daddr=<?php echo $post_address; ?>" target="_blank"><?php esc_html_e( 'Get Directions on Google MAPS to', 'classiera' ); ?>: <?php echo $post_address; ?></a></span></div>
					</div>
					<?php }?>
                </div>
			</section>
			<?php } /* Hide Map Check*/?>
			<section class="authorProfile boxPad">
				<div class="row">
					<div class="large-3 medium-3 columns">
						<div class="authorImage">
							<?php require_once get_template_directory() . '/inc/BFI_Thumb.php'; 
							$user_ID = $post->post_author;
							?>
							<?php $author_avatar_url = get_user_meta($user_ID, "classify_author_avatar_url", true); 
											if(!empty($author_avatar_url)) {
												$params = array( 'width' => 120, 'height' => 120, 'crop' => true );
												echo "<img class='author-avatar' src='" . bfi_thumb( "$author_avatar_url", $params ) . "' alt='' />";
											}else{
												$author_id = get_the_author_meta('user_email', $user_ID);
												//echo $author_id ; exit();
												$avatar_url = classiera_get_avatar_url ($author_id, $size = '150' );?>
												<img class="avatar" src="<?php echo $avatar_url; ?>" alt="" /><?php
											}
											?>
						</div>
						<div class="authorName">
                                <h4><?php echo get_the_author_meta('display_name', $user_ID ); ?></h4>
                        </div>
					</div><!--End Large 3 -->
					<div class="large-9 medium-9 columns">
						<div class="authorDetails">
							<?php $curauth = get_user_by( 'id', get_queried_object()->post_author ); // get the info about the current author ?>
							<?php $classieraAuthorAddress = $curauth->address; 
								if(!empty($classieraAuthorAddress)) {
							?>
								<div class="authorAdress authorbg">
                                    <i class="fa fa-map-marker"></i>
                                    <p><?php esc_html_e('Address', 'classiera'); ?>:<?php echo $classieraAuthorAddress; ?></p>
                                </div>
								<?php }?>
							<?php $curauth = get_user_by( 'id', get_queried_object()->post_author ); // get the info about the current author ?>
							<?php $classieraAuthorPh = $curauth->phone; 
								if(!empty($classieraAuthorPh)) {
							?>
								<div class="authorPhone authorbg">
                                    <i class="fa fa-phone"></i>
                                    <p><?php echo $classieraAuthorPh; ?></p>
                                </div>
								<?php } ?>
							<?php $curauth = get_user_by( 'id', get_queried_object()->post_author ); // get the info about the current author ?>
							<?php $classieraAuthorWeb = $curauth->user_url;
							if(!empty($classieraAuthorWeb)) {	
							?>
								<div class="authorUrl authorbg">
                                    <i class="fa fa-globe"></i>
                                    <p><a href="<?php echo $classieraAuthorWeb; ?>"><?php echo $classieraAuthorWeb; ?></p>
                                </div>
							<?php } ?>
								<div class="viewProfile">
                                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" class="button round"><?php esc_html_e('View Profile', 'classiera'); ?></a>
                                </div>
						</div>
					</div>
				</div>
			</section><!-- End Author Profile -->
			 <!-- author ad -->
			<section class="authorAd">
			<?php 
			$homeAd2 = '';
			$homeAdImg2 = $redux_demo['home_ad2']['url']; 
			$homeAdImglink2 = $redux_demo['home_ad2_url']; 
			$singlePostGoogle = $redux_demo['home_html_ad2'];
			if(!empty($singlePostGoogle) || !empty($homeAdImg2)){
				if(!empty($singlePostGoogle)){
						$homeAd2 = $singlePostGoogle;
				}else{
						$homeAd2 = '<a href="'.$homeAdImglink2.'" target="_blank"><img alt="" src="'.$homeAdImg2.'" /></a>';
				}
			}
			?>	
				<?php echo $homeAd2; ?>
            </section><!-- End author ad -->
			<?php 
				$classieraToAuthor = $redux_demo['author-msg-box-off'];
				if($classieraToAuthor == 1){
			?>
			<section class="authorMsg">
				<div class="authorHead">
					 <h4><?php esc_html_e('TO AUTHOR', 'classiera'); ?></h4>
				</div>
				<div class="authorForm">
					<form name="contactForm" action="<?php the_permalink(); ?>" id="contact-form" method="post" class="contactform" >
						<div class="row">						
						<?php if(isset($emailSent) && $emailSent == true) { ?>
						<span><?php esc_html_e( 'Your Message have been sent!', 'classiera' ); ?></span>
						<?php }elseif($hasError == true && $emailSent != true) {?>
							<div class="large-12 medium-12 columns">
								<h4>
								<?php 
								if(!empty($nameError)){
									echo $nameError."<br />";
								}
								if(!empty($subjectError)){
									echo $subjectError."<br />";
								}
								if(!empty($emailError)){
									echo $emailError."<br />";
								}
								if(!empty($commentError)){
									echo $commentError."<br />";
								}
								if(!empty($humanTestError)){
									echo $humanTestError."<br />";
								}
								?>
								</h4>
							</div>
						<?php }?>
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-user"></i>
									<input type="text" placeholder="<?php esc_html_e( 'Full Name', 'classiera' ); ?>" name="contactName" id="contactName" class="" />
								</div>
							</div><!--End Name-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-envelope"></i>
									<input type="text" placeholder="<?php esc_html_e( 'Email', 'classiera' ); ?>" name="email" id="email" class="" />
								</div>
							</div><!--End Email-->
							<div class="large-12 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-book"></i>
									<input type="text" placeholder="<?php esc_html_e( 'Subject', 'classiera' ); ?>" name="subject" id="subject" class="" />
								</div>
							</div><!--End Subjext-->
							<div class="large-12 columns">
								<div class="inner-addon left-addon">
									<textarea placeholder="<?php esc_html_e( 'Write your message here...', 'classiera' ); ?>" name="comments" id="commentsText" cols="8" rows="5" ></textarea>
								</div>
							</div><!--End Your Message-->
							<?php 
								$classieraFirstNumber = rand(1,9);
								$classieraLastNumber = rand(1,9);
								$classieraNumberAnswer = $classieraFirstNumber + $classieraLastNumber;
							?>
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<p>
									<?php esc_html_e("Human Test: Find the X ", "classiera"); ?><?php echo $classieraFirstNumber; ?> + <?php echo $classieraLastNumber;?> = </p>
								</div>
							</div><!--End test question-->
							<div class="large-6 medium-6 columns">
								<div class="inner-addon left-addon">
									<i class="icon fa fa-pencil"></i>
									<input type="text" placeholder="<?php esc_html_e( 'Your answer', 'classiera' ); ?>" name="humanTest" id="humanTest" value="" class="" />
									<input type="hidden" name="humanAnswer" id="humanAnswer" value="<?php echo $classieraNumberAnswer; ?>" />
									<input type="hidden" name="classiera_post_title" id="classiera_post_title" value="<?php the_title(); ?>" />
									<input type="hidden" name="classiera_post_url" id="classiera_post_url" value="<?php the_permalink(); ?>"  />
								</div>
							</div><!--End Answer Input-->
							<div class="large-12 columns">
								<div class="inner-addon left-addon">
									<input class="button round btnfull" name="submitted" type="submit" value="<?php esc_html_e( 'Send Message', 'classiera' ); ?>" class="input-submit"/>
								</div>
							</div>
						</div>
					</form>
				</div>
			</section><!-- End author Message -->
				<?php } ?>
			<section class="userComments">
				<?php 
					$file ='';
					$separate_comments ='';
					?>
	    			<?php comments_template( $file, $separate_comments ); ?>
			</section><!-- end comments -->
		</div>
		<!-- Sidebar -->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row collapse">
				<?php get_sidebar('pages'); ?>
				</div>
			</section>
		</div><!-- Sidebar End -->
	</div><!-- End Main Row -->
</section><!-- End advertisement -->
<?php endwhile; ?>
<?php 
	global $redux_demo;
	$relatedAdsOn = $redux_demo['related-ads-on'];
if($relatedAdsOn== 1){	
?>
<section id="latestAds">
	<div class="row">
		<div class="authorHead">
			<h4><?php esc_html_e( 'Related ads', 'classiera' ); ?></h4>
		</div>
	</div>
	<section id="premiumAdv">
		<div class="customNavigation">
            <div class="row">
                <div class="medium-4 medium-centered columns">
                    <div class="navText">                        
						<a class="prev"><i class="fa <?php if(is_rtl()){ echo "fa-angle-right";}else{ echo "fa-angle-left"; } ?>"></i></a>
                        <span><?php esc_html_e( 'Previous', 'classiera' ); ?></span>
                        <span><?php esc_html_e( 'Next', 'classiera' ); ?></span>
                        <a class="next"><i class="fa <?php if(is_rtl()){ echo "fa-angle-left";}else{ echo "fa-angle-right"; } ?>"></i></a>
                    </div>
                </div>
            </div>
        </div><!-- End customNavigation -->
		<div id="owl-demo" class="owl-carousel">
			<?php 
				$orig_post = $post; 
				global $post;
				$tags = wp_get_post_tags($post->ID);
				$relatedCat = wp_get_post_categories($post->ID);
				if ($tags || $relatedCat){
					
				$tag_ids = array();
				foreach($tags as $individual_tag)
				$tag_ids[] = $individual_tag->term_id;
				$args=array(  
							'tag__in' => $tag_ids,  
							'post__not_in' => array($post->ID),  
							'posts_per_page'=>$classieraRelatedCount, // Number of related posts to display.  
							'ignore_sticky_posts'=>1,
						);
				$current = -1;
				$my_query = new wp_query( $args );
				$category_icon_code ="";
				$category_icon_color ="";
				$your_image_url ="";
				while( $my_query->have_posts() ) {
					$my_query->the_post();
					global $postID;
					$current++;
					$category = get_the_category();
					if ($category[0]->category_parent == 0) {
						$tag = get_cat_ID( $category[0]->name );
						$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
						if (isset($tag_extra_fields[$tag])) {
							$category_icon_code = $tag_extra_fields[$tag]['category_icon_code']; 
							$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
							$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
						}
					}
					if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}
				?>
					<div class="item">					
						<div class="carousel">
							<?php 
							if ( has_post_thumbnail()) {
								$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-pslider');
								$thumb_id = get_post_thumbnail_id($post->id);
								$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);			
								$postTiti= get_the_title();
								?>
							<div class="premiumIMG"><img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/></div>
								<?php
							}else{							
							?>
							<div class="premiumIMG">
								<img src="<?php echo get_template_directory_uri() . '/images/nothumb/nothumbpslider.png' ?>" alt="No Thumb"/>
							</div>
							<?php }?>
							
							
							<?php $post_price = get_post_meta($post->ID, 'post_price', true); 
								if(!empty($post_price)){
							?>
							<span class="price"><?php echo $post_price; ?></span>
								<?php }?>
							<div class="hover">
								<a href="<?php the_permalink(); ?>">
									<span class="info">
										<i class="<?php echo $category_icon_code; ?>" style="background-color:<?php echo $category_icon_color; ?>"></i>
										<span class="title"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 40) ? substr($theTitle,0,37).'...' : $theTitle; echo $theTitle; ?></span>
									
										<small><?php esc_html_e( 'Category', 'classiera' ); ?> &nbsp;:&nbsp;<?php echo $category[0]->name ; ?></small> 
									</span>
								</a>
							</div><!--End hover -->
						</div>
					</div>
				<?php }?><!--End while -->
			<?php }?><!--End Main tags if -->
		</div>
	</section><!-- End premiumAdv -->
</section>
<?php } ?>
<!-- Company Section Start-->
<?php 
global $redux_demo; 
$classieraCompany = $redux_demo['partners-on'];
if($classieraCompany == 1){
	get_template_part('templates/company');
} ?>
<!-- Company Section End-->	
<?php get_footer(); ?>