<?php
/**
 * The template for displaying the single blog posts.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that other
 * 'pages' on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Classiera
 * @since Classiera 1.0
 */

get_header();

 ?>
<?php 
	$page = get_page($post->ID);
	$current_page_id = $page->ID;
?>
<?php $page_custom_title = get_post_meta($current_page_id, 'page_custom_title', true); ?>
<?php global $redux_demo; ?> 
<?php $titleBg = $redux_demo['title-bg']['url']; ?>	
<section class="pageHeading" style="background:url(<?php echo $titleBg; ?>);">
	<div class="row">
		<h3><?php the_title(); ?></h3>
		<p><?php echo $page_custom_title; ?></p>
	</div>
</section><!-- End page Heading -->
<!-- Section advertisement -->
<section id="advertisement" class="removePad noBorder">
	<div class="row">
		<div class="large-8 medium-12 columns">
			<div class="blogPost noBorder">
				<div class="blog-post-head blog-post-head-single">
					<h3><?php the_title(); ?></h3>
					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
					<p>
						<i class="fa fa-user"></i>
						<span><?php esc_html_e( 'Posted By', 'classiera' ); ?>:</span>
						<strong><?php the_author(); ?></strong>
						<i class="fa fa-calendar-o"></i>
						<?php $dateFormat = get_option( 'date_format' );?>
						<span><?php echo get_the_date($dateFormat, $post->ID); ?></span>
						<i class="fa fa-comments"></i>
						<span><?php esc_html_e( 'Comments', 'classiera' ); ?></span>
						<strong><?php echo comments_number(); ?></strong>
					</p>
				</div><!-- blog-post-head -->
					<?php if ( has_post_thumbnail() ){ ?>
				<div class="blog-media-single">
					<?php 
					$imageurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'classiera-single');
					$thumb_id = get_post_thumbnail_id($post->id);
					$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
					?>
					<img src="<?php echo $imageurl[0]; ?>" alt="<?php if(empty($alt)){echo "Image";}else{ echo $alt; } ; ?>"/>
				</div><!-- blog-media noBorder -->
					<?php } ?>
				<article class="post removePad">
					<?php $content = the_content(); ?>
				</article><!--article -->
				<div class="row">
					<div class="large-12 columns">
						<div class="blog-single-share">
							<div class="share">
								<div class="row collapse">
									<div class="large-6 medium-6 columns">
										<div class="tags">
											<span class="shareIcon"><i class="fa fa-tags"></i><?php esc_html_e( 'Tags', 'classiera' ); ?> : </span>
											<?php echo get_the_term_list( $post->ID, 'post_tag', '<ul class="inline-list"><li>', '</li><li>', '</li></ul>' ); ?>
										</div><!--tags -->
									</div><!--large-6 medium-6 columns -->
									<div class="large-6 medium-6 columns line">
										<span class="shareIcon">
											<i class="fa fa-share-alt"></i>
											<?php esc_html_e( 'Share', 'classiera' ); ?>&nbsp;:&nbsp;
										</span>
										<ul class="rrssb-buttons inline-list">
											<li class="rrssb-facebook">
												<a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" class="popup">
													<i class="fa fa-facebook"></i>
												</a>
											</li>
											<li class="rrssb-twitter">
												<a href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>"
													class="popup">
													<i class="fa fa-twitter"></i>
												 </a>
											</li>
											<li class="rrssb-googleplus">                                    
												<a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" class="popup">
													  <i class="fa fa-google-plus"></i>
												</a>
											</li>
										</ul>
									</div><!--large-6 medium-6 columns -->
								</div><!--row -->
							</div><!--share -->
						</div><!--blog-single-share -->
					</div><!--large-12 columns -->
				</div><!--row -->
				<?php endwhile; endif; ?>
			</div><!-- blogPost noBorder -->
			<!-- comments Start-->
			<section class="userComments">
				<?php 
					$file ='';
					$separate_comments ='';
					?>
	    			<?php comments_template( $file, $separate_comments ); ?>
			</section>
			<!-- comments End-->
		</div><!-- large-8 medium-12 columns -->
		<!-- Sidebar Start-->
		<div class="large-4 medium-12 columns">
			<section class="sidebar">
				<div class="row">
					<?php get_sidebar('blog'); ?>
				</div>
			</section>
		</div>
		<!-- Sidebar End-->
	</div><!-- Row -->
</section>
<!-- Section advertisement End -->
<?php get_footer(); ?>