<?php
/**
 * Initialize the custom theme options.
 */
add_action( 'admin_init', 'mnky_custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 */
function mnky_custom_theme_options() {
  
  /* OptionTree is not loaded yet */
  if ( ! function_exists( 'ot_settings_id' ) )
    return false;
    
  /**
   * Get a copy of the saved settings array. 
   */
  $saved_settings = get_option( ot_settings_id(), array() );
  
  /**
   * Custom settings array that will eventually be 
   * passes to the OptionTree Settings API Class.
   */
  $custom_settings = array( 
    'contextual_help' => array( 
      'sidebar'       => ''
    ),
    'sections'        => array( 
      array(
        'id'          => 'general',
        'title'       => __( 'General Options', 'care' )
      ),
      array(
        'id'          => 'header_options',
        'title'       => __( 'Header', 'care' )
      ),
      array(
        'id'          => 'title_options',
        'title'       => __( 'Title Area', 'care' )
      ),
      array(
        'id'          => 'color_options',
        'title'       => __( 'Content Colors', 'care' )
      ),
      array(
        'id'          => 'typography',
        'title'       => __( 'Typography', 'care' )
      ),
      array(
        'id'          => 'footer_options',
        'title'       => __( 'Footer', 'care' )
      ),
      array(
        'id'          => 'blog_options',
        'title'       => __( 'Blog &amp; Posts', 'care' )
      ),
      array(
        'id'          => 'woocommerce',
        'title'       => __( 'WooCommerce', 'care' )
      ),
      array(
        'id'          => 'custom_css',
        'title'       => __( 'Custom CSS', 'care' )
      ),
      array(
        'id'          => 'import_data',
        'title'       => __( 'Import Demo', 'care' )
      ),
      array(
        'id'          => 'import_successful',
        'title'       => __( 'Import Successful', 'care' )
      )
    ),
    'settings'        => array( 
      array(
        'id'          => 'primary_tab',
        'label'       => __( 'Primary', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'accent_color',
        'label'       => __( 'Theme accent color', 'care' ),
        'desc'        => __( 'This will be general color scheme for your website. Click input field for color picker.', 'care' ),
        'std'         => '#3498db',
        'type'        => 'colorpicker',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'layout_style',
        'label'       => __( 'Layout style', 'care' ),
        'desc'        => __( '1. Full width layout <br />
2. Boxed layout', 'care' ),
        'std'         => 'full-width',
        'type'        => 'radio-image',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'header_style',
        'label'       => __( 'Header width', 'care' ),
        'desc'        => __( 'For full width layout you can chose from 2 header styles:<br />
1. Full width<br />
2. Same as content width', 'care' ),
        'std'         => 'fixed-width',
        'type'        => 'radio-image',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'layout_style:is(full-width)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'content_width',
        'label'       => __( 'Content width', 'care' ),
        'desc'        => __( 'This setting will apply selected layout width to your website.', 'care' ),
        'std'         => '980',
        'type'        => 'radio',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => '940',
            'label'       => __( '940px', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => '980',
            'label'       => __( '980px', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => '1100',
            'label'       => __( '1100px', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'scroll_to_top_button',
        'label'       => __( 'Scroll to top button', 'care' ),
        'desc'        => __( 'Enable or disable "To Top" button when you scroll down.', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'page_comments',
        'label'       => __( 'Comments on page', 'care' ),
        'desc'        => __( 'Turn ON or OFF comments on pages.', 'care' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'body_background',
        'label'       => __( 'Body background', 'care' ),
        'desc'        => __( 'Choose body background for boxed layout.', 'care' ),
        'std'         => '',
        'type'        => 'background',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'layout_style:is(boxed)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'use_pattern',
        'label'       => __( 'Predefined pattern', 'care' ),
        'desc'        => __( 'Select background pattern for boxed layout.', 'care' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'layout_style:is(boxed)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'background_pattern',
        'label'       => __( 'Patterns', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'radio-image',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'layout_style:is(boxed),use_pattern:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'favicon_tab',
        'label'       => __( 'Favicons', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'favicon',
        'label'       => __( 'Favicon', 'care' ),
        'desc'        => __( 'Size 16x16 px. Upload image in .ico format.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'iphone_favicon',
        'label'       => __( 'iPhone icon', 'care' ),
        'desc'        => __( 'If set, anyone who saves your webpage to the home screen will see a nice app-like icon. <br />
Recommended image format is .png. <br />
Size 60x60 px.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'iphone_favicon_retina',
        'label'       => __( 'iPhone retina icon', 'care' ),
        'desc'        => __( 'Size 120x120 px.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'ipad_favicon',
        'label'       => __( 'iPad icon', 'care' ),
        'desc'        => __( 'Size 76x76 px.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'ipad_favicon_retina',
        'label'       => __( 'iPad retina icon', 'care' ),
        'desc'        => __( 'Size 152x152 px.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'code_tab',
        'label'       => __( 'Analytics &amp; Custom code', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'tracking_code',
        'label'       => __( 'Analytics / tracking code', 'care' ),
        'desc'        => __( 'Paste your Google Analytics or other tracking code in text area. Or any code to be placed before <code><span>&lt;</span>/head&gt;</code> in header file.', 'care' ),
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'general',
        'rows'        => '10',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'code_before_body',
        'label'       => __( 'Code before <span>&lt;</span>/body&gt;', 'care' ),
        'desc'        => __( 'Add your custom code in footer before <code><span>&lt;</span>/body&gt;</code> tag.', 'care' ),
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'general',
        'rows'        => '10',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'default_header_tab',
        'label'       => __( 'General', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sticky_header',
        'label'       => __( 'Sticky header', 'care' ),
        'desc'        => __( 'Do you want a header to stick to top while you scroll?', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'header_height',
        'label'       => __( 'Header height', 'care' ),
        'desc'        => __( 'Height of the header area (menu area). Example: <code>65px</code>', 'care' ),
        'std'         => '80px',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'header_bg',
        'label'       => __( 'Header background color', 'care' ),
        'desc'        => __( 'Choose your site header color.', 'care' ),
        'std'         => '#ffffff',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'menu_tab',
        'label'       => __( 'Menu', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'search_button',
        'label'       => __( 'Search button in menu', 'care' ),
        'desc'        => __( 'Enables or disables search from menu.', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'cart_button',
        'label'       => __( 'WooCommerce cart button in menu', 'care' ),
        'desc'        => __( 'Do you want a smart WooCommerce cart icon in main menu?', 'care' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'menu_right',
        'label'       => __( 'Menu margin right', 'care' ),
        'desc'        => __( 'Move your menu horizontally with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'care' ),
        'std'         => '',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'default_menu_link',
        'label'       => __( 'Menu link color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '#444444',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'default_menu_link_h',
        'label'       => __( 'Menu link hover color', 'care' ),
        'desc'        => __( 'Leave empty to use "Theme accent color".', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'menu_hover_bg',
        'label'       => __( 'Menu item background hover color', 'care' ),
        'desc'        => __( 'Background color for hovered menu item. <br />
Leave empty for no hover background.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'menu_bottom_border',
        'label'       => __( 'Menu bottom border', 'care' ),
        'desc'        => __( 'Sets 1px bottom border for menu. <br />
Leave empty for no border.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'show_submenu_styles',
        'label'       => __( 'Show submenu styles?', 'care' ),
        'desc'        => __( 'Enable submenu styling.', 'care' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'submenu_background',
        'label'       => __( 'Submenu background color', 'care' ),
        'desc'        => __( 'Background color for the submenu section. <br />
Leave empty for same color as header.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'submenu_link_color',
        'label'       => __( 'Submenu link color', 'care' ),
        'desc'        => __( 'Color for links in submenu. Leave empty for main menu link color.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'submenu_link_hover_color',
        'label'       => __( 'Submenu link hover color', 'care' ),
        'desc'        => __( 'Hover color for links. Leave empty for main menu link color.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'megamenu_title_color',
        'label'       => __( 'Megamenu column title color', 'care' ),
        'desc'        => __( 'Color for column title inside megamenu.', 'care' ),
        'std'         => '#284b80',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'submenu_hover_bg',
        'label'       => __( 'Submenu item background hover color', 'care' ),
        'desc'        => __( 'Background color for hovered menu item.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'current_submenu_bg',
        'label'       => __( 'Active menu item background color', 'care' ),
        'desc'        => __( 'Background color for active submenu item.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'megamenu_separator_color',
        'label'       => __( 'Submenu link and megamenu column separator color', 'care' ),
        'desc'        => __( 'Leave empty for default color.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'show_submenu_styles:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_tab',
        'label'       => __( 'Logo', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo',
        'label'       => __( 'Logo', 'care' ),
        'desc'        => __( 'Please choose an image file for your logo.', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_retina',
        'label'       => __( 'Logo (Retina version @2x)', 'care' ),
        'desc'        => __( 'Retina logo should be <code>2x</code> the size of default logo keeping the aspect ratio!', 'care' ),
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'retina_logo_width',
        'label'       => __( 'Standart logo width (for retina logo)', 'care' ),
        'desc'        => __( 'If retina logo is uploaded, please enter the STANDARD (1x) logo width.<br />
Remember to add <code>px</code> value in the end. Example: <code>100px</code>', 'care' ),
        'std'         => '',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'retina_logo_height',
        'label'       => __( 'Standart logo height (for retina logo)', 'care' ),
        'desc'        => __( 'If retina logo is uploaded, please enter the STANDARD (1x) logo height.<br />
Remember to add <code>px</code> value in the end. Example: <code>100px</code>code', 'care' ),
        'std'         => '',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_top',
        'label'       => __( 'Margin top', 'care' ),
        'desc'        => __( 'Move your logo vertically with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>px', 'care' ),
        'std'         => '0px',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'logo_left',
        'label'       => __( 'Margin left', 'care' ),
        'desc'        => __( 'Move your logo horizontally with this option. Remember to add <code>px</code> value after the number. For example: <code>25px</code>', 'care' ),
        'std'         => '0px',
        'type'        => 'text',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'top_bar_tab',
        'label'       => __( 'Top bar', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'top_bar',
        'label'       => __( 'Header top bar', 'care' ),
        'desc'        => __( 'Top bar appears in header above the menu. If activated, new widget areas appear in Appearance/Widgets - \'Top Bar Sidebar Left\' and \'Top Bar Sidebar Right\'.', 'care' ),
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'enable_top_bar',
            'label'       => __( 'Enable Top Bar', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'top_bar_bg',
        'label'       => __( 'Background color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '#3498db',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'top_bar:is(on)',
        'operator'    => 'and'
      ),      
	  array(
        'id'          => 'top_bar_border',
        'label'       => __( 'Bottom border color', 'care' ),
        'desc'        => __( 'Set bottom border color for top bar. Leave empty for no border.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'top_bar:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'top_bar_text_color',
        'label'       => __( 'Text and link color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '#ffffff',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'top_bar:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'top_bar_link_hover',
        'label'       => __( 'Link hover color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'header_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'top_bar:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'title_background_tab',
        'label'       => __( 'Background &amp; colors', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'title_bg',
        'label'       => __( 'Background', 'care' ),
        'desc'        => __( 'You can either use color or upload a background image. Leave blank for default setting.', 'care' ),
        'std'         => '',
        'type'        => 'background',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'title_color',
        'label'       => __( 'Title color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'title_border',
        'label'       => __( 'Border color', 'care' ),
        'desc'        => __( 'Set top & bottom border color for title area. Leave empty for no border.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'breadcrumbs_tab',
        'label'       => __( 'Breadcrumbs', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'breadcrumb',
        'label'       => __( 'Breadcrumbs', 'care' ),
        'desc'        => __( 'Enable or disable breadcrumbs under the page or post title.', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'breadcrumbs_color',
        'label'       => __( 'Breadcrumb color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'breadcrumb:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'breadcrumbs_hover_color',
        'label'       => __( 'Breadcrumb hover color', 'care' ),
        'desc'        => __( 'Click input field for color picker or enter your custom value.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'title_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'breadcrumb:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'global_color_section',
        'label'       => __( 'Global', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'body_text_color',
        'label'       => __( 'Body text color', 'care' ),
        'desc'        => __( 'General color for all body content.', 'care' ),
        'std'         => '#575757',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'headings_color',
        'label'       => __( 'Headings (H1, H2, H3, H4, H5, H6)', 'care' ),
        'desc'        => __( 'Color for heading tags. Applies for all heading elements, if different color is not specified in element styling.', 'care' ),
        'std'         => '#284b80',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'link_color',
        'label'       => __( 'Link color', 'care' ),
        'desc'        => __( 'Global link color.', 'care' ),
        'std'         => '#3498db',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'link_hover_color',
        'label'       => __( 'Link hover color', 'care' ),
        'desc'        => __( 'Global link hover color. <br /> To use "Theme accent color" leave empty.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_tab',
        'label'       => __( 'Sidebar', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_text_color',
        'label'       => __( 'Text color', 'care' ),
        'desc'        => __( 'Choose text color for sidebar widget content.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_link_color',
        'label'       => __( 'Link color', 'care' ),
        'desc'        => __( 'Choose color for links in sidebar.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_link_hover_color',
        'label'       => __( 'Link hover color', 'care' ),
        'desc'        => __( 'Leave empty to use "Theme accent color".', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_title_color',
        'label'       => __( 'Widget title color', 'care' ),
        'desc'        => __( 'Color for widget titles in sidebar.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'sidebar_divider_color',
        'label'       => __( 'Widget divider color', 'care' ),
        'desc'        => __( 'Choose border line color separating list items in sidebar.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'misc_color_section',
        'label'       => __( 'Misc', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'meta_color',
        'label'       => __( 'Post meta text color', 'care' ),
        'desc'        => __( 'Set color for post meta fields (tags, date, category, author, comments count) on blog index and single post pages.', 'care' ),
        'std'         => '#3e293e',
        'type'        => 'colorpicker',
        'section'     => 'color_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'custom_fonts_tab',
        'label'       => __( 'Custom fonts', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'body_font',
        'label'       => __( 'Body font', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'typography',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'menu_font',
        'label'       => __( 'Menu font', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'typography',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'heading_font',
        'label'       => __( 'Default heading font', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'typography',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'vc_heading_font',
        'label'       => __( 'Visual Composer heading element font', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'typography',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'widget_font',
        'label'       => __( 'Widget title font', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'typography',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'font_size_tab',
        'label'       => __( 'Font sizes', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'body_size',
        'label'       => __( 'Body', 'care' ),
        'desc'        => __( 'General body font size. <br /> Remember to add <code>px</code> value after the number. For example: <code>13px</code>', 'care' ),
        'std'         => '14px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h1',
        'label'       => __( 'H1', 'care' ),
        'desc'        => __( 'Heading 1 tag font size. <br /> Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '30px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h2',
        'label'       => __( 'H2', 'care' ),
        'desc'        => __( 'Heading 2 tag font size. <br />Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '24px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h3',
        'label'       => __( 'H3', 'care' ),
        'desc'        => __( 'Heading 3 tag font size. <br />Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '20px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h4',
        'label'       => __( 'H4', 'care' ),
        'desc'        => __( 'Heading 4 tag font size. <br />Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '18px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h5',
        'label'       => __( 'H5', 'care' ),
        'desc'        => __( 'Heading 5 tag font size. <br />Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '16px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'h6',
        'label'       => __( 'H6', 'care' ),
        'desc'        => __( 'Heading 6 tag font size. <br />Remember to add <code>px</code> value after the number.', 'care' ),
        'std'         => '13px',
        'type'        => 'text',
        'section'     => 'typography',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_tab',
        'label'       => __( 'Footer', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_columns',
        'label'       => __( 'Column count', 'care' ),
        'desc'        => __( 'Choose column count for your footer.', 'care' ),
        'std'         => 'vc_col-sm-3',
        'type'        => 'select',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'vc_col-sm-12',
            'label'       => __( '1', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'vc_col-sm-6',
            'label'       => __( '2', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'vc_col-sm-4',
            'label'       => __( '3', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'vc_col-sm-3',
            'label'       => __( '4', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'footer_bg',
        'label'       => __( 'Background', 'care' ),
        'desc'        => __( 'You can either use color or upload a background image. Leave blank for default setting.', 'care' ),
        'std'         => '',
        'type'        => 'background',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_text_color',
        'label'       => __( 'Text color', 'care' ),
        'desc'        => __( 'Choose text color for your footer widget content.', 'care' ),
        'std'         => '#999999',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_link',
        'label'       => __( 'Link color', 'care' ),
        'desc'        => __( 'Will apply color to all links located in footer widgets.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_link_hover',
        'label'       => __( 'Link hover color', 'care' ),
        'desc'        => __( 'Leave empty to use "Theme accent color" or link hover color if set.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'footer_widget_title',
        'label'       => __( 'Widget title color', 'care' ),
        'desc'        => __( 'Color for widget titles in footer.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_tab',
        'label'       => __( 'Copyright', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_bg',
        'label'       => __( 'Background', 'care' ),
        'desc'        => __( 'You can either use color or upload a background image. Leave blank for default setting.', 'care' ),
        'std'         => '',
        'type'        => 'background',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_text_color',
        'label'       => __( 'Text color', 'care' ),
        'desc'        => __( 'Choose text color for your copyright area widget content.', 'care' ),
        'std'         => '#999999',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_link',
        'label'       => __( 'Link color', 'care' ),
        'desc'        => __( 'Color for links located in your copyright area widgets.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_link_hover',
        'label'       => __( 'Link hover color', 'care' ),
        'desc'        => __( 'Leave empty to use "Theme accent color" or link hover color if set.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'copyright_widget_title',
        'label'       => __( 'Widget title color', 'care' ),
        'desc'        => __( 'Color for widget titles in copyright area.', 'care' ),
        'std'         => '',
        'type'        => 'colorpicker',
        'section'     => 'footer_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'blog_tab',
        'label'       => __( 'Blog', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'blog_layout',
        'label'       => __( 'Blog layout', 'care' ),
        'desc'        => __( '1. Full width content<br />
2. Content / Right sidebar <br />
3. Content / Left sidebar', 'care' ),
        'std'         => 'right-sidebar',
        'type'        => 'radio-image',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'blog_post_text_align',
        'label'       => __( 'Blog post text align', 'care' ),
        'desc'        => __( 'Choose text align for the blog post.', 'care' ),
        'std'         => 'left',
        'type'        => 'select',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'left',
            'label'       => __( 'Left', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'center',
            'label'       => __( 'Center', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'right',
            'label'       => __( 'Right', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'blog_title',
        'label'       => __( 'Blog title', 'care' ),
        'desc'        => __( 'Choose whether to display or hide blog title.', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'blog_custom_header',
        'label'       => __( 'Custom HTML after header in blog page', 'care' ),
        'desc'        => __( 'Insert any custom code you wish. Shortcodes allowed!', 'care' ),
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'content_type',
        'label'       => __( 'Content type for post preview', 'care' ),
        'desc'        => __( 'Choose what to display on blog index pages. Note that only \'Full Content\' respects WordPress \'read more\' tag.', 'care' ),
        'std'         => 'full_content',
        'type'        => 'select',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'excerpt',
            'label'       => __( 'Excerpt', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'full_content',
            'label'       => __( 'Full content', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'exclude_from_blog',
        'label'       => __( 'Exclude category from blog', 'care' ),
        'desc'        => __( 'This option will exclude selected category posts from blog and search pages.', 'care' ),
        'std'         => '',
        'type'        => 'category-checkbox',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_date',
        'label'       => __( 'Post date in meta', 'care' ),
        'desc'        => __( 'Do you want to display date in post meta fields?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_category',
        'label'       => __( 'Post category in meta', 'care' ),
        'desc'        => __( 'Do you want to display category in post meta fields?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_author',
        'label'       => __( 'Post author in meta', 'care' ),
        'desc'        => __( 'Do you want to display author in post meta fields?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_comments',
        'label'       => __( 'Comments link in meta', 'care' ),
        'desc'        => __( 'Do you want to display comment count in post meta fields?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_tab',
        'label'       => __( 'Posts', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_layout',
        'label'       => __( 'Post layout', 'care' ),
        'desc'        => __( '1. Full width content<br />
2. Content / Right sidebar <br />
3. Content / Left sidebar', 'care' ),
        'std'         => 'right-sidebar',
        'type'        => 'radio-image',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'single_post_text_align',
        'label'       => __( 'Post text align', 'care' ),
        'desc'        => __( 'Choose text align for single post.', 'care' ),
        'std'         => 'left',
        'type'        => 'select',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => 'left',
            'label'       => __( 'Left', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'center',
            'label'       => __( 'Center', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => 'right',
            'label'       => __( 'Right', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'post_links',
        'label'       => __( 'Previous &amp; next post link', 'care' ),
        'desc'        => __( 'Do you want to display next and previous post links on single blog post page?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'post_tags',
        'label'       => __( 'Post tags after content', 'care' ),
        'desc'        => __( 'Display post tags on single post page?', 'care' ),
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'author_description',
        'label'       => __( 'Post author description', 'care' ),
        'desc'        => __( 'When ON, author info box will only appear for those post authors who have "Biographical Info" field filled!', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'blog_options',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'cart_widget',
        'label'       => __( 'Display cart content on hover', 'care' ),
        'desc'        => __( 'Display cart content on icon hover (ON) or just lead to cart page on click (OFF)?', 'care' ),
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => 'cart_button:is(on)',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'catalog_layout',
        'label'       => __( 'Product archive page (shop) layout', 'care' ),
        'desc'        => __( '1. Full width content<br />
2. Content / Right sidebar <br />
3. Content / Left sidebar', 'care' ),
        'std'         => 'right-sidebar',
        'type'        => 'radio-image',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'woo_title',
        'label'       => __( 'WooCommerce product page title', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'woo_custom_header',
        'label'       => __( 'Custom HTML after header in WooCommerce product page', 'care' ),
        'desc'        => '',
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'product_layout',
        'label'       => __( 'Single product page layout', 'care' ),
        'desc'        => __( '1. Full width content<br />
2. Content / Right sidebar <br />
3. Content / Left sidebar', 'care' ),
        'std'         => 'right-sidebar',
        'type'        => 'radio-image',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'woo_columns',
        'label'       => __( 'Product column count', 'care' ),
        'desc'        => __( 'Choose column count for main product catalog page.', 'care' ),
        'std'         => '',
        'type'        => 'select',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and',
        'choices'     => array( 
          array(
            'value'       => '3',
            'label'       => __( '3 columns', 'care' ),
            'src'         => ''
          ),
          array(
            'value'       => '4',
            'label'       => __( '4 columns', 'care' ),
            'src'         => ''
          )
        )
      ),
      array(
        'id'          => 'woo_product_count',
        'label'       => __( 'Products per page', 'care' ),
        'desc'        => __( 'Choose how many products to display on product catalog page.', 'care' ),
        'std'         => '9',
        'type'        => 'text',
        'section'     => 'woocommerce',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'custom_css',
        'label'       => __( 'Custom CSS', 'care' ),
        'desc'        => __( 'Add any of your custom CSS here: <br /> 

<pre><code>.page-id-10 .page-header {
background:#faa732;
}
</code></pre>

Have fun!', 'care' ),
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'custom_css',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => '',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'import_demo_data_section',
        'label'       => __( 'Import demo', 'care' ),
        'desc'        => __( '<h1>Welcome to Care theme!</h1>
<span class="import_note">You can replicate live preview website by importing demo data.<br /> Posts, pages, widgets, menus and reading settings will be set automatically. <br />You can change and edit everything later.</span>

<a href="themes.php?page=ot-theme-options&amp;import_data_content=true">Import demo data</a>

<span class="import_note import_warning"><strong>NOTICE: </strong>Images and graphics used in live demo are licensed for preview purposes only and are replaced with placeholder images in this demo content.</span>', 'care' ),
        'std'         => '',
        'type'        => 'textblock',
        'section'     => 'import_data',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => 'import-demo',
        'condition'   => '',
        'operator'    => 'and'
      ),
      array(
        'id'          => 'import_successful_section',
        'label'       => __( 'Import successful', 'care' ),
        'desc'        => __( '<div class="success-icon"></div>
<h1>Data Imported Successfully!</h1>', 'care' ),
        'std'         => '',
        'type'        => 'textblock',
        'section'     => 'import_successful',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'min_max_step'=> '',
        'class'       => 'import-successful',
        'condition'   => '',
        'operator'    => 'and'
      )
    )
  );
  
  /* allow settings to be filtered before saving */
  $custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );
  
  /* settings are not the same update the DB */
  if ( $saved_settings !== $custom_settings ) {
    update_option( ot_settings_id(), $custom_settings ); 
  }
  
  /* Lets OptionTree know the UI Builder is being overridden */
  global $ot_has_custom_theme_options;
  $ot_has_custom_theme_options = true;
  
}