<?php
/*
Template Name: Under Construction Template
*/
get_header(); //the_post();
$theid = (isset($carbon_uc_id)) ? $carbon_uc_id : get_the_ID();
$post = get_post($theid);
if (class_exists('Ultimate_VC_Addons')) {
	if(stripos($post->post_content, 'font_call:')){
		preg_match_all('/font_call:(.*?)"/',$post->post_content, $display);
		$carbon_import_fonts = array_unique( $display[1] );
		enquque_ultimate_google_fonts_optimzed($carbon_import_fonts);
		
		$standardfonts = array('Arial','Arial Black','Helvetica','Helvetica Neue','Courier New','Georgia','Impact','Lucida Sans Unicode','Times New Roman', 'Trebuchet MS','Verdana','');
		$importfonts = "";
	
		foreach ($carbon_import_fonts as $font){
			if (!in_array($font,$standardfonts)){
				$font = str_replace(" ","+",str_replace("|",":",$font));
				if ($importfonts=="") $importfonts .= $font;
				else {
					if (strpos($importfonts, $font) === false)
						$importfonts .= "|{$font}";
				}
			}
		}
	
		if ($importfonts!="") {
			$carbon_import_fonts = $importfonts;
			carbon_set_import_fonts($carbon_import_fonts);
			carbon_google_fonts_scripts();
		}
	}
}
?>

	<div class="fullwindow_rev">
		<?php
		$daslider = get_post_meta($theid, 'underconstruction_rev_value', true);
		if ($daslider){
			if (substr($daslider, 0, 10) === "revSlider_"){
				if (!function_exists('putRevSlider')){
					echo 'Please install the missing plugin - Revolution Slider.';
				} else {
					putRevSlider(substr($daslider, 10));
				}
			}
		} else {
			echo "You need to create and a Revolution Slider instance and then choose it in this Page Options.";
		}
		?>
	</div>
	<div class="fullwindow_content container">
		<div class="tb-row">
			<div class="tb-cell">
				<?php 
					echo do_shortcode($post->post_content);
					/* custom element css */
					$shortcodes_custom_css = get_post_meta( $theid, '_wpb_shortcodes_custom_css', true );
					if ( ! empty( $shortcodes_custom_css ) ) {
						carbon_set_custom_inline_css($shortcodes_custom_css);
					}
				?>
			</div>
		</div>
	</div>
	<?php wp_footer(); ?>
</div> <!-- END OF MAIN -->
<div id="templatepath" class="carbon_helper_div"><?php echo esc_url(get_template_directory_uri())."/"; ?></div>
<div id="homeURL" class="carbon_helper_div"><?php echo esc_url(home_url('/')); ?>/</div>
<div id="styleColor" class="carbon_helper_div"><?php $carbon_styleColor = "#".get_option("carbon_style_color"); echo esc_html($carbon_styleColor);?></div>		
<div id="headerStyleType" class="carbon_helper_div"><?php $carbon_headerStyleType = get_option("carbon_header_style_type"); echo esc_html($carbon_headerStyleType); ?></div>
<div class="carbon_helper_div" id="reading_option"><?php 
	$carbon_reading_option = get_option('carbon_blog_reading_type');
	if ($carbon_reading_option == "scrollauto"){
		$detect = new Mobile_Detect();
		if ($detect->isMobile())
			$carbon_reading_option = "scroll";
	}
	echo esc_html($carbon_reading_option); 
?></div>
<?php
	$carbon_color_code = get_option("carbon_style_color");
?>
<div class="carbon_helper_div" id="carbon_no_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'No more posts to load.', get_option('carbon_no_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_no_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_load_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Load More Posts', get_option('carbon_load_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_load_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_loading_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Loading posts.', get_option('carbon_loading_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_loading_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_links_color_hover"><?php echo esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $carbon_color_code, get_option("carbon_links_color_hover"))); ?></div>
<div class="carbon_helper_div" id="carbon_enable_images_magnifier"><?php echo esc_html(get_option('carbon_enable_images_magnifier')); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_hover_option"><?php echo esc_html(get_option('carbon_thumbnails_hover_option')); ?></div>
<div class="carbon_helper_div" id="carbon_menu_color">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="carbon_fixed_menu"><?php echo esc_html(get_option("carbon_fixed_menu")); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_effect"><?php if (get_option("carbon_animate_thumbnails") == "on") echo esc_html(get_option("carbon_thumbnails_effect")); else echo "none"; ?></div>
<div class="carbon_helper_div loadinger">
	<img alt="loading" src="<?php echo esc_url(get_template_directory_uri()). '/images/ajx_loading.gif' ?>">
</div>
<div class="carbon_helper_div" id="permalink_structure"><?php echo esc_html(get_option('permalink_structure')); ?></div>
<div class="carbon_helper_div" id="headerstyle3_menucolor">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="disable_responsive_layout"><?php echo esc_html(get_option('carbon_disable_responsive')); ?></div>
<div class="carbon_helper_div" id="filters-dropdown-sort"><?php esc_html_e('Sort Gallery','carbon'); ?></div>
<div class="carbon_helper_div" id="searcheverything"><?php echo esc_html(get_option("carbon_enable_search_everything")); ?></div>
<div class="carbon_helper_div" id="carbon_header_shrink"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){if (get_option('carbon_header_shrink_effect') == 'on'){echo "yes";} else echo "no";}} ?></div>
<div class="carbon_helper_div" id="carbon_header_after_scroll"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){echo "yes";} else echo "no";} ?></div>
<div class="carbon_helper_div" id="upper_grayscale_effect"><?php echo esc_html(get_option("carbon_enable_grayscale")); ?></div>
<div class="carbon_helper_div" id="carbon_enable_ajax_search"><?php echo esc_html(get_option("carbon_enable_ajax_search")); ?></div>
<div class="carbon_helper_div" id="carbon_menu_add_border"><?php echo esc_html(get_option("carbon_menu_add_border")); ?></div>
<div class="carbon_helper_div" id="carbon_newsletter_input_text"><?php
	if (function_exists('icl_t')){
		echo esc_html(icl_t( 'carbon', 'Enter your email here', get_option('carbon_newsletter_input_text')));
	} else {
		echo esc_html(get_option('carbon_newsletter_input_text'));
	}
?></div>
<?php
	if (function_exists('icl_t')){
		?>
		<div class="carbon_helper_div" id="carbon_wpml_current_lang"><?php echo ICL_LANGUAGE_CODE; ?></div>
		<?php
	}
?>