<?php
/**
 * @package WordPress
 * @subpackage Carbon
 */
?>
	
	<div id="big_footer" <?php if (get_option("carbon_footer_full_width") == "on") echo " class='footer-full-width'"; ?>>

		<?php
		if (get_option("carbon_show_primary_footer") == "on"){
			?>
			<div id="primary_footer">
			    	<?php
			    	/* Show Newsletter in Footer */
					if (get_option("carbon_newsletter_enabled") == "on"){
						$code = get_option("carbon_mailchimp_code");
						if (!empty($code)){
						    $output = '<div class="footer_newsletter"><div class="mail-box"><div class="mail-news container"><div class="news-l"><div class="banner"><h3>'.sprintf(esc_html("%s", "carbon"), get_option("carbon_newsletter_text")).'</h3><p>'.sprintf(esc_html("%s", "carbon"), get_option("carbon_newsletter_stext")).'</p></div><div class="form">';
						    if (function_exists('icl_t')){
							    $output = '<div class=""><div class="mail-box"><div class="mail-news"><div class="news-l"><div class="banner"><h3>'.wp_kses_post(icl_t( 'carbon', 'Subscribe our <span>Newsletter</span>', get_option('carbon_newsletter_text'))).'</h3><p>'.wp_kses_post(icl_t( 'carbon', 'Subscribe to our newsletter to receive news, cool free stuff updates and new released products (no spam!)', get_option('carbon_newsletter_stext'))).'</p></div><div class="form">';
						    }
							$output .= stripslashes($code);
							$output .= '</div></div></div></div></div>';			
						} else {
							$output = '<div class="">'.esc_html__('You need to fill the inputs on the Appearance > Carbon Options > Newsletter panel in order to work.','carbon').'</div>';
						}			
						$output = wp_kses_no_null( $output, array( 'slash_zero' => 'keep' ) );
						$output = wp_kses_normalize_entities($output);
						echo wp_kses_hook($output, 'post', array()); // WP changed the order of these funcs and added args to wp_kses_hook		
					
					}?>
			    	<div class="<?php if (get_option("carbon_footer_full_width") == "off") echo "container"; ?> no-fcontainer">
			    		
	    		<?php
	    		
					if(get_option("carbon_footer_number_cols") == "one"){ ?>
						<div class="footer_sidebar col-xs-12 col-md-12"><?php carbon_print_sidebar('footer-one-column'); ?></div>
					<?php }
					if(get_option("carbon_footer_number_cols") == "two"){ ?>
						<div class="footer_sidebar col-xs-12 col-md-6"><?php carbon_print_sidebar('footer-two-column-left'); ?></div>
						<div class="footer_sidebar col-xs-12 col-md-6"><?php carbon_print_sidebar('footer-two-column-right'); ?></div>
					<?php }
					if(get_option("carbon_footer_number_cols") == "three"){
						if(get_option("carbon_footer_columns_order") == "one_three"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-three-column-left'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-three-column-center'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-three-column-right'); ?></div>
						<?php }
						if(get_option("carbon_footer_columns_order") == "one_two_three"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-three-column-left-1_3'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-8"><?php carbon_print_sidebar('footer-three-column-right-2_3'); ?></div>
						<?php }
						if(get_option("carbon_footer_columns_order") == "two_one_three"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-8"><?php carbon_print_sidebar('footer-three-column-left-2_3'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-three-column-right-1_3'); ?></div>
						<?php }
					}
					if(get_option("carbon_footer_number_cols") == "four"){
						if(get_option("carbon_footer_columns_order_four") == "one_four"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-left'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-center-left'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-center-right'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-right'); ?></div>
						<?php }
						if(get_option("carbon_footer_columns_order_four") == "two_one_two_four"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-left-1_2_4'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-6"><?php carbon_print_sidebar('footer-four-column-center-2_2_4'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-3"><?php carbon_print_sidebar('footer-four-column-right-1_2_4'); ?></div>
						<?php }
						if(get_option("carbon_footer_columns_order_four") == "three_one_four"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-8"><?php carbon_print_sidebar('footer-four-column-left-3_4'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-four-column-right-1_4'); ?></div>
						<?php }
						if(get_option("carbon_footer_columns_order_four") == "one_three_four"){ ?>
							<div class="footer_sidebar col-xs-12 col-md-4"><?php carbon_print_sidebar('footer-four-column-left-1_4'); ?></div>
							<div class="footer_sidebar col-xs-12 col-md-8"><?php carbon_print_sidebar('footer-four-column-right-3_4'); ?></div>
						<?php }
					}
				?>
				</div>
		    </div>
			<?php
		}
	?>
    
    <?php
	    if (get_option("carbon_show_sec_footer") == "on"){
		    $carbon_is_only_custom_text = (get_option("carbon_footer_display_logo") != 'on' && get_option("carbon_footer_display_social_icons") != "on") ? true : false;
		    ?>
		    <div id="secondary_footer">
				<div class="container <?php echo $carbon_is_only_custom_text ? "only_custom_text" : ""; ?>">
					
					<?php
						/* FOOTER LOGOTYPE */
						if (get_option("carbon_footer_display_logo") == 'on'){
						?>
						<a class="footer_logo align-<?php echo esc_attr(get_option("carbon_footer_logo_alignment")); ?>" href="<?php echo esc_url(home_url("/")); ?>" tabindex="-1">
				        	<?php
				    			$alone = true;
			    				if (get_option("carbon_footer_logo_retina_image_url") != ""){
				    				$alone = false;
			    				}
		    					?>
		    					<img class="footer_logo_normal <?php if (!$alone) echo "notalone"; ?>" style="position: relative;" src="<?php echo esc_url(get_option("carbon_footer_logo_image_url")); ?>" alt="<?php esc_attr_e("", "carbon"); ?>" title="<?php esc_attr_e("", "carbon"); ?>">
			    					
			    				<?php 
			    				if (get_option("carbon_footer_logo_retina_image_url") != ""){
			    				?>
				    				<img class="footer_logo_retina" style="display:none; position: relative;" src="<?php echo esc_url(get_option("carbon_footer_logo_retina_image_url")); ?>" alt="<?php esc_attr_e("", "carbon"); ?>" title="<?php esc_attr_e("", "carbon"); ?>">
			    				<?php
		    					}
			    			?>
				        </a>
						<?php
						}
						
						
						
						/* FOOTER SOCIAL ICONS */
						if (get_option("carbon_footer_display_social_icons") == "on"){
						?>
						<div class="social-icons-fa align-<?php echo esc_attr(get_option("carbon_footer_social_icons_alignment")); ?>">
					        <ul>
							<?php
								$icons = array(array("facebook","Facebook"),array("twitter","Twitter"),array("tumblr","Tumblr"),array("stumbleupon","Stumble Upon"),array("flickr","Flickr"),array("linkedin","LinkedIn"),array("delicious","Delicious"),array("skype","Skype"),array("digg","Digg"),array("google-plus","Google+"),array("vimeo-square","Vimeo"),array("deviantart","DeviantArt"),array("behance","Behance"),array("instagram","Instagram"),array("wordpress","Wordpress"),array("youtube","Youtube"),array("reddit","Reddit"),array("rss","RSS"),array("soundcloud","SoundCloud"),array("pinterest","Pinterest"),array("dribbble","Dribbble"));
								foreach ($icons as $i){
									if (is_string(get_option("carbon_icon-".$i[0])) && get_option("carbon_icon-".$i[0]) != ""){
									?>
									<li>
										<a href="<?php echo esc_url(get_option("carbon_icon-".$i[0])); ?>" target="_blank" class="<?php echo esc_attr(strtolower($i[0])); ?>" title="<?php echo esc_attr($i[1]); ?>"><i class="fa fa-<?php echo esc_attr(strtolower($i[0])); ?>"></i></a>
									</li>
									<?php
									}
								}
							?>
						    </ul>
						</div>
						<?php
						}
						/* FOOTER CUSTOM TEXT */
						if (get_option("carbon_footer_display_custom_text") == "on"){
						?>
						<div class="footer_custom_text <?php echo $carbon_is_only_custom_text ? "wide" : esc_attr(get_option("carbon_footer_custom_text_alignment")); ?>"><?php echo do_shortcode(stripslashes(get_option("carbon_footer_custom_text"))); ?></div>
						<?php
						}
						
					?>
				</div>
			</div>
		    <?php
	    }
    ?>
	</div>

<?php

/* sets the type of pagination [scroll, autoscroll, paged, default] */
wp_reset_postdata();
$carbon_reading_option = get_option('carbon_blog_reading_type');
if (is_archive() || is_single() || is_search() || is_page_template('blog-template.php') || is_page_template('blog-masonry-template.php')) {

	$nposts = get_option('posts_per_page');

	$carbon_more = 0;
	$carbon_pag = 0;

	$orderby="";
	$category="";
	$nposts = "";
	$order = "";

	$carbon_pag = $wp_query->query_vars['paged'];
	if (!is_numeric($carbon_pag)) $carbon_pag = 1;
	$max = 0;

	switch ($carbon_reading_option){
		case "scrollauto": 

				// Add code to index pages.
				if( !is_singular() ) {	

					if (is_search()){

						$carbon_reading_option = get_option('carbon_blog_reading_type');
						$se = get_option("carbon_enable_search_everything");

						$nposts = get_option('posts_per_page');

						$carbon_pag = $wp_query->query_vars['paged'];
						if (!is_numeric($carbon_pag)) $carbon_pag = 1;

						if ($se == "on"){
							$args = array(
								'showposts' => get_option('posts_per_page'),
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								's' => esc_html($_GET['s'])
							);

						    $carbon_the_query = new WP_Query( $args );

						    $args2 = array(
								'showposts' => -1,
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								's' => esc_html($_GET['s'])
							);

							$counter = new WP_Query($args2);

						} else {
							$args = array(
								'showposts' => get_option('posts_per_page'),
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								'post_type' => 'post',
								's' => esc_html($_GET['s'])
							);

						    $carbon_the_query = new WP_Query( $args );

						    $args2 = array(
								'showposts' => -1,
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								'post_type' => 'post',
								's' => esc_html($_GET['s'])
							);

							$counter = new WP_Query($args2);
						}

						$max = ceil($counter->post_count / $nposts);
						$carbon_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;

					} else {

						$max = $wp_query->max_num_pages;
						$carbon_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;

					}
					
					$carbon_inline_script = '
						jQuery(document).ready(function($){
							"use strict";
							if (jQuery("#reading_option").html() === "scrollauto" && !jQuery("body").hasClass("single")){ 
								window.carbon_loadingPoint = 0;
								//monitor page scroll to fire up more posts loader
								window.clearInterval(window.carbon_interval);
								window.carbon_interval = setInterval("carbon_monitorScrollTop()", 1000 );
							}
						});
					';
					wp_add_inline_script('carbon-global', $carbon_inline_script, 'after');

				} else {

				    $args = array(
	    				'showposts' => $nposts,
	    				'orderby' => $orderby,
	    				'order' => $order,
	    				'cat' => $category,
	    				'paged' => $carbon_pag,
	    				'post_status' => 'publish'
	    			);

	    		    $carbon_the_query = new WP_Query( $args );

		    		$max = $carbon_the_query->max_num_pages;
		    		$carbon_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;

		    		$carbon_inline_script = '
						jQuery(document).ready(function($){
							"use strict";
							if (jQuery("#reading_option").html() === "scrollauto" && !jQuery("body").hasClass("single")){ 
								window.carbon_loadingPoint = 0;
								//monitor page scroll to fire up more posts loader
								window.clearInterval(window.carbon_interval);
								window.carbon_interval = setInterval("carbon_monitorScrollTop()", 1000 );
							}
						});
					';
					wp_add_inline_script('carbon-global', $carbon_inline_script, 'after');

	    		}
			break;
		case "scroll": 

				// Add code to index pages.
				if( !is_singular() ) {	

					if (is_search()){

						$nposts = get_option('posts_per_page');

						$se = get_option("carbon_enable_search_everything");

						if ($se == "on"){
							$args = array(
								'showposts' => get_option('posts_per_page'),
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								's' => esc_html($_GET['s'])
							);

						    $carbon_the_query = new WP_Query( $args );

						    $args2 = array(
								'showposts' => -1,
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								's' => esc_html($_GET['s'])
							);

							$counter = new WP_Query($args2);

						} else {
							$args = array(
								'showposts' => get_option('posts_per_page'),
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								'post_type' => 'post',
								's' => esc_html($_GET['s'])
							);

						    $carbon_the_query = new WP_Query( $args );

						    $args2 = array(
								'showposts' => -1,
								'post_status' => 'publish',
								'paged' => $carbon_pag,
								'post_type' => 'post',
								's' => esc_html($_GET['s'])
							);

							$counter = new WP_Query($args2);
						}

						$max = ceil($counter->post_count / $nposts);
						$carbon_pag = 1;

						$carbon_pag = $wp_query->query_vars['paged'];
						if (!is_numeric($carbon_pag)) $carbon_pag = 1;

					} else {
						$max = $wp_query->max_num_pages;
						$carbon_paged = $carbon_pag;

					}


				} else {

					$orderby = "";
					$category = "";

				    $args = array(
	    				'showposts' => $nposts,
	    				'orderby' => $orderby,
	    				'order' => $order,
	    				'cat' => $category,
	    				'post_status' => 'publish'
	    			);

	    		    $carbon_the_query = new WP_Query( $args );


		    		$max = $carbon_the_query->max_num_pages;
		    		$carbon_pag = 1;

					$carbon_pag = $wp_query->query_vars['paged'];
					if (!is_numeric($carbon_pag)) $carbon_pag = 1;		    			    				
	    		}

			break;
	}
	?>
	<div class="carbon_helper_div" id="loader-startPage"><?php echo esc_html($carbon_pag); ?></div>
	<div class="carbon_helper_div" id="loader-maxPages"><?php echo esc_html($max); ?></div>
	<div class="carbon_helper_div" id="loader-nextLink"><?php echo next_posts($max, false); ?></div>
	<div class="carbon_helper_div" id="loader-prevLink"><?php echo previous_posts($max, false); ?></div>
	<?php
}

$carbon_styleColor = "#".esc_html(get_option("carbon_style_color"));
$carbon_bodyLayoutType = get_option("carbon_body_layout_type");
$carbon_headerType = get_option("carbon_header_type");
?>
</div> <!-- END OF MAIN -->
<div id="bodyLayoutType" class="carbon_helper_div"><?php echo esc_html($carbon_bodyLayoutType); ?></div>
<div id="headerType" class="carbon_helper_div"><?php echo esc_html($carbon_headerType); ?></div>
<?php 
	if (get_option("carbon_body_shadow") == "on"){
		?>
			<div id="bodyShadowColor" class="carbon_helper_div"><?php echo "#".esc_html(get_option("carbon_body_shadow_color")); ?></div>
		<?php
	}
	$carbon_headerStyleType = get_option("carbon_header_style_type");
?>
<div id="templatepath" class="carbon_helper_div"><?php echo esc_url(get_template_directory_uri())."/"; ?></div>
<div id="homeURL" class="carbon_helper_div"><?php echo esc_url(home_url("/")); ?></div>
<div id="styleColor" class="carbon_helper_div"><?php echo "#".esc_html(get_option("carbon_style_color")); ?></div>	
<div id="headerStyleType" class="carbon_helper_div"><?php echo esc_html($carbon_headerStyleType); ?></div>
<div class="carbon_helper_div" id="reading_option"><?php 
	if ($carbon_reading_option == "scrollauto"){
		$detect = new Mobile_Detect();
		if ($detect->isMobile())
			$carbon_reading_option = "scroll";
	}
	echo esc_html($carbon_reading_option); 
?></div>
<?php
	$carbon_color_code = get_option("carbon_style_color");
?>
<div class="carbon_helper_div" id="carbon_no_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'No more posts to load.', get_option('carbon_no_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_no_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_load_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Load More Posts', get_option('carbon_load_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_load_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_loading_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Loading posts.', get_option('carbon_loading_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_loading_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_links_color_hover"><?php echo esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $carbon_color_code, get_option("carbon_links_color_hover"))); ?></div>
<div class="carbon_helper_div" id="carbon_enable_images_magnifier"><?php echo esc_html(get_option('carbon_enable_images_magnifier')); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_hover_option"><?php echo esc_html(get_option('carbon_thumbnails_hover_option')); ?></div>
<div id="homePATH" class="carbon_helper_div"><?php echo ABSPATH; ?></div>
<div class="carbon_helper_div" id="carbon_menu_color">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="carbon_fixed_menu"><?php echo esc_html(get_option("carbon_fixed_menu")); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_effect"><?php if (get_option("carbon_animate_thumbnails") == "on") echo esc_html(get_option("carbon_thumbnails_effect")); else echo "none"; ?></div>
<div class="carbon_helper_div loadinger">
	<img alt="loading" src="<?php echo esc_url(get_template_directory_uri()). '/images/ajx_loading.gif' ?>">
</div>
<div class="carbon_helper_div" id="permalink_structure"><?php echo esc_html(get_option('permalink_structure')); ?></div>
<div class="carbon_helper_div" id="headerstyle3_menucolor">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="disable_responsive_layout"><?php echo esc_html(get_option('carbon_disable_responsive')); ?></div>
<div class="carbon_helper_div" id="filters-dropdown-sort"><?php esc_html_e('Sort Gallery','carbon'); ?></div>
<div class="carbon_helper_div" id="searcheverything"><?php echo esc_html(get_option("carbon_enable_search_everything")); ?></div>
<div class="carbon_helper_div" id="carbon_header_shrink"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){if (get_option('carbon_header_shrink_effect') == 'on'){echo "yes";} else echo "no";}} ?></div>
<div class="carbon_helper_div" id="carbon_header_after_scroll"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){echo "yes";} else echo "no";} ?></div>
<div class="carbon_helper_div" id="upper_grayscale_effect"><?php echo esc_html(get_option("carbon_enable_grayscale")); ?></div>
<div class="carbon_helper_div" id="carbon_enable_ajax_search"><?php echo esc_html(get_option("carbon_enable_ajax_search")); ?></div>
<div class="carbon_helper_div" id="carbon_menu_add_border"><?php echo esc_html(get_option("carbon_menu_add_border")); ?></div>
<div class="carbon_helper_div" id="carbon_newsletter_input_text"><?php
	if (function_exists('icl_t')){
		echo esc_html(icl_t( 'carbon', 'Enter your email here', get_option('carbon_newsletter_input_text')));
	} else {
		echo esc_html(get_option('carbon_newsletter_input_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_content_to_the_top">
	<?php 
		if (is_singular() && get_post_meta(get_the_ID(), 'carbon_enable_custom_header_options_value', true)=='yes') echo esc_html(get_post_meta(get_the_ID(), 'carbon_content_to_the_top_value', true));
		else echo esc_html(get_option('carbon_content_to_the_top')); 
	?>
</div>
<div class="carbon_helper_div" id="carbon_update_section_titles"><?php echo esc_html(get_option('carbon_update_section_titles')); ?></div>
<?php
	if (function_exists('icl_t')){
		?>
		<div class="carbon_helper_div" id="carbon_wpml_current_lang"><?php echo ICL_LANGUAGE_CODE; ?></div>
		<?php
	}
?>
<?php 
	$standardfonts = array('Arial','Arial Black','Helvetica','Helvetica Neue','Courier New','Georgia','Impact','Lucida Sans Unicode','Times New Roman', 'Trebuchet MS','Verdana','');
	$importfonts = "";
	$carbon_import_fonts = carbon_get_import_fonts();

	foreach ($carbon_import_fonts as $font){
		if (!in_array($font,$standardfonts)){
			$font = str_replace(" ","+",str_replace("|",":",$font));
			if ($importfonts=="") $importfonts .= $font;
			else {
				if (strpos($importfonts, $font) === false)
					$importfonts .= "|{$font}";
			}
		}
	}

	if ($importfonts!="") {
		$carbon_import_fonts = $importfonts;
		carbon_set_import_fonts($carbon_import_fonts);
		carbon_google_fonts_scripts();
	}

	if (get_option("carbon_enable_gotop") == "on"){
		?>
		<p id="back-top"><a href="#home"><i class="ion-ios-arrow-thin-up"></i></a></p>
		<?php
	}
	
	carbon_get_team_profiles_content();
	carbon_get_custom_inline_css();

	if (get_option("carbon_body_type") == "body_boxed"){
		?>
		</div>
		<?php
	}
	
	wp_footer(); 
?>
    	
</body>
</html>