<?php get_header(); carbon_print_menu(); $carbon_color_code = get_option("carbon_style_color"); ?>

	<div class="container">
		<div class="entry-header">
			<div class="error-c">
				<img src="<?php echo esc_url(get_template_directory_uri() . "/images/error.png");?>" title=""/>
				<br>
				<h1 class="heading-error"><?php
					if (function_exists('icl_t')){
						wp_kses_post(printf(esc_html__( "%s", "carbon" ), stripslashes_from_strings_only(icl_t( 'carbon', 'Oops! There is nothing here...', get_option('carbon_404_heading')))));
					} else {
						wp_kses_post(printf(esc_html__( "%s", "carbon" ), stripslashes_from_strings_only(get_option('carbon_404_heading'))));
					}
				?></h1>
							
				<p class="text-error"><?php
					if (function_exists('icl_t')){
						wp_kses_post(printf(esc_html__( "%s", "carbon" ), stripslashes_from_strings_only(icl_t( 'carbon', "It seems we can't find what you're looking for. Perhaps searching one of the links in the above menu, can help.", get_option('carbon_404_text')))));
					} else {
						wp_kses_post(printf(esc_html__( "%s", "carbon" ), stripslashes_from_strings_only(get_option('carbon_404_text'))));
					}
				?></p>
				
				<a href="<?php echo esc_url(home_url("/")); ?>" class="errorbutton"><?php
					if (function_exists('icl_t')){
						printf(esc_html__("%s","carbon"), icl_t( 'carbon', 'GO TO HOMEPAGE', get_option('carbon_404_button_text')));
					} else {
						printf(esc_html__("%s","carbon"), get_option('carbon_404_button_text'));
					}
				?></a>
			</div>
			
		</div>
	</div>
<?php
$carbon_styleColor = "#".esc_html(get_option("carbon_style_color"));
$carbon_bodyLayoutType = get_option("carbon_body_layout_type");
$carbon_headerType = get_option("carbon_header_type");
?>
<div id="bodyLayoutType" class="carbon_helper_div"><?php echo esc_html($carbon_bodyLayoutType); ?></div>
<div id="headerType" class="carbon_helper_div"><?php echo esc_html($carbon_headerType); ?></div>
<?php 
	if (get_option("carbon_body_shadow") == "on"){
		?>
			<div id="bodyShadowColor" class="carbon_helper_div"><?php echo "#".esc_html(get_option("carbon_body_shadow_color")); ?></div>
		<?php
	}
	$carbon_headerStyleType = get_option("carbon_header_style_type");
?>
<div id="templatepath" class="carbon_helper_div"><?php echo esc_url(get_template_directory_uri())."/"; ?></div>
<div id="homeURL" class="carbon_helper_div"><?php echo esc_url(home_url("/")); ?>/</div>
<div id="styleColor" class="carbon_helper_div"><?php echo "#".esc_html(get_option("carbon_style_color")); ?></div>	
<div id="headerStyleType" class="carbon_helper_div"><?php echo esc_html($carbon_headerStyleType); ?></div>
<div class="carbon_helper_div" id="carbon_no_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'No more posts to load.', get_option('carbon_no_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_no_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_load_more_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Load More Posts', get_option('carbon_load_more_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_load_more_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_loading_posts_text"><?php
	if (function_exists('icl_t')){
		printf(esc_html__("%s", "carbon"), icl_t( 'carbon', 'Loading posts.', get_option('carbon_loading_posts_text')));
	} else {
		printf(esc_html__("%s", "carbon"), get_option('carbon_loading_posts_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_links_color_hover"><?php echo esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $carbon_color_code, get_option("carbon_links_color_hover"))); ?></div>
<div class="carbon_helper_div" id="carbon_enable_images_magnifier"><?php echo esc_html(get_option('carbon_enable_images_magnifier')); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_hover_option"><?php echo esc_html(get_option('carbon_thumbnails_hover_option')); ?></div>
<div id="homePATH" class="carbon_helper_div"><?php echo ABSPATH; ?></div>
<div class="carbon_helper_div" id="carbon_menu_color">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="carbon_fixed_menu"><?php echo esc_html(get_option("carbon_fixed_menu")); ?></div>
<div class="carbon_helper_div" id="carbon_thumbnails_effect"><?php if (get_option("carbon_animate_thumbnails") == "on") echo esc_html(get_option("carbon_thumbnails_effect")); else echo "none"; ?></div>
<div class="carbon_helper_div loadinger">
	<img alt="loading" src="<?php echo esc_url(get_template_directory_uri()). '/images/ajx_loading.gif' ?>">
</div>
<div class="carbon_helper_div" id="permalink_structure"><?php echo esc_html(get_option('permalink_structure')); ?></div>
<div class="carbon_helper_div" id="headerstyle3_menucolor">#<?php echo esc_html(get_option("carbon_menu_color")); ?></div>
<div class="carbon_helper_div" id="disable_responsive_layout"><?php echo esc_html(get_option('carbon_disable_responsive')); ?></div>
<div class="carbon_helper_div" id="filters-dropdown-sort"><?php esc_html_e('Sort Gallery','carbon'); ?></div>
<div class="carbon_helper_div" id="templatepath"><?php echo esc_url(get_template_directory_uri()); ?></div>
<div class="carbon_helper_div" id="searcheverything"><?php echo esc_html(get_option("carbon_enable_search_everything")); ?></div>
<div class="carbon_helper_div" id="carbon_header_shrink"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){if (get_option('carbon_header_shrink_effect') == 'on'){echo "yes";} else echo "no";}} ?></div>
<div class="carbon_helper_div" id="carbon_header_after_scroll"><?php if (get_option('carbon_fixed_menu') == 'on'){if (get_option('carbon_header_after_scroll') == 'on'){echo "yes";} else echo "no";} ?></div>
<div class="carbon_helper_div" id="upper_grayscale_effect"><?php echo esc_html(get_option("carbon_enable_grayscale")); ?></div>
<div class="carbon_helper_div" id="carbon_enable_ajax_search"><?php echo esc_html(get_option("carbon_enable_ajax_search")); ?></div>
<div class="carbon_helper_div" id="carbon_menu_add_border"><?php echo esc_html(get_option("carbon_menu_add_border")); ?></div>
<div class="carbon_helper_div" id="carbon_newsletter_input_text"><?php
	if (function_exists('icl_t')){
		echo esc_html(icl_t( 'carbon', 'Enter your email here', get_option('carbon_newsletter_input_text')));
	} else {
		echo esc_html(get_option('carbon_newsletter_input_text'));
	}
?></div>
<div class="carbon_helper_div" id="carbon_content_to_the_top">
	<?php 
		if (is_singular() && get_post_meta(get_the_ID(), 'carbon_enable_custom_header_options_value', true)=='yes') echo esc_html(get_post_meta(get_the_ID(), 'carbon_content_to_the_top_value', true));
		else echo esc_html(get_option('carbon_content_to_the_top')); 
	?>
</div>
<div class="carbon_helper_div" id="carbon_update_section_titles"><?php echo esc_html(get_option('carbon_update_section_titles')); ?></div>
<?php
	if (function_exists('icl_t')){
		?>
		<div class="carbon_helper_div" id="carbon_wpml_current_lang"><?php echo ICL_LANGUAGE_CODE; ?></div>
		<?php
	}
?>
<?php 
	$standardfonts = array('Arial','Arial Black','Helvetica','Helvetica Neue','Courier New','Georgia','Impact','Lucida Sans Unicode','Times New Roman', 'Trebuchet MS','Verdana','');
	$importfonts = "";
	$carbon_import_fonts = carbon_get_import_fonts();

	foreach ($carbon_import_fonts as $font){
		if (!in_array($font,$standardfonts)){
			$font = str_replace(" ","+",str_replace("|",":",$font));
			if ($importfonts=="") $importfonts .= $font;
			else {
				if (strpos($importfonts, $font) === false)
					$importfonts .= "|{$font}";
			}
		}
	}

	if ($importfonts!="") {
		$carbon_import_fonts = $importfonts;
		carbon_set_import_fonts($carbon_import_fonts);
		carbon_google_fonts_scripts();
	}

wp_footer(); ?>