<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$attribute_keys = array_keys( $attributes );

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<form class="variations_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo esc_attr( json_encode( $available_variations ) ) ?>">
	<?php do_action( 'woocommerce_before_variations_form' ); ?>

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
		<p class="stock out-of-stock"><?php esc_html_e( 'This product is currently out of stock and unavailable.', '7upframework' ); ?></p>
	<?php else : ?>
		<div class="variations">
			<div class="inner">
				<?php foreach ( $attributes as $attribute_name => $options ) : ?>
					<p>
						<label class="label" for="<?php echo sanitize_title( $attribute_name ); ?>"><?php echo wc_attribute_label( $attribute_name ); ?></label>
						<span class="value">
							<?php
								$classes="select_attr";
								$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) : $product->get_variation_default_attribute( $attribute_name );
								wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected ,'class'=>$classes) );
								echo end( $attribute_keys ) === $attribute_name ? '<a class="reset_variations" href="#">' . esc_html__( 'Clear selection', '7upframework' ) . '</a>' : '';
							?>
						</span>
					</p>
		        <?php endforeach;?>
			</div>
		</div>

		<?php do_action( 'woocommerce_before_single_variation' ); ?>
		<div class="single_variation_wrap" style="display:none;">
			<div class="single_variation"></div>
		</div>
		<div class="quantity-controls quantity-minus minus"><?php esc_html_e('minus','7upframework')?></div>
		<input type="text" class="input-text qty" title="Qty" value="<?php echo apply_filters( 'woocommerce_quantity_input_min', 1, $product )?>" maxlength="12" id="qty" name="quantity">       
		<div class="quantity-controls quantity-plus plus"><?php esc_html_e('plus','7upframework')?></div>

		<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" />
		<input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
		<input type="hidden" name="variation_id" class="variation_id" value="" />

		<button type="submit" class="single_add_to_cart_button alt btn-cart"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
	<?php endif; ?>

	<?php do_action( 'woocommerce_after_single_variation' ); ?>
</form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>
