<?php
 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header();
$sidebar=sv_get_sidebar();
$sidebar_pos=$sidebar['position'];
$main_class = 'col-md-12 ';
if($sidebar_pos == 'left' || $sidebar_pos == 'right') $main_class = 'col-lg-9 col-md-8 col-sm-8 col-xs-12 ';
if($sidebar_pos == 'both') $main_class = 'col-lg-6 col-md-8 col-sm-8 col-xs-12 ';
?>
<div class="main-container col3-layout woocommerce product">
	<div id="main-content" class="main">
		<?php sv_header_page();?>
		<div class="container">
			<div class="row">
				<?php if($sidebar_pos=='left' || $sidebar_pos=='both'){ get_sidebar('woocommerce'); }?>

				<div class="col-main <?php echo esc_attr($main_class);?>">
					<div class="row">
						<div class="box-breadcrumbs col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<div class="breadcrumbs">
								<?php
									$args = array(
											'delimiter' => ' <i class="fa fa-angle-right"></i> ',
											'before' => '<span class="breadcrumb-title">',
											'after' => '</span>',
									);
								?>
								<?php woocommerce_breadcrumb( $args ); ?>
							</div>
						</div>
						<?php
							$args = array(
								'orderby'           => 'name', 
								'order'             => 'ASC',
								'hide_empty'        => true, 
							); 

							$tags = get_terms('product_tag', $args);
							if($tags):
						?>
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
						<div class="block-tag">
							<label><?php esc_html_e('Hot Tag','7upframework')?></label>
							<?php 
								foreach($tags as $tag):
								$tag_id = $tag->term_id;
								$tag_name = $tag->name;
							?>
							<a href="<?php echo get_term_link( absint($tag_id), 'product_tag' ); ?>"><span><?php echo esc_attr($tag_name);?></span></a>
							<?php endforeach;?>
							<span class="open-item closetag"><?php esc_html_e('open','7upframework');?></span>
						</div>	
						<?php endif;?>	
						<!--<div class="category-title">
							<h1>Auto Accessories</h1>
							</div>-->
						<div id="catalog-listing">
							<div class="category-products">
							<?php if ( get_option( 'woocommerce_shop_page_display' ) == '' ) :?>
								<div class="toolbar-top">
									<div class="toolbar col-lg-12 col-md-12 col-sm-12 col-xs-12">
										<div class="box-top col-lg-12 col-md-12 col-sm-12 col-xs-12">
											<?php
												do_action( 'woocommerce_before_shop_loop' );
											?>
										</div>
									</div>
								</div>
							<?php endif;?>
								<?php if(have_posts()):?>
								<ul class="products-grid row">
									<?php 										
										woocommerce_product_subcategories();
										$key=0;
										while(have_posts()) : the_post();
										global $product;
										$key++;
										$column = sv_get_option('set_shop_col');
										$col = 2;
										if($column == '4') $col = 3;
										if($column == '3') $col = 4;
										if($key % (int)$col == 1) $clearfix = 'col-lg-'.$column.' col-md-'.$column.' col-sm-'.$column.' col-xs-6 item clear-item';
										else $clearfix = 'col-lg-'.$column.' col-md-'.$column.' col-sm-'.$column.' col-xs-6 item';
										$post=get_post(get_the_id());
										$date_pro=strtotime($post->post_date);
										$date_now=strtotime('now');
										$set_timer = sv_get_option( 'sv_set_time_woo', 30);
										$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
										if($uppsell < 0) $uppsell_html = '<span class="status-product-new">'.esc_html__('new','7upframework').'</span>';
                    					else $uppsell_html = '';
										$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
										$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
										$sale_price_dates_to 	= ( $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
										$percent = '';
										if($sale_price) {
					                        $percent = '<span class="status-product-sale">'.round((($regular_price-$sale_price)/$regular_price)*100,0).'%</span>';
					                        $price_show = $sale_price;
					                    }
										$args = array('orderby' => 'name', 'order' => 'ASC', 'fields' => 'all');
										$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
										$term_id=$terms[0]->term_id;
										$term_name=$terms[0]->name;
										$link_classes = 'wishlist';
										$product_type = $html_wl = '';
										if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
										$thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
									?>
									
									<li class="<?php echo esc_attr($clearfix);?>">
										<div class="item-product">
											<div class="item-thumb-product">
												<?php echo get_the_post_thumbnail(get_the_ID(),array(270*1.5,344*1.5),array('class' => 'product-thumb-front'));?>
												<img src="<?php echo esc_url($thumbnail_hover);?>" alt="" class="product-thumb-behind" />
												<div class="info-product-cart">
													<div class="inner-info-product-cart">
														<ul>
															<?php echo balanceTags($html_wl);?>
															<li><a data-product-id="<?php echo get_the_ID();?>" href="<?php the_permalink()?>" class="vt_quickview_handler fancybox"><span><i class="fa fa-search"></i></span></a></li>
															<li><?php sv_compare_url(true)?></li>
														</ul>
														<?php 
														echo apply_filters( 'woocommerce_loop_add_to_cart_link',
					                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
					                                                esc_url( $product->add_to_cart_url() ),
					                                                esc_attr( $product->get_id() ),
					                                                esc_attr( $product->get_sku() ),
					                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
					                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
					                                                esc_attr( $product->get_type() ),
					                                                esc_html( $product->add_to_cart_text() )
					                                            ),
					                                        $product );
														?>
													</div>
												</div>
												<?php balanceTags($uppsell_html);?>
												<?php balanceTags($percent);?>
											</div>
											<div class="item-info-product">
												<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
												<div class="info-product-price">
													<?php echo balanceTags($product->get_price_html());?>
												</div>
												<div class="rating-wrap">
												<?php 
												$star = $product->get_average_rating();
							                    $width = $star / 5 * 100;
							                    if($star){?>
							                        <div class="rating">
							                            <div class="ratings">
							                                <div class="rating-box">
							                                    <div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
							                                </div>
							                            </div>
							                        </div>
							                    <?php } ?>
												</div>
											</div>
										</div>										
									</li>
									<?php endwhile;?>
									<!--end item -->
								</ul>
								<?php endif;?>
								<?php sv_paging_nav();?>
								<!--Static HTML -->
								<?php sv_single_advantages();?>								
								<!--Static HTML -->
							</div>
						</div>							
						</div>							
					</div>
				</div>
				<?php if($sidebar_pos=='right'){ get_sidebar('woocommerce'); }?>
				<?php if($sidebar_pos=='both'){ get_sidebar('right'); }?>
			</div>
		</div>
	</div>
</div>
<?php get_footer();?>