<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package 7up-framework
 */
$sidebar=sv_get_sidebar();
$sidebar_pos=$sidebar['position'];
$main_class = 'col-md-12';
if($sidebar_pos != 'no') $main_class = 'content-blog col-lg-9 col-md-8 col-sm-8 col-xs-12';
get_header();?>
<?php sv_header_page();?>
<div id="main-content" class="sv-default">
	
    <div id="blog-page" class="blog-page-default">
        <div class="container">
            <div class="row">   
                <?php if($sidebar_pos=='left'){ get_sidebar(); }?>
                <div class="<?php echo esc_attr($main_class); ?>">
					<div class="wrap-breadcrumb">
						<?php sv_display_breadcrumb();?>
						<?php
							if(is_front_page() && is_home()) $id = (int)get_option( 'page_on_front' );
							if(!is_front_page() && is_home()) $id = (int)get_option( 'page_for_posts' );
						?>
						<h1 class="blog-title"><?php echo get_the_title($id);?></h1>
					</div>
                    <?php if(have_posts()):?>    
					    <?php while (have_posts()) :the_post();?>

							<?php get_template_part('sv_templates/blog-content/content')?>
								
					    <?php endwhile;?>
					    <?php wp_reset_postdata();?>

					    <?php sv_paging_nav();?>

					<?php else : ?>
					    <?php get_template_part( 'sv_templates/blog-content/content', 'none' ); ?>
					<?php endif;?>
                    <?php wp_reset_postdata();?>
                </div>
                <?php if($sidebar_pos=='right'){ get_sidebar(); }?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
