<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package 7up-framework
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<!--<script type='text/javascript' src='http://getfirebug.com/releases/lite/1.2/firebug-lite-compressed.js'></script>-->
<?php wp_head(); ?>
</head>
<?php 
$bg_class = '';
$body_bg = sv_get_value_by_id('body_background');
if(!empty($body_bg)){
	$bg_class = SV_Assets::build_css('background:url("'.$body_bg.'") no-repeat top center;');
}
?>
<body <?php body_class($bg_class); ?>>
<div class="wrap">
<?php 
	$check_fixed = sv_get_option('sv_menu_fixed','on');
	if($check_fixed == 'on') $class_add = 'header_fixed';
	else $class_add = '';
?>
<header id="header" class="site-header clearfix <?php echo esc_attr($class_add);?>">
	<div class="header-container header-container03">
		<!-- <div class="header"> -->
	        <?php
	        $page_id = sv_get_value_by_id('sv_header_page');
	        if(!empty($page_id)){		        	
	        	echo '<div class="header"><div class="container">';
	        	// if(!wp_is_mobile()) echo '<div class="row">';
	        	echo SV_Template::get_vc_pagecontent($page_id);
	        	// if(!wp_is_mobile()) echo '</div>';
	        	echo '</div></div>';
	        }
	        else{ ?>
	        <div class="header header-default">
	        <div class="container">
				<div class="row">
					<div class="header-inner">
						<div class="col-md-12 text-center">
							<a class="logo" href="<?php echo esc_url(home_url('/'));?>">
								<?php $sv_logo=sv_get_option('logo');?>
                                <?php if($sv_logo!=''){
                                    echo '<img src="' .esc_url($sv_logo) . '" alt="logo">';
                                }   else { echo '<h1>'.get_bloginfo('name', 'display').'</h1>'; }
                                ?>
							</a>
						</div>
						<div class="col-md-12">
							<div class="main-nav">
								<?php if ( has_nav_menu( 'primary' ) ) {
	                                wp_nav_menu( array(
                                        'theme_location' => 'primary',
                                        'container'=>false,
                                        'walker'=>new Sv_nav_menu(),
                                        'menu_class'=>'list-inline',
	                                ));
	                            } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			</div>
			<?php } ?>
		<!-- </div> -->
	</div>  
</header>

