<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package 7up-framework
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */

if ( post_password_required() ) {
    return;
}
if(!function_exists('sv_comments_list'))
{ 
    function sv_comments_list($comment, $args, $depth) {

        $GLOBALS['comment'] = $comment;
        /* override default avatar size */
        $args['avatar_size'] = 122;
        if ('pingback' == $comment->comment_type || 'trackback' == $comment->comment_type) :
            ?>
            <span id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>></span>
            <div class="comment-body">
                <?php esc_html_e('Pingback:', '7upframework'); ?> <?php comment_author_link(); ?> <?php edit_comment_link(esc_html__('Edit', 'unitedthemes'), '<span class="edit-link"><i class="fa fa-pencil-square-o"></i>', '</span>'); ?>
            </div>
        <?php else : ?>
            <div id="comment-<?php comment_ID(); ?>" <?php comment_class(empty($args['has_children']) ? '' : 'parent' ); ?>>
                <article id="div-comment-<?php comment_ID(); ?>" class="clearfix media">
                    <a class="media-left" href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"> <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size']); ?> </a>
                    <div class="media-body">
                        <h3 class="media-heading"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"> <?php printf(esc_html__('%s', '7upframework'), sprintf('<cite class="fn">%s</cite>', get_comment_author_link())); ?></a> <small><?php echo human_time_diff( get_comment_time('U'), current_time('timestamp') ) .' '.  esc_html__("ago",'7upframework'); ?></small></h3>
                        <?php comment_text();?>
                        <?php if (is_super_admin()): ?>
                            <a href="<?php echo get_edit_comment_link ( get_comment_ID() ) ?>" class="btn btn-sm btn-reply btn-outline"><i class="fa fa-edit"></i><?php esc_html_e(' Edit','7upframework');?></a>
                        <?php endif; ?>
                        <?php if (comments_open()): ?>
                            <?php echo str_replace('comment-reply-link', 'btn btn-sm btn-reply btn-outline', get_comment_reply_link(array_merge( $args, array('reply_text' =>esc_html__('<i class="fa fa-reply"></i> Reply','7upframework'),'depth' => $depth, 'max_depth' => $args['max_depth'])))) ?>

                        <?php endif; ?>
                    </div>
                                  
                </article><!-- .comment-body -->
            </div>
        <?php
        endif;
    }
}
?>

    <div id="comments" class="comments-area comments">

        <?php // You can start editing here -- including this comment! ?>

        <?php if ( have_comments() ) : ?>
            <h2><?php echo esc_html__('Comments', '7upframework'); ?></h2>
            <ol class="comments">
                <?php
                wp_list_comments(array(
                    'style' => '',
                    'short_ping' => true,
                    'avatar_size' => 74,
                    'max_depth' => '5',
                    // 'callback' => 'sv_comments_list',
                    // 'walker' => new sv_custom_comment()
                ));
                ?>
            </ol>
            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
                <nav id="comment-nav-below" class="comment-navigation" role="navigation">
                    <h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', '7upframework' ); ?></h1>
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', '7upframework' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', '7upframework' ) ); ?></div>
                </nav><!-- #comment-nav-below -->
            <?php endif; // check for comment navigation ?>

        <?php endif; // have_comments() ?>

        <?php
            // If comments are closed and there are comments, let's leave a little note, shall we?
            if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :?>
               <p class="no-comments"><?php esc_html_e( 'Comments are closed.', '7upframework' ); ?></p>
            <?php endif; ?>

    </div><!-- #comments -->
    <div class="leave-comments">
        <?php
        $comment_form = array(
            'title_reply' => esc_html__('Leave a comments', '7upframework'),
            'fields' => apply_filters( 'comment_form_default_fields', array(
                    'author' =>'<div class="form-group">
                                    <label class="control-label" for="author">'.esc_html__( 'Name', '7upframework' ).'</label>
                                    <input class="form-control input-md" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .'" placeholder="'.esc_html__( 'Name', '7upframework' ).'" />
                                </div>',
                    'email' =>'<div class="form-group">
                                    <label class="control-label" for="email">'.esc_html__( 'Email', '7upframework' ).'</label>
                                    <input class="form-control input-md" id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) .'" placeholder="'.esc_html__( 'Email', '7upframework' ).'" />
                                </div>',
                    'url' =>'<div class="form-group">
                                    <label class="control-label" for="url">'.esc_html__( 'Website', '7upframework' ).'</label>
                                    <input class="form-control input-md" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .'" placeholder="'.esc_html__( 'Website', '7upframework' ).'" />
                                </div>',

                )
            ),
            'comment_field' =>  '<div class="form-group">
                                    <label class="control-label">'.esc_html__( 'Message', '7upframework' ).'</label>
                                    <textarea id="comment" class="form-control" rows="5" name="comment" aria-required="true" placeholder="'.esc_html__( 'message:', '7upframework' ).'"></textarea>
                                </div>',
            'must_log_in' => '<div class="must-log-in control-group"><div class="controls">' .sprintf(wp_kses_post(__( 'You must be <a href="%s">logged in</a> to post a comment.','7upframework' )),wp_login_url( apply_filters( 'the_permalink', get_permalink() ) )) . '</div></div >',
            'logged_in_as' => '<div class="logged-in-as control-group"><div class="controls">' .sprintf(wp_kses_post(__( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>','7upframework' )),admin_url( 'profile.php' ),$user_identity,wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) )) . '</div></div>',
            'comment_notes_before' => '',
            'comment_notes_after' => '',
            'id_form'              => 'commentform',
            'id_submit'            => 'submit',
            'title_reply'          => esc_html__( 'Leave Comments','7upframework' ),
            'title_reply_to'       => esc_html__( 'Leave a Reply %s','7upframework' ),
            'cancel_reply_link'    => esc_html__( 'Cancel reply','7upframework' ),
            'label_submit'         => esc_html__( 'Submit','7upframework' ),
            'class_submit'         => 'btn btn-submit',
        );
        ?>
        <?php comment_form($comment_form); ?>
    </div>
<?php

class sv_custom_comment extends Walker_Comment {
     
    /** START_LVL 
     * Starts the list before the CHILD elements are added. */
    function start_lvl( &$output, $depth = 0, $args = array() ) {       
        $GLOBALS['comment_depth'] = $depth + 1;

           $output .= '<div class="children">';
        }
 
    /** END_LVL 
     * Ends the children list of after the elements are added. */
    function end_lvl( &$output, $depth = 0, $args = array() ) {
        $GLOBALS['comment_depth'] = $depth + 1;
        $output .= '</div>';
    }
    function end_el( &$output, $object, $depth = 0, $args = array() ) {
        $output .= '';
    }
}
?>

