<?php
/*
 * Template Name: Blog Template
 *
 *
 * */

$sidebar=sv_get_sidebar();
$sidebar_pos=$sidebar['position'];
$main_class = '';
if($sidebar_pos != 'no') $main_class = 'content-blog col-lg-9 col-md-8 col-sm-8 col-xs-12';
get_header();?>
<?php sv_header_page();?>
<div id="main-content" class="sv-default">
    <div id="blog-page" class="blog-page-default">
        <div class="container">
            <div class="row">
                <?php if($sidebar_pos=='left'){ get_sidebar(); }?>				
                <div class="<?php echo esc_attr($main_class); ?>">
                    <div class="wrap-breadcrumb">
                        <?php sv_display_breadcrumb();?>
                        <h1 class="blog-title"><?php echo get_the_title();?></h1>
                    </div>
                    <?php 
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    query_posts('post_type=post&paged='.$paged );
                    ?>
                    <?php if(have_posts()):?>    
					    <?php while (have_posts()) :the_post();?>
							<?php get_template_part('sv_templates/blog-content/content')?>
								
					    <?php endwhile;?>
					    <?php wp_reset_postdata();?>

					    <?php sv_paging_nav();?>

					<?php else : ?>
					    <?php get_template_part( 'sv_templates/blog-content/content', 'none' ); ?>
					<?php endif;?>
                    <?php wp_reset_postdata();?>
                </div>
                <?php if($sidebar_pos=='right'){ get_sidebar(); }?>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
