<?php
/**
 * Adds Foo_Widget widget.
 */
class SV_Featured_Product extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'sv_featured_product', // Base ID
			esc_html__( 'Featured Product', '7upframework' ), // Name
			array( 'description' => esc_html__( 'View Featured Woocommerce Product', '7upframework' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo balancetags($args['before_widget']);
		if ( ! empty( $instance['title'] ) ) {
			echo balancetags($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
		}
		?>
		
		<?php
			$number = absint( $instance['number'] );
			$featured_args = array(
				'post_type' => 'product',
				'posts_per_page'=>$number,
			);
			$featured_args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
			$query = new WP_Query($featured_args);
			if($query->have_posts()):
		?>
		<div class="block block-special vt-slider clearfix">
			<div class="slider-inner">
				<div class="container-slider">
					<div class="wrap-item">
						<?php 
							$key=0;
							while($query->have_posts()) : $query->the_post();
							$key++;
							$post=get_post(get_the_id());
							$date_pro=strtotime($post->post_date);
							$date_now=strtotime('now');
							$set_timer = sv_get_option( 'sv_set_time_woo', 30);
							$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
							$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
							$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
							$sale_price_dates_to 	= ( $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
							if($sale_price) $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
							else $sale_price = $regular_price;
							$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
							$cat_html = '';
							if(is_object($terms) && !empty($terms)){
								$term_id=$terms[0]->term_id;
								$term_name=$terms[0]->name;
								$cat_html = '<div class="cate-name">
												<a href="'.get_term_link( $term_id, 'product_cat' ).'">'.$term_name.'</a>
											</div>';
							}
							$link_classes = 'wishlist';
							$product_type = '';
						?>
						<div class="item">
							<div class="inner">
								<div class="item-image">
									<div class="item-image-inner">
										<a href="<?php the_permalink();?>" class="product-image">
											<img alt="" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()))?>"/>
										</a> 
									</div>
								</div>
								<div class="subitem">
									<div class="subitem-image">
										<div class="item-image-inner">
											<a href="<?php the_permalink();?>" class="product-image">
												<img alt="" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()))?>"/>
											</a> 
											<div class="item-btn">
												<div class="btn-wqc">
													<?php if(class_exists('YITH_WCWL_Init')):?>
														<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr(get_the_id()) ?>" class="add_to_wishlist link-wishlist" ></a>
													<?php endif;?>
													<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
													<?php
														sv_compare_url(true);
													?>
												</div>  
											</div>
										</div>
									</div>
									<div class="product-info">
										<div class="product-name">
											<a href="<?php the_permalink();?>"><?php the_title();?></a>
										</div>
										<?php echo balancetags($cat_html);?>
										<div class="wrap-ns-price">
											<div class="price-box">
												<p class="special-price">
													<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php global $product;echo esc_attr($product->get_price()); ?></span>
												</p>
												<p class="old-price">
													<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($sale_price);?></span>
												</p>
											</div>
											<div class="wrap-new-sale">
												<?php if($percent):?>
													<div class="sale-item"><?php echo esc_attr($percent);?></div>
												<?php endif;?>
												<?php if($uppsell<0):?>
													<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
												<?php endif;?>
											</div>
										</div>
										<?php
											global $product;
											echo apply_filters( 'woocommerce_loop_add_to_cart_link',
												sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
													esc_url( $product->add_to_cart_url() ),
													esc_attr( $product->get_id() ),
													esc_attr( $product->get_sku() ),
													esc_attr( isset( $quantity ) ? $quantity : 1 ),
													$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
													esc_attr( $product->get_type() ),
													esc_html( $product->add_to_cart_text() )
												),
											$product );
										?>	
									</div>
									<!--end product-info-->
								</div>
								<!--end subitem-->
							</div>
						</div>
						<?php endwhile;?>
						<!--end item-->
					</div>
					<!--wrap-item-->
				</div>
				<!--container-slider-->	
			</div>
			<!--slider-inner-->	
		</div>
		<?php endif;wp_reset_postdata();?>
		<?php
		echo balancetags($args['after_widget']);
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'New title', '7upframework' );
		$number = empty( $instance['number'] ) ? 6 : absint( $instance['number'] );
		?>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', '7upframework' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number:', '7upframework' ); ?></label> 
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="text" value="<?php echo esc_attr( $number ); ?>">
		</p>
		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['number'] = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : '';
		return $instance;
	}

} // class Foo_Widget
// register Foo_Widget widget
function register_sv_featured_product() {
    register_widget( 'SV_Featured_Product' );
}
add_action( 'widgets_init', 'register_sv_featured_product' );