<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
 
/******************************************Core Function******************************************/
//Get option
if(!function_exists('sv_get_option')){
    function sv_get_option($key,$default=NULL)
    {
        if(function_exists('ot_get_option'))
        {
            return ot_get_option($key,$default);
        }

        return $default;
    }
}

//Autoload folder
if(!function_exists('sv_load_elements')){
    function sv_load_elements($folder)
    {
        //Auto load widget
        $files=glob(get_template_directory()."/"."7upframe/".$folder."/*.php");

        // Auto load all file
        if(!empty($files)){
            foreach ($files as $filename)
            {
                require_once $filename;
            }
        }

    }
}

//Get list header page
if(!function_exists('sv_list_header_page'))
{
    function sv_list_header_page()
    {
        global $post;
        $page_list = array();
        $page_list[] = array(
            'value' => '',
            'label' => esc_html__('-- Choose One --','7upframework')
        );
        $args= array(
        'post_type' => 'page',
        'posts_per_page' => -1, 
        );
        $query = new WP_Query($args);
        if($query->have_posts()): while ($query->have_posts()):$query->the_post();
            if (strpos($post->post_content, '[sv_logo') ||  strpos($post->post_content, '[sv_menu')) {
                $page_list[] = array(
                    'value' => $post->ID,
                    'label' => $post->post_title
                );
            }
            endwhile;
        endif;
        wp_reset_postdata();
        return $page_list;
    }
}

//Get list sidebar
if(!function_exists('sv_get_sidebar_ids'))
{
    function sv_get_sidebar_ids($for_optiontree=false)
    {
        global $wp_registered_sidebars;
        $r=array();
        $r[]=esc_html__('--Select--','7upframework');
        if(!empty($wp_registered_sidebars)){
            foreach($wp_registered_sidebars as $key=>$value)
            {

                if($for_optiontree){
                    $r[]=array(
                        'value'=>$value['id'],
                        'label'=>$value['name']
                    );
                }else{
                    $r[$value['id']]=$value['name'];
                }
            }
        }
        return $r;
    }
}

//Get order list
if(!function_exists('sv_get_order_list'))
{
    function sv_get_order_list($current=false,$extra=array(),$return='array')
    {
        $default = array(
            esc_html__('None','7upframework')               => 'none',
            esc_html__('Post ID','7upframework')            => 'ID',
            esc_html__('Author','7upframework')             => 'author',
            esc_html__('Post Title','7upframework')         => 'title',
            esc_html__('Post Name','7upframework')          => 'name',
            esc_html__('Post Date','7upframework')          => 'date',
            esc_html__('Last Modified Date','7upframework') => 'modified',
            esc_html__('Post Parent','7upframework')        => 'parent',
            esc_html__('Random','7upframework')             => 'rand',
            esc_html__('Comment Count','7upframework')      => 'comment_count',
            esc_html__('View Post','7upframework')          => 'post_views',
            esc_html__('Like Post','7upframework')          => '_post_like_count',
            esc_html__('Custom Modified Date','7upframework')=> 'time_update',            
        );

        if(!empty($extra) and is_array($extra))
        {
            $default=array_merge($default,$extra);
        }

        if($return=="array")
        {
            return $default;
        }elseif($return=='option')
        {
            $html='';
            if(!empty($default)){
                foreach($default as $key=>$value){
                    $selected=selected($key,$current,false);
                    $html.="<option {$selected} value='{$key}'>{$value}</option>";
                }
            }
            return $html;
        }
    }
}

// Get sidebar
if(!function_exists('sv_get_sidebar'))
{
    function sv_get_sidebar()
    {
        $default=array(
            'position'=>'right',
            'id'      =>'blog-sidebar'
        );

        return apply_filters('sv_get_sidebar',$default);
    }
}

//Favicon
if(!function_exists('sv_load_favicon'))
{
    add_action( 'wp_head','sv_load_favicon');
    add_action('login_head', 'sv_load_favicon');
    add_action('admin_head', 'sv_load_favicon');
    function sv_load_favicon()
    {
        $value = sv_get_option('favicon');
        $favicon = (isset($value) && !empty($value))?$value:false;
        if($favicon)
            echo '<link rel="Shortcut Icon" href="' . esc_url( $favicon ) . '" type="image/x-icon" />' . "\n";
    }
}

//Fill css background
if(!function_exists('sv_fill_css_background'))
{
    function sv_fill_css_background($data)
    {
        $string = '';
        if(!empty($data['background-color'])) $string .= 'background-color:'.$data['background-color'].';'."\n";
        if(!empty($data['background-repeat'])) $string .= 'background-repeat:'.$data['background-repeat'].';'."\n";
        if(!empty($data['background-attachment'])) $string .= 'background-attachment:'.$data['background-attachment'].';'."\n";
        if(!empty($data['background-position'])) $string .= 'background-position:'.$data['background-position'].';'."\n";
        if(!empty($data['background-size'])) $string .= 'background-size:'.$data['background-size'].';'."\n";
        if(!empty($data['background-image'])) $string .= 'background-image:url("'.$data['background-image'].'");'."\n";
        if(!empty($string)) return SV_Assets::build_css($string);
        else return false;
    }
}

// Get list menu
if(!function_exists('sv_list_menu_name'))
{
    function sv_list_menu_name()
    {
        $menu_nav = wp_get_nav_menus();
        $menu_list = array('Default' => '');
        if(is_array($menu_nav) && !empty($menu_nav))
        {
            foreach($menu_nav as $item)
            { 
                if(is_object($item))
                {
                    $menu_list[$item->name] = $item->slug;
                }
            }
        }
        return $menu_list;
    }
}

//Display BreadCrumb
if(!function_exists('sv_display_breadcrumb'))
{
    function sv_display_breadcrumb()
    {
        $breadcrumb = sv_get_value_by_id('sv_show_breadrumb','on');
        // if($breadcrumb == 'on'){ 
            $b_class = sv_fill_css_background(sv_get_option('sv_bg_breadcrumb'));
            ?>
            <div class="tp-breadcrumb <?php echo esc_attr($b_class)?>">
                <?php 
                    if(function_exists('bcn_display')) bcn_display();
                    else sv_breadcrumb();
                ?>
            </div>
        <?php //}
    }
}

//Custom BreadCrumb
if(!function_exists('sv_breadcrumb'))
{
    function sv_breadcrumb() {
        global $post;
        echo '<ul id="breadcrumbs">';
        if (!is_home() || (is_home() && !is_front_page())) {
            echo '<li><a href="';
            echo esc_url(home_url('/'));
            echo '">';
            echo esc_html__('Home','7upframework');
            echo '</a></li><li class="separator">'.' <i class="fa fa-angle-right"></i> '.'</li>';
            if(is_home() && !is_front_page()){
                echo '<li>'.esc_html__('Blog','7upframework').'</li>'; 
            }
            if (is_category() || is_single()) {
                echo '<li>';
                the_category(' </li><li class="separator"> <i class="fa fa-angle-right"></i> </li><li> ');
                if (is_single()) {
                    echo '</li><li class="separator"> <i class="fa fa-angle-right"></i> </li><li>';
                    the_title();
                    echo '</li>';
                }
            } elseif (is_page()) {
                if($post->post_parent){
                    $anc = get_post_ancestors( get_the_ID() );
                    $title = get_the_title();
                    foreach ( $anc as $ancestor ) {
                        $output = '<li><a href="'.get_permalink($ancestor).'" title="'.get_the_title($ancestor).'">'.get_the_title($ancestor).'</a></li> <li class="separator">/</li>';
                    }
                    echo balanceTags($output);
                    echo '<strong title="'.$title.'"> '.$title.'</strong>';
                } else {
                    echo '<li><strong> '.get_the_title().'</strong></li>';
                }
            }
        }
        elseif (is_tag()) {single_tag_title();}
        elseif (is_day()) {echo"<li>Archive for "; the_time('F jS, Y'); echo'</li>';}
        elseif (is_month()) {echo"<li>Archive for "; the_time('F, Y'); echo'</li>';}
        elseif (is_year()) {echo"<li>Archive for "; the_time('Y'); echo'</li>';}
        elseif (is_author()) {echo"<li>Author Archive"; echo'</li>';}
        elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>Blog Archives"; echo'</li>';}
        elseif (is_search()) {echo"<li>Search Results"; echo'</li>';}
        echo '</ul>';
    }
}

//Get page value by ID
if(!function_exists('sv_get_value_by_id'))
{   
    function sv_get_value_by_id($key)
    {
        if(!empty($key)){
            $id = get_the_ID();
            if(is_front_page() && is_home()) $id = (int)get_option( 'page_on_front' );
            if(!is_front_page() && is_home()) $id = (int)get_option( 'page_for_posts' );
            if(is_archive()) $id = 0;
            // var_dump($id);
            $value = get_post_meta($id,$key,true);
            if(empty($value)) $value = sv_get_option($key);
            return $value;
        }
        else return 'Missing a variable of this funtion';
    }
}

//Check woocommerce page
if (!function_exists('sv_is_woocommerce_page')) {
    function sv_is_woocommerce_page() {
        if(  function_exists ( "is_woocommerce" ) && is_woocommerce()){
                return true;
        }
        $woocommerce_keys   =   array ( "woocommerce_shop_page_id" ,
                                        "woocommerce_terms_page_id" ,
                                        "woocommerce_cart_page_id" ,
                                        "woocommerce_checkout_page_id" ,
                                        "woocommerce_pay_page_id" ,
                                        "woocommerce_thanks_page_id" ,
                                        "woocommerce_myaccount_page_id" ,
                                        "woocommerce_edit_address_page_id" ,
                                        "woocommerce_view_order_page_id" ,
                                        "woocommerce_change_password_page_id" ,
                                        "woocommerce_logout_page_id" ,
                                        "woocommerce_lost_password_page_id" ) ;
        foreach ( $woocommerce_keys as $wc_page_id ) {
                if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
                        return true ;
                }
        }
        return false;
    }
}

//navigation
if(!function_exists('sv_paging_nav'))
{
    function sv_paging_nav()
    {
        // Don't print empty markup if there's only one page.
        if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
            return;
        }

        $paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
        $pagenum_link = html_entity_decode( get_pagenum_link() );
        $query_args   = array();
        $url_parts    = explode( '?', $pagenum_link );

        if ( isset( $url_parts[1] ) ) {
            wp_parse_str( $url_parts[1], $query_args );
        }

        $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
        $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

        $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
        $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

        // Set up paginated links.
        $links = paginate_links( array(
            'base'     => $pagenum_link,
            'format'   => $format,
            'total'    => $GLOBALS['wp_query']->max_num_pages,
            'current'  => $paged,
            'mid_size' => 1,
            'add_args' => array_map( 'urlencode', $query_args ),
            'prev_text' => esc_html__( '&larr;', 'twentyfourteen' ),
            'next_text' => esc_html__( '&rarr;', 'twentyfourteen' ),
        ) );

        if ($links) : ?>
            <nav class="navigation paging-navigation">
                <div class="pagination loop-pagination">
                    <?php echo balanceTags($links); ?>
                </div><!-- .pagination -->
            </nav><!-- .navigation -->
        <?php endif;
    }
}

//Set post view
if(!function_exists('sv_set_post_view'))
{
    function sv_set_post_view($post_id=false)
    {
        if(!$post_id) $post_id=get_the_ID();

        $view=(int)get_post_meta($post_id,'post_views',true);
        $view++;
        update_post_meta($post_id,'post_views',$view);
    }
}

//Get post view
if(!function_exists('sv_get_post_view'))
{
    function sv_get_post_view($post_id=false)
    {
        if(!$post_id) $post_id=get_the_ID();

        return (int)get_post_meta($post_id,'post_views',true);
    }
}

//remove attr embed
if(!function_exists('sv_remove_w3c')){
    function sv_remove_w3c($embed_code){
        $embed_code=str_replace('webkitallowfullscreen','',$embed_code);
        $embed_code=str_replace('mozallowfullscreen','',$embed_code);
        $embed_code=str_replace('frameborder="0"','',$embed_code);
        $embed_code=str_replace('frameborder="no"','',$embed_code);
        $embed_code=str_replace('scrolling="no"','',$embed_code);
        $embed_code=str_replace('&','&amp;',$embed_code);
        return $embed_code;
    }
}

// MetaBox
if(!function_exists('sv_display_metabox'))
{
    function sv_display_metabox($type ='') {?>
        <div class="meta-box">
            <!-- <span class="meta-item"><i class="fa fa-calendar"></i><?php //echo get_the_date('M j Y'); ?></span> -->
            <a class="meta-item" href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><i class="fa fa-user"></i><?php echo get_the_author(); ?></a>
            <span class="meta-item"><i class="fa fa-folder-open"></i>
                <?php $cats = get_the_category_list(', ');?>
                <?php if($cats) echo balanceTags($cats); else esc_html_e("No Category",'7upframework');?>
            </span>
            <span class="meta-item"><i class="fa fa-tags"></i>
                <?php $tags = get_the_tag_list('',', ','');?>
                <?php if($tags) echo balanceTags($tags); else esc_html_e("No Tag",'7upframework');?>
            </span>

            <a class="meta-item-end" href="<?php echo get_comments_link()?>"><i class="fa fa-comments"></i><?php echo get_comments_number(); ?> <?php echo (get_comments_number()>1) ? esc_html__('Comments','7upframework') :  esc_html__('Comment','7upframework')?> </a>
            
        </div>
    <?php }
}
// get list taxonomy
if(!function_exists('sv_vc_list_taxonomy'))
{
    function sv_vc_list_taxonomy($taxonomy,$show_all = true)
    {
        if($show_all) $list = array('--Select--' => '');
        else $list = array();
        if(!isset($taxonomy) || empty($taxonomy)) $taxonomy = 'category';
        $tags = get_terms('product_cat');
        foreach ($tags as $tag) {
            $list[$tag->name] = $tag->slug;
        }
        return $list;
    }
}
/***************************************END Core Function***************************************/


/***************************************Add Theme Function***************************************/

//Search Product By Category
if(!function_exists('sv_search_product')){
    function sv_search_product(){?>
    <form id="search_mini_form" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
        <div class="dropdown-cate">
            <span class="cat-search"><?php esc_html_e("All Categories",'7upframework');?></span>
            <div class="wrap-scrollbar" style="display: none;">
                <div class="slimScrollDiv">
                    <div class="scrollbar">
                        <ul>
                            <li><?php esc_html_e("All Categories",'7upframework');?> </li>
                            <?php 
                                $product_cat_list = get_terms('product_cat');
                                if(is_array($product_cat_list) && !empty($product_cat_list)){
                                    foreach ($product_cat_list as $cat) {
                                        echo '<li data-filter=".'.$cat->slug.'">'.$cat->name.'</li>';
                                    }
                                }
                            ?>
                        </ul>
                    </div>
                    <!-- <div class="slimScrollBar"></div>
                    <div class="slimScrollRail"></div> -->
                </div>
            </div>
        </div>
        <div class="form-search">    
            <input id="search" type="search" class="input-text" placeholder="<?php echo esc_html__( 'Enter Key Search ...', '7upframework' ); ?>" value="<?php echo get_search_query(); ?>" name="s"/>
            <input type="hidden" name="post_type" value="product" />
            <input class="cat-value" type="hidden" name="product_cat" value="" />
            <button type="submit" class="button form-button"><span><?php echo esc_html__( 'Search', '7upframework' ); ?></span></button>
        </div>
    </form>

    <?php }
}
if(!function_exists('sv_search_product2')){
    function sv_search_product2(){?>
    <form method="get" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
        <div class="search-cat">
            <a href="#" class="box-cat-toggle cat-search">All Categories</a>
            <div class="list-cat-scrollbar">
                <div class="scrollbar">
                    <ul>
                        <li><a href="#"><?php esc_html_e("All Categories",'7upframework');?> </a></li>
                        <?php 
                            $product_cat_list = get_terms('product_cat');
                            if(is_array($product_cat_list) && !empty($product_cat_list)){
                                foreach ($product_cat_list as $cat) {
                                    echo '<li data-filter=".'.$cat->slug.'"><a href="#">'.$cat->name.'</a></li>';
                                }
                            }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="search-form home13">    
            <input type="text" class="search-style13" placeholder="<?php echo esc_html__( 'Search ...', '7upframework' ); ?>" value="<?php echo get_search_query(); ?>" name="s"/>
            <input type="hidden" name="post_type" value="product" />
            <input class="cat-value" type="hidden" name="product_cat" value="" />
            <input type="submit" class="search-style13"/>
        </div>
    </form>

    <?php }
}
if(!function_exists('sv_simple_search_form')){
    function sv_simple_search_form(){ ?>
        <form id="search_mini_form" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
            <?php 
            $search_val = get_search_query();
            if(empty($search_val)){
                $search_val = esc_html__("Search...","7upframework");
            }
            ?>
            <input type="text" name="s" value="<?php echo esc_attr($search_val);?>" onfocus="if (this.value==this.defaultValue) this.value = ''" onblur="if (this.value=='') this.value = this.defaultValue">
            <input type="hidden" name="post_type" value="product" />
            <input class="cat-value" type="hidden" name="product_cat" value="" />
            <input type="submit"/>
        </form>
    <?php }
}
if(!function_exists('sv_cat_search_list')){
    function sv_cat_search_list(){ ?>
        <div class="wrap-scrollbar" style="display: none;">
            <div class="slimScrollDiv">
                <div class="scrollbar">
                    <ul>
                        <li><?php esc_html_e("All Categories",'7upframework');?> </li>
                        <?php 
                            $product_cat_list = get_terms('product_cat');
                            if(is_array($product_cat_list) && !empty($product_cat_list)){
                                foreach ($product_cat_list as $cat) {
                                    echo '<li data-filter=".'.$cat->slug.'">'.$cat->name.'</li>';
                                }
                            }
                        ?>
                    </ul>
                </div>
                <!-- <div class="slimScrollBar"></div>
                <div class="slimScrollRail"></div> -->
            </div>
        </div>
    <?php }
}
//Header page
if(!function_exists('sv_header_page')){
    function sv_header_page(){
        $url = sv_get_option('header_url');
        $image = sv_get_value_by_id('header_bg');
        $title = sv_get_option('header_title');
        if(function_exists('is_shop')) $is_shop = is_shop();
        else $is_shop = false;
        if(!$is_shop && !is_single()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            if(is_object($cat_obj)){
                $get_meta_option = get_option('term_cat_meta');
                $term_option_name = "taxonomy_".$cat_obj->slug;
                if(isset($get_meta_option[$term_option_name])){
                    $term_meta = $get_meta_option[$term_option_name];
                    if(isset($term_meta['header_cat'])){
                        if(!empty($term_meta['header_cat'])) $image = wp_get_attachment_url($term_meta['header_cat']);
                    }
                }                
            }
            if(is_archive()) $title = get_the_archive_title();
            else $title = get_the_title();
        }
        if(is_single()) {
            $header_meta = get_post_meta(get_the_ID(),'header_title',true);
            if(!empty($header_meta)) $title = $header_meta;
            else $title = get_the_title();
            $image = sv_get_value_by_id('header_bg');
            $url = get_the_permalink();
        }
        if((!is_front_page() && is_home()) || (is_front_page() && is_home())){
            $title = 'Wellcome to our Canifa Blog';
            $image = sv_get_value_by_id('header_bg');
        }
        $header_show = sv_get_value_by_id('show_header');
        ?>
        <?php if(($header_show == 'on' || $header_show == 'yes') && !empty($image)):?>
            <div class="block-banner-cate">
                <a href="<?php echo esc_url($url);?>">
                    <img src="<?php echo esc_url($image);?>" alt="banner-image">
                </a>
            <?php if(!empty($title)):?>
                <div class="block-banner-cate-inner">
                    <div class="container">
                        <div class="row">
                            <div class="row">
                                <h1 class="title">
                                    <?php echo balanceTags($title);?>
                                </h1>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif;?>
            </div>
        <?php endif;?>
    <?php }
}
// auto create attribute
if( class_exists( 'WooCommerce' ) ){
    $transient_name = 'wc_attribute_taxonomies';
    global $wpdb;
    $attribute_taxonomies = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "woocommerce_attribute_taxonomies" );
    $attribute_size = array(
        'attribute_id' => ''.rand().'', 
        'attribute_name' => 'size', 
        'attribute_label' => 'Size',
        'attribute_public' => '',
        'attribute_type' => 'select', 
        'attribute_orderby' => 'menu_order', 
        );
    $attribute_color = array(
        'attribute_id' => ''.rand().'', 
        'attribute_name' => 'color', 
        'attribute_label' => 'Color',
        'attribute_public' => '',
        'attribute_type' => 'select', 
        'attribute_orderby' => 'menu_order', 
        );
    $attribute_brand = array(
        'attribute_id' => ''.rand().'', 
        'attribute_name' => 'brand', 
        'attribute_label' => 'Brand',
        'attribute_public' => '', 
        'attribute_type' => 'select', 
        'attribute_orderby' => 'menu_order', 
        );
    $attribute_material = array(
        'attribute_id' => ''.rand().'', 
        'attribute_name' => 'material', 
        'attribute_label' => 'Material',
        'attribute_public' => '', 
        'attribute_type' => 'select', 
        'attribute_orderby' => 'menu_order', 
        );
    if(empty($attribute_taxonomies)){
        $wpdb->insert( $wpdb->prefix . "woocommerce_attribute_taxonomies", $attribute_size, '%s' );
        $wpdb->insert( $wpdb->prefix . "woocommerce_attribute_taxonomies", $attribute_color, '%s' );
        $wpdb->insert( $wpdb->prefix . "woocommerce_attribute_taxonomies", $attribute_brand, '%s' );
        $wpdb->insert( $wpdb->prefix . "woocommerce_attribute_taxonomies", $attribute_material, '%s' );
        $attribute_taxonomies = $wpdb->get_results( "SELECT * FROM " . $wpdb->prefix . "woocommerce_attribute_taxonomies" );
        set_transient( $transient_name, $attribute_taxonomies );
        delete_transient( $transient_name );
    }
}

if(!function_exists('sv_single_advantages')){
    function sv_single_advantages(){
        $html = sv_get_option('single_advantages');
        if(!empty($html)) echo apply_filters('the_content',$html);
    }
}
//excerpt
function sv_custom_excerpt_length( $length ) {
    return 40;
}
add_filter( 'excerpt_length', 'sv_custom_excerpt_length', 999 );
function sv_excerpt_more($more) {
    return ' ...';
}
add_filter('excerpt_more', 'sv_excerpt_more');
// CHECK BROWSER
if(!function_exists('sv_getBrowser')){
    function sv_getBrowser() 
    { 
        $u_agent = $_SERVER['HTTP_USER_AGENT'];
        $bname = 'Unknown';
        $platform = 'Unknown';
        $version= "";

        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        }
        elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        }
        elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }
        
        // Next get the name of the useragent yes seperately and for good reason
        if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Internet Explorer'; 
            $ub = "MSIE"; 
        } 
        elseif(preg_match('/Firefox/i',$u_agent)) 
        { 
            $bname = 'Mozilla Firefox'; 
            $ub = "Firefox"; 
        } 
        elseif(preg_match('/Chrome/i',$u_agent)) 
        { 
            $bname = 'Google Chrome'; 
            $ub = "Chrome"; 
        } 
        elseif(preg_match('/Safari/i',$u_agent)) 
        { 
            $bname = 'Apple Safari'; 
            $ub = "Safari"; 
        } 
        elseif(preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Opera'; 
            $ub = "Opera"; 
        } 
        elseif(preg_match('/Netscape/i',$u_agent)) 
        { 
            $bname = 'Netscape'; 
            $ub = "Netscape"; 
        } 
        
        // finally get the correct version number
        $known = array('Version', $ub, 'other');
        $pattern = '#(?<browser>' . join('|', $known) .
        ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }
        
        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
                $version= $matches['version'][0];
            }
            else {
                $version= $matches['version'][1];
            }
        }
        else {
            $version= $matches['version'][0];
        }
        
        // check if we have a number
        if ($version==null || $version=="") {$version="?";}
        
        return array(
            'userAgent' => $u_agent,
            'name'      => $bname,
            'version'   => $version,
            'platform'  => $platform,
            'pattern'    => $pattern
        );
    }
}
//Compare URL
if(!function_exists('sv_compare_url')){
    function sv_compare_url($echo = false, $ajax = false){
        global $yith_woocompare;
        $browser = sv_getBrowser();
        if(strpos($browser['name'],'Safari')) $safari = false;
        else $safari = true;
        if(is_single()) $cp_text = esc_html__("Compare","7upframework");
        else $cp_text = '<i class="fa fa-external-link-square"></i>';
        $id = get_the_ID();
        $cp_link = str_replace('&', '&amp;',add_query_arg( array('action' => 'yith-woocompare-add-product','id' => $id )));
        if(class_exists('YITH_Woocompare_Frontend') && $safari){            
            if($echo){
                if($ajax){
                    $cp_text = esc_html__("Compare","7upframework");                    
                    echo '<a href="'.$cp_link.'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.$cp_text.'</a>';
                }
                else echo '<a href="'.$yith_woocompare->obj->add_product_url( get_the_ID()).'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.$cp_text.'</a>';
            }
            else{
                if($ajax){
                    $html = '<a href="'.$cp_link.'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.$cp_text.'</a>';
                }
                else $html = '<a href="'.$cp_link.'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.$cp_text.'</a>';
                return $html;
            }
        }
    }
}
/***************************************END Theme Function***************************************/
// var_dump($_SERVER['HTTP_USER_AGENT']);
?>
