<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_wc_product_onsale' ) ) {
	function sv_wc_product_onsale( $atts, $content = null ) {
		$html = $title = '';
		extract( shortcode_atts(
			array(
				'title'  	=> '',
				'style'  	=> '',
			), $atts ) );
		ob_start();
		?>
		<?php
			$args = array(
					'post_type' => 'product',					
				);
			$args['meta_query']['relation']= 'OR';
            $args['meta_query'][]=array(
                'key'   => '_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
            $args['meta_query'][]=array(
                'key'   => '_min_variation_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
			$query = new WP_Query($args);
			if($query->have_posts()):
		?>
		<div class="block-lastest-deals product">
			<div class="title">
				<h2><?php echo esc_attr($title);?></h2>
				<div class="navslider">
					<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework')?></span></a>
					<a href="#" class="next"><span><?php esc_html_e('Next','7upframework')?></span></a>
				</div>
			</div>
			<div class="slider-inner">
				<div class="container-slider">
					<div class="wrap_item">
						<?php 
							$key=0;
							while($query->have_posts()) : $query->the_post();
							global $product;
							$key++;
							$post=get_post(get_the_id());
							$date_pro=strtotime($post->post_date);
							$date_now=strtotime('now');
							$set_timer = sv_get_option( 'sv_set_time_woo', 30);
							$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
							$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
							$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
							$sale_price_dates_to 	= ( $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
							if($sale_price) $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
							else $sale_price = $regular_price;							
							$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
							$cat_html = '';
                            if(is_object($terms) && !empty($terms)){
                                $term_id=$terms[0]->term_id;
                                $term_name=$terms[0]->name;
                                $cat_html = '<div class="cate-name">
                                                <a href="'.get_term_link( $term_id, 'product_cat' ).'">'.$term_name.'</a>
                                            </div>';
                            }
							$link_classes = 'wishlist';
							$product_type = '';
						?>
						<div class="item">
							<div class="inner">
								<div class="item-image">
									<div class="item-image-inner">
										<a href="<?php the_permalink();?>" class="product-image">
											<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
										</a>                             
										<div class="item-btn">
											<div class="btn-wqc">
												<?php if(class_exists('YITH_WCWL_Init')):?>
													<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr(get_the_id()) ?>" class="add_to_wishlist link-wishlist" ></a>
												<?php endif;?>
												<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
												<?php
													sv_compare_url(true);
												?>
											</div>  
										</div>
									</div>
								</div>
								<div class="product-info">
									<div class="product-name">
										<a href="<?php the_permalink();?>"><?php the_title();?></a>
									</div>
									<?php echo balanceTags($cat_html)?>
									<div class="wrap-ns-price">
										<div class="price-box">
											<p class="special-price">
												<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
											</p>
											<p class="old-price">
												<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
											</p>
										</div>
										<div class="wrap-new-sale">
											<?php if($percent):?>
												<div class="sale-item"><?php echo esc_attr($percent);?></div>
											<?php endif;?>
											<?php if($uppsell<0):?>
												<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
											<?php endif;?>
										</div>
									</div>
									<div class="defaultCountdown1 sv-countdown" data-dateto="<?php echo esc_attr($sale_price_dates_to);?>"></div>
									
									<div class="rating">
									<?php	
										global $product;             
										$star = $product->get_average_rating();
										$width = $star / 5 * 100;
										if($star):
									?>
										<div class="ratings">
											<div class="rating-box">
												<div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
											</div>
										</div>
										<p class="rating-links">
											<a href="<?php the_permalink()?>/#tab-reviews"><?php echo esc_attr($product->get_review_count());esc_html_e(' (vote)','7upframework');?></a>
											<span class="separator">|</span>
											<a href="" class="re-temp"><?php esc_html_e('Add Review','7upframework');?></a>
										</p>
									<?php endif;?>
									</div>
									<div class="desc">
										<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
									</div>
									<?php
										echo apply_filters( 'woocommerce_loop_add_to_cart_link',
											sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
												esc_url( $product->add_to_cart_url() ),
												esc_attr( $product->get_id() ),
												esc_attr( $product->get_sku() ),
												esc_attr( isset( $quantity ) ? $quantity : 1 ),
												$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
												esc_attr( $product->get_type() ),
												esc_html( $product->add_to_cart_text() )
											),
										$product );
									?>	
								</div>
							</div>
							<!--end inner -->
						</div>
						<!--end item -->
						<?php endwhile;?>
					</div>
					<!--wrap_item -->
				</div>
				<!--end container slider -->
			</div>
			<!--end slider-inner -->
		</div>
		<?php endif;wp_reset_postdata();?>
		<?php
		$html .= @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('wc_product_onsale','sv_wc_product_onsale');
/* Sale off Product
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Product Onsale', '7upframework' ),
		'category'  => '7Up-theme',
		'base'     => 'wc_product_onsale',
		'icon'    => 'icon-st',
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Title', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Title For Slider', '7upframework' ),
				'param_name'  => 'title',
			),
		)
	)
);