<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7upteam.com
 */

if ( ! function_exists( 'sv_wc_slide_product' ) ) {
	function sv_wc_slide_product( $atts, $shortcode_content = null ) {
		$html = $number = $orderby  = $order  = $product_type = '';
		extract( shortcode_atts(
			array(
				'style'  	=> 'normal',
				'item'  	=> '4',
				'speed'  	=> '',
				'number'  		=> '',
				'orderby'  		=> 'date',
				'order'  		=> 'DESC',
				'product_type'  => 'latest',
				'hover_auto'    => '',
			), $atts ) );
		ob_start();
		?>
		<?php
			global $post;
			if($product_type=='latest'){
				$args = array(
					'post_type' => 'product',
					'posts_per_page'=> $number,
					'orderby' => $orderby,
					'order' => $order,
				);
			}
			if($product_type=='featured'){
				$args = array(
					'post_type' => 'product',
					'posts_per_page'=> $number,
					'orderby' => $orderby,
					'order' => $order,
				);
				$args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
			}
			if($product_type=='bestsell'){
				$args = array(
					'post_type' => 'product',
					'posts_per_page'=> $number,
					'order' => $order,
					'meta_key' => 'total_sales',
					'orderby' => 'meta_value_num',
				);
			}
			if($product_type=='onsale'){
				$args = array(
					'post_type' => 'product',
					'posts_per_page'=> $number,
					'orderby' => $orderby,
					'order' => $order,
				);
				$args['meta_query']['relation']= 'OR';
	            $args['meta_query'][]=array(
	                'key'   => '_sale_price',
	                'value' => 0,
	                'compare' => '>',                
	                'type'          => 'numeric'
	            );
	            $args['meta_query'][]=array(
	                'key'   => '_min_variation_sale_price',
	                'value' => 0,
	                'compare' => '>',                
	                'type'          => 'numeric'
	            );
			}
			if($style == 'countdown'){
				$args['meta_query'] = array(
									array(
										'key'     => '_sale_price_dates_from',
										'value'   => 0,
										'compare' => '>'
									)
								);
			}
			$query = new WP_query($args);
			$auto_hover = '';
			if($hover_auto == 'yes'){
                $auto_hover = 'sv-block-hover hover-style1';
            }
			if($query->have_posts()):

		?>
		<div class="<?php echo esc_attr($auto_hover);?> block-newarrial product">
			<div class="slider-inner">
				<div class="container-slider">
					<div class="wrap_item sv_slider" data-num="<?php echo esc_attr($item);?>" data-speed="<?php echo esc_attr($speed);?>">
						<?php
							$key = 0;
							while($query->have_posts()):
							$query->the_post();
							$key++;
							global $post,$product;
							// setup_postdata($post);
							$date_pro=strtotime($post->post_date);
							$date_now=strtotime('now');
							$set_timer = sv_get_option( 'sv_set_time_woo', 30);
							$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
							$sale_price_dates_to 	= ( $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
							$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
							$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
							$percent = '';
							if($sale_price) $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
							else $sale_price = $regular_price;
						?>
						<?php if($style == 'countdown'):?>
							<div class="item countdown-item">
								<div class="inner">
									<div class="item-image">
										<div class="item-image-inner">
											<a title="<?php the_title();?>" href="<?php the_permalink();?>" class="product-image">
												<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
											</a>
											<?php if($sale_price_dates_to):?>
											<div class="defaultCountdown2 sv-countdown2" data-dateto="<?php echo esc_attr($sale_price_dates_to);?>"></div>
										<?php endif;?>
											<div class="item-btn">
												<div class="btn-wqc">
													<?php if(class_exists('YITH_WCWL_Init')):?>
														<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr(get_the_id()) ?>" class="add_to_wishlist link-wishlist" ></a>
													<?php endif;?>
													<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework');?></span></a>
													<?php
														sv_compare_url(true);
													?>
												</div>  
											</div>
										</div>
										<?php
											echo apply_filters( 'woocommerce_loop_add_to_cart_link',
												sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
													esc_url( $product->add_to_cart_url() ),
													esc_attr( $product->get_id() ),
													esc_attr( $product->get_sku() ),
													esc_attr( isset( $quantity ) ? $quantity : 1 ),
													$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
													esc_attr( $product->get_type() ),
													esc_html( $product->add_to_cart_text() )
												),
											$product );
										?>
									</div>
									<div class="product-info">
										<div class="product-name">
											<a title="<?php the_title();?>" href="<?php the_permalink();?>"><?php the_title();?></a>
										</div>	
										<div class="cate-name">	
											<?php
												$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
												if(isset($terms[0])){
													$term_id=$terms[0]->term_id;
													$term_name=$terms[0]->name;
											?>	
											<a href="<?php echo get_term_link( $term_id, 'product_cat' ); ?>"><?php echo esc_attr($term_name);?></a>
											<?php }?>
										</div>									
										<div class="wrap-ns-price">
											<div class="price-box">
												<p class="special-price">
													<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
												</p>
												<p class="old-price">
													<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
												</p>
											</div>
											<div class="wrap-new-sale">
												<?php if($percent):?>
													<div class="sale-item"><?php echo esc_attr($percent);?></div>
												<?php endif;?>
												<?php if($uppsell<0):?>
													<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
												<?php endif;?>
											</div>
										</div>										
									</div>
								</div>
							</div>
						<?php endif;?> 
						<?php if($style == 'havebg'):?>
							<div class="item havebg-item">
								<div class="inner">
									<div class="item-image">
										<div class="item-image-inner">
											<a title="<?php the_title();?>" href="<?php the_permalink();?>" class="product-image">
												<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
											</a>
											<div class="wrap-item-btn">
												<div class="item-btn">
													<div class="btn-wqc">
														<?php if(class_exists('YITH_WCWL_Init')):?>
															<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr(get_the_id()) ?>" class="add_to_wishlist link-wishlist" ></a>
														<?php endif;?>
														<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework');?></span></a>
														<?php
															sv_compare_url(true);
														?>
													</div>  
													<?php
														echo apply_filters( 'woocommerce_loop_add_to_cart_link',
															sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
																esc_url( $product->add_to_cart_url() ),
																esc_attr( $product->get_id() ),
																esc_attr( $product->get_sku() ),
																esc_attr( isset( $quantity ) ? $quantity : 1 ),
																$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
																esc_attr( $product->get_type() ),
																esc_html( $product->add_to_cart_text() )
															),
														$product );
													?>
												</div>
											</div>
										</div>
									</div>
									<div class="product-info">
										<div class="product-name">
											<a title="<?php the_title();?>" href="<?php the_permalink();?>"><?php the_title();?></a>
										</div>	
										<div class="cate-name">	
											<?php
												$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
												if(isset($terms[0])){
													$term_id=$terms[0]->term_id;
													$term_name=$terms[0]->name;
											?>	
											<a href="<?php echo get_term_link( $term_id, 'product_cat' ); ?>"><?php echo esc_attr($term_name);?></a>
											<?php }?>
										</div>									
										<div class="wrap-ns-price clearfix">
											<div class="price-box">
												<p class="special-price">
													<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
												</p>
												<p class="old-price">
													<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
												</p>
											</div>
											<div class="wrap-new-sale">
												<?php if($percent):?>
													<div class="sale-item"><?php echo esc_attr($percent);?></div>
												<?php endif;?>
												<?php if($uppsell<0):?>
													<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
												<?php endif;?>
											</div>
										</div>										
									</div>
								</div>
							</div>
						<?php endif;?> 
						<?php if($style == 'normal'):;?>
						<div class="item">
							<div class="inner">
								<div class="item-image">
									<a href="<?php the_permalink();?>" class="product-image">
										<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
									</a>     
									<div class="images-info">
										<div class="wrap-style">
											<div class="product-name">
												<a href="<?php echo esc_url(get_permalink());?>"><?php echo get_the_title();?></a>
											</div>
											<div class="wrap-ns-price">
												<div class="price-box">
													<p class="special-price">
														<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
													</p>
													<p class="old-price">
														<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
													</p>
												</div>
												<div class="wrap-new-sale">
													<?php if($percent):?>
														<div class="sale-item"><?php echo esc_attr($percent);?></div>
													<?php endif;?>
													<?php if($uppsell<0):?>
														<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
													<?php endif;?>
												</div>
											</div>
										</div>
										<div class="item-btn">
											<div class="btn-wqc">
												<?php if(class_exists('YITH_WCWL_Init')):?>
													<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr($post->ID) ?>" data-product-type="<?php echo esc_attr($product_type)?>" class="add_to_wishlist link-wishlist" ></a>
												<?php endif;?>
												<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
												<?php
													sv_compare_url(true);
												?>
											</div>
											<?php
												global $product;
												echo apply_filters( 'woocommerce_loop_add_to_cart_link',
													sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
														esc_url( $product->add_to_cart_url() ),
														esc_attr( $product->get_id() ),
														esc_attr( $product->get_sku() ),
														esc_attr( isset( $quantity ) ? $quantity : 1 ),
														$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
														esc_attr( $product->get_type() ),
														esc_html( $product->add_to_cart_text() )
													),
												$product );
											?>		
										</div>
									</div>
								</div>
								
							</div>
						</div>
						<?php endif;?>
						<?php endwhile;?>
					</div>
					<div class="navslider">
						<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
						<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
					</div>
				</div>
			</div>
		</div>
		<?php endif;?>		
		<?php
		wp_reset_postdata();
		$html = ob_get_clean();
		return $html;
	}
}
stp_reg_shortcode('wc_slide_product','sv_wc_slide_product');
/* Woocommerce List Category
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Woocommerce Slide Products', '7upframework' ),
		'category'  => '7Up-theme',
		'base'     => 'wc_slide_product',
		'icon'    => 'icon-st',
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Style', '7upframework' ),
				'type'        => 'dropdown',
				'param_name'  => 'style',
				'value' => array(
					esc_html__('Normal','7upframework')    => 'normal',
					esc_html__('Countdown hover','7upframework')  => 'countdown',
					esc_html__('Background','7upframework')  => 'havebg'
				),
				'description' => esc_html__( 'Display date countdown if this value set Yes and on sale.', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Item slider display', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number of item. Default is 4.', '7upframework' ),
				'param_name'  => 'item',
			),
			array(
				'heading'     => esc_html__( 'Speed', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
				'param_name'  => 'speed',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Order By', '7upframework' ),
				'value' => array(
					esc_html__('Date','7upframework')  => 'date',
					esc_html__('Rand','7upframework')  => 'rand',
					esc_html__('Name','7upframework')  => 'title',
					esc_html__('Price','7upframework') => 'price',
				),
				'param_name' => 'orderby',
				'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Order', '7upframework' ),
				'type'        => 'dropdown',
				'param_name'  => 'order',
				'value' => array(					
					esc_html__('Desc','7upframework')  => 'DESC',
					esc_html__('Asc','7upframework')  => 'ASC',
				),
				'description' => esc_html__( 'Select Order Type ', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Product Type', '7upframework' ),
				'type'        => 'dropdown',
				'param_name'  => 'product_type',
				'value' => array(
					esc_html__('Latest Products','7upframework')    => 'latest',
					esc_html__('Featured Products','7upframework')  => 'featured',
					esc_html__('Best Sellers','7upframework')       => 'bestsell',
					esc_html__('On Sale','7upframework')            => 'onsale',
				),
				'description' => esc_html__( 'Select Product View Type', '7upframework' ),
			),			
			array(
				'heading'     => esc_html__( 'Number Products', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'number',
				'description' => esc_html__( 'Enter Number Product View', '7upframework' ),
			),
			array(
                    'heading'     => esc_html__( 'Auto hover', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'hover_auto',
                    'value' => array(                   
                        esc_html__('No','7upframework')  => '',
                        esc_html__('Yes','7upframework')  => 'yes',
                    ),
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => 'normal'
                        )
                ),
		)
	)
);