<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_wc_select_category' ) ) {
	function sv_wc_select_category( $atts, $content = false ) {
		$html = $list_type = '';
		extract( shortcode_atts(
			array(
				'list_type'  	=> 'list',
				'item'  	=> '3',
				'speed'  	=> '',
			), $atts ) );
		ob_start();
		global $select_list_type, $g_item, $g_speed;
		$select_list_type = $list_type;
		$g_item = $item;
		$g_speed = $speed;
		?>
		<?php if($select_list_type=='list'):?>
		<div class="block-shop-the-look">
			<div class="slider-inner">
				<div class="container-slider">
					<div class="wrap_item sv_slider" data-num="<?php echo esc_attr($item);?>" data-speed="<?php echo esc_attr($speed);?>">
					<?php 
						echo wpb_js_remove_wpautop($content, true);
					?>
					</div>
					<div class="navslider">
						<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
						<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
					</div>
				</div>
			</div>
		</div>
		<?php endif;?>
		<?php if($select_list_type=='tab'):?>
		<div class="block-trend-now product">
			<div class="box-left tab-item col-lg-5 col-md-5 col-sm-12 col-xs-12">
				<ul class="box-left-inner tab-wrap">
					
				</ul>
			</div>
			<div class="tab-content col-lg-7 col-md-7 col-sm-12 col-xs-12">
				<?php 
					echo wpb_js_remove_wpautop($content, false);
				?>
			</div>
		</div>
		<?php endif;?>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('wc_select_category','sv_wc_select_category');

if ( ! function_exists( 'sv_wc_select_category_item' ) ) {
	function sv_wc_select_category_item( $atts, $content = false ) {
		$html = $category_id = $category_image = $descript = '';
		extract( shortcode_atts(
			array(
				'category_id'  	=> '',
				'category_image'  	=> '',
				'descript'  	=> '',
			), $atts ) );
		ob_start();
		global $select_list_type, $g_item, $g_speed;
		$term = get_term_by('slug', $category_id, 'product_cat');
		if(is_object($term) && !empty($term)){
			$term_link = get_term_link( $term, 'product_cat' );
			?>
			<?php if($select_list_type=='list' && is_object($term)):?>		
				<div class="item">
					<div class="inner">
						<a href="<?php echo esc_url($term_link);?>">
							<img alt="<?php echo esc_attr($term->slug);?>" src="<?php echo wp_get_attachment_url($category_image);?>" />
						</a>
						<div class="cate-info">
							<a class="cate-name" href="<?php echo esc_url($term_link);?>">
								<span class="title"><?php echo esc_attr($descript);?></span>
								<span class="pro-total"><?php echo esc_attr($term->count);?> <?php esc_html_e('products','7upframework')?></span>
							</a>
							
							<a class="button" href="<?php echo esc_url($term_link);?>"><?php esc_html_e('Shop now','7upframework')?></a>
						</div>
					</div>
				</div>
			<?php endif;?>
			<?php if($select_list_type=='tab' && is_object($term)):?>
				
				<div class="tab-pane">
					<div class="box-trend-now">
						<div class="slider-inner">
							<div class="container-slider products-grid">
								<div class="item tab-item">
									<a class="inner" data-toggle="tab" href="#">
									<span class="product-image">
									<img alt="<?php echo esc_attr($term->slug);?>" width="142" height="142" src="<?php echo wp_get_attachment_url($category_image);?>" />
									</span>
									<span class="product-name"><span><?php echo esc_attr($term->name);?></span></span>
									</a>
								</div>
								<div class="wrap_item sv_slider" data-num="<?php echo esc_attr($g_item);?>" data-speed="<?php echo esc_attr($g_speed);?>" data-itemres="1,2,3">
									<?php
										$args = array(
											'post_type' => 'product',
											'tax_query' => array(
												array(
													'taxonomy' => 'product_cat',
													'field'    => 'slug',
													'terms'    => $category_id,
												),
											),
										);
										$query = new WP_Query( $args );
										if($query->have_posts()) : 
									?>
									<?php 
										$key=0;
										while($query->have_posts()) : $query->the_post();
										global $post,$product;
										$key++;
										$date_pro=strtotime($post->post_date);
										$date_now=strtotime('now');
										$set_timer = sv_get_option( 'sv_set_time_woo', 30);
										$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
										$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
										$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
										if($sale_price) $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
										else $sale_price = $regular_price;
									?>
									<div class="item">
										<div class="inner">
											<div class="item-image">
												<div class="item-image-inner">
													<a title="<?php the_title();?>" href="<?php the_permalink();?>" class="product-image">
													<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
													</a>
													<div class="item-btn">
														<div class="btn-wqc">
															<?php if(class_exists('YITH_WCWL_Init')):?>
																<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr(get_the_id()) ?>" class="add_to_wishlist link-wishlist" ></a>
															<?php endif;?>
															<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework');?></span></a>
															<?php
																sv_compare_url(true);
															?>
														</div>  
													</div>
												</div>
											</div>
											<div class="product-info">
												<div class="product-name">
													<a title="<?php the_title();?>" href="<?php the_permalink();?>"><?php the_title();?></a>
												</div>
												<div class="cate-name">	
													<?php
														$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
														$cat_html = '';
		                                                if(is_object($terms) && !empty($terms)){
		                                                    $term_id=$terms[0]->term_id;
		                                                    $term_name=$terms[0]->name;
		                                                    $cat_html = '<a href="'.get_term_link( $term_id, 'product_cat' ).'">'.$term_name.'</a>';
		                                                }
													?>	
													<?php balanceTags($cat_html);?>
												</div>
												
												<div class="wrap-ns-price">
													<div class="price-box">
														<p class="special-price">
															<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
														</p>
														<p class="old-price">
															<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
														</p>
													</div>
													<div class="wrap-new-sale">
														<?php if($percent):?>
															<div class="sale-item"><?php echo esc_attr($percent);?></div>
														<?php endif;?>
														<?php if($uppsell<0):?>
															<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
														<?php endif;?>
													</div>
												</div>
												<?php
													echo apply_filters( 'woocommerce_loop_add_to_cart_link',
														sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
															esc_url( $product->add_to_cart_url() ),
															esc_attr( $product->get_id() ),
															esc_attr( $product->get_sku() ),
															esc_attr( isset( $quantity ) ? $quantity : 1 ),
															$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
															esc_attr( $product->get_type() ),
															esc_html( $product->add_to_cart_text() )
														),
													$product );
												?>		
											</div>
										</div>
									</div>
									<?php endwhile;
									wp_reset_postdata();?>
									<?php else:?>
									<p><?php esc_html_e( 'Category is empty.','7upframework' ); ?></p>
									<?php endif; ?>
								</div>
								<!--end wrap_item-->
								<div class="navslider">
									<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
									<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endif;?>
			<?php
		}
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('wc_select_category_item','sv_wc_select_category_item');
/* Payment
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Woocommerce Select Category', '7upframework' ),
		'base'     => 'wc_select_category',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'wc_select_category_item' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'List Category Type', '7upframework' ),
				'value' => array(
					esc_html__( 'Slider', '7upframework' ) => 'list',
					esc_html__( 'Tab', '7upframework' ) => 'tab',
				),
				'param_name' => 'list_type',
				'description' => esc_html__( 'Select List Category Type', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Item slider display', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number of item. Default is 3.', '7upframework' ),
				'param_name'  => 'item',
			),
			array(
				'heading'     => esc_html__( 'Speed', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
				'param_name'  => 'speed',
			)
		)
	)
);
add_action( 'vc_build_admin_page','sv_add_map_category_item' );
if ( ! function_exists( 'sv_add_map_category_item' ) ) {
	function sv_add_map_category_item(){
		vc_map(
			array(
				'name'     => esc_html__( 'Woocommerce Category Item', '7upframework' ),
				'base'     => 'wc_select_category_item',
				'icon'     => 'icon-st',
				'content_element' => true,
				'as_child' => array('only' => 'wc_select_category'),
				'params'   => array(
					array(
						'heading'     => esc_html__( 'Category', '7upframework' ),
						'type'        => 'dropdown',
						'description' => esc_html__( 'Choose Category View', '7upframework' ),
						'param_name'  => 'category_id',
						'value'		  => sv_vc_list_taxonomy('product_cat')
					),					
					array(
						'heading'     => esc_html__( 'Category Description', '7upframework' ),
						'type'        => 'textfield',
						'description' => esc_html__( 'Enter Category Short Description', '7upframework' ),
						'param_name'  => 'descript',
					),
					array(
						'heading'     => esc_html__( 'Category Image', '7upframework' ),
						'type'        => 'attach_image',
						'description' => esc_html__( 'Enter Category Image', '7upframework' ),
						'param_name'  => 'category_image',
					),
				)
			)
		);
	}
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_WC_Select_Category extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_WC_Select_Category_Item extends WPBakeryShortCode {
    }
}