<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_wc_sale_countdown' ) ) {
	function sv_wc_sale_countdown( $atts, $content = null ) {
		$html = $time_count_down = $link_count_down = $text_view_all = $auto_hover = '';
		extract( shortcode_atts(
			array(
				'style'  	=> 'style-1',
				'time_count_down'  	=> '',
				'link_count_down'  	=> '',
				'color_circle'  	=> '#ffd2d1',
				'color_text'  		=> '#ff6766',
				'number'  	=> '10',
				'text_view_all'  	=> '',
				'item'  	=> '1',
				'speed'  	=> '',
				'post_item' => '6',
				'hover_auto'	=> ''
			), $atts ) );
		if($hover_auto == 'yes'){
            $auto_hover = 'sv-block-hover hover-style2';
        }
		if(!empty($time_count_down)){
		ob_start();		
		?>
		
		<div class="block-extra <?php echo esc_attr($style);?> <?php echo esc_attr($auto_hover);?>">
			<div class="wrap-block-title">
				<div class="box-top col-lg-12 col-md-12 col-sm-12 col-xs-12">
					<?php if($style == 'style-1'){?>
						<div class="box-left col-lg-4 col-md-12 col-sm-12 col-xs-12">
							<?php echo wpb_js_remove_wpautop($content, true);?>
						</div>
						<div class="box-right col-lg-8 col-md-12 col-sm-12 col-xs-12">
							<div class="dateCountdown01" data-cColor="<?php echo esc_attr($color_circle);?>" data-tColor="<?php echo esc_attr($color_text);?>" data-date="<?php echo esc_attr($time_count_down);?>" style="width: 500px; height: 110px; padding: 0px; box-sizing: border-box;"></div> 
							<div class="dateCountdown02" data-cColor="<?php echo esc_attr($color_circle);?>" data-tColor="<?php echo esc_attr($color_text);?>" data-date="<?php echo esc_attr($time_count_down);?>" style="width: 350px; height: 83px; padding: 0px; box-sizing: border-box;"></div>
							<a class="button" href="<?php echo esc_url($link_count_down);?>"><?php echo balanceTags($text_view_all);?></a>
						</div>
					<?php }
					else{?>
						<div class="box-title text-center">
							<?php echo wpb_js_remove_wpautop($content, true);?>
						</div>
						<div class="box-count-down text-center">
							<div class="dateCountdown01" data-cColor="<?php echo esc_attr($color_circle);?>" data-tColor="<?php echo esc_attr($color_text);?>" data-date="<?php echo esc_attr($time_count_down);?>" style="width: 500px; height: 110px; padding: 0px; box-sizing: border-box;"></div>
							<div class="dateCountdown02" data-cColor="<?php echo esc_attr($color_circle);?>" data-tColor="<?php echo esc_attr($color_text);?>" data-date="<?php echo esc_attr($time_count_down);?>" style="width: 300px; height: 83px; padding: 0px; box-sizing: border-box;"></div>
						</div>
					<?php }?>
				</div>
			</div>
			<div class="box-bottom col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<div class="box-extra-slider">
					<div class="slider-inner">
						<div class="container-slider product">
							<div class="product-grid" data-num="<?php echo esc_attr($item);?>" data-speed="<?php echo esc_attr($speed);?>">
		
								<?php
									$format_time_count_down=strtotime(mysql2date('Y-m-d', $time_count_down));
									$args = array(
										'post_type'=>'product',
										'posts_per_page'=>$number,
									);
									$args['meta_query']['relation']= 'OR';
						            $args['meta_query'][]=array(
						                'key'   => '_sale_price',
						                'value' => 0,
						                'compare' => '>',                
						                'type'          => 'numeric'
						            );
						            $args['meta_query'][]=array(
						                'key'   => '_min_variation_sale_price',
						                'value' => 0,
						                'compare' => '>',                
						                'type'          => 'numeric'
						            );
									$the_query = new WP_Query( $args );
									$key = 0;
									if($the_query->have_posts()) : while($the_query->have_posts()) : $the_query->the_post();
										$sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
										if($sale_price):
										$key++;
										$post=get_post(get_the_id());
										$date_pro=strtotime($post->post_date);
										$date_now=strtotime('now');
										$set_timer = sv_get_option( 'sv_set_time_woo', 30);
										$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
										$regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
										$percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
										$terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
										$term_html = '';
										if(isset($terms[0])){
											$term_id=$terms[0]->term_id;
											$term_name=$terms[0]->name;
											$term_html = 	'<div class="cate-name">
																<a href="'.get_term_link( $term_id, 'product_cat' ).'">'.esc_attr($term_name).'</a>
															</div>';
										}
										$link_classes = 'wishlist';
										$product_type = '';
										$percent_width = '33.3333';
										if((int)$post_item % 2 == 0  && (int)$post_item % 3 != 0 ) $percent_width = '50';
										if((int)$post_item == 1 ) $percent_width = '100';
										$width_class = SV_Assets::build_css('width:'.$percent_width.'%');
									?>
									<?php if($key%(int)$post_item==1):?>
									<div class="wrap_item">
									<?php endif;?>								
										<div class="item <?php echo esc_attr($width_class);?>">
											<div class="inner">
												<div class="item-image">
													<div class="item-image-inner">
														<a href="<?php the_permalink();?>" class="product-image">
														<?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
														</a>                             
														<div class="item-btn">
															<div class="btn-wqc">
																<?php if(isset($link_classes)):?>
																<a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo get_the_id(); ?>" data-product-type="<?php echo esc_attr($product_type)?>" class="add_to_wishlist link-wishlist <?php echo esc_attr($link_classes) ?>" ></a>
																<?php endif;?>
																<a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
																<?php
																	sv_compare_url(true);
																?>
															</div>  
														</div>
													</div>
												</div>
												<div class="product-info">
													<div class="product-name">
														<a href="<?php the_permalink();?>"><?php the_title();?></a>
													</div>
													<?php balanceTags($term_html)?>													
													<div class="rating">
													<?php	
														global $product;													
														$star = $product->get_average_rating();
														$width = $star / 5 * 100;
														if($star):
													?>
														<div class="ratings">
															<div class="rating-box">
																<div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
															</div>
														</div>
														<p class="rating-links">
															<a href="<?php the_permalink()?>"><?php echo esc_attr($product->get_review_count());esc_html_e(' (vote)','7upframework');?></a>
															<span class="separator">|</span>
															<a href="" class="re-temp"><?php esc_html_e('Add Review','7upframework');?></a>
														</p>
													<?php endif;?>
													</div>
													<div class="desc">
														<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
													</div>
													<div class="wrap-ns-price">
														<div class="price-box">
															<p class="special-price">																
																<span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
															</p>
															<p class="old-price">
																<span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
															</p>
														</div>
														<div class="wrap-new-sale">
															<?php if($percent):?>
																<div class="sale-item"><?php echo esc_attr($percent);?></div>
															<?php endif;?>
															<?php if($uppsell<0):?>
																<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
															<?php endif;?>
														</div>
													</div>
													<?php
														echo apply_filters( 'woocommerce_loop_add_to_cart_link',
															sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
																esc_url( $product->add_to_cart_url() ),
																esc_attr( $product->get_id() ),
																esc_attr( $product->get_sku() ),
																esc_attr( isset( $quantity ) ? $quantity : 1 ),
																$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
																esc_attr( $product->get_type() ),
																esc_html( $product->add_to_cart_text() )
															),
														$product );
													?>		
												</div>
											</div>
										</div>
									<?php if($key%(int)$post_item==0):?>
									</div>
									<?php endif;?>
								<?php endif;endwhile;endif;
								wp_reset_postdata();?>
								<?php if($key%(int)$post_item!=0) echo '</div>';?>
							</div>
							<div class="navslider">
								<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
								<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
		$html .= @ob_get_clean();
		}
		return  $html;
	}
}
stp_reg_shortcode('wc_sale_countdown','sv_wc_sale_countdown');
/* Sale off Product
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Woocommerce Sale Count down', '7upframework' ),
		'category'  => '7Up-theme',
		'base'     => 'wc_sale_countdown',
		'icon'    => 'icon-st',
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Style', '7upframework' ),
				'type'        => 'dropdown',
				'description' => esc_html__( 'Choose style to display.', '7upframework' ),
				'param_name'  => 'style',
				'value'			=> array(
						esc_html__('Style 1','7upframework') => 'style-1',
						esc_html__('Style 2','7upframework') => 'style-2'
					)
			),
			array(
				'heading'     => esc_html__( 'Time Count Down', '7upframework' ),
				'type'        => 'datepicker',
				'description' => esc_html__( 'Setup timer count down', '7upframework' ),
				'param_name'  => 'time_count_down',
			),
			array(
				'heading'     => esc_html__( 'Circle Background Color', '7upframework' ),
				'type'        => 'colorpicker',
				'param_name'  => 'color_circle',
				'edit_field_class'=>'vc_col-sm-6 vc_column',
			),
			array(
				'heading'     => esc_html__( 'Circle Color', '7upframework' ),
				'type'        => 'colorpicker',
				'param_name'  => 'color_text',
				'edit_field_class'=>'vc_col-sm-6 vc_column',
			),
			array(
                'heading'     => esc_html__( 'Number', '7upframework' ),
                'type'        => 'textfield',
                'description' => esc_html__( 'Enter number of product. Default is 10.', '7upframework' ),
                'param_name'  => 'number',
            ),
			array(
				'heading'     => esc_html__( 'Text Count Down', '7upframework' ),
				'type'        => 'textarea_html',
				'description' => esc_html__( 'Intro text box count down', '7upframework' ),
				'param_name'  => 'content',
			),
			array(
				'heading'     => esc_html__( 'Link Product Sale', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter link to page product sale', '7upframework' ),
				'param_name'  => 'link_count_down',
				"dependency"    => array(
                    "element"   => 'style',
                    "value"     => 'style-1'
                    )
			),
			array(
				'heading'     => esc_html__( 'View All Text', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter text view all', '7upframework' ),
				'param_name'  => 'text_view_all',
				"dependency"    => array(
                    "element"   => 'style',
                    "value"     => 'style-1'
                    )
			),
			array(
				'heading'     => esc_html__( 'Item slider display', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number of item. Default is 1.', '7upframework' ),
				'param_name'  => 'item',
			),
			array(
				'heading'     => esc_html__( 'Speed', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
				'param_name'  => 'speed',
			),
			array(
				'heading'     => esc_html__( 'Number post per slider', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number of post display is one item slider. Default is 6.', '7upframework' ),
				'param_name'  => 'post_item',
			),
			array(
                    'heading'     => esc_html__( 'Auto hover', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'hover_auto',
                    'value' => array(                   
                        esc_html__('No','7upframework')  => '',
                        esc_html__('Yes','7upframework')  => 'yes',
                    )
                )
		)
	)
);