<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 26/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_video_bg'))
{
    function sv_vc_video_bg($attr, $content = false)
    {
        $html = $v_loop = $v_autoplay = $v_controls = '';
        extract(shortcode_atts(array(
            'video_url'         => '',
            'loop'              => 'no',
            'autoplay'          => 'no',
            'show_control'      => 'no',
            'video_image'       => '',
        ),$attr));
        $img = wp_get_attachment_image_src( $video_image ,"full");
        if($loop == 'yes') $v_loop = 'loop="loop"';
        if($autoplay == 'yes') $v_autoplay = 'autoplay="autoplay"';
        if($show_control == 'yes') $v_controls = 'controls';        
        $html .= '<div class="block-video-newletter">';
        if(!empty($video_url))
        $html .=    '<video '.$v_loop.' '.$v_autoplay.' '.$v_controls.' class="block-video">
                        <source type="video/mp4" src="'.esc_url($video_url).'">
                    </video>';        
        if(!empty($content)){
            $html .=    '<div class="block-newletter text-center">';
            $html .=    wpb_js_remove_wpautop($content, true);
            $html .=    '</div>';
        }
        $html .= '</div>';
        $html .= '<div class="banner-mobile hide-des">
                        <a href="#">
                            <img src="'.esc_url($img[0]).'" alt="">
                        </a>
                    </div>';
        
        return $html;
    }
}

stp_reg_shortcode('sv_video_bg','sv_vc_video_bg');

vc_map( array(
    "name"      => esc_html__("SV Video Background", '7upframework'),
    "base"      => "sv_video_bg",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "textfield",
            "heading" => esc_html__("Video Url",'7upframework'),
            "param_name" => "video_url",
        ),
        array(
            'heading'     => esc_html__( 'Loop', '7upframework' ),
            'type'        => 'checkbox',
            'param_name'  => 'loop',
            'value' => array( esc_html__( 'Auto Loop', '7upframework' ) => 'yes' )
        ),
        array(
            'heading'     => esc_html__( 'Autoplay', '7upframework' ),
            'type'        => 'checkbox',
            'param_name'  => 'autoplay',
            'value' => array( esc_html__( 'Auto Play', '7upframework' ) => 'yes' )
        ),
        array(
            'heading'     => esc_html__( 'Control Video', '7upframework' ),
            'type'        => 'checkbox',
            'param_name'  => 'show_control',
            'value' => array( esc_html__( 'show', '7upframework' ) => 'yes' )
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Video image",'7upframework'),
            "param_name" => "video_image",
        ),
        array(
            "type" => "textarea_html",
            "holder" => "div",
            "heading" => esc_html__("Video image",'7upframework'),
            "param_name" => "content",
        )
    )
));