<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/10/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_service'))
{
    function sv_vc_service($attr, $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'title'      => '',
            'icon'      => '',
            'image'      => '',
            'link'      => '#',
            'image_hover'      => '',
            'style_type'      => 'style1',
        ),$attr));
        if($style_type == 'style4'){
            $html .=    '<div class="item-service-support">
                            <a href="'.esc_url($link).'"><i class="fa '.$icon.'"></i> '.$title.'</a>
                        </div>'; 
        }
        else{
            if(!empty($image)){
                $img = wp_get_attachment_image_src( $image ,"full");
                if($style_type == 'style3'){
                    $html .=    '<div class="item-service-box">
                                    <h3>'.$title.'</h3>
                                    <a href="'.esc_url($link).'" class="item-service-link">
                                        <img src="'.esc_url($img[0]).'" alt="">
                                    </a>
                                    '.wpb_js_remove_wpautop($content, true).'
                                </div>';
                }            
                else{
                    $check_hi = 'no-hover-image';
                    if(!empty($image_hover)){
                        $img_hover = wp_get_attachment_image_src( $image_hover ,"full");
                        $check_hi = 'has-hover-image';
                    }
                    $html .=    '<div class="service-item '.$style_type.'">
                                    <div class="service-image '.$check_hi.'">
                                        <img class="active-image" alt="service-image-active" src="'.esc_url($img[0]).'"/>';
                    if(!empty($image_hover)){
                        $html .=        '<img class="hover-image" alt="service-image-hover" src="'.esc_url($img_hover[0]).'"/>';
                    }
                    $html .=        '</div>
                                    <div class="service-content">
                                        '.wpb_js_remove_wpautop($content, true).'
                                    </div>
                                </div>';   
                }
            }
        }    
        return $html;
    }
}

stp_reg_shortcode('sv_service','sv_vc_service');

vc_map( array(
    "name"      => esc_html__("SV Service", '7upframework'),
    "base"      => "sv_service",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(        
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Style Type', '7upframework' ),
            'value' => array(
                esc_html__( 'Style 1', '7upframework' ) => 'style1',
                esc_html__( 'Style 2', '7upframework' ) => 'style2',
                esc_html__( 'Style 3', '7upframework' ) => 'style3',
                esc_html__( 'Style 4', '7upframework' ) => 'style4',
            ),
            'param_name' => 'style_type',
            'description' => esc_html__( 'Select style', '7upframework' ),
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Icon",'7upframework'),
            "param_name" => "icon",
            "edit_field_class"  => 'vc_col-xs-12 vc_column sv_iconpicker',
            "dependency"    => array(
                "element"   => 'style_type',
                "value"     => 'style4'
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Title",'7upframework'),
            "param_name" => "title",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link",'7upframework'),
            "param_name" => "link",
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Service image",'7upframework'),
            "param_name" => "image",
            "dependency"    => array(
                "element"   => 'style_type',
                "value"     => array('style1','style2','style3')
                )
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Hover image",'7upframework'),
            "param_name" => "image_hover",
            "dependency"    => array(
                "element"   => 'style_type',
                "value"     => array('style1','style2','style3')
                )
        ),
        array(
            "type" => "textarea_html",
            "heading" => esc_html__("Service content",'7upframework'),
            "param_name" => "content",
            "dependency"    => array(
                "element"   => 'style_type',
                "value"     => array('style1','style2','style3')
                )
        ),
    )
));