<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 04/11/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_designer'))
{
    function sv_vc_designer($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'title'            => '',
            'designer'            => '',
            'label'       => '',
            'link'              => ''
        ),$attr));
        parse_str( urldecode( $designer ), $data);
        $html .=    '<div class="content-list-designer">
                        <label>'.$title.'</label>
                        <ul class="list-inline">';
        if(is_array($data)){
            foreach ($data as $key => $value) {
                $img = wp_get_attachment_image_src( $value['image'] ,"full");
        $html .=            '<li class="item-designer">
                                <a href="'.esc_url($value['link']).'" class="designer-thumb">
                                    <img src="'.esc_url($img[0]).'" alt="">
                                </a>
                                <h3><a href="'.esc_url($value['link']).'">'.$value['name'].'</a></h3>
                            </li>';
            }
        }
        $html .=        '</ul>
                        <a href="'.esc_url($link).'" class="see-all-designer">'.$label.'</a>
                    </div>';        
        return $html;
    }
}

stp_reg_shortcode('sv_designer','sv_vc_designer');

vc_map( array(
    "name"      => esc_html__("SV Designer", '7upframework'),
    "base"      => "sv_designer",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "heading" => esc_html__("Title",'7upframework'),
            "param_name" => "title",
        ),
        array(
            "type" => "add_designer",
            "heading" => esc_html__("Designer",'7upframework'),
            "param_name" => "designer",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Label button",'7upframework'),
            "param_name" => "label",
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link button",'7upframework'),
            "param_name" => "link",
        )
    )
));