<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_advert' ) ) {
	function sv_advert( $atts, $shortcode_content = null ) {
		$html = $style = '';
		extract( shortcode_atts(
			array(
				'style'  	=> 'adv_center',
			), $atts ) );
		ob_start();
		?>
		<div class="block-custom-advert <?php echo esc_attr($style);?> clearfix">
			<?php 
				echo wpb_js_remove_wpautop($shortcode_content, false);
			?>
		</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('advert','sv_advert');

if ( ! function_exists( 'sv_advert_item' ) ) {
	function sv_advert_item( $atts, $shortcode_content = null ) {
		$html = $adv_image = $adv_link = $adv_title =$adv_desc = '';
		extract( shortcode_atts(
			array(
				'adv_image'  	=> '',
				'adv_link'  	=> '',
				'adv_title'  	=> '',
				'adv_desc'  	=> '',
			), $atts ) );
		ob_start();
		?>
			<div class="item-advert">
				<div class="inner-item-advert">
					<a class="product-image" href="<?php echo esc_url($adv_link);?>">
						<img src="<?php echo wp_get_attachment_url($adv_image);?>" alt="">
					</a> 
					<div class="info">
						<div class="inner">
							<p class="p1"><?php  echo esc_attr($adv_title);?></p>
							<p class="p2"><?php  echo esc_attr($adv_desc);?></p>
							<a href="<?php  echo esc_url($adv_link);?>" class="link-sn"><?php esc_html_e('Shop Now','7upframework');?></a>
						</div>
					</div>
				</div>
			</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('advert_item','sv_advert_item');
/* Payment
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Advert', '7upframework' ),
		'base'     => 'advert',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'advert_item' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', '7upframework' ),
				'value' => array(
					esc_html__( 'Center', '7upframework' ) => 'adv_center',
					esc_html__( 'Left', '7upframework' ) => 'adv_left',
					esc_html__( 'Right', '7upframework' ) => 'adv_right',
				),
				'param_name' => 'style',
				'description' => esc_html__( 'Select advert layout', '7upframework' ),
			),
		)
	)
);

vc_map(
	array(
		'name'     => esc_html__( 'Advert Item', '7upframework' ),
		'base'     => 'advert_item',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'advert'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Advert Image', '7upframework' ),
				'type'        => 'attach_image',
				'description' => esc_html__( 'Enter Adv Image', '7upframework' ),
				'param_name'  => 'adv_image',
			),
			array(
				'heading'     => esc_html__( 'Advert Link', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Adv Link', '7upframework' ),
				'param_name'  => 'adv_link',
			),
			
			array(
				'heading'     => esc_html__( 'Advert Title', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Adv Title', '7upframework' ),
				'param_name'  => 'adv_title',
			),
			
			array(
				'heading'     => esc_html__( 'Advert Description', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Adv Description', '7upframework' ),
				'param_name'  => 'adv_desc',
			),
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Advert extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Advert_Item extends WPBakeryShortCode {
    }
}