<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */
if ( ! function_exists( 'sv_slide_banner' ) ) {
	function sv_slide_banner( $atts, $shortcode_content = null ) {
		$html = $caption_control = $border_style = $arrow_style = $paginav_control = '';
		extract( shortcode_atts(
			array(
				'caption_control'  	=> 'show',
				'paginav_control'  	=> 'hide',
				'speed'  	=> '',
				'border_style'  => 'none',
				'title'  => '',
				'arrow_style'  => 'short_arrow',
			), $atts ) );
		if($arrow_style == 'single-arrow'){
			$html .= 	'<div class="category-adv-slider single-slider single-arrow">';
			if(!empty($title)) $html .= '<h2 class="title-slider">'.$title.'</h2>';
			$html .= 		'<div class="wrap-item">';
			$html .= 			wpb_js_remove_wpautop($shortcode_content, true);
			$html .= 		'</div>
						</div>';
		}
		else{
			ob_start();
			?>
			<div class="box-banner-slider <?php echo esc_attr($arrow_style);?> <?php if($paginav_control=='show'){echo "paginav_show";} ?> <?php if($border_style=='solid'){echo "border-solid-info";} ?>">
				<div class="slider-inner">
					<div class="container-slider <?php if($arrow_style == 'hidden_arrow') echo 'banner-slider'?>">
						<div class="wrap_item" data-num="1" data-speed="<?php echo esc_attr($speed);?>">
							<?php echo wpb_js_remove_wpautop($shortcode_content, true);?>
						</div>
						<!--wrap_item -->
						<div class="wrap-navslider <?php if($caption_control=='hide') echo 'wrap-none-caption';?>">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
								<div class="navslider">
									<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
									<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
								</div>
							</div>
						</div>
					</div>
					<!--end container slider -->
				</div>
				<!--end slider-inner -->
				<?php if($caption_control=='show'):?>
				<div class="list-cate">
					<div class="inner">
						<ul class="append_li">
							
						</ul>
					</div>
				</div>
				<?php endif;?>
			</div>
			<!--end box-banner-slider --> 	
			<?php
			$html = @ob_get_clean();
		}
		return  $html;
	}
}

stp_reg_shortcode('slide_banner','sv_slide_banner');

if ( ! function_exists( 'sv_slide_banner_item' ) ) {
	function sv_slide_banner_item( $atts, $content = null ) {
		$html = $title = $image = $link = '';
		extract( shortcode_atts(
			array(
				'title'  	=> '',
				'subtitle'  	=> '',
				'image'  	=> '',
				'link'  	=> '',
			), $atts ) );
		ob_start();
		?>		
		<div class="item">
			<a href="<?php echo esc_attr($link);?>" class="item-image">
			<img alt="" src="<?php echo wp_get_attachment_url($image);?>">
			</a>
			<div class="banner-info">
				<div class="box-inner">
					<?php echo wpb_js_remove_wpautop($content, true);?>
				</div>
			</div>
			<div class="caption_slide">
				<span class="link1" data-index="0"><?php echo balanceTags($title);?></span>
				<a href="<?php echo esc_url($link);?>" class="link2"><?php echo balanceTags($subtitle);?></a>
			</div>
		</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('slide_banner_item','sv_slide_banner_item');
if ( ! function_exists( 'sv_slide_banner_item2' ) ) {
	function sv_slide_banner_item2( $atts, $content = null ) {
		$html = $bg_class = $image = $img_html = '';
		extract( shortcode_atts(
			array(
				'style'  	=> 'style-special',
				'image'  	=> '',
				'link'  	=> '',
			), $atts ) );
		if(!empty($image)){
			if($style == 'style-new-arrival'){
				$html .= 	'<div class="item">
								<div class="new-arrival-thumb">
									<a href="'.esc_url($link).'">
										<img class="img-responsive" src="'.wp_get_attachment_url($image).'" alt="">
									</a>
								</div>
								<div class="new-arrival-info">
									'.wpb_js_remove_wpautop($content, true).'
								</div>
							</div>';
			}
			else{
				// if(wp_is_mobile()){
					$img_html = '<img class="img-responsive" src="'.wp_get_attachment_url($image).'" alt="" />';
				// }
				// else{
					$bg_class = SV_Assets::build_css('background:url("'.wp_get_attachment_url($image).'") no-repeat center top');
				// }
				$html .= 	'<div class="item item-height '.$bg_class.'">
								'.$img_html.'
								<div class="item-info-banner '.$style.'">
									'.wpb_js_remove_wpautop($content, true).'
								</div>
							</div>';
				}
		}
		return  $html;
	}
}
stp_reg_shortcode('slide_banner_item2','sv_slide_banner_item2');
if ( !function_exists( 'sv_vc_slide_item_adv' ) ) {
	function sv_vc_slide_item_adv( $atts, $content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'image'  	=> '',
				'link'  	=> '',
				'des'  		=> '',
				'label'  	=> '',
			), $atts ) );
		$html .= 	'<div class="item">
						<div class="item-category-adv">';
		if(!empty($image)){
			$html .= 	'<a href="'.esc_url($link).'" class="item-category-adv-link"><img src="'.wp_get_attachment_url($image).'" alt="" /></a>';
		}
		if(!empty($des)){
			$html .= 	'<p class="desc">'.$des.'</p>';
		}
		if(!empty($label)){
			$html .= 	'<a href="'.esc_url($link).'" class="readmore">'.$label.'</a>';
		}
		$html .= 		'</div>
					</div>';
		return  $html;
	}
}
stp_reg_shortcode('slide_item_adv','sv_vc_slide_item_adv');
/* Select Category
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Banner Slide', '7upframework' ),
		'base'     => 'slide_banner',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'slide_banner_item,slide_banner_item2,slide_item_adv,vc_column_text' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Caption Control', '7upframework' ),
				'value' => array(
					esc_html__( 'Show', '7upframework' ) => 'show',
					esc_html__( 'Hide', '7upframework' ) => 'hide',
				),
				'param_name' => 'caption_control',
				'description' => esc_html__( 'Show/Hide slide caption', '7upframework' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Paginav Control', '7upframework' ),
				'value' => array(
					esc_html__( 'Hide', '7upframework' ) => 'hide',
					esc_html__( 'Show', '7upframework' ) => 'show',
				),
				'param_name' => 'paginav_control',
				'description' => esc_html__( 'Show/Hide slide pagination', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Speed', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
				'param_name'  => 'speed',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Style', '7upframework' ),
				'value' => array(
					esc_html__( 'None', '7upframework' ) => 'none',
					esc_html__( 'Solid', '7upframework' ) => 'solid',
				),
				'param_name' => 'border_style',
				'description' => esc_html__( 'Show/Hide border banner info', '7upframework' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Arrow Style', '7upframework' ),
				'value' => array(
					esc_html__( 'Short', '7upframework' ) => 'short_arrow',
					esc_html__( 'Long', '7upframework' ) => 'long_arrow',
					esc_html__( 'Default home 10', '7upframework' ) => 'new-arrival-slider',
					esc_html__( 'Single arrow', '7upframework' ) => 'single-arrow',
					esc_html__( 'Hidden', '7upframework' ) => 'hidden_arrow',
				),
				'param_name' => 'arrow_style',
				'description' => esc_html__( 'Select arrow style', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Title', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'title',
				'dependency'	=> array(
					'element'	=> 'arrow_style',
					'value'	=> 'single-arrow',
					)
			),
		),		
	)
);

vc_map(
	array(
		'name'     => esc_html__( 'Slide Item', '7upframework' ),
		'base'     => 'slide_banner_item',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'slide_banner'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Title', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'title',
			),
			array(
				'heading'     => esc_html__( 'Subtitle', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'subtitle',
			),
			array(
				'heading'     => esc_html__( 'Image', '7upframework' ),
				'type'        => 'attach_image',
				'param_name'  => 'image',
			),
			array(
				'heading'     => esc_html__( 'Content', '7upframework' ),
				'type'        => 'textarea_html',
				'param_name'  => 'content',
			),
			array(
				'heading'     => esc_html__( 'Link Subtitle', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'link',
			),
		)
	)
);
vc_map(
	array(
		'name'     => esc_html__( 'Slide Item 2', '7upframework' ),
		'base'     => 'slide_banner_item2',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'slide_banner'),
		'params'   => array(			
			array(
				'heading'     => esc_html__( 'Style', '7upframework' ),
				'type'        => 'dropdown',
				'param_name'  => 'style',
				'value'		  => array(
					esc_html__( 'Special', '7upframework' ) => 'style-special',
					esc_html__( 'Normal', '7upframework' ) => 'style-normal',
					esc_html__( 'New arrival', '7upframework' ) => 'style-new-arrival',
					)
			),
			array(
				'heading'     => esc_html__( 'Image', '7upframework' ),
				'type'        => 'attach_image',
				'param_name'  => 'image',
			),
			array(
				'heading'     => esc_html__( 'Link', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'link',
				'dependency'	=> array(
					'element'	=> 'style',
					'value'		=> 'style-new-arrival',
					)
			),
			array(
				'heading'     => esc_html__( 'Content', '7upframework' ),
				'type'        => 'textarea_html',
				'param_name'  => 'content',
			),
		)
	)
);
vc_map(
	array(
		'name'     => esc_html__( 'Slide Item Adv', '7upframework' ),
		'base'     => 'slide_item_adv',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'slide_banner'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Image', '7upframework' ),
				'type'        => 'attach_image',
				'param_name'  => 'image',
			),
			array(
				'heading'     => esc_html__( 'Link', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'link',
			),
			array(
				'heading'     => esc_html__( 'Label button', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'label',
			),
			array(
				'heading'     => esc_html__( 'Description', '7upframework' ),
				'type'        => 'textarea',
				'param_name'  => 'des',
			),
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Slide_Banner extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Slide_Banner_Item extends WPBakeryShortCode {}
    class WPBakeryShortCode_Slide_Banner_Item2 extends WPBakeryShortCode {}
    class WPBakeryShortCode_Slide_Item_Adv extends WPBakeryShortCode {}
}