<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 09/12/15
 * Time: 10:00 AM
 */

if ( ! function_exists( 'sv_vc_select_category2' ) ) {
	function sv_vc_select_category2( $atts, $content = false ) {
		$html = $list_type = '';
		extract( shortcode_atts(
			array(
				'title'  	=> '',
				'image'  	=> '',
				'link'  	=> '#',
			), $atts ) );
		$html .= 	'<div class="category-dropdown">';
		if(!empty($title)){
			$html .= 		'<h2 class="title-cat-dropdown">'.$title.'</h2>';
		}
		$html .= 		'<div class="content-cat-dropdown">';
		if(!empty($image)){
		$html .= 			'<div class="leading-cat-dropdown">
								<a href="'.esc_url($link).'">'.wp_get_attachment_image($image,'full',array('class'=>'img-responsive')).'</a>
							</div>';
						}
		$html .= 			'<ul class="list-cat-dropdown">';
		$html .=                wpb_js_remove_wpautop($content, false);					
		$html .= 			'</ul>
						</div>
					</div>';
		return  $html;
	}
}
stp_reg_shortcode('sv_select_category2','sv_vc_select_category2');

if ( ! function_exists( 'sv_vc_select_category_item2' ) ) {
	function sv_vc_select_category_item2( $atts, $content = false ) {
		$html = $category_id = $category_image = $descript = '';
		extract( shortcode_atts(
			array(
				'category_id'  	=> '',
				'category_image'  	=> '',
				'descript'  	=> '',
				'show_product'  	=> '',
			), $atts ) );
		$term = get_term_by('slug', $category_id, 'product_cat');
		if(is_object($term) && !empty($term)){
			$term_link = get_term_link( $term, 'product_cat' );
			$args = array(
	            'post_type'         => 'product',
	            'posts_per_page'    => 3,
	            );
			$args['tax_query'][]=array(
	                    'taxonomy'=>'product_cat',
	                    'field'=>'slug',
	                    'terms'=> $category_id
	                );
	        $product_query = new WP_Query($args);
			$html .= 	'<li>';
			if(!empty($category_image)){
			$html .= 		'<div class="thumb-cat-dropdown">
								<a href="'.esc_url($term_link).'">'.wp_get_attachment_image($category_image,'full').'</a>
							</div>';
						}
			$html .= 		'<div class="info-cat-dropdown">
								<h3><a href="'.esc_url($term_link).'">'.$term->name.'</a></h3>
								<p>'.$descript.'</p>
							</div>';
			if($show_product){
				$html .= 		'<div class="product-cats">
									<div class="text-center"><h2>'.esc_html__("Recent Product","7upframework").'</h2></div>';
				if($product_query->have_posts()) {
		            while($product_query->have_posts()) {
		                $product_query->the_post();
		                global $product,$post;
						if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(210,268));
		                        else $thumb_html = '';                        
		                        $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
		                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
		                                                esc_url( $product->add_to_cart_url() ),
		                                                esc_attr( $product->get_id() ),
		                                                esc_attr( $product->get_sku() ),
		                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
		                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
		                                                esc_attr( $product->get_type() ),
		                                                esc_html( $product->add_to_cart_text() )
		                                            ),
		                                        $product );
		                        $html .=    '<div class="item-product product-lower mega-cat">
		                                            <div class="item-product-thumb item-thumb-product">
		                                                <a href="'.get_the_permalink().'">
		                                                   '.$thumb_html.'
		                                                </a>                                                
		                                            </div>
		                                            <div class="item-product-info">
		                                                <h3 class="title-product"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
		                                                <div class="info-product-price">
		                                                    '.$product->get_price_html().'
		                                                </div>
		                                            </div>
		                                        </div>';
					}
				}
				$html .= 		'</div>';
			}
			$html .= 	'</li>';
		}
		return  $html;
	}
}
stp_reg_shortcode('sv_select_category_item2','sv_vc_select_category_item2');
/* Payment
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Woocommerce Select Category 2', '7upframework' ),
		'base'     => 'sv_select_category2',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'sv_select_category_item2' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(			
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', '7upframework' ),
				'param_name'  => 'title',
			),
			array(
				'type'        => 'attach_image',
				'heading'     => esc_html__( 'Image', '7upframework' ),
				'param_name'  => 'image',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Link', '7upframework' ),
				'param_name'  => 'link',
			),
		)
	)
);
add_action( 'vc_build_admin_page','sv_add_category_item2' );
if ( ! function_exists( 'sv_add_category_item2' ) ) {
	function sv_add_category_item2(){
		vc_map(
			array(
				'name'     => esc_html__( 'Woocommerce Category Item 2', '7upframework' ),
				'base'     => 'sv_select_category_item2',
				'icon'     => 'icon-st',
				'content_element' => true,
				'as_child' => array('only' => 'sv_select_category2'),
				'params'   => array(
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Category', '7upframework' ),
						'description' => esc_html__( 'Choose Category View', '7upframework' ),
						'param_name'  => 'category_id',
						'value'		  => sv_vc_list_taxonomy('product_cat')
					),
					
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Category Description', '7upframework' ),
						'description' => esc_html__( 'Enter Category Short Description', '7upframework' ),
						'param_name'  => 'descript',
					),
					array(
						'type'        => 'attach_image',
						'heading'     => esc_html__( 'Category Image', '7upframework' ),
						'description' => esc_html__( 'Enter Category Image', '7upframework' ),
						'param_name'  => 'category_image',
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Show product', '7upframework' ),
						'param_name'  => 'show_product',
					),
				)
			)
		);
	}
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_SV_Select_Category2 extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_SV_Select_Category_Item2 extends WPBakeryShortCode {
    }
}