<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 09/12/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_category_parent'))
{
    function sv_vc_category_parent($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'category'      => '',
            'brands'        => '',
            'brands_scroll' => 'five-item',
            'number'        => '5',
            'product_type'  => 'latest',
            'order_by'      => 'date',
            'order'         => 'DESC',
        ),$attr));
        $term = get_term_by('slug', $category, 'product_cat');
        // $term_link = get_term_link( $term, 'product_cat' );
        if(is_object($term) && !empty($term)){
            parse_str( urldecode( $brands ), $data);
            $term_childs = get_term_children( $term->term_id, 'product_cat' );
            $args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $number,
                'orderby'          => $order_by,
                'order'             => $order,
                );
            if($product_type == 'toprate'){
                $args['meta_key'] = '_wc_average_rating';
                $args['orderby'] = 'meta_value_num';
                $args['meta_query'] = WC()->query->get_meta_query();
                $args['tax_query'][] = WC()->query->get_tax_query();
            }
            if($product_type == 'mostview'){
                $args['meta_key'] = 'post_views';
                $args['orderby'] = 'meta_value_num';
            }
            if($product_type == 'bestsell'){
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
            }
            if($product_type=='onsale'){
                $args['meta_query'][]=array(
                    'key'   => '_sale_price',
                    'value' => 0,
                    'compare' => '>',                
                    'type'          => 'numeric'
                );
            }
            if($product_type == 'featured'){
                $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
            }
            $html .=    '<div class="inner-category-tab-slider">
                            <div class="row">
                                <div class="col-md-4 col-sm-4 col-xs-12">
                                    <div class="sidebar-category-tab">
                                        <h2 class="title-category-tab">'.$term->name.'</h2>
                                        <div class="clearfix">
                                            <div class="brand-cat-slider '.$brands_scroll.'">
                                                <div class="vertical-slider">
                                                    <ul>';
                                    if(is_array($data))
                                    {
                                        foreach ($data as $key => $value) {
                                            $html .=    '<li><a href="'.esc_url($value['link']).'">'.wp_get_attachment_image( $value['image'] ,"full").'</a></li>';
                                        }
                                    }
            $html .=                                '</ul>
                                                </div>
                                                <div class="jcaroul-control-nav">
                                                    <a class="prev" href="#">prev</a>
                                                    <a class="next" href="#">next</a>
                                                </div>
                                            </div>
                                            <div class="list-title-tab-category">
                                                <ul class="nav nav-tabs" role="tablist">';
                                $c_cat_count = 1;
                                foreach ($term_childs as $term_id) {
                                    $term_ob = get_term_by('id',$term_id,'product_cat');
                                    if($term_ob->count > 0){
                                        if($c_cat_count == 1) $class_active = 'active';
                                        else $class_active = '';                                    
                                        $html .=    '<li role="presentation" class="'.$class_active.'"><a href="#'.$term_ob->slug.'" aria-controls="'.$term_ob->slug.'" role="tab" data-toggle="tab">'.$term_ob->name.'</a></li>';
                                        $c_cat_count++;
                                    }
                                }
            $html .=                            '</ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8 col-sm-8 col-xs-12">
                                    <div class="tab-content home13">';
                                $c_cat_count = 1;
                                foreach ($term_childs as $term_id) {
                                    $term_ob = get_term_by('id',$term_id,'product_cat');
                                    $args['tax_query'][]=array(
                                                'taxonomy'=>'product_cat',
                                                'field'=>'id',
                                                'terms'=> $term_id
                                            );
                                    $product_query = new WP_Query($args);
                                    if($term_ob->count > 0){
                                        if($c_cat_count == 1) $class_active = 'active';
                                        else $class_active = '';
                                        $html .=    '<div role="tabpanel" class="tab-pane '.$class_active.'" id="'.$term_ob->slug.'">
                                                        <div class="category-tab-content clearfix">';
                                        $count_item = 1;
                                        if($product_query->have_posts()) {
                                            while($product_query->have_posts()) {
                                                $product_query->the_post();
                                                global $product,$post;
                                                $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);                                            
                                                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                        esc_url( $product->add_to_cart_url() ),
                                                                        esc_attr( $product->get_id() ),
                                                                        esc_attr( $product->get_sku() ),
                                                                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
                                                                        esc_attr( $product->get_type() ),
                                                                        esc_html( $product->add_to_cart_text() )
                                                                    ),
                                                                $product );
                                                if($count_item == 1){
                                                    $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                        esc_url( $product->add_to_cart_url() ),
                                                                        esc_attr( $product->get_id() ),
                                                                        esc_attr( $product->get_sku() ),
                                                                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-add-to-cart' : '',
                                                                        esc_attr( $product->get_type() ),
                                                                        esc_html( $product->add_to_cart_text() )
                                                                    ),
                                                                $product );
                                                    $html_cp = sv_compare_url();
                                                    if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a>';
                                                    if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(361,461));
                                                    else $thumb_html = '';
                                                    $html .=    '<div class="category-tab-main">
                                                                    <div class="item-product product-lower">
                                                                        <div class="item-product-thumb item-thumb-product">
                                                                            <a href="'.get_the_permalink().'">'.$thumb_html.'</a>
                                                                        </div>
                                                                        <div class="item-product-info">
                                                                            <h3 class="title-product"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                                            <div class="info-product-price">
                                                                                '.$product->get_price_html().'
                                                                            </div>
                                                                        </div>
                                                                        <div class="product-extra-link product">
                                                                            '.$button_html.'
                                                                            '.$html_cp.'
                                                                            '.$html_wl.'
                                                                        </div>
                                                                    </div>
                                                                </div>';
                                                }
                                                else{
                                                    $html_cp = '<li>'.sv_compare_url().'</li>';
                                                    if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
                                                    if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(171,217));
                                                    else $thumb_html = '';
                                                    $html .=    '<div class="category-tab-single">
                                                                    <div class="item-product product-lower">
                                                                        <div class="item-product-thumb item-thumb-product">
                                                                            <a href="'.get_the_permalink().'">'.$thumb_html.'</a>
                                                                            <div class="info-product-cart">
                                                                                <div class="inner-info-product-cart product">
                                                                                    <ul>
                                                                                        '.$html_wl.'
                                                                                        <li><a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span><i class="fa fa-search"></i></span></a></li>
                                                                                        '.$html_cp.'
                                                                                    </ul>
                                                                                    '.$button_html.'
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="item-product-info">
                                                                            <h3 class="title-product"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                                            <div class="info-product-price">
                                                                                '.$product->get_price_html().'
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>';
                                                }
                                                $count_item++;
                                            }
                                        }
                                        $html .=        '</div>
                                                    </div>';
                                        $c_cat_count++;
                                    }
                                }
                                        
            $html .=                '</div>
                                </div>
                            </div>
                        </div>';
        }
        wp_reset_postdata();
        return $html;
    }
}

stp_reg_shortcode('sv_category_parent','sv_vc_category_parent');
add_action( 'vc_build_admin_page','sv_admin_category_parent' );
if ( ! function_exists( 'sv_admin_category_parent' ) ) {
    function sv_admin_category_parent(){
        vc_map( array(
            "name"      => esc_html__("SV Show Category", '7upframework'),
            "base"      => "sv_category_parent",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Category', '7upframework' ),
                    'description' => esc_html__( 'Choose Category View', '7upframework' ),
                    'param_name'  => 'category',
                    'value'       => sv_vc_list_taxonomy('product_cat')
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Number', '7upframework' ),
                    'description' => esc_html__( 'Enter number of product. Default is 5.', '7upframework' ),
                    'param_name'  => 'number',
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Product Type', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'product_type',
                    'value' => array(
                        esc_html__('Latest Products','7upframework')    => 'latest',
                        esc_html__('Featured Products','7upframework')  => 'featured',
                        esc_html__('Best Sellers','7upframework')       => 'bestsell',
                        esc_html__('On Sale','7upframework')            => 'onsale',
                        esc_html__('Top rate','7upframework')           => 'toprate',
                        esc_html__('Most view','7upframework')          => 'mostview',
                    ),
                    'description' => esc_html__( 'Select Product View Type', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Order By', '7upframework' ),
                    'value' => array(
                        esc_html__('Date','7upframework')  => 'date',
                        esc_html__('Rand','7upframework')  => 'rand',
                        esc_html__('Name','7upframework')  => 'title',
                        esc_html__('Price','7upframework') => 'price',
                    ),
                    'param_name' => 'orderby',
                    'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Order', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'order',
                    'value' => array(                   
                        esc_html__('Desc','7upframework')  => 'DESC',
                        esc_html__('Asc','7upframework')  => 'ASC',
                    ),
                    'description' => esc_html__( 'Select Order Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Brand items scroll', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'brands_scroll',
                    'value' => array(
                        esc_html__('Five items','7upframework')    => 'five-item',
                        esc_html__('Four items','7upframework')  => 'four-item',
                    )
                ),
                array(
                    'heading'     => esc_html__( 'Brands', '7upframework' ),
                    'type'        => 'add_brand',
                    'param_name'  => 'brands',
                )
            )
        ));
    }
}