<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_product_list'))
{
    function sv_vc_product_list($attr, $content = false)
    {
        $html = $html_wl = $html_cp = '';
        extract(shortcode_atts(array(
            'style'         => 'slider',
            'title'         => '',
            'head_title'    => '',
            'title_image'   => '',
            'image'         => '',
            'image_link'    => '',
            'number'        => '8',
            'cats'          => '',
            'order_by'      => 'date',
            'order'         => 'DESC',
            'item'          => '4',
            'product_type'  => 'latest',
        ),$attr));
        $args = array(
            'post_type'         => 'product',
            'posts_per_page'    => $number,
            'order_by'          => $order_by,
            'order'             => $order,
            );
        $custom_list = array();

        if($product_type == 'bestsell'){
            $args['meta_key'] = 'total_sales';
            $args['orderby'] = 'meta_value_num';
        }
        if($product_type=='onsale'){
            $args['meta_query']['relation']= 'OR';
            $args['meta_query'][]=array(
                'key'   => '_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
            $args['meta_query'][]=array(
                'key'   => '_min_variation_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
        }
        if($product_type == 'featured'){
            $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
        }
        if(!empty($cats)) {
            $custom_list = explode(",",$cats);
            $args['tax_query'][]=array(
                'taxonomy'=>'product_cat',
                'field'=>'slug',
                'terms'=> $custom_list
            );
        }
        $product_query = new WP_Query($args);
        $count_query = $product_query->post_count;
        switch ($style) {
            case 'grid-thumb':
                if(!empty($image)){
                    $img = wp_get_attachment_image_src( $image ,"full");
                    $image_url = $img[0];
                }
                else $image_url = '';
                $html .=    '<div class="category-leading clearfix">';
                $html .=        '<div class="thumb-category-leading">
                                    <a href="'.esc_url($image_link).'"><img src="'.esc_url($image_url).'" alt="" /></a>
                                    <div class="text-category-leading">
                                        <span>'.$head_title.'</span>
                                        <h2>'.$title.'</h2>
                                    </div>
                                </div>';
                $html .=        '<div class="content-category-leading">';
                $count = 1;
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        $regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
                        $sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
                        if(!empty($sale_price)) $price_show = $sale_price;
                        else $price_show = $regular_price;
                        $html_cp = '<li>'.sv_compare_url().'</li>';
                        if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
                        $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                        $product );                        
                        $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(240,306));
                        else $thumb_html = '';
                        $html .=    '<div class="item-product-category-leading product">
                                        <div class="item-thumb-product">
                                            <a href="'.get_the_permalink().'" class="product-thumb-link">
                                                '.$thumb_html.'
                                            </a>
                                            <div class="leading-info-product-cart">
                                                <a href="#" class="product-thumb-link">
                                                    <img src="'.esc_url($thumbnail_hover).'" alt="" />
                                                </a>
                                                <div class="info-product-cart">
                                                    <div class="inner-info-product-cart">
                                                        <ul>
                                                            '.$html_wl.'
                                                            <li><a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span><i class="fa fa-search"></i></span></a></li>
                                                            '.$html_cp.'
                                                        </ul>
                                                        '.$button_html.'
                                                        <div class="info-product-price">
                                                            <span>'.get_woocommerce_currency_symbol().$price_show.'</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>';
                        
                        $count++;
                    }
                }                    
                $html .=            '</div>
                                </div>';
                // $html .= '  </div>';
                break;

            case 'mega-slider':
                $html .=    '<div class="mega-menu-list-product">
                                <h2 class="title-mega-menu">'.$title.'</h2>
                                <div class="wrap-item">';                
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(128*1.5,163*1.5));
                        else $thumb_html = '';
                        $html .=    '<div class="item">
                                        <div class="inner-item">
                                            <div class="mega-slide-thumb">
                                                <a href="'.get_the_permalink().'">'.$thumb_html.'</a>
                                            </div>
                                            <div class="mega-slide-text">
                                                '.$product->get_price_html().'
                                            </div>
                                        </div>
                                    </div>';
                    }
                }

                $html .=        '</div>
                                    <div class="owl-direct-nav">
                                        <a class="prev" href="#"><i class="fa fa-arrow-circle-left"></i></a>
                                        <a class="next" href="#"><i class="fa fa-arrow-circle-right"></i></a>
                                    </div>
                            </div>';
                break;
            
            default:
                $col = 12;
                $col_num = 12/(int)$item;
                $loop = (int)$item*2;                
                if($style == 'grid-product'){
                    $wrap_class = 'wrap-item-noslider';
                    $html .=    '<div class="new-arrival-product"><div class="title-box-default">                                
                                    <span class="title-tab">'.$title.'</span>                                
                                </div>';
                }
                else{
                    $wrap_class = 'wrap-item';
                    $html .=    '<div class="new-arrival-product"><div class="title-box-default">
                                    <a href="#" class="prev-new-arrival"><i class="fa fa-arrow-circle-left"></i></a>
                                    <span class="title-tab">'.$title.'</span>
                                    <a href="#" class="next-new-arrival"><i class="fa fa-arrow-circle-right"></i></a>
                                </div>';
                }                
                $html .=    '<div class="content-product-slider">
                                <div class="'.$wrap_class.'">';
                $count = 1;
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        $html_cp = '<li>'.sv_compare_url().'</li>';
                        if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
                        $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                        $product );
                        $percent = '';
                        $regular_price = get_post_meta( get_the_ID(), '_regular_price', true);
                        $sale_price = get_post_meta( get_the_ID(), '_sale_price', true);
                        if($sale_price) {
                            $percent = '<span class="status-product-sale">'.round((($regular_price-$sale_price)/$regular_price)*100,0).'%</span>';
                            $price_show = $sale_price;
                        }
                        else $price_show = $regular_price;
                        $date_pro=strtotime($post->post_date);
                        $date_now=strtotime('now');
                        $set_timer = sv_get_option( 'sv_set_time_woo', 30);
                        $uppsell=($date_now-$date_pro-$set_timer*24*60*60);
                        if($uppsell < 0) $uppsell_html = '<span class="status-product-new">'.esc_html__('new','7upframework').'</span>';
                        else $uppsell_html = '';
                        $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(270*1.5,344*1.5),array('class' => 'product-thumb-front'));
                        else $thumb_html = '';
                        $star = $product->get_average_rating();
                        $width = $star / 5 * 100;
                        if($star){
                        ob_start();?>
                            <div class="rating">
                                <div class="ratings">
                                    <div class="rating-box">
                                        <div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        $rating_html = @ob_get_clean();
                        }
                        else $rating_html = '';
                        if($count % $loop == 1){
                        $html .=    '<div class="item">
                                        <div class="row">';
                        }
                        $html .=            '<div class="col-md-'.$col_num.' col-sm-6 col-xs-12">
                                                <div class="item-product product">
                                                    <div class="item-thumb-product">
                                                        '.$thumb_html.'
                                                        <img src="'.esc_url($thumbnail_hover).'" alt="" class="product-thumb-behind" />
                                                        <div class="info-product-cart">
                                                            <div class="inner-info-product-cart">
                                                                <ul>
                                                                    '.$html_wl.'
                                                                    <li><a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span><i class="fa fa-search"></i></span></a></li>
                                                                    '.$html_cp.'
                                                                </ul>
                                                                '.$button_html.'
                                                            </div>
                                                        </div>
                                                        '.$uppsell_html.'
                                                        '.$percent.'
                                                    </div>
                                                    <div class="item-info-product">
                                                        <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                        <div class="info-product-price">
                                                            '.$product->get_price_html().'
                                                        </div>
                                                        <div class="rating-wrap">'.$rating_html.'</div>
                                                    </div>
                                                </div>
                                            </div>';  
                        if($count % $loop == 0 || $count == $count_query){              
                        $html .=        '</div>
                                    </div>';
                        }
                        $count++;
                    }
                }
                $html .=        '</div>
                            </div></div>';
                break;
        }
        wp_reset_postdata();
        return $html;
    }
}

stp_reg_shortcode('sv_product_list','sv_vc_product_list');
add_action( 'vc_build_admin_page','sv_add_list_new_product' );
if ( ! function_exists( 'sv_add_list_new_product' ) ) {
    function sv_add_list_new_product(){
        vc_map( array(
            "name"      => esc_html__("SV Product list", '7upframework'),
            "base"      => "sv_product_list",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title', '7upframework' ),
                    'param_name'  => 'title'
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title Head text', '7upframework' ),
                    'param_name'  => 'head_title'
                ),
                array(
                    'type'        => 'attach_image',
                    'heading'     => esc_html__( 'Title image', '7upframework' ),
                    'param_name'  => 'title_image'
                ),
                array(
                    'type'        => 'attach_image',
                    'heading'     => esc_html__( 'Featured Image', '7upframework' ),
                    'param_name'  => 'image'
                ),
                array(
                    'heading'     => esc_html__( 'Style', '7upframework' ),
                    'type'        => 'dropdown',
                    'description' => esc_html__( 'Choose style to display.', '7upframework' ),
                    'param_name'  => 'style',
                    'value'       => array(
                        esc_html__('Slider','7upframework') => 'slider',
                        esc_html__('Mega Slider','7upframework') => 'mega-slider',
                        esc_html__('Grid product','7upframework') => 'grid-product',
                        esc_html__('Grid Featured image','7upframework') => 'grid-thumb',
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Number', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of product. Default is 8.', '7upframework' ),
                    'param_name'  => 'number',
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Item/row', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of item. Default is 4.', '7upframework' ),
                    'param_name'  => 'item',
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Product Type', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'product_type',
                    'value' => array(
                        esc_html__('Latest Products','7upframework')    => 'latest',
                        esc_html__('Featured Products','7upframework')  => 'featured',
                        esc_html__('Best Sellers','7upframework')       => 'bestsell',
                        esc_html__('On Sale','7upframework')            => 'onsale',
                    ),
                    'description' => esc_html__( 'Select Product View Type', '7upframework' ),
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'holder'     => 'div',
                    'heading'     => esc_html__( 'Product Categories', '7upframework' ),
                    'type'        => 'checkbox',
                    'param_name'  => 'cats',
                    'value'       => sv_vc_list_taxonomy('product_cat',false)
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Order By', '7upframework' ),
                    'value' => array(
                        esc_html__('Date','7upframework')  => 'date',
                        esc_html__('Rand','7upframework')  => 'rand',
                        esc_html__('Name','7upframework')  => 'title',
                        esc_html__('Price','7upframework') => 'price',
                    ),
                    'param_name' => 'orderby',
                    'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Order', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'order',
                    'value' => array(                   
                        esc_html__('Desc','7upframework')  => 'DESC',
                        esc_html__('Asc','7upframework')  => 'ASC',
                    ),
                    'description' => esc_html__( 'Select Order Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                )
            )
        ));
    }
}