<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_product_list_home10'))
{
    function sv_vc_product_list_home10($attr, $content = false)
    {
        $html = $el_class = $html_wl = $html_cp = '';
        extract(shortcode_atts(array(
            'style'         => 'slider-1',
            'left'          => '',
            'title'         => '',
            'sale_box'      => '',
            'new_box'       => '',
            'number'        => '8',
            'cats'          => '',
            'order_by'      => 'date',
            'order'         => 'DESC',
            'item'          => '4',
            'product_type'  => 'latest',
        ),$attr));
        $custom_list = array();
        $args = array(
            'post_type'         => 'product',
            'posts_per_page'    => $number,
            'orderby'          => $order_by,
            'order'             => $order,
            );
        if($product_type == 'toprate'){
            $args['meta_key'] = '_wc_average_rating';
            $args['orderby'] = 'meta_value_num';
            $args['meta_query'] = WC()->query->get_meta_query();
            $args['tax_query'][] = WC()->query->get_tax_query();
        }
        if($product_type == 'mostview'){
            $args['meta_key'] = 'post_views';
            $args['orderby'] = 'meta_value_num';
        }
        if($product_type == 'bestsell'){
            $args['meta_key'] = 'total_sales';
            $args['orderby'] = 'meta_value_num';
        }
        if($product_type=='onsale'){
            $args['meta_query']['relation']= 'OR';
            $args['meta_query'][]=array(
                'key'   => '_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
            $args['meta_query'][]=array(
                'key'   => '_min_variation_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
        }
        if($product_type == 'featured'){
            $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
        }
        if(!empty($cats)) {
            $custom_list = explode(",",$cats);
            $args['tax_query'][]=array(
                'taxonomy'=>'product_cat',
                'field'=>'slug',
                'terms'=> $custom_list
            );
        }
        // var_dump($args);
        $product_query = new WP_Query($args);
        $count_query = $product_query->post_count;
        switch ($style) {
            case 'slider-1':
                if(!empty($sale_box)) $el_class = 'new-first';            
                $html .= '<div class="product-slider single-slider single-arrow ">';
                if(!empty($title)) $html .= '<h2 class="title-slider">'.$title.'</h2>';
                if(!empty($new_box)) $html .= '<div class="new-product-hightlight '.$el_class.'"><span>'.$new_box.'</span></div>';
                if(!empty($sale_box)) $html .= '<div class="sale-product-hightlight"><span>'.$sale_box.'</span></div>';             
                $html .= '<div class="wrap-item">';
                $count = 1;
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        $regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
                        $sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
                        if(!empty($sale_price)) $price_show = $sale_price;
                        else $price_show = $regular_price;
                        $html_cp = sv_compare_url();
                        if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a>';
                        $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-add-to-cart' : '',
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                        $product );                  
                        $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(328,418));
                        else $thumb_html = '';
                        $html .=    '<div class="item">
                                        <div class="item-product">
                                            <div class="item-product-thumb">
                                                <a href="'.get_the_permalink().'" class="item-product-link">
                                                   '.$thumb_html.'
                                                </a>
                                            </div>
                                            <div class="item-product-info">
                                                <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                <div class="info-product-price">
                                                    '.$product->get_price_html().'
                                                </div>
                                                <div class="product-extra-link product">
                                                    '.$html_wl.'
                                                    '.$button_html.'
                                                    '.$html_cp.'
                                                </div>
                                            </div>
                                            <div class="info-product-price-view">'.$product->get_price_html().'</div>
                                        </div>
                                    </div>';
                        $count++;
                    }
                }                    
                $html .=            '</div>
                                </div>';
                break;

            case 'tab-cate':
                if(!empty($cats)){
                $cats = explode(',', $cats);
                $mg_class = '';
                if(!empty($left)) $mg_class = SV_Assets::build_css('margin-left:'.$left.'px;');
                $html .=    '<div class="title-tab-product-category">
                                <ul class="nav nav-tabs '.$mg_class.'" role="tablist">';
                $ccount = 1;
                foreach ($cats as $cat_id) {
                    $f_class = '';$expanded = 'false';
                    if($ccount == 1){
                        $f_class = 'active';
                        $expanded = 'true';
                    }
                    $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                    if(is_object($term) && !empty($term)){
                        $html .= '<li role="presentation" class="'.$f_class.'"><a href="#'.$term->slug.'" aria-controls="'.$term->slug.'" role="tab" data-toggle="tab" aria-expanded="'.$expanded.'">'.$term->name.'</a></li>';
                        $ccount ++;
                    }
                }                
                $html .= '</ul>
                            </div>
                            <div class="content-tab-product-category single-arrow">
                                <div class="tab-content">';
                $ccount = 1;
                foreach ($cats as $cat_id) {
                    $f_class = '';
                    if($ccount == 1) $f_class = 'active';
                    $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                    if(is_object($term) && !empty($term)){
                        $args['tax_query'][]=array(
                                                'taxonomy'=>'product_cat',
                                                'field'=>'slug',
                                                'terms'=> $cat_id
                                            );
                        $product_query = new WP_Query($args);
                        $html .=    '<div role="tabpanel" class="tab-pane '.$f_class.'" id="'.$term->slug.'">
                                        <div class="wrap-item">';
                        if($product_query->have_posts()) {
                            while($product_query->have_posts()) {
                                $product_query->the_post();
                                global $product,$post;
                                $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
                                if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(328,418),array('class'=>'product-thumb-front'));
                                else $thumb_html = '';
                                $sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
                                $regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
                                $percent = '';
                                if($sale_price) {
                                    $percent='<label class="persale">'.round((($regular_price-$sale_price)/$regular_price)*100,0).'%</label>';
                                }
                                $html_cp = '<li>'.sv_compare_url().'</li>';
                                if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
                                $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                        esc_url( $product->add_to_cart_url() ),
                                                        esc_attr( $product->get_id() ),
                                                        esc_attr( $product->get_sku() ),
                                                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
                                                        esc_attr( $product->get_type() ),
                                                        esc_html( $product->add_to_cart_text() )
                                                    ),
                                                $product );
                                $html .=    '<div class="item">
                                                <div class="item-product">
                                                    <div class="item-product-thumb item-thumb-product">
                                                        <a href="'.get_the_permalink().'">
                                                        '.$thumb_html.'
                                                        <img src="'.esc_url($thumbnail_hover).'" alt="" class="product-thumb-behind" />
                                                        </a>
                                                        <div class="info-product-cart">
                                                            <div class="inner-info-product-cart product">
                                                                <ul>
                                                                    '.$html_wl.'
                                                                    <li><a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span><i class="fa fa-search"></i></span></a></li>
                                                                    '.$html_cp.'
                                                                </ul>
                                                                '.$button_html.'
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="item-product-info">
                                                        <h3 class="title-product"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                        <div class="info-product-price">
                                                            '.$product->get_price_html().'
                                                            '.$percent.'
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>';
                            }
                        }
                        $html .=            '</div>
                                        </div>';
                        $ccount ++;
                    }
                }
                $html .=        '</div>  
                            </div>';
                }
                break;

            case 'slider-2':
                if(!empty($sale_box)) $el_class = 'new-first';            
                $html .= '<div class="statistic-product-slider single-slider single-arrow">';
                if(!empty($title)) $html .= '<h2 class="title-slider">'.$title.'</h2>';
                if(!empty($new_box)) $html .= '<div class="new-product-hightlight '.$el_class.'"><span>'.$new_box.'</span></div>';
                if(!empty($sale_box)) $html .= '<div class="sale-product-hightlight"><span>'.$sale_box.'</span></div>';
                $html .= '<div class="wrap-item">';
                $count = $i = 1;
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        $view_html = '';
                        if($product_type == 'bestsell') $view_html =   '<div class="order-number">
                                                                            <span>'.get_post_meta( $product->get_id(), 'total_sales', true ).' '.esc_html__("order","7upframework").'</span>
                                                                        </div>';
                        if($product_type == 'toprate') $view_html =   '<div class="order-number">
                                                                            <span>'.$product->get_rating_count().' '.esc_html__("rate","7upframework").'</span>
                                                                        </div>';
                        $regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
                        $sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
                        if(!empty($sale_price)) $price_show = $sale_price;
                        else $price_show = $regular_price;
                        $html_cp = '<li>'.sv_compare_url().'</li>';
                        if(class_exists('YITH_WCWL_Init')) $html_wl = '<li><a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ><i class="fa fa-heart"></i></a></li>';
                        $button_html =  apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-product-add-cart' : '',
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                        $product );
                        $thumbnail_hover = get_post_meta(get_the_ID(),'product_thumb_hover',true);
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(100,128));
                        else $thumb_html = '';
                        $star = $product->get_average_rating();
                        $width = $star / 5 * 100;
                        if($star){
                        ob_start();?>
                            <div class="rating">
                                <div class="ratings">
                                    <div class="rating-box">
                                        <div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        $rating_html = @ob_get_clean();
                        }
                        else $rating_html = '';                        
                        if($i == 1) $html .=    '<div class="item">';
                        $html .=        '<div class="item-product item-product-list">
                                            <div class="item-product-thumb">
                                                <a href="'.get_the_permalink().'" class="item-product-link">
                                                    '.$thumb_html.'
                                                </a>                                                
                                            </div>
                                            <div class="item-product-info">
                                                <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                                <div class="info-product-price">
                                                    '.$product->get_price_html().'
                                                </div>
                                                '.$rating_html.'
                                                '.$view_html.'
                                            </div>
                                        </div>';
                        if($i == 3 || $count == $count_query) $html .=    '</div>';                       
                        $count++;
                        $i++;
                        if($i > 3) $i = 1;
                    }
                }                    
                $html .=            '</div>
                                </div>';
                break;
            
            case 'hot-deals':
                $args['meta_key'] = 'deals_time';
                $args['orderby'] = 'meta_value_num';
                $args['order'] = 'ASC';
                $product_query = new WP_Query($args);
                $html .=    '<div class="deals-off home13">';
                if(!empty($title)){
                    $html .=    '<h2 class="deals-title">'.$title.'</h2>';
                }
                $html .=        '<div class="deals-off-content">';
                if($product_query->have_posts()) {
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product,$post;
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(100,128));
                        else $thumb_html = '';
                        $star = $product->get_average_rating();
                        $width = $star / 5 * 100;
                        if($star){
                        ob_start();?>
                            <div class="rating">
                                <div class="ratings">
                                    <div class="rating-box">
                                        <div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        $rating_html = @ob_get_clean();
                        }
                        else $rating_html = '';
                        $deals_time = get_post_meta(get_the_ID(),'deals_time',true);
                        $date_to = current_time( 'Y/m/d ' ).$deals_time;
                        $html .=    '<div class="item-product item-product-list">
                                        <div class="item-product-thumb">
                                            <a class="item-product-link" href="'.get_the_permalink().'">
                                                '.$thumb_html.'
                                            </a>
                                        </div>
                                        <div class="item-product-info">
                                            <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                                            <div class="info-product-price">
                                                '.$product->get_price_html().'
                                            </div>
                                            '.$rating_html;
                        if(!empty($deals_time)){
                        $html .=            '<div class="deal-timer">
                                                <div class="deals-countdown" data-dateto="'.$date_to.'"></div>
                                            </div>';
                                        }
                        $html .=        '</div>
                                    </div>';
                    }
                }                
                                    
                $html .=        '</div>
                            </div>';
                break;

            default:
                
                break;
        }
        wp_reset_postdata();
        return $html;
    }
}

stp_reg_shortcode('sv_product_list_home10','sv_vc_product_list_home10');
add_action( 'vc_build_admin_page','sv_add_list_new_product_home10' );
if ( ! function_exists( 'sv_add_list_new_product_home10' ) ) {
    function sv_add_list_new_product_home10(){
        vc_map( array(
            "name"      => esc_html__("SV Product list home10", '7upframework'),
            "base"      => "sv_product_list_home10",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Title', '7upframework' ),
                    'param_name'  => 'title'
                ),                
                array(
                    'heading'     => esc_html__( 'Style', '7upframework' ),
                    'type'        => 'dropdown',
                    'description' => esc_html__( 'Choose style to display.', '7upframework' ),
                    'param_name'  => 'style',
                    'value'       => array(
                        esc_html__('Slider 1','7upframework') => 'slider-1',
                        esc_html__('Slider 2','7upframework') => 'slider-2',
                        esc_html__('Tab category','7upframework') => 'tab-cate',
                        esc_html__('Hot Deals','7upframework') => 'hot-deals',
                        )
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Sale Box', '7upframework' ),
                    'param_name'  => 'sale_box',
                    'dependency'  => array(
                        'element'   => 'style',
                        'value'   => array('slider-1','slider-2'),
                        )
                ),
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'New Box', '7upframework' ),
                    'param_name'  => 'new_box',
                    'dependency'  => array(
                        'element'   => 'style',
                        'value'   => array('slider-1','slider-2'),
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Margin left list tab', '7upframework' ),
                    'type'        => 'textfield',
                    'param_name'  => 'left',
                    'description' => esc_html__( 'Enter number of margin left for list tab. Unit (px). Exxample 200.', '7upframework' ),
                    'dependency'  => array(
                        'element'   => 'style',
                        'value'   => 'tab-cate',
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Number', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of product. Default is 8.', '7upframework' ),
                    'param_name'  => 'number',
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Item/row', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of item. Default is 4.', '7upframework' ),
                    'param_name'  => 'item',
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Product Type', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'product_type',
                    'value' => array(
                        esc_html__('Latest Products','7upframework')    => 'latest',
                        esc_html__('Featured Products','7upframework')  => 'featured',
                        esc_html__('Best Sellers','7upframework')       => 'bestsell',
                        esc_html__('On Sale','7upframework')            => 'onsale',
                        esc_html__('Top rate','7upframework')           => 'toprate',
                        esc_html__('Most view','7upframework')          => 'mostview',
                    ),
                    'description' => esc_html__( 'Select Product View Type', '7upframework' ),
                    // 'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'holder'     => 'div',
                    'heading'     => esc_html__( 'Product Categories', '7upframework' ),
                    'type'        => 'checkbox',
                    'param_name'  => 'cats',
                    'value'       => sv_vc_list_taxonomy('product_cat',false)
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Order By', '7upframework' ),
                    'value' => array(
                        esc_html__('Date','7upframework')  => 'date',
                        esc_html__('Rand','7upframework')  => 'rand',
                        esc_html__('Name','7upframework')  => 'title',
                        esc_html__('Price','7upframework') => 'price',
                    ),
                    'param_name' => 'orderby',
                    'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Order', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'order',
                    'value' => array(                   
                        esc_html__('Desc','7upframework')  => 'DESC',
                        esc_html__('Asc','7upframework')  => 'ASC',
                    ),
                    'description' => esc_html__( 'Select Order Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                )
            )
        ));
    }
}