<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_payment' ) ) {
	function sv_payment( $atts, $shortcode_content = null ) {
		$html = $align = '';
		extract( shortcode_atts(
			array(
				'align'  	=> 'text-left',
			), $atts ) );
		ob_start();
		?>
		<ul class="block-payment <?php echo esc_attr($align);?>">
			<?php 
				//echo do_shortcode($shortcode_content);
				echo wpb_js_remove_wpautop($shortcode_content, false);
			?>
		</ul>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('payment','sv_payment');

if ( ! function_exists( 'sv_payment_item' ) ) {
	function sv_payment_item( $atts, $shortcode_content = null ) {
		$html = $payment_icon = $payment_link = '';
		extract( shortcode_atts(
			array(
				'payment_icon'  	=> '',
				'payment_link'  	=> '',
			), $atts ) );
		ob_start();
		?>
			<li>
				<a href="<?php echo esc_url($payment_link);?>">
					<img src="<?php echo wp_get_attachment_url($payment_icon);?>" alt="">
				</a>
			</li>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('payment_item','sv_payment_item');
/* Payment
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Payment', '7upframework' ),
		'base'     => 'payment',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'payment_item' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Align', '7upframework' ),
				'value' => array(
					esc_html__( 'Align Left', '7upframework' ) => 'text-left',
					esc_html__( 'Align Center', '7upframework' ) => 'text-center',
					esc_html__( 'Align Right', '7upframework' ) => 'text-right',
				),
				'param_name' => 'align',
				'description' => esc_html__( 'Select payment layout', '7upframework' ),
			),
		)
	)
);

vc_map(
	array(
		'name'     => esc_html__( 'Payment Item', '7upframework' ),
		'base'     => 'payment_item',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'payment'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Icon Payment', '7upframework' ),
				'type'        => 'attach_image',
				'description' => esc_html__( 'Enter Icon Payment', '7upframework' ),
				'param_name'  => 'payment_icon',
			),
			array(
				'heading'     => esc_html__( 'Url', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Payment Link', '7upframework' ),
				'param_name'  => 'payment_link',
			),
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Payment extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Payment_Item extends WPBakeryShortCode {
    }
}