<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_mini_cart'))
{
    function sv_vc_mini_cart($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'      => 'style-1',
            'icon'       => '',
            'title'      => '',
        ),$attr));        
        global $woocommerce;
        if($style == 'style-2'){
            $html_cart_style =     '<div class="box-right home-13"><div class="block-cart box">
                                    <div class="shop-cart-box cart-icon">
                                        <a href="'.wc_get_cart_url().'">
                                            <img src="'.wp_get_attachment_url($icon).'" alt="">
                                            <sup class="total-item">0</sup>
                                            <label for="">'.$title.'</label>
                                        </a>
                                    </div>';
        }
        else{
            $html_cart_style =     '<div class="box-right home-10"><div class="block-cart box">
                                    <div class="top-cart cart-icon">
                                        <h2>'.$title.'</h2>
                                        <p><span class="total-item">0</span> '.esc_html__("Item(s)","7upframework").' - <span class="price-mini-cart">$0.00</span></p>
                                    </div>';
        }
        $html .=    $html_cart_style.'
                        <div class="block-content box-inner">
                        <input id="num-decimal" type="hidden" value="'.get_option("woocommerce_price_num_decimals").'">
                        <input id="currency" type="hidden" value=".'.get_option("woocommerce_currency").'">
                            <div class="inner">
                                <p class="block-subtitle">'.esc_html__("Recently added item(s)","7upframework").'</p>
                                <ol class="mini-products-list" id="cart-sidebar">';
                                $count_item = 0;                                
                                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                    $count_item++;
                                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                                    $product_quantity = woocommerce_quantity_input( array(
                                        'input_name'  => "cart[{$cart_item_key}][qty]",
                                        'input_value' => $cart_item['quantity'],
                                        'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                        'min_value'   => '0'
                                    ), $_product, false );
                                    ob_start();
                                    $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                                    if ( ! $_product->is_visible() ) {
                                        echo balanceTags($thumbnail);
                                    } else {
                                        printf( '<a class="product-image" href="%s">%s</a>', esc_url( $_product->get_permalink( $cart_item ) ), $thumbnail );
                                    }
                                    $html .='<li class="item odd id_'.$product_id.'" data-key="'.$cart_item_key.'">
                                                '.@ob_get_clean().'
                                                '.apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                                    '<a href="%s" class="btn-remove remove" title="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
                                                    esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                                                    'X',
                                                    esc_attr( $product_id ),
                                                    esc_attr( $_product->get_sku() )
                                                ), $cart_item_key ).'
                                                <div class="product-details">
                                                    <p class="product-name">
                                                        <a href="'.esc_url( $_product->get_permalink( $cart_item )).'">'.$_product->get_title().'</a>                                                        
                                                    </p>
                                                    <span class="price">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ).'</span>          
                                                    <label>QTY:</label> <strong>'.$cart_item['quantity'].'</strong> 
                                                </div>
                                            </li>';
                                }
        $html .=                '</ol><input id="count-cart-item" type="hidden" value="'.$count_item.'">
                                <div class="summary">
                                    <p class="subtotal">
                                        <span class="label">'.esc_html__('Subtotal:','7upframework').'</span> 
                                        '.$woocommerce->cart->get_cart_total().'                                                                        
                                    </p>
                                </div>
                                <div class="actions">
                                    <div class="a-inner">
                                        <a href="'.wc_get_cart_url().'" class="btn-mycart">'.esc_html__('view cart','7upframework').'</a>
                                        <a class="btn-checkout" href="'.wc_get_checkout_url().'">'.esc_html__('Checkout','7upframework').'</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div></div>';
        return $html;
    }
}

stp_reg_shortcode('sv_mini_cart','sv_vc_mini_cart');

vc_map( array(
    "name"      => esc_html__("SV Mini Cart", '7upframework'),
    "base"      => "sv_mini_cart",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Style', '7upframework' ),
            'param_name' => 'style',
            'value' => array(
                esc_html__("Style 1",'7upframework') => 'style-1',
                esc_html__("Style 2",'7upframework') => 'style-2',
            ), 
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Icon",'7upframework'),
            "param_name" => "icon",
            "dependency" => array(
                "element"   => "style",
                "value"   => "style-2",
                )
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "heading" => esc_html__("Title",'7upframework'),
            "param_name" => "title",
        )
    )
));