<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7upteam.com
 */
if ( ! function_exists( 'sv_list_wc_category' ) ) {
	function sv_list_wc_category( $atts, $shortcode_content = null ) {
		$html = $orderby  = $order = $view_count = $hide_empty = '';
		extract( shortcode_atts(
			array(
				'cat_list'  	=> '',
				'item_slider'  	=> '6',
				'speed'			=> '',
				'orderby'  		=> 'id',
				'order'  		=> 'DESC',
				'view_count'  	=> 'false',
				'hide_empty'  	=> 'false',
			), $atts ) );
		ob_start();
		?>
		<div class="block-categories">
			<div class="inner-cate">
				<div class="wrap_item sv_slider" data-num="<?php echo esc_attr($item_slider);?>" data-speed="<?php echo esc_attr($speed);?>">
					<?php
						$args = array(
							'orderby'           => $orderby, 
							'order'             => $order,
							'hide_empty'        => $hide_empty
						);
						if(!empty($cat_list)) $terms = explode(",",$cat_list);
						else $terms = get_terms('product_cat',$args);
						foreach($terms as $key => $term):
							if(!empty($cat_list)) {
								$term = get_term_by('slug', $term, 'product_cat');
								if(is_object($term) && !empty($term)){
								$term_id = $term->term_id;
								$thumbnail_id = get_woocommerce_term_meta( $term_id, 'thumbnail_id', true ); 
					?>
								<div class="item <?php if($key==0){echo 'first';}?>">
									<div class="inner">
										<a class="cate-img" href="<?php echo get_term_link($term,'product_cat');?>">
											<img alt="<?php echo esc_attr($term->slug);?>" width="120" height="70" src="<?php echo wp_get_attachment_url($thumbnail_id);?>"/>                
										</a>
										<a class="cate-name" href="<?php echo get_term_link($term,'product_cat');?>">
											<?php echo esc_attr($term->name);?> 
											<?php if($view_count=='true') echo '<span>('.$term->count.')</span>';?>
										</a>
									</div>
								</div>
					<?php
								}
							}
						endforeach;?>
				</div>
				<div class="navslider">
					<a class="prev" href="#"><span><?php esc_html_e('Prev','7upframework')?></span></a>
					<a class="next" href="#"><span><?php esc_html_e('Next','7upframework')?></span></a>
				</div>
			</div>
		</div>
		<?php
		$html = ob_get_clean();
		return $html;
	}
}
stp_reg_shortcode('list_wc_category','sv_list_wc_category');
add_action( 'vc_build_admin_page','sv_add_mapShortcodes_category' );
if ( ! function_exists( 'sv_add_mapShortcodes_category' ) ) {
	function sv_add_mapShortcodes_category(){
		
		vc_map(
			array(
				'name'     => esc_html__( 'Woocommerce Categories', '7upframework' ),
				'category'  => '7Up-theme',
				'base'     => 'list_wc_category',
				'icon'    => 'icon-st',
				'params'   => array(
					array(
			            "type" => "checkbox",
			            'holder' => 'div',
			            "heading" => esc_html__("Categories", '7upframework'),
			            "param_name" => "cat_list",
			            'description' => esc_html__( 'Check product categories to show. Default show all categories.', '7upframework' ),
			            'value'		=> sv_vc_list_taxonomy('product_cat',false)
			        ),
			        array(
			            "type" => "textfield",
			            'holder' => 'div',
			            "heading" => esc_html__("Item slider display", '7upframework'),
			            "param_name" => "item_slider",
			            'description' => esc_html__( 'Number item of slider. Default is 6.', '7upframework' )
			        ),			        
					array(
						'heading'     => esc_html__( 'Speed', '7upframework' ),
						'type'        => 'textfield',
						'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
						'param_name'  => 'speed',
					),
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Order By', '7upframework' ),
						'value' => array(
							esc_html__('None','7upframework')  => 'none',
							esc_html__('ID','7upframework')  => 'id',
							esc_html__('Count','7upframework') => 'count',
							esc_html__('Name','7upframework') => 'name',
						),
						'param_name' => 'orderby',
						'description' => esc_html__( 'Select Orderby Type on list all categories', '7upframework' )
					),
					array(
						'heading'     => esc_html__( 'Order', '7upframework' ),
						'type'        => 'dropdown',
						'param_name'  => 'order',
						'value' => array(
							esc_html__('Desc','7upframework')  => 'DESC',
							esc_html__('Asc','7upframework')  => 'ASC',
						),
						'description' => esc_html__( 'Select Order Type on list all categories', '7upframework' )
					),
					array(
						'heading'     => esc_html__( 'Hide Empty', '7upframework' ),
						'type'        => 'checkbox',
						'param_name'  => 'hide_empty',
						'value' => array( esc_html__( 'Yes', '7upframework' ) => 'true' )
					),
					array(
						'heading'     => esc_html__( 'View Count', '7upframework' ),
						'type'        => 'checkbox',
						'param_name'  => 'view_count',
						'value' => array( esc_html__( 'Yes', '7upframework' ) => 'true' )
					),
				)
			)
		);
	}
}