<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 05/09/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_list_style_product'))
{
    function sv_vc_list_style_product($attr, $content = false)
    {
        $html = $html_wl = $html_cp = '';
        extract(shortcode_atts(array(
            'style'         => 'featured-product',
            'number'        => '8',
            'cats'          => '',
            'order_by'      => 'date',
            'order'         => 'DESC',
            'right_content' => '',
            'extra_text'    => '',
            'featured_thumb'=> '',
            'featured_url'  => '#',
            'button_text'   => '',
            'item'          => '4',
            'speed'         => '',
            'product_type'  => 'latest',
            'hover_auto'    => '',
            'item_style'    => '',
        ),$attr));
        $args = array(
            'post_type'         => 'product',
            'posts_per_page'    => $number,
            'order_by'          => $order_by,
            'order'             => $order,
            );
        $custom_list = array();

        if($product_type == 'bestsell'){
            $args['meta_key'] = 'total_sales';
            $args['orderby'] = 'meta_value_num';
        }
        if($product_type=='onsale'){
            $args['meta_query'][]=array(
                'key'   => '_sale_price',
                'value' => 0,
                'compare' => '>',                
                'type'          => 'numeric'
            );
        }
        if($product_type == 'featured'){
            $args['tax_query'][] =  array(
                                        'taxonomy' => 'product_visibility',
                                        'field'    => 'name',
                                        'terms'    => 'featured',
                                        'operator' => 'IN',
                                    );
        }
        if(!empty($cats)) {
            $custom_list = explode(",",$cats);
            $args['tax_query'][]=array(
                'taxonomy'=>'product_cat',
                'field'=>'slug',
                'terms'=> $custom_list
            );
        }
        $product_query = new WP_Query($args);
        // $cat_all_list = get_terms('product_cat');
        switch ($style) {
            case 'featured-product':
                $html .= '<div class="wrap-featured-look"><div class="container"><div class="row"><div class="row">
                            <div class="box1 col-lg-4 col-md-4 col-sm-4 col-xs-12"></div>
                            <div class="box2 col-lg-6 col-md-6 col-sm-6 col-xs-12"></div>
                            <div class="box3 col-lg-2 col-md-2 col-sm-2 col-xs-12"></div>
                            <div class="box4 col-lg-7 col-md-7 col-sm-7 col-xs-12"></div>
                            <div class="inner-featured-look">';
                if(!empty($content))
                    $html .=    '<div class="block1 box col-xs-12">
                                    <div class="inner">
                                        '.wpb_js_remove_wpautop($content, true).'
                                    </div>
                                </div>';
                if(!empty($featured_thumb)){

                    $html .=    '<div class="block2 box col-xs-12">
                                    <a class="banner" href="'.$featured_url.'">
                                    <img alt="featured-product-image" src="'.wp_get_attachment_url($featured_thumb).'" />
                                    </a>
                                </div>';
                }
                    $html .=    '<div class="block3 box col-xs-12">
                                    <div class="inner">'.$extra_text.'</div>
                                    <div id="status" class="st-close"></div>
                                </div>
                                <div class="block4 box col-xs-12">
                                    <div class="box-featured-look" id="box-featured-look">
                                        <div class="slider-inner">
                                            <div class="container-slider products-grid product">
                                                <div class="wrap_item sv_slider" data-num="'.$item.'" data-speed="'.$speed.'" data-itemres="1,2,3">';
                                    
                                    if($product_query->have_posts()) {
                                        while($product_query->have_posts()) {
                                            $product_query->the_post();
                                            global $product,$post,$yith_woocompare;
                                            $terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
                                            $cat_html = '';
                                            if(is_object($terms) && !empty($terms)){
                                                $term_id=$terms[0]->term_id;
                                                $term_name=$terms[0]->name;
                                                $cat_html = '<div class="cate-name">
                                                                <a href="'.get_term_link( $term_id, 'product_cat' ).'">'.$term_name.'</a>
                                                            </div>';
                                            }
                                            if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ></a>';
                                            $html_cp = sv_compare_url();
                                            $percent = '';
                                            $regular_price = get_post_meta( get_the_ID(), '_regular_price', true);
                                            $sale_price = get_post_meta( get_the_ID(), '_sale_price', true);
                                            if($sale_price) {
                                                $percent = '<div class="sale-item">'.round((($regular_price-$sale_price)/$regular_price)*100,0).'%</div>';
                                                $price_show = $sale_price;
                                            }
                                            else $price_show = $regular_price;
                                            $date_pro=strtotime($post->post_date);
                                            $date_now=strtotime('now');
                                            $set_timer = sv_get_option( 'sv_set_time_woo', 30);
                                            $uppsell=($date_now-$date_pro-$set_timer*24*60*60);
                                            if($uppsell < 0) $uppsell_html = '<div class="new-item">'.esc_html__('new','7upframework').'</div>';
                                            else $uppsell_html = '';
                                            $button_html = apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                esc_url( $product->add_to_cart_url() ),
                                                                esc_attr( $product->get_id() ),
                                                                esc_attr( $product->get_sku() ),
                                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                                esc_attr( $product->get_type() ),
                                                                esc_html( $product->add_to_cart_text() )
                                                            ),
                                                        $product );
                                            ob_start();
                                            $star = $product->get_average_rating();
                                            $width = $star / 5 * 100;
                                            if($star):?>
                                                <div class="rating">
                                                    <div class="ratings">
                                                        <div class="rating-box">
                                                            <div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
                                                        </div>
                                                    </div>
                                                    <p class="rating-links">
                                                        <a href="<?php the_permalink()?>"><?php echo esc_attr($product->get_review_count());esc_html_e(' (vote)','7upframework');?></a>
                                                        <span class="separator">|</span>
                                                        <a href="<?php the_permalink()?>" class="re-temp"><?php esc_html_e('Add Review','7upframework');?></a>
                                                    </p>
                                                </div>
                                            <?php endif;
                                            $rating_html = @ob_get_clean();
                                            $html .= '<div class="item">
                                                        <div class="inner">
                                                            <div class="item-image">
                                                                <div class="item-image-inner">
                                                                    <a href="'.get_the_permalink().'" class="product-image">
                                                                    '.get_the_post_thumbnail(get_the_ID(),array(200,300)).'
                                                                    </a>                             
                                                                    <div class="item-btn">
                                                                        <div class="btn-wqc">
                                                                            '.$html_wl.'
                                                                            <a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span>'.esc_html__('Quick View','7upframework').'</span></a>
                                                                            '.$html_cp.'
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="product-info">
                                                                <div class="product-name">
                                                                    <a href="'.get_the_permalink().'">'.get_the_title().'</a>
                                                                </div>
                                                                '.$cat_html.'                                                               
                                                                '.$rating_html.'
                                                                <div class="wrap-ns-price">
                                                                    <div class="price-box">
                                                                        <p class="special-price">
                                                                            <span class="price">'.$product->get_price_html().'</span>
                                                                        </p>
                                                                    </div>
                                                                    <div class="wrap-new-sale">
                                                                        '.$percent.'
                                                                        '.$uppsell_html.'
                                                                    </div>
                                                                </div>
                                                                '.$button_html.'
                                                            </div>
                                                        </div>
                                                    </div>';
                                        }
                                    }
                $html .=                        '</div>
                                                <div class="navslider">
                                                    <a href="#" class="prev"><span>'.esc_html__('Prev','7upframework').'</span></a>
                                                    <a href="#" class="next"><span>'.esc_html__('Next','7upframework').'</span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div></div></div></div>';
                break;

            case 'grid-product':
                $html .= '<div class="block-banner-home2">';
                $i = 1;
                $thumb_html = '';                
                if($product_query->have_posts()) {
                    if(!empty($content)) $content_html = wpb_js_remove_wpautop($content, true);
                    else $content_html = '';
                    if($featured_url):
                    $html .= '<div class="box-first col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <a href="'.$featured_url.'" class="product-image">
                                <img alt="" src="'.wp_get_attachment_url($featured_thumb).'"/>
                            </a> 
                            <div class="info">
                                <div class="inner">'.$content_html.'</div>
                            </div>
                        </div>';
                    endif;  
                    while($product_query->have_posts()) {
                        $product_query->the_post();
                        global $product;
                        $button_html = apply_filters( 'woocommerce_loop_add_to_cart_link',
                                    sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                        esc_url( $product->add_to_cart_url() ),
                                        esc_attr( $product->get_id() ),
                                        esc_attr( $product->get_sku() ),
                                        esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button link-sn' : '',
                                        esc_attr( $product->get_type() ),
                                        esc_html( $product->add_to_cart_text() )
                                    ),
                                $product );
                        $item_class = 'item col-lg-3 col-md-3 col-sm-3 col-xs-6';
                        if(has_post_thumbnail(get_the_ID())) $thumb_html = get_the_post_thumbnail(get_the_ID(),array(290,350));
                        $html .=    '<div class="'.$item_class.'">
                                        <a href="'.get_the_permalink().'" class="product-image">
                                        '.$thumb_html.'
                                        </a> 
                                        <div class="info">
                                            <div class="inner">
                                                <p class="p1">'.get_the_title().'</p>
                                                <p class="p2">SKU: '.get_post_meta(get_the_id(),'_sku',true).'</p>
                                                <a href="'.get_permalink().'" class="link-sn">Shop Now</a>
                                            </div>
                                        </div>
                                    </div>';

                        $i++;
                    }
                }
                $html .= '</div>';
                break;

            case 'tab-grid':
                if(!empty($cats)){
                $cats = explode(',', $cats);
                if(!empty($content)) $content_html = wpb_js_remove_wpautop($content, true);
                else $content_html = '';
                $tab_item_html = $auto_hover = '';
                $ccount = 1;
                $pre = rand(1,1000);
                foreach ($cats as $cat_id) {
                    $f_class = '';
                    if($ccount == 1) $f_class = 'active';
                    if($ccount == count($cats)) $f_class = 'last';
                    $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                    $tab_item_html .= '<li class="'.$f_class.'"><a data-toggle="tab" href="#'.$pre.$term->slug.'">'.$term->name.'</a></li>';
                    $ccount ++;
                }
                if($hover_auto == 'yes'){
                    $auto_hover = 'sv-block-hover hover-style2';
                }
                $html .= '<div class="'.$auto_hover.' block-'.$style.'">';
                $html .=    '<div class="tab-item">
                                '.$content_html.'
                                <ul>
                                    '.$tab_item_html.'
                                </ul>
                            </div>';
                $html .=    '<div class="tab-content product">';
                                    $ccount = 1;
                                    foreach ($cats as $cat_id) {
                                        $f_class = '';
                                        if($ccount == 1) $f_class = 'active';
                                        $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                    $html .=    '<div class="tab-pane '.$f_class.'" id="'.$pre.$term->slug.'">
                                    <div class="box-'.$style.' item-'.$item_style.'">';
                                        $args = array(
                                            'post_type'         => 'product',
                                            'posts_per_page'    => $number,
                                            'order_by'          => $order_by,
                                            'order'             => $order,
                                            );
                                        $args['tax_query'][]=array(
                                            'taxonomy'=>'product_cat',
                                            'field'=>'slug',
                                            'terms'=> $cat_id
                                        );
                                        if($product_type == 'bestsell'){
                                            $args['meta_key'] = 'total_sales';
                                            $args['orderby'] = 'meta_value_num';
                                        }
                                        if($product_type=='onsale'){
                                            $args['meta_query'][]=array(
                                                'key'   => '_sale_price',
                                                'value' => 0,
                                                'compare' => '>',                
                                                'type'          => 'numeric'
                                            );
                                        }
                                        if($product_type == 'featured-product'){
                                            $args['tax_query'][] =  array(
                                                'taxonomy' => 'product_visibility',
                                                'field'    => 'name',
                                                'terms'    => 'featured',
                                                'operator' => 'IN',
                                            );
                                        }
                                        global $yith_woocompare;
                                        $product_query = new WP_Query($args);
                                        $i = 1;
                                        if($product_query->have_posts()) {
                                            while($product_query->have_posts()) {
                                                $product_query->the_post();
                                                global $product,$post;
                                                $post=get_post(get_the_id());
                                                $sale_price=get_post_meta( get_the_ID(), '_sale_price', true);
                                                $date_pro=strtotime($post->post_date);
                                                $date_now=strtotime('now');
                                                $set_timer = sv_get_option( 'sv_set_time_woo', 30);
                                                $uppsell=($date_now-$date_pro-$set_timer*24*60*60);
                                                $regular_price=get_post_meta( get_the_ID(), '_regular_price', true);
                                                $percent = '';
                                                if($sale_price) {
                                                    $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
                                                }
                                                if(has_post_thumbnail(get_the_ID())) $thumb_html = '<a href="'.get_the_permalink().'" class="product-image">'.get_the_post_thumbnail(get_the_ID(),array(300,450)).'</a>';
                                                else $thumb_html = '';
                                                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ></a>';
                                                $html_cp = sv_compare_url();                                                
                                                $button_html = apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                    esc_url( $product->add_to_cart_url() ),
                                                                    esc_attr( $product->get_id() ),
                                                                    esc_attr( $product->get_sku() ),
                                                                    esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                                    esc_attr( $product->get_type() ),
                                                                    esc_html( $product->add_to_cart_text() )
                                                                ),
                                                            $product );
                                                if($i == 1) $class_item = 'first-item';
                                                else $class_item = '';
                                                    ob_start();
                                                ?>
                                                <?php if($i == 1) echo '<div class="first-wrap">';?>
                                                <?php if($i == 2) echo '</div><div class="main-wrap">';?>
                                                <div class="item <?php echo esc_attr($class_item);?>">
                                                    <div class="inner">
                                                        <div class="item-image">
                                                            <div class="inner-item-image">
                                                                <a href="<?php the_permalink();?>" class="product-image">
                                                                    <?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
                                                                </a>     
                                                                <div class="images-info">                                                                
                                                                    <div class="item-btn">
                                                                        <div class="btn-wqc">
                                                                            <?php if(class_exists('YITH_WCWL_Init')):?>
                                                                                <a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr($post->ID) ?>" data-product-type="<?php echo esc_attr($product_type)?>" class="add_to_wishlist link-wishlist" ></a>
                                                                            <?php endif;?>
                                                                            <a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
                                                                            <?php
                                                                                sv_compare_url(true);
                                                                            ?>
                                                                        </div>
                                                                        <?php
                                                                            global $product;
                                                                            echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                                sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                                    esc_url( $product->add_to_cart_url() ),
                                                                                    esc_attr( $product->get_id() ),
                                                                                    esc_attr( $product->get_sku() ),
                                                                                    esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                                                    esc_attr( $product->get_type() ),
                                                                                    esc_html( $product->add_to_cart_text() )
                                                                                ),
                                                                            $product );
                                                                        ?>   
                                                                        <div class="wrap-ns-price">
                                                                            <div class="price-box">
                                                                                <p class="special-price">
                                                                                    <span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
                                                                                </p>
                                                                                <p class="old-price">
                                                                                    <span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
                                                                                </p>
                                                                            </div>
                                                                            <div class="wrap-new-sale">
                                                                                <?php if(isset($percent) && $sale_price):?>
                                                                                    <div class="sale-item"><?php echo esc_attr($percent);?></div>
                                                                                <?php endif;?>
                                                                                <?php if($uppsell<0):?>
                                                                                    <div class="new-item"><?php esc_html_e('new','7upframework')?></div>
                                                                                <?php endif;?>
                                                                            </div>
                                                                        </div>  
                                                                    </div>
                                                                </div>
                                                            </div>                                                        
                                                        </div>                                                        
                                                    </div>
                                                </div>
                                                <?php if($i == $product_query->post_count) echo '</div>';?>
                                                <?php 
                                                $html .= @ob_get_clean();                                                
                                                $i ++;
                                            }
                                        }
                                        $html .= '</div>                                                
                                            </div>';
                                $ccount ++;
                                    }
                $html .=    '</div>';
                $html .= '</div>';
                }
                break;
                
            default:
                if(!empty($cats)){
                $cats = explode(',', $cats);
                if(!empty($content)) $content_html = wpb_js_remove_wpautop($content, true);
                else $content_html = '';
                $tab_item_html = $auto_hover = '';
                $ccount = 1;
                $pre = rand(1,1000);
                foreach ($cats as $cat_id) {
                    $f_class = '';
                    if($ccount == 1) $f_class = 'active';
                    if($ccount == count($cats)) $f_class = 'last';
                    $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                    if(is_object($term) && !empty($term)){
                        $tab_item_html .= '<li class="'.$f_class.'"><a data-toggle="tab" href="#'.$pre.$term->slug.'">'.$term->name.'</a></li>';
                    }
                    $ccount ++;
                }
                if($hover_auto == 'yes'){
                    $auto_hover = 'sv-block-hover hover-style2';
                }
                $html .= '<div class="'.$auto_hover.' block-'.$style.'">';
                $html .=    '<div class="tab-item">
                                '.$content_html.'
                                <ul>
                                    '.$tab_item_html.'
                                </ul>
                            </div>';
                $html .=    '<div class="tab-content product">';
                                    $ccount = 1;
                                    foreach ($cats as $cat_id) {
                                        $f_class = '';
                                        if($ccount == 1) $f_class = 'active';
                                        $term = get_term_by( 'slug',$cat_id, 'product_cat' );
                                        if(is_object($term) && !empty($term)){
                    $html .=    '<div class="tab-pane '.$f_class.'" id="'.$pre.$term->slug.'">
                                    <div class="box-'.$style.' item-'.$item_style.'">
                                        <div class="slider-inner">
                                            <div class="container-slider products-grid">
                                                <div class="wrap_item sv_slider slider_'.$pre.'" data-num="'.$item.'" data-speed="'.$speed.'">';
                                        $args = array(
                                            'post_type'         => 'product',
                                            'posts_per_page'    => $number,
                                            'order_by'          => $order_by,
                                            'order'             => $order,
                                            );
                                        $args['tax_query'][]=array(
                                            'taxonomy'=>'product_cat',
                                            'field'=>'slug',
                                            'terms'=> $cat_id
                                        );
                                        if($product_type == 'bestsell'){
                                            $args['meta_key'] = 'total_sales';
                                            $args['orderby'] = 'meta_value_num';
                                        }
                                        if($product_type=='onsale'){
                                            $args['meta_query'][]=array(
                                                'key'   => '_sale_price',
                                                'value' => 0,
                                                'compare' => '>',                
                                                'type'          => 'numeric'
                                            );
                                        }
                                        if($product_type == 'featured-product'){
                                            $args['tax_query'][] =  array(
                                                'taxonomy' => 'product_visibility',
                                                'field'    => 'name',
                                                'terms'    => 'featured',
                                                'operator' => 'IN',
                                            );
                                        }
                                        global $yith_woocompare;
                                        $product_query = new WP_Query($args);
                                        if($product_query->have_posts()) {
                                            while($product_query->have_posts()) {
                                                $product_query->the_post();
                                                global $product,$post;
                                                if(has_post_thumbnail(get_the_ID())) $thumb_html = '<a href="'.get_the_permalink().'" class="product-image">'.get_the_post_thumbnail(get_the_ID(),array(300,450)).'</a>';
                                                else $thumb_html = '';
                                                if(class_exists('YITH_WCWL_Init')) $html_wl = '<a href="'.str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )).'" rel="nofollow" data-product-id="'.get_the_ID().'" class="add_to_wishlist link-wishlist" ></a>';
                                                $html_cp = sv_compare_url();
                                                $terms = wp_get_post_terms( get_the_id(), 'product_cat', $args );
                                                $cat_html = '';
                                                if(is_object($terms) && !empty($terms)){
                                                    $term_id=$terms[0]->term_id;
                                                    $term_name=$terms[0]->name;
                                                    $cat_html = '<div class="cate-name">
                                                                    <a href="'.get_term_link( $term_id, 'product_cat' ).'">'.$term_name.'</a>
                                                                </div>';
                                                }
                                                $percent = '';
                                                $regular_price = get_post_meta( get_the_ID(), '_regular_price', true);
                                                $sale_price = get_post_meta( get_the_ID(), '_sale_price', true);
                                                if(!empty($sale_price)) {
                                                    $percent = '<div class="sale-item">'.round((($regular_price-$sale_price)/$regular_price)*100,0).'%</div>';
                                                    $price_show = $sale_price;
                                                }
                                                else $price_show = $regular_price;
                                                $date_pro=strtotime($post->post_date);
                                                $date_now=strtotime('now');
                                                $set_timer = sv_get_option( 'sv_set_time_woo', 30);
                                                $uppsell=($date_now-$date_pro-$set_timer*24*60*60);
                                                if($uppsell < 0) $uppsell_html = '<div class="new-item">'.esc_html__('new','7upframework').'</div>';
                                                else $uppsell_html = '';
                                                $button_html = apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                    esc_url( $product->add_to_cart_url() ),
                                                                    esc_attr( $product->get_id() ),
                                                                    esc_attr( $product->get_sku() ),
                                                                    esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                                    esc_attr( $product->get_type() ),
                                                                    esc_html( $product->add_to_cart_text() )
                                                                ),
                                                            $product );
                                                if($item_style == 'style-2'){ 
                                                    if($sale_price) $percent=round((($regular_price-$sale_price)/$regular_price)*100,0).'%';
                                                    ob_start();
                                                ?>
                                                <div class="item">
                                                    <div class="inner">
                                                        <div class="item-image">
                                                            <a href="<?php the_permalink();?>" class="product-image">
                                                                <?php if(has_post_thumbnail()) the_post_thumbnail(array(300,450))?>
                                                            </a>     
                                                            <div class="images-info">
                                                                <div class="wrap-style">
                                                                    <div class="product-name">
                                                                        <a href="<?php echo esc_url(get_permalink());?>"><?php echo get_the_title();?></a>
                                                                    </div>
                                                                    <div class="wrap-ns-price">
                                                                        <div class="price-box">
                                                                            <p class="special-price">                                                               
                                                                                <span class="price"><?php echo balanceTags($product->get_price_html()); ?></span>
                                                                            </p>
                                                                            <p class="old-price">
                                                                                <span class="price"><?php echo get_woocommerce_currency_symbol();?><?php echo esc_attr($regular_price);?></span>
                                                                            </p>
                                                                        </div>
                                                                        <div class="wrap-new-sale">
                                                                            <?php if($percent):?>
                                                                                <div class="sale-item"><?php echo esc_attr($percent);?></div>
                                                                            <?php endif;?>
                                                                            <?php if($uppsell<0):?>
                                                                                <div class="new-item"><?php esc_html_e('new','7upframework')?></div>
                                                                            <?php endif;?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="item-btn">
                                                                    <div class="btn-wqc">
                                                                        <?php if(class_exists('YITH_WCWL_Init')):?>
                                                                            <a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo esc_attr($post->ID) ?>" data-product-type="<?php echo esc_attr($product_type)?>" class="add_to_wishlist link-wishlist" ></a>
                                                                        <?php endif;?>
                                                                        <a data-product-id="<?php echo get_the_id(); ?>" href="<?php the_permalink();?>" class="vt_quickview_handler fancybox"><span><?php esc_html_e('Quick View','7upframework')?></span></a>
                                                                        <?php
                                                                            sv_compare_url(true);
                                                                        ?>
                                                                    </div>
                                                                    <?php
                                                                        global $product;
                                                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="btn-cart button %s product_type_%s"><span>%s</span></a>',
                                                                                esc_url( $product->add_to_cart_url() ),
                                                                                esc_attr( $product->get_id() ),
                                                                                esc_attr( $product->get_sku() ),
                                                                                esc_attr( isset( $quantity ) ? $quantity : 1 ),
                                                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                                                esc_attr( $product->get_type() ),
                                                                                esc_html( $product->add_to_cart_text() )
                                                                            ),
                                                                        $product );
                                                                    ?>      
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                                <?php 
                                                $html .= @ob_get_clean();
                                                }
                                                else{
                                                $html .= '<div class="item">
                                                            <div class="inner">
                                                                <div class="item-image">
                                                                    <div class="item-image-inner">
                                                                        '.$thumb_html.'
                                                                        <div class="item-btn">
                                                                            <div class="btn-wqc">
                                                                                '.$html_wl.'
                                                                                <a data-product-id="'.get_the_id().'" href="'.get_the_permalink().'" class="vt_quickview_handler fancybox"><span>'.esc_html__('Quick View','7upframework').'</span></a>
                                                                                '.$html_cp.'
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="product-info">
                                                                    <div class="product-name">
                                                                        <a href="'.get_the_permalink().'">'.get_the_title().'</a>
                                                                    </div>
                                                                    '.$cat_html.'
                                                                    <div class="wrap-ns-price">
                                                                        <div class="price-box">
                                                                            <p class="special-price">
                                                                                <span class="price">'.$product->get_price_html().'</span>
                                                                            </p>
                                                                        </div>
                                                                        <div class="wrap-new-sale">
                                                                            '.$percent.'
                                                                            '.$uppsell_html.'
                                                                        </div>
                                                                    </div>
                                                                    '.$button_html.'
                                                                </div>
                                                            </div>
                                                        </div>';
                                                }
                                            }
                                        }
                                        $html .= '</div>
                                                <div class="navslider">
                                                    <a href="#" class="prev"><span>'.esc_html__('Prev','7upframework').'</span></a>
                                                    <a href="#" class="next"><span>'.esc_html__('Next','7upframework').'</span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>';
                                $ccount ++;
                                        }
                                    }
                $html .=    '</div>';
                $html .= '</div>';
                }                
                break;
        }
        wp_reset_postdata();
        return $html;
    }
}

stp_reg_shortcode('list_style_product','sv_vc_list_style_product');
add_action( 'vc_build_admin_page','sv_add_list_style_product' );
if ( ! function_exists( 'sv_add_list_style_product' ) ) {
    function sv_add_list_style_product(){
        vc_map( array(
            "name"      => esc_html__("SV List Style Product", '7upframework'),
            "base"      => "list_style_product",
            "icon"      => "icon-st",
            "category"  => '7Up-theme',
            "params"    => array(
                array(
                    'heading'     => esc_html__( 'Style', '7upframework' ),
                    'type'        => 'dropdown',
                    'description' => esc_html__( 'Choose style to display.', '7upframework' ),
                    'param_name'  => 'style',
                    'value'       => array(
                        esc_html__('Featured Product','7upframework') => 'featured-product',
                        esc_html__('Tab Slider Right content','7upframework') => 'new-arrivals',
                        esc_html__('Tab Slider','7upframework') => 'best-seller',
                        esc_html__('Grid Product','7upframework') => 'grid-product',
                        esc_html__('Tab Grid','7upframework') => 'tab-grid',
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Number', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of product. Default is 8.', '7upframework' ),
                    'param_name'  => 'number',
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Product Type', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'product_type',
                    'value' => array(
                        esc_html__('Latest Products','7upframework')    => 'latest',
                        esc_html__('Featured Products','7upframework')  => 'featured',
                        esc_html__('Best Sellers','7upframework')       => 'bestsell',
                        esc_html__('On Sale','7upframework')            => 'onsale',
                    ),
                    'description' => esc_html__( 'Select Product View Type', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'holder'     => 'div',
                    'heading'     => esc_html__( 'Product Categories', '7upframework' ),
                    'type'        => 'checkbox',
                    'param_name'  => 'cats',
                    'value'       => sv_vc_list_taxonomy('product_cat',false)
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Order By', '7upframework' ),
                    'value' => array(
                        esc_html__('Date','7upframework')  => 'date',
                        esc_html__('Rand','7upframework')  => 'rand',
                        esc_html__('Name','7upframework')  => 'title',
                        esc_html__('Price','7upframework') => 'price',
                    ),
                    'param_name' => 'orderby',
                    'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Order', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'order',
                    'value' => array(                   
                        esc_html__('Desc','7upframework')  => 'DESC',
                        esc_html__('Asc','7upframework')  => 'ASC',
                    ),
                    'description' => esc_html__( 'Select Order Type ', '7upframework' ),
                    'edit_field_class'=>'vc_col-sm-6 vc_column',
                ),
                array(
                    'heading'     => esc_html__( 'Title Content', '7upframework' ),
                    'type'        => 'textarea_html',
                    'param_name'  => 'content',
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => array('new-arrivals','best-seller','featured-product','grid-product')
                        )
                ),
                array(
                    "type" => "attach_image",
                    "heading" => esc_html__("Featured Image",'7upframework'),
                    "param_name" => "featured_thumb",
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     =>array( 'featured-product','grid-product')
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Featured Link', '7upframework' ),
                    'type'        => 'textfield',
                    'param_name'  => 'featured_url',
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     =>array( 'featured-product','grid-product')
                        )
                ),               
                array(
                    'heading'     => esc_html__( 'Extra Text', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'This text are show with extra text icon with style Featured Product.', '7upframework' ),
                    'param_name'  => 'extra_text',
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => 'featured-product'
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Item slider display', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter number of item. Default is 4.', '7upframework' ),
                    'param_name'  => 'item',
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => array('new-arrivals','best-seller','featured-product')
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Speed', '7upframework' ),
                    'type'        => 'textfield',
                    'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
                    'param_name'  => 'speed',
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => array('new-arrivals','best-seller','featured-product')
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Auto hover', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'hover_auto',
                    'value' => array(                   
                        esc_html__('No','7upframework')  => '',
                        esc_html__('Yes','7upframework')  => 'yes',
                    ),
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => array('new-arrivals','best-seller','featured-product','tab-grid')
                        )
                ),
                array(
                    'heading'     => esc_html__( 'Item Style', '7upframework' ),
                    'type'        => 'dropdown',
                    'param_name'  => 'item_style',
                    'value' => array(                   
                        esc_html__('Style 1','7upframework')  => '',
                        esc_html__('Style 2','7upframework')  => 'style-2',
                    ),
                    "dependency"    => array(
                        "element"   => 'style',
                        "value"     => array('new-arrivals','best-seller')
                        )
                )
            )
        ));
    }
}