<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */
 if ( ! function_exists( 'sv_canifa_latest_blog' ) ) {
	function sv_canifa_latest_blog( $atts, $shortcode_content = null ) {
		$html = $number_latest_blog = $post_orderby = $order = $text_readmore = '';
		extract( shortcode_atts(
			array(
				'style'  				=> '',
				'number_latest_blog'  	=> '4',
				'text_readmore'  		=> '',
				'post_orderby'  		=> 'None',
				'post_order'  		    => 'DESC',
				'item'  				=> '2',
				'speed'  				=> '',
			), $atts ) );
		$col = 12;
		$col_num = $col/(int)$item;
		global $post;
		$args=array(
			'post_type'=>'post',
			'posts_per_page'=>$number_latest_blog,
			'orderby'=>$post_orderby,
			'order' => $post_order
		);
		// var_dump($style);
		$query = new WP_Query($args);
		if($style == 'lastest-home10'){
			$html .= '<div class="content-news-scroll">';
			$i = 1;
			if($query->have_posts()){
				while($query->have_posts()){
					$query->the_post();
					if($i % 2 == 0) $item_class = 'item-right';
					else $item_class = 'item-left';
					$html .= 	'<div class="col-md-6 col-sm-6 col-xs-12">
									<div class="'.$item_class.'">
										<div class="item-news">
											<div class="item-news-thumb">
												<div class="news-date"><i class="fa fa-calendar-check-o"></i> <span>'.get_the_date('j M, Y').'</span></div>
												<a href="'.get_the_permalink().'" class="news-thumb-link">
													'.get_the_post_thumbnail(get_the_ID(),array(200,224)).'
												</a>
											</div>
											<div class="item-news-info">
												<h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
												<p>'.get_the_excerpt().'</p>
												<span>'.get_post_meta(get_the_ID(),'name_style',true).'</span>
											</div>
										</div>
									</div>
								</div>';
					$i++;
				}
			}
			$html .= '</div>';
		}
		else{
			if($style == 'post-grid'){
				if($query->have_posts()):
					while($query->have_posts()):
						$query->the_post();
					$thumb_url = '';
					if(has_post_thumbnail()){
						$thumb_url = wp_get_attachment_url( get_post_thumbnail_id() );
					}
					// var_dump(get_the_ID());
					$html .= '<div class="col-md-'.$col_num.' col-sm-6 col-xs-12">
								<div class="item-our-blog">
									<div class="our-blog-thumb">
										<a href="'.get_the_permalink().'">
											'.get_the_post_thumbnail(get_the_ID(),array(360,438)).'
										</a>
									</div>
									<div class="our-blog-info">
										<div class="inner-our-blog-info">
											<span>'.get_the_date('M j Y').'</span>
											<h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
											<span>'.get_comments_number().' '.esc_html__("Comments","7upframework").'</span>
											<div class="post-extra-link">
												<a class="fancybox" href="'.esc_url($thumb_url).'" data-fancybox-group="gallery" title="'.get_the_title().'"><img src="'.get_template_directory_uri().'/assets/images/icon-search.png" alt=""></a>
												<a href="'.get_the_permalink().'"><i class="fa fa-link"></i></a>
											</div>
										</div>
									</div>
								</div>
							</div>';
					endwhile;
				endif;
			}
			else{
				ob_start();
				?>
				<div class="lastest-blog">
					<div class="slider-inner">
						<div class="container-slider">
							<div class="wrap_item sv_slider" data-num="<?php echo esc_attr($item);?>" data-speed="<?php echo esc_attr($speed);?>" data-itemres="1,2,2">
								<?php
									$i = 1;
									if($query->have_posts()):
										while($query->have_posts()):
											$query->the_post();
											if($i % 2 == 1) $item_class = 'item-class';
											else $item_class = '';
											?>
											<div class="item <?php echo esc_attr($item_class);?>">
												<div class="inner">
													<div class="blog-info clearfix">
														<a href="<?php the_permalink();?>" class="pro-name"><?php echo get_the_title();?></a>
														<div class="date-com">
															<span class="date-style"><?php echo mysql2date('M d Y', $post->post_date); ?></span>
															<a href="#" class="com-style">
															<?php comments_number(esc_html__('0 Comment','7upframework'), esc_html__('1 Comment','7upframework'), esc_html__('% Comment','7upframework'));?>
															</a>
														</div>
														<div class="desc">
															<?php echo get_the_excerpt();?>                    
														</div>
														<?php if($text_readmore):?>
														<a href="<?php the_permalink();?>" class="button"><?php echo esc_attr($text_readmore);?></a>
														<?php endif;?>
													</div>
													<?php if(has_post_thumbnail()):?>
													<div class="wrap-image">
														<a title="<?php the_title();?>" href="<?php the_permalink()?>" class="blog-image">
															<?php the_post_thumbnail(array(255,255));?>    
														</a>
													</div>
												<?php endif;?>
												</div>
											</div>
								<?php 	$i++;
									endwhile;
								endif;
								?>
							</div>
							<!--end wrap_item-->
							<div class="navslider">
								<a href="#" class="prev"><span><?php esc_html_e('Prev','7upframework');?></span></a>
								<a href="#" class="next"><span><?php esc_html_e('Next','7upframework');?></span></a>
							</div>
						</div>
						<!--end container-slider-->    
					</div>
					<!--end slider-inner-->    
				</div>
				<!--lastest-blog-->  
				<?php
				$html = @ob_get_clean();
			}
		}
		wp_reset_postdata();
		return  $html;
	}
}
stp_reg_shortcode('latest_blog','sv_canifa_latest_blog');
/* Latest Blog
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Canifa List Post', '7upframework' ),
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'base'     => 'latest_blog',
		'icon'    => 'icon-st',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', '7upframework' ),
				'value' => array(
					esc_html__('Slider','7upframework') => '',
					esc_html__('Grid','7upframework')  => 'post-grid',
					esc_html__('Home 10 style','7upframework')  => 'lastest-home10',
				),
				'param_name' => 'style',
				'description' => esc_html__( 'Select Order style to display ', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Number Post', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number post', '7upframework' ),
				'param_name'  => 'number_latest_blog',
			),
			array(
				'heading'     => esc_html__( 'Item slider display', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter number of item. Default is 2.', '7upframework' ),
				'param_name'  => 'item',
			),
			array(
				'heading'     => esc_html__( 'Speed', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
				'param_name'  => 'speed',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Order By', '7upframework' ),
				'value' => array(
					esc_html__('None','7upframework') =>'none',
					esc_html__('Post ID','7upframework') => 'ID',
					esc_html__('Author','7upframework')=>'author',
					esc_html__('Post Title','7upframework')=>'title',
					esc_html__('Post Name','7upframework')=>'name',
					esc_html__('Post Date','7upframework')=>'date',
					esc_html__('Last Modified Date','7upframework')=>'modified',
					esc_html__('Post Parent','7upframework')=>'parent',
					esc_html__('Random','7upframework')=>'rand',
					esc_html__('Comment Count','7upframework')=>'comment_count',
				),
				'param_name' => 'post_orderby',
				'description' => esc_html__( 'Select Orderby Type ', '7upframework' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Order', '7upframework' ),
				'value' => array(
					esc_html__('Desc','7upframework') => 'DESC',
					esc_html__('Asc','7upframework')  => 'ASC',
				),
				'param_name' => 'post_order',
				'description' => esc_html__( 'Select Order Type ', '7upframework' ),
			),
			array(
				'heading'     => esc_html__( 'Read More Text', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter text for readmore link', '7upframework' ),
				'param_name'  => 'text_readmore',
			),
		)
	)
);