<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_map'))
{
    function sv_vc_map($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'style'         =>'',
            'market'        =>'',
            'zoom'          =>'16',
            'location'      =>'',
            'control'       =>'yes',
            'scrollwheel'   =>'yes',
            'disable_ui'    =>'no',
            'draggable'     =>'yes',
            'width'     =>'100%',
            'height'     =>'500px'
        ),$attr));
        wp_enqueue_script('google-map');
        parse_str( urldecode( $location ), $locations);
        $location_text = '';
        foreach ($locations as $values) {
            $location_text .= '|';
            foreach ($values as $value) {
                $location_text .= $value.',';
            }
        }
        $img = array();$img[0]='';
        if($market != '') {
            $img = wp_get_attachment_image_src($market,"full");
        }
        $map_css = 'width:'.$width.';height:'.$height.';max-width-100%;';
        $html .= '<div class="clearfix"></div><div id="st-map" class="'.SV_Assets::build_css($map_css).'" data-location="'.$location_text.'" data-market="'.$img[0].'" data-zoom="'.$zoom.'" data-style="'.$style.'" data-control="'.$control.'" data-scrollwheel="'.$scrollwheel.'" data-disable_ui="'.$disable_ui.'" data-draggable="'.$draggable.'"></div>';
        return $html;
    }
}

stp_reg_shortcode('sv_map','sv_vc_map');

vc_map( array(
    "name"      => esc_html__("SV GoogleMap", '7upframework'),
    "base"      => "sv_map",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "dropdown",
            "holder" => "div",
            "heading" => esc_html__("Map Style",'7upframework'),
            "param_name" => "style",
            'value' => array(
                esc_html__('Default','7upframework') => '',
                esc_html__('Grayscale','7upframework') => 'grayscale',
                esc_html__('Blue','7upframework') => 'blue',
                esc_html__('Dark','7upframework') => 'dark',
                esc_html__('Pink','7upframework') => 'pink',
                esc_html__('Light','7upframework') => 'light',
                esc_html__('Blueessence','7upframework') => 'blueessence',
                esc_html__('Bentley','7upframework') => 'bentley',
                esc_html__('Retro','7upframework') => 'retro',
                esc_html__('Cobalt','7upframework') => 'cobalt',
                esc_html__('Brownie','7upframework') => 'brownie'
            ),
        ),
        array(
            "type" => "add_location_map",
            "heading" => esc_html__( "Add Map Location", '7upframework' ),
            "param_name" => "location",
            "description" => esc_html__( "Click Add more button to add location.", '7upframework' )
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "heading" => esc_html__( "Map Zoom", '7upframework' ),
            "param_name" => "zoom",
            "description" => esc_html__( "Enter zoom for map. Default is 16", '7upframework' ),
        ),
        array(
            'type' => 'attach_image',
            "holder" => "div",
            'heading' => esc_html__( 'Marker Image', '7upframework' ),
            'param_name' => 'market',
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Map Width', '7upframework' ),
            'param_name' => 'width',
            "description" => esc_html__( "This is value to set width for map. Unit % or px. Example: 100%,500px. Default is 100%", '7upframework' )
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Map Height', '7upframework' ),
            'param_name' => 'height',
            "description" => esc_html__( "This is value to set height for map. Unit % or px. Example: 100%,500px. Default is 500px", '7upframework' )
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("MapTypeControl",'7upframework'),
            "param_name" => "control",
            'value' => array(
                esc_html__('Yes','7upframework') => 'yes',
                esc_html__('No','7upframework') => 'no',
                ),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Scrollwheel",'7upframework'),
            "param_name" => "scrollwheel",
            'value' => array(
                esc_html__('Yes','7upframework') => 'yes',
                esc_html__('No','7upframework') => 'no',
                ),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("DisableDefaultUI",'7upframework'),
            "param_name" => "disable_ui",
            'value' => array(
                esc_html__('No','7upframework') => 'no',
                esc_html__('Yes','7upframework') => 'yes',
                ),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Draggable",'7upframework'),
            "param_name" => "draggable",
            'value' => array(
                esc_html__('Yes','7upframework') => 'yes',
                esc_html__('No','7upframework') => 'no',
                ),
            'edit_field_class'=>'vc_col-sm-6 vc_column'
        )
    )
));