<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */
 if ( ! function_exists( 'sv_floating_sidebar' ) ) {
	function sv_floating_sidebar( $atts, $shortcode_content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'title'  	=> '',
				'number'  	=> '',
				'height'	=> '',
			), $atts ) );
		ob_start();
		?>
		<?php
			global $post;
			$args = array(
				'post_type'=>'post',
				'posts_per_page'=>$number
			);
			$query_post = new WP_Query( $args );
			if($query_post->have_posts()): 
 		?>
		<div class="wrap-floating-sidebar">
			<h2 class="title-floating-sidebar"><?php echo esc_attr($title);?></h2>
			<div class="floating-sidebar" style="height:<?php echo esc_attr($height).'px';?>">
				<div class="inner-floating-sidebar">
				<?php 
					while($query_post->have_posts()) : $query_post->the_post();
					$str_gals=get_post_meta(get_the_id(),'format_gallery',true);
					$gals=explode(',',$str_gals);
					$img_src=wp_get_attachment_image_src( get_post_thumbnail_id(get_the_id()), array(200,200) );
				?>	
				<?php if($gals[0]!=''):?>
				<script type="text/javascript">
					jQuery(document).ready(function($){
						$("#post_<?php echo get_the_id();?>").click(function(event) {
							event.preventDefault();
							$.fancybox.open([
								<?php foreach($gals as $gal):?>
								{
									href : '<?php echo wp_get_attachment_url($gal);?>',
								},
								<?php endforeach;?>
							]);
						});
					});
				</script>
				<?php endif;?>
				<div class="floating-post clearfix">
					<div class="floating-post-thumb">
						<img src="<?php echo esc_url($img_src[0]);?>" alt="" />
						<div class="float-extra-link">
							<?php if($gals[0]!=''):?>
								<a href="#" id="<?php echo 'post_'.get_the_id();?>"><i class="fa fa-search"></i></a>
							<?php endif;?>
							<a href="<?php the_permalink();?>"><i class="fa fa-link"></i></a>
						</div>
					</div>
					<div class="floating-post-content">
						<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
						<p class="floating-post-date"><?php the_time('M d Y');?></p>
						<a href="<?php the_permalink();?>" class="readmore"><?php echo esc_html__('read and shop now','7upframework');?></a>
					</div>
				</div>
				<?php endwhile?>
				</div>
			</div>
		</div>
		<?php endif;wp_reset_postdata();?>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('floating_sidebar','sv_floating_sidebar');

vc_map(
	array(
		'name'     => esc_html__( 'Floating Sidebar', '7upframework' ),
		'base'     => 'floating_sidebar',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'params'   => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title Sidebar",'7upframework'),
				"param_name" => "title",
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number Posts",'7upframework'),
				"param_name" => "number",
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Sidebar Height",'7upframework'),
				"param_name" => "height",
			),
		)
	)
);