<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */
if ( ! function_exists( 'sv_floating_box' ) ) {
	function sv_floating_box( $atts, $content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'type'  	=> 'text-inner',
			), $atts ) );
		ob_start();
		?>
		<div class="floating-box <?php echo esc_attr($type);?>">
			<div class="wrap-item">
				<?php 
					echo wpb_js_remove_wpautop($content, true);
				?>
			</div>
		</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}

stp_reg_shortcode('floating_box','sv_floating_box');

if ( ! function_exists( 'sv_floating_box_item' ) ) {
	function sv_floating_box_item( $atts, $content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'image'  	=> '',
				'link'  	=> '',
				'image_hover'  	=> '',
			), $atts ) );
		ob_start();
		?>		
		<div class="item">
			<?php if($image_hover):?>
			<div class="thumb-slider has-image-hover">
				<a href="<?php echo esc_url($link);?>">
					<img class="floating-current-image img-responsive"  src="<?php echo wp_get_attachment_url(esc_attr($image));?>" alt="" />
					<img class="floating-hover-image img-responsive"  src="<?php echo wp_get_attachment_url(esc_attr($image_hover));?>" alt="" />
				</a>
			</div>
			<?php else:?>
			<div class="thumb-slider">
				<a href="<?php echo esc_url($link);?>">
					<img class="floating-current-image img-responsive"  src="<?php echo wp_get_attachment_url(esc_attr($image));?>" alt="" />
				</a>
			</div>
			<?php endif;?>
			<div class="text-slider">
				<div class="inner-text-slider">
					<?php 
						echo wpb_js_remove_wpautop($content, true);
					?>
				</div>
			</div>
		</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('floating_box_item','sv_floating_box_item');
/*Vc Map*/
vc_map(
	array(
		'name'     => esc_html__( 'Floating Box', '7upframework' ),
		'base'     => 'floating_box',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'floating_box_item' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Type', '7upframework' ),
				'value' => array(
					esc_html__( 'Text Inner', '7upframework' ) => 'text-inner',
					esc_html__( 'Text Outer', '7upframework' ) => 'text-outer',
				),
				'param_name' => 'type',
				'description' => esc_html__( 'Select Box Type', '7upframework' ),
			),
		),		
	)
);

vc_map(
	array(
		'name'     => esc_html__( 'Floating Box Item', '7upframework' ),
		'base'     => 'floating_box_item',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'floating_box'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Link', '7upframework' ),
				'type'        => 'textfield',
				'param_name'  => 'link',
			),
			array(
				'heading'     => esc_html__( 'Image', '7upframework' ),
				'type'        => 'attach_image',
				'param_name'  => 'image',
			),
			array(
				'heading'     => esc_html__( 'Image Hover', '7upframework' ),
				'type'        => 'attach_image',
				'param_name'  => 'image_hover',
			),
			array(
				'heading'     => esc_html__( 'Content', '7upframework' ),
				'type'        => 'textarea_html',
				'param_name'  => 'content',
			),
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Floating_Box extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Floating_Box_Item extends WPBakeryShortCode {
    }
}
