<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_facebook_fanpage' ) ) {
	function sv_facebook_fanpage( $atts, $shortcode_content = null ) {
		$html = $widget_title = $data_href = $data_width = $data_height ='';
		extract( shortcode_atts(
			array(
				'widget_title'  	=> '',
				'data_href'  		=> '',
				'data_width'  		=> '',
				'data_height'  		=> '',
				'appid'  		=> '691387590945471',
			), $atts ) );
		ob_start();
		?>
		<h2 class="widgettitle"><?php echo esc_attr($widget_title);?></h2>
		<div class="fanbox-content">
			<div id="fb-root"></div>
			<script>(function(d, s, id) {
			  var js, fjs = d.getElementsByTagName(s)[0];
			  if (d.getElementById(id)) return;
			  js = d.createElement(s); js.id = id;
			  js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.4";
			  fjs.parentNode.insertBefore(js, fjs);
			}(document, 'script', 'facebook-jssdk'));</script>

			<div class="fb-page" data-href="<?php echo esc_url($data_href);?>" data-width="<?php echo esc_attr($data_width);?>" data-height="<?php echo esc_attr($data_height);?>" data-small-header="false" data-adapt-container-width="false" data-hide-cover="false" data-show-facepile="true" data-show-posts="false"><div class="fb-xfbml-parse-ignore"><blockquote cite="<?php echo esc_url($data_href);?>"><a href="<?php echo esc_url($data_href);?>"></a></blockquote></div></div>
		</div>
		<?php
		$html = @ob_get_clean();
		return  $html;
	}
}
stp_reg_shortcode('facebook_fanpage','sv_facebook_fanpage');
/* Facebook Fanpage
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Facebook Fan Page', '7upframework' ),
		'category'  => '7Up-theme',
		'base'     => 'facebook_fanpage',
		'icon'    => 'icon-st',
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Title Widget', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Title For Widget', '7upframework' ),
				'param_name'  => 'widget_title',
			),
			array(
				'heading'     => esc_html__( 'Url', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Url Fanpage', '7upframework' ),
				'param_name'  => 'data_href',
			),
			array(
				'heading'     => esc_html__( 'Width', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Width Fan Box', '7upframework' ),
				'param_name'  => 'data_width',
			),
			array(
				'heading'     => esc_html__( 'Height', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Width Fan Box', '7upframework' ),
				'param_name'  => 'data_height',
			),
		)
	)
);