<?php
/**
 * @version    1.0
 * @package    Canifa
 * @author     7up Team <7uptheme.com>
 * @copyright  Copyright (C) 2015 7uptheme. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.7uptheme.com
 */

if ( ! function_exists( 'sv_vc_brand' ) ) {
	function sv_vc_brand( $atts, $content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'item'  	=> '6',
				'speed'  	=> '',
				'itemres'  	=> '2,3,4,5',
			), $atts ) );
		$html .= 	'<div class="list-brand single-arrow">
						<div class="wrap-item" data-item="'.$item.'" data-speed="'.$speed.'" data-itemres="'.$itemres.'">
							'.wpb_js_remove_wpautop($content, true).'
						</div>
					</div>';
		return  $html;
	}
}
stp_reg_shortcode('sv_brand','sv_vc_brand');

if ( ! function_exists( 'sv_vc_brand_item' ) ) {
	function sv_vc_brand_item( $atts, $content = null ) {
		$html = '';
		extract( shortcode_atts(
			array(
				'logo'  	=> '',
				'link'  	=> '',
			), $atts ) );
		if(!empty($logo)){
            $img = wp_get_attachment_image_src( $logo ,"full");
			$html .= 	'<div class="item">
							<div class="item-brand">
								<a href="'.esc_url($link).'">
									<img src="'.esc_url($img[0]).'" alt="">
								</a>
							</div>
						</div>';
		}
		return  $html;
	}
}
stp_reg_shortcode('sv_brand_item','sv_vc_brand_item');
/* Payment
---------------------------------------------------------- */
vc_map(
	array(
		'name'     => esc_html__( 'Brand', '7upframework' ),
		'base'     => 'sv_brand',
		'category' => esc_html__( '7Up-theme', '7upframework' ),
		'icon'     => 'icon-st',
		'as_parent' => array( 'only' => 'sv_brand_item' ),
		'content_element' => true,
		'js_view' => 'VcColumnView',
		'params'   => array(
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Item/slider', '7upframework' ),				
				'param_name' => 'item',
			),
			array(
                'heading'     => esc_html__( 'Speed', '7upframework' ),
                'type'        => 'textfield',
                'description' => esc_html__( 'Enter time slider go to next item. Unit (ms). Example 5000. If empty this field autoPlay is false.', '7upframework' ),
                'param_name'  => 'speed',
            ),
            array(
                'heading'     => esc_html__( 'Custom Item', '7upframework' ),
                'type'        => 'textfield',
                'description' => esc_html__( 'Enter custom item for each window 360px,480px,768px,992px. Default is "2,3,4,5"', '7upframework' ),
                'param_name'  => 'itemres',
            ),
		)
	)
);

vc_map(
	array(
		'name'     => esc_html__( 'Brand Item', '7upframework' ),
		'base'     => 'sv_brand_item',
		'icon'     => 'icon-st',
		'content_element' => true,
		'as_child' => array('only' => 'sv_brand'),
		'params'   => array(
			array(
				'heading'     => esc_html__( 'Logo', '7upframework' ),
				'type'        => 'attach_image',
				'description' => esc_html__( 'Enter Icon Payment', '7upframework' ),
				'param_name'  => 'logo',
			),
			array(
				'heading'     => esc_html__( 'Link', '7upframework' ),
				'type'        => 'textfield',
				'description' => esc_html__( 'Enter Brand Link', '7upframework' ),
				'param_name'  => 'link',
			),
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Sv_Brand extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Sv_Brand_Item extends WPBakeryShortCode {
    }
}