<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
// remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20 );
// add_action( 'woocommerce_after_order_notes', 'woocommerce_checkout_payment', 20 );
/*********************************** ADD TO CART AJAX *******************************************/
if(class_exists("woocommerce")){
add_action( 'wp_ajax_add_to_cart', 'sv_minicart_ajax' );
add_action( 'wp_ajax_nopriv_add_to_cart', 'sv_minicart_ajax' );
if(!function_exists('sv_minicart_ajax')){
	function sv_minicart_ajax() {
		
		$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) );
		$quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] );
		$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

		if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) ) {
			do_action( 'woocommerce_ajax_added_to_cart', $product_id );
			WC_AJAX::get_refreshed_fragments();
		} else {
			$this->json_headers();

			// If there was an error adding to the cart, redirect to the product page to show any errors
			$data = array(
				'error' => true,
				'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
				);
			echo json_encode( $data );
		}
		die();
	}
}
/*********************************** END ADD TO CART AJAX ****************************************/

/********************************** REMOVE ITEM MINICART AJAX ************************************/

add_action( 'wp_ajax_product_remove', 'sv_product_remove' );
add_action( 'wp_ajax_nopriv_product_remove', 'sv_product_remove' );
if(!function_exists('sv_product_remove')){
	function sv_product_remove() {
	    global $wpdb, $woocommerce;
	    $cart_item_key = $_POST['cart_item_key'];
	    if ( $woocommerce->cart->get_cart_item( $cart_item_key ) ) {
			$woocommerce->cart->remove_cart_item( $cart_item_key );
		}
	    exit();
	}
}
/********************************* END REMOVE ITEM MINICART AJAX *********************************/

/********************************* ADD FIELD PRODUCT CATEGORY *********************************/

add_action( 'product_cat_add_form_fields', 'sv_taxonomy_add_new_meta_field', 10, 2 );
if(!function_exists('sv_taxonomy_add_new_meta_field')){
	function sv_taxonomy_add_new_meta_field() {
	  // this will add the custom meta field to the add new term page
	  ?>
	    <tr class="form-field">
	        <th scope="row" valign="top"><label><?php esc_html_e('Header image','7upframework')?></label></th>
	        <td>
	            <div id="product_cat_header" style="float: left; margin-right: 10px;">
	            	<?php $url = plugins_url().'/woocommerce/assets/images/placeholder.png';?>
	            	<img src="<?php echo esc_url($url);?>" width="60px" height="60px">
	            </div>
	            <div style="line-height: 60px;">	            	
	            	<input type="hidden" id="thumb_cat" name="term_meta[thumb_cat]" value="0">
	                <input type="hidden" id="header_cat" name="term_meta[header_cat]" value="0">
	                <button type="button" class="upload_image_header button"><?php esc_html_e('Upload/Add image','7upframework')?></button>
	                <button type="button" class="remove_image_header button" style="display: none;"><?php esc_html_e('Remove image','7upframework')?></button>
	            </div>
	            <div class="clear"></div>
	        </td>
	    </tr>
	  <?php
	}
}

/********************************* END ADD FIELD PRODUCT CATEGORY *********************************/

/********************************* EDIT PRODUCT CATEGORY *********************************/
if(!function_exists('sv_taxonomy_edit_meta_field')){
	function sv_taxonomy_edit_meta_field($term) {
	 
	    // put the term ID into a variable
	    $t_slug = $term->slug;
	 
	    // retrieve the existing value(s) for this meta field. This returns an array
	    $get_term_meta = get_option( "term_cat_meta" );
	    $term_option_name = "taxonomy_".$term->slug;
	    $term_meta = $get_term_meta[$term_option_name];
	    // var_dump($get_term_meta);
	    $img_url = plugins_url().'/woocommerce/assets/images/placeholder.png';
	    $remove_style = 'display: none;';
	    $has_img = '';
	    if($term_meta['header_cat']) {
	        $img_url = wp_get_attachment_url($term_meta['header_cat']);
	        $remove_style = '';
	        $has_img = 'has-image';
	    }
	    ?>
	    <tr class="form-field">
	        <th scope="row" valign="top"><label><?php esc_html_e('Header image','7upframework')?></label></th>
	        <td>
	            <div id="product_cat_header" data-url="<?php echo plugins_url().'/woocommerce/assets/images/placeholder.png';?>" class="<?php echo esc_attr($has_img);?>" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url($img_url)?>" width="60px" height="60px"></div>
	            <div style="line-height: 60px;">
	            	<input type="hidden" id="thumb_cat" name="term_meta[thumb_cat]" value="<?php echo esc_attr($term_meta['thumb_cat'])?>">
	                <input type="hidden" id="header_cat" name="term_meta[header_cat]" value="<?php echo esc_attr($term_meta['header_cat'])?>">
	                <button type="button" class="upload_image_header button"><?php esc_html_e('Upload/Add image','7upframework')?></button>
	                <button type="button" class="remove_image_header button" style="<?php esc_attr($remove_style)?>"><?php esc_html_e('Remove image','7upframework')?></button>
	            </div>
	            <div class="clear"></div>
	        </td>
	    </tr>
	<?php
	}
}
add_action( 'product_cat_edit_form_fields', 'sv_taxonomy_edit_meta_field', 10, 2 );

/********************************* END EDIT PRODUCT CATEGORY *********************************/

/********************************* SAVE FIELD PRODUCT CATEGORY *********************************/
if(!function_exists('sv_save_taxonomy_custom_meta')){
	function sv_save_taxonomy_custom_meta( $term_id ) {
	    if ( isset( $_POST['term_meta'] ) ) {
	        $term = get_term_by('id', $term_id, 'product_cat');
	        $term_meta = get_option( "term_cat_meta" );
	        $term_option_name = "taxonomy_".$term->slug;
	        $cat_keys = array_keys( $_POST['term_meta'] );
	        foreach ( $cat_keys as $key ) {
	            if ( isset ( $_POST['term_meta'][$key] ) ) {
	                $term_meta[$term_option_name][$key] = $_POST['term_meta'][$key];
	            }
	        }
	        // Save the option array.
	        update_option( "term_cat_meta", $term_meta );
	    }
	}
}
add_action( 'edited_product_cat', 'sv_save_taxonomy_custom_meta', 10, 2 );  
add_action( 'create_product_cat', 'sv_save_taxonomy_custom_meta', 10, 2 );

/******************************** END SAVE FIELD PRODUCT CATEGORY ********************************/

add_action('init', 'sv_set_catthumb_import');
if(!function_exists('sv_set_catthumb_import')){
	function sv_set_catthumb_import(){
		if(get_option('term_cat_meta') == 'set-import-cat'){
			global $config;
			$import_option = $config['import_option'];
			foreach ($import_option as $key => $value) {
				$term_slug = str_replace('taxonomy_', '', $key);
				$term = get_term_by('slug', $term_slug, 'product_cat');
				if(!empty($value['thumb_cat']) && is_object($term))
				update_woocommerce_term_meta( $term->term_id, 'thumbnail_id', $value['thumb_cat'] );
			}
			update_option( "term_cat_meta", $import_option );
		}
	}
}

// var_dump(get_option('term_cat_meta'));
/********************************** FANCYBOX POPUP CONTENT ************************************/

add_action( 'wp_ajax_product_popup_content', 'sv_product_popup_content' );
add_action( 'wp_ajax_nopriv_product_popup_content', 'sv_product_popup_content' );
if(!function_exists('sv_product_popup_content')){
	function sv_product_popup_content() {
		$product_id = $_POST['product_id'];
		$query = new WP_Query( array(
			'post_type' => 'product',
			'post__in' => array($product_id)
			));
		if( $query->have_posts() ):
		while ( $query->have_posts() ) : $query->the_post();	
		global $post,$product,$woocommerce;
		$date_pro=strtotime($post->post_date);
		$date_now=strtotime('now');
		$set_timer = sv_get_option( 'sv_set_time_woo', 30);
		$uppsell=($date_now-$date_pro-$set_timer*24*60*60);
		?>
		<div class="product-view">
			<div id="info-product-detail" class="info-product-detail clearfix">
				<div class="product-img-box images col-lg-7 col-md-7 col-sm-6 col-xs-12">
					<div class="inner">
						<div class="img-left">
							<div class="product-image product-image-zoom">
								<div class="product-image-gallery">
									<?php
										if ( has_post_thumbnail() ) {

											$image_title 	= esc_attr( get_the_title( get_post_thumbnail_id() ) );
											$image_caption 	= get_post( get_post_thumbnail_id() )->post_excerpt;
											$image_link  	= wp_get_attachment_url( get_post_thumbnail_id() );
											$image       	= get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array(
												'title'	=> $image_title,
												'alt'	=> $image_title
												) );

											$attachment_count = count( $product->get_gallery_image_ids() );

											if ( $attachment_count > 0 ) {
												$gallery = '[product-gallery]';
											} else {
												$gallery = '';
											}

											echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img class="attachment-shop_single" src="%s" alt="%s" />', $image_link, $image_caption, $image ), $post->ID );

										} else {

											echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img src="%s" alt="%s" />', wc_placeholder_img_src(), esc_html__( 'Placeholder', '7upframework' ) ), $post->ID );

										}
									?>
								</div>
							</div>
							<!--product-image-zoom-->	
							<div class="popup-btn  hidden-phone">
								<?php echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<a href="%s" id="popup-image" itemprop="image" class="woocommerce-main-image zoom fancybox-buttons" title="%s" data-rel="prettyPhoto' . $gallery . '">'.esc_html__("Click to popup images","7upframework").'</a>', $image_link, $image_caption, $image ), $post->ID );?>
							</div>
							<!--popup-btn-->						
						</div>
						<div class="more-views">
							<div class="navslider">
								<a class="prev"><?php esc_html_e('prev','7upframework');?></a> 
								<a class="next"><?php esc_html_e('next','7upframework');?></a>
							</div>
							<div class="inner">
								<?php
									$attachment_ids = $product->get_gallery_image_ids();
									$number_thumb = count($attachment_ids);
								?>
								<div id="jCarouselLite" class="jCarouselLite" data-num="<?php echo esc_attr($number_thumb);?>">
									<ul>
									<?php
										$popup_html = '<div style="display:none">';
										if ( $attachment_ids ) {
											$i = 0;
											foreach ( $attachment_ids as $attachment_id ) {
												$classes = array( 'zoom' );
												$image_link = wp_get_attachment_url( $attachment_id );
												if ( ! $image_link )
													continue;
												$image_title 	= esc_attr( get_the_title( $attachment_id ) );
												$image_caption 	= esc_attr( get_post_field( 'post_excerpt', $attachment_id ) );
												$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), 0, $attr = array(
													'title'	=> $image_title,
													'alt'	=> $image_title
													) );
												$image_class = esc_attr( implode( ' ', $classes ) );
												$popup_html .= 	'<a data-rel="prettyPhoto[product-gallery]" data-image-index="'.$i.'" title="'.$image_caption.'" href="'.esc_url($image_link).'" class="thumb-link">
																	'.$image.'
																</a>';
														$i++;
												echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<li><a class="click-view" href="%s"  title="%s">%s</a></li>', $image_link, $image_caption, $image ), $attachment_id, $post->ID, $image_class );
											} 
										}
										$popup_html .= '</div>';
										?>
									</ul>
									<?php echo balanceTags($popup_html);?>
								</div>
							</div>
						</div>
						<!--more-views--> 
					</div>
				</div>
				<div class="product-shop col-lg-5 col-md-5 col-sm-6 col-xs-12">
					<div class="box-left">
						<div class="product-name">
							<h1><a href="<?php the_permalink()?>"><?php the_title();?></a></h1>
						</div>
						<?php		
							global $product;             
							$star = $product->get_average_rating();
							$width = $star / 5 * 100;
							if($star):
						?>
						<div class="rating">
							<div class="ratings">
								<div class="rating-box">
									<div style="width:<?php echo esc_attr($width).'%';?>" class="rating"></div>
								</div>
							</div>
							<p class="rating-links">
								<a href="#tab-reviews"><?php echo esc_attr($product->get_review_count());?> <?php esc_html_e('(vote)','7upframework');?></a>
								<span class="separator">|</span>
								<a href="#" class="re-temp"><?php esc_html_e('Add Review','7upframework');?></a>
							</p>
						</div>
						<?php endif;?>
						<?php
							$sku=get_post_meta($post->ID,'_sku',true);
							if($sku):
						?>
								<div class="product-code box-style">
									<ul>
										<li class="first"><?php esc_html_e('Product Id','7upframework');?></li>
										<li class="last"><?php echo esc_attr($sku);?></li>
									</ul>
								</div>
							<?php endif;
						?>
						<?php
							$stock = get_post_meta($post->ID,'_stock_status',true);
						?>
						<div class="availability in-stock box-style">
							<ul>
								<li class="first"><?php esc_html_e('Availability','7upframework');?></li>
								<li class="last">
									<?php
										if($stock == 'instock'){ esc_html_e('In stock','7upframework');};
										if($stock == 'outofstock'){ esc_html_e('Out of stock','7upframework');};
									?>
								</li>
							</ul>
						</div>
						<div class="short-description">
							<div class="std">
								<?php echo apply_filters( 'woocommerce_short_description', $post->post_excerpt ) ?>
							</div>
						</div>
						<div class="wrap-ns-price">
							<div class="price-box">
								<span class="regular-price">
									<span class="price"><?php echo balanceTags($product->get_price_html());?></span>                                    
								</span>
							</div>
							<div class="wrap-new-sale">
								<?php if($uppsell<0):?>
									<div class="new-item"><?php esc_html_e('new','7upframework')?></div>
								<?php endif;?>
							</div>
						</div>
						<div class="product-addto">
							<div class="product-addto-inner">
								<div id="product-options-wrapper" class="product-options">
								
								</div>
								<div class="product-options-bottom">
									<div class="add-to-cart">
										<?php 
											$max_val = apply_filters( 'woocommerce_quantity_input_max', $product->backorders_allowed() ? '' : $product->get_stock_quantity(), $product );
											//var_dump($max_val);
											if($max_val){
												$max_val=$max_val;
											}else{
												$max_val=1;
											}
										?>
										
										<?php do_action( 'woocommerce_' . $product->get_type() . '_add_to_cart'  );?>
									</div>
									<ul class="add-to-links ">
										<li><a href="<?php echo esc_url( str_replace('&', '&amp;',add_query_arg( 'add_to_wishlist', get_the_ID() )) )?>" rel="nofollow" data-product-id="<?php echo get_the_id(); ?>"  class="add_to_wishlist link-wishlist wishlist" ><?php esc_html_e('Wishlist','7upframework');?></a></li>
										<li><span class="separator">|</span> 
										<?php
											sv_compare_url(true,true);
										?>
										</li>
										<li><a href="mailto:<?php echo get_option( 'admin_email' );?>" class="email-friend"><?php esc_html_e('Email','7upframework');?></a></li>
										<li><a class="print" href="javascript:window.print()"><?php esc_html_e('Print','7upframework')?></a></li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php 
		endwhile;
		endif;
		wp_reset_postdata();
	}
}
}
/********************************* END FANCYBOX POPUP CONTENT *********************************/