<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 22/08/15
 * Time: 10:20 AM
 */
if(!class_exists('SV_TestimonialController'))
{
    class SV_TestimonialController{

        static function _init()
        {
            if(function_exists('stp_reg_post_type'))
            {
                add_action('init',array(__CLASS__,'_add_post_type'));
            }
        }

        static function _add_post_type()
        {
            $labels = array(
                'name'               => esc_html__('Testimonial','7upframework'),
                'singular_name'      => esc_html__('Testimonial','7upframework'),
                'menu_name'          => esc_html__('Testimonial','7upframework'),
                'name_admin_bar'     => esc_html__('Testimonial','7upframework'),
                'add_new'            => esc_html__('Add New','7upframework'),
                'add_new_item'       => esc_html__( 'Add New Testimonial','7upframework' ),
                'new_item'           => esc_html__( 'New Testimonial', '7upframework' ),
                'edit_item'          => esc_html__( 'Edit Testimonial', '7upframework' ),
                'view_item'          => esc_html__( 'View Testimonial', '7upframework' ),
                'all_items'          => esc_html__( 'All Testimonial', '7upframework' ),
                'search_items'       => esc_html__( 'Search Testimonial', '7upframework' ),
                'parent_item_colon'  => esc_html__( 'Parent Testimonial:', '7upframework' ),
                'not_found'          => esc_html__( 'No Testimonial found.', '7upframework' ),
                'not_found_in_trash' => esc_html__( 'No Testimonial found in Trash.', '7upframework' )
            );

            $args = array(
                'labels'             => $labels,
                'public'             => true,
                'publicly_queryable' => true,
                'show_ui'            => true,
                'show_in_menu'       => true,
                'query_var'          => true,
                'rewrite'            => array( 'slug' => 'testimonial' ),
                'capability_type'    => 'post',
                'has_archive'        => true,
                'hierarchical'       => false,
                'menu_position'      => null,
                'supports'           => array( 'title', 'editor', 'thumbnail' )
            );

            stp_reg_post_type('testimonial',$args);
            self::_add_meta_box();
        }

        static function _add_meta_box (){
            $my_meta_box = array(
                'id'        => 'portfolio_option',
                'title'     => esc_html__(  'Portfolio Option' , '7upframework' ),
                'desc'      => '',
                'pages'     => array( 'portfolio' ),
                'context'   => 'normal',
                'priority'  => 'high',
                'fields'    => array(                    
                    array(
                        'id'                => 'website',
                        'label'             => esc_html__('website', '7upframework'),
                        'desc'              => esc_html__('Enter website url','7upframework'),
                        'type'              => 'text',
                    )
                )
            );

            if ( function_exists( 'ot_register_meta_box' ) )
                ot_register_meta_box($my_meta_box );
        }
    }

    SV_TestimonialController::_init();

}