<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */

add_action('admin_init', 'sv_custom_meta_boxes');
if(!function_exists('sv_custom_meta_boxes')){
    function sv_custom_meta_boxes(){
        //Format content
        $format_metabox = array(
            'id' => 'block_format_content',
            'title' => esc_html__('Format Settings', '7upframework'),
            'desc' => '',
            'pages' => array('post'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(                
                array(
                    'id'    => 'format_image',
                    'label' => esc_html__('Upload Image', '7upframework'),
                    'desc'  =>  esc_html__('The Image display in single post with image format of post', '7upframework'),
                    'type'  => 'upload',
                ),
                array(
                    'id' => 'format_gallery',
                    'label' => esc_html__('Add Gallery', '7upframework'),
                    'desc'  =>  esc_html__('The Images display as slider in single post with gallery format of post', '7upframework'),
                    'type' => 'Gallery',
                ),
                array(
                    'id' => 'format_media',
                    'label' => esc_html__('link media you want display with video and audio format of post', '7upframework'),
                    'type' => 'text',
                ),
                array(
                    'id' => 'name_style',
                    'label' => esc_html__('Name', '7upframework'),
                    'type' => 'text',
                )
            ),
        );
        $bg_metabox = array(
            'id' => 'block_background',
            'title' => esc_html__('Body Settings', '7upframework'),
            'desc' => '',
            'pages' => array('page'),
            'context' => 'side',
            'priority' => 'low',
            'fields' => array(                
                array(
                    'id'    => 'body_background',
                    'label' => esc_html__('Body Background', '7upframework'),
                    'type'  => 'upload',
                )
            ),
        );
        $product_metabox = array(
            'id' => 'block_product_thumb_hover',
            'title' => esc_html__('Product hover image', '7upframework'),
            'desc' => '',
            'pages' => array('product'),
            'context' => 'side',
            'priority' => 'low',
            'fields' => array(                
                array(
                    'id'    => 'product_thumb_hover',
                    'label' => esc_html__('Product hover image', '7upframework'),
                    'type'  => 'upload',
                ),
                array(
                    'id'    => 'deals_time',
                    'label' => esc_html__('Deals time', '7upframework'),
                    'type'  => 'text',
                    'desc' => esc_html__('Enter deals time format housr:min. 00:00 ~ 23:59.', '7upframework'),
                )
            ),
        );
        // SideBar
    	$sidebar_metabox_default = array(
            'id'        => 'sv_sidebar_option',
            'title'     => 'Advanced Settings',
            'desc'      => '',
            'pages'     => array( 'page','post','product'),
            'context'   => 'side',
            'priority'  => 'low',
            'fields'    => array(
                array(
                    'id'          => 'sv_sidebar_position',
                    'label'       => esc_html__('Sidebar position ','7upframework'),
                    'type'        => 'select',
                    'std' => '',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','7upframework'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('No Sidebar','7upframework'),
                            'value'=>'no'
                        ),
                        array(
                            'label'=>esc_html__('Left sidebar','7upframework'),
                            'value'=>'left'
                        ),
                        array(
                            'label'=>esc_html__('Right sidebar','7upframework'),
                            'value'=>'right'
                        ),
                    ),

                ),
                array(
                    'id'        =>'sv_select_sidebar',
                    'label'     =>esc_html__('Selects sidebar','7upframework'),
                    'type'      =>'sidebar-select',
                    'condition' => 'sv_sidebar_position:not(no),sv_sidebar_position:not()',
                ),
                array(
                    'id'          => 'show_header',
                    'label'       => esc_html__('Show Header','7upframework'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','7upframework'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('Yes','7upframework'),
                            'value'=>'yes'
                        ),
                        array(
                            'label'=>esc_html__('No','7upframework'),
                            'value'=>'no'
                        ),
                    ),

                ),
                array(
                    'id'        =>'header_bg',
                    'label'     =>esc_html__('Header Image','7upframework'),
                    'type'      =>'upload',
                    'condition' => 'show_header:is(yes)',
                ),
                array(
                    'id'          => 'sv_header_page',
                    'label'       => esc_html__('Choose page header','7upframework'),
                    'type'        => 'select',
                    'choices'     => sv_list_header_page()
                ),
                array(
                    'id'          => 'sv_footer_page',
                    'label'       => esc_html__('Choose page footer','7upframework'),
                    'type'        => 'page-select'
                )
            )
        );    
        if (function_exists('ot_register_meta_box')){
            ot_register_meta_box($format_metabox);
            ot_register_meta_box($sidebar_metabox_default);
            ot_register_meta_box($bg_metabox);
            ot_register_meta_box($product_metabox);
        }
    }
}
?>