<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(!defined('ABSPATH')) return;

if(!class_exists('SV_BaseController'))
{
    class SV_BaseController
    {
        static function _init()
        {
            //Default Framwork Hooked

            add_filter( 'wp_title', array(__CLASS__,'_wp_title'), 10, 2 );
            add_action( 'wp', array(__CLASS__,'_setup_author') );
            add_action( 'after_setup_theme', array(__CLASS__,'_after_setup_theme') );
            add_action('widgets_init',array(__CLASS__,'_add_sidebars'));

            add_action('wp_enqueue_scripts',array(__CLASS__,'_add_scripts'));

            //Custom hooked
            add_filter('sv_get_sidebar',array(__CLASS__,'_blog_filter_sidebar'));
            
            add_action('wp_head',array(__CLASS__,'_show_custom_css'),100);

            add_action('admin_enqueue_scripts',array(__CLASS__,'_add_admin_scripts'));

            add_filter( 'style_loader_src',array(__CLASS__,'_remove_enqueue_ver'), 10, 2 );
            add_filter( 'script_loader_src',array(__CLASS__,'_remove_enqueue_ver'), 10, 2 );

            add_filter('mce_buttons', array(__CLASS__,'_register_buttons'));
            add_filter('tiny_mce_before_init', array(__CLASS__,'_add_tinymce_settings'));

        }

        static function _add_scripts()
        {
            $css_url = get_template_directory_uri() . '/assets/css/';
            $js_url = get_template_directory_uri() . '/assets/js/';
            /*
             * Javascript
             * */
            if ( is_singular() && comments_open()){
            wp_enqueue_script( 'comment-reply' );
            }
            //Register JS
            wp_register_script('s7t-bootstrap',$js_url.'lib/bootstrap.min.js',array('jquery'),null,true);
            wp_register_script('s7t-jcarousellite',$js_url.'lib/jquery.jcarousellite.js',array('jquery'),null,true);
            wp_register_script('s7t-owl-carousel-min',$js_url.'lib/owl.carousel.min.js',array('jquery'),null,true);
            wp_register_script('s7t-jquery-noconflict',$js_url.'lib/jquery-noconflict.js',array('jquery'),null,true);
            wp_register_script('s7t-jquery-countdown',$js_url.'lib/jquery.countdown.js',array('jquery'),null,true);
            wp_register_script('s7t-mCustomScrollbar',$js_url.'lib/jquery.mCustomScrollbar.concat.min.js',array('jquery'),null,true);
            wp_register_script('s7t-TimeCircles',$js_url.'lib/TimeCircles.js',array('jquery'),null,true);
            wp_register_script('s7t-custom-script',$js_url.'script.js',array('jquery'),null,true);
            wp_register_script('s7t-custom-script2',$js_url.'script2.js',array('jquery'),null,true);
            wp_register_script('s7t-jquery-fancybox',$js_url.'lib/jquery.fancybox.js',array('jquery'),null,true);
            wp_register_script('s7t-jquery-elevatezoom',$js_url.'lib/jquery.elevatezoom.js',array('jquery'),null,true);
            wp_register_script('s7t-mCustomScrollbar',$js_url.'lib/jquery.mCustomScrollbar.js',array('jquery'),null,true);
            wp_register_script('s7t-modernizr',$js_url.'lib/modernizr.custom.js',array('jquery'),null,true);
            wp_register_script('s7t-hoverdir',$js_url.'lib/jquery.hoverdir.js',array('jquery'),null,true);
            wp_register_script('s7t-detail',$js_url.'lib/detail.js',array('jquery'),null,true);
            wp_register_script('s7t-theme',$js_url.'lib/theme.js',array('jquery'),null,true);
            wp_register_script( 'google-map', "//maps.google.com/maps/api/js?key=AIzaSyBX2IiEBg-0lQKQQ6wk6sWRGQnWI7iogf0", array('jquery'), null, true );
            
            //ENQUEUE JS
            wp_enqueue_script('s7t-bootstrap');
            wp_enqueue_script('s7t-jcarousellite');
            wp_enqueue_script('s7t-owl-carousel-min');
            wp_enqueue_script('s7t-jquery-noconflict');
            wp_enqueue_script('s7t-jquery-countdown');
            wp_enqueue_script('s7t-mCustomScrollbar');
            wp_enqueue_script('s7t-modernizr');
            wp_enqueue_script('s7t-hoverdir');
            wp_enqueue_script('s7t-TimeCircles');
            wp_enqueue_script('s7t-jquery-fancybox');
            wp_enqueue_script('s7t-jquery-elevatezoom');
            wp_enqueue_script('s7t-custom-script2');
            wp_enqueue_script( 's7t-ajax', $js_url.'ajax.js', array( 'jquery' ),null,true);
            wp_localize_script( 's7t-ajax', 'ajax_process', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
            
            // CSS
            wp_enqueue_style('s7t-Sevillana','http://fonts.googleapis.com/css?family=Sevillana');
            wp_enqueue_style('s7t-Lato','https://fonts.googleapis.com/css?family=Lato:400,100,700');
            wp_enqueue_style('s7t-Poiret','https://fonts.googleapis.com/css?family=Poiret+One');
            // wp_enqueue_style('s7t-open-sans','http://fonts.googleapis.com/css?family=Open+Sans:300,300italic,400,400italic,600,600italic,700,700italic,800,800italic' );
            wp_enqueue_style('s7t-bootstrap',$css_url.'lib/bootstrap.min.css');
            wp_enqueue_style('s7t-font-awesome',$css_url.'lib/font-awesome.min.css');
            wp_enqueue_style('s7t-countdown',$css_url.'lib/countdown.css');
            wp_enqueue_style('s7t-owl.carousel',$css_url.'lib/owl.carousel.css');
            wp_enqueue_style('s7t-mCustomScrollbar',$css_url.'lib/jquery.mCustomScrollbar.css');
            wp_enqueue_style('s7t-owl.theme',$css_url.'lib/owl.theme.css');
            wp_enqueue_style('s7t-jquery-fancybox',$css_url.'lib/jquery.fancybox.css');
            wp_enqueue_style('s7t-owl.transitions',$css_url.'lib/owl.transitions.css');
            wp_enqueue_style('s7t-theme-unitest',$css_url.'theme-unitest.css');
            wp_enqueue_style('s7t-theme-default',$css_url.'lib/theme-default.css');
            wp_enqueue_style('s7t-theme-style',$css_url.'style.css');
            wp_enqueue_style('s7t-home11-style',$css_url.'style-home11.css');
            wp_enqueue_style('s7t-home12-style',$css_url.'style-home12.css');
            wp_enqueue_style('s7t-home13-style',$css_url.'style-home13.css');
            wp_enqueue_style('s7t-vt-responsive',$css_url.'lib/vt-responsive.css');
            if(is_rtl()) wp_enqueue_style('s7t-rtl',$css_url.'lib/rtl.css');
            wp_enqueue_style('s7t-default',get_stylesheet_uri());

        }


        static function _show_custom_css()
        {
            $style=SV_Template::load_view('custom_css');?>

            <style id="sv_cutom_css">
                <?php print ($style);?>
            </style>

            <?php echo "\n";
            ?>
            <script type="text/javascript">
              (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
              (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
              m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
              })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

              ga('create', 'UA-69246918-1', 'auto');
              ga('send', 'pageview');

            </script>
            <?php
        }

        static function _blog_filter_sidebar($sidebar)
        {
            if((!is_front_page() && is_home()) || (is_front_page() && is_home())){
                $pos=sv_get_option('sv_sidebar_position_blog');
                $sidebar_id=sv_get_option('sv_sidebar_blog');
            }
            else{
                if(is_single()){
                    $pos = sv_get_option('sv_sidebar_position_post');
                    $sidebar_id = sv_get_option('sv_sidebar_post');
                }
                else{
                    $pos = sv_get_option('sv_sidebar_position_page');
                    $sidebar_id = sv_get_option('sv_sidebar_page');
                }        
            }
            if(class_exists( 'WooCommerce' )){
                if(sv_is_woocommerce_page()){
                    if(!is_single()){
                        $pos = sv_get_option('sv_sidebar_position_woo');
                        $sidebar_id = sv_get_option('sv_sidebar_woo');
                    }
                    else{
                        $pos = sv_get_option('sv_sidebar_position_woo_single');
                        $sidebar_id = sv_get_option('sv_sidebar_woo_single');
                    } 
                }
            }
            if(is_archive() && !sv_is_woocommerce_page()){
                $pos = sv_get_option('sv_sidebar_position_page_archive');
                $sidebar_id = sv_get_option('sv_sidebar_page_archive');
            }
            else{
                if(!is_home()){
                    $id = get_the_ID();
                    if(is_404()) $id = sv_get_option('sv_404_page');
                    if(is_front_page()) $id = (int)get_option('page_on_front');
                    if (class_exists('woocommerce')) {
                        if(is_shop()) $id = (int)get_option('woocommerce_shop_page_id');
                        if(is_cart()) $id = (int)get_option('woocommerce_cart_page_id');
                        if(is_checkout()) $id = (int)get_option('woocommerce_checkout_page_id');
                        if(is_account_page()) $id = (int)get_option('woocommerce_myaccount_page_id');
                    }
                    $sidebar_pos = get_post_meta($id,'sv_sidebar_position',true);
                    $id_side_post = get_post_meta($id,'sv_select_sidebar',true);
                    if(!empty($sidebar_pos)){
                        $pos = $sidebar_pos;
                        if(!empty($id_side_post)) $sidebar_id = $id_side_post;
                    }
                }
            }
            if(is_search()) {
                $sidebar_id = 'blog-sidebar';
                $pos = 'right';
            }
            if($sidebar_id){
                $sidebar['id']=$sidebar_id;
            }

            if($pos){
                $sidebar['position']=$pos;
            }

            return $sidebar;
        }
        
        
        // -----------------------------------------------------
        // Default Hooked, Do not edit

        /**
         * Hook setup theme
         *
         *
         * */

        static function _after_setup_theme()
        {
            /*
             * Make theme available for translation.
             * Translations can be filed in the /languages/ directory.
             * If you're building a theme based on stframework, use a find and replace
             * to change LANGUAGE to the name of your theme in all the template files
             */

            // This theme uses wp_nav_menu() in one location.
            global $config;
            $menus= $config['nav_menu'];
            if(is_array($menus) and !empty($menus) )
            {
                register_nav_menus($menus);
            }


            add_theme_support( "title-tag" );
            add_theme_support('automatic-feed-links');
            add_theme_support('post-thumbnails');
            add_theme_support('html5',array(
                'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
            ));
            add_theme_support('post-formats',array(
                'image', 'video', 'gallery','audio','quote'
            ));
            add_theme_support('custom-header');
            add_theme_support('custom-background');
            add_theme_support('woocommerce');
        }

        /**
         * Add default sidebar to website
         *
         *
         * */
        static function _add_sidebars()
        {
            // From config file
            global $config;
            $sidebars = $config['sidebars'];
            if(is_array($sidebars) and !empty($sidebars) )
            {
                foreach($sidebars as $value){
                    register_sidebar($value);
                }
            }
            $add_sidebars = sv_get_option('sv_add_sidebar');
            if(is_array($add_sidebars) and !empty($add_sidebars) )
            {
                foreach($add_sidebars as $sidebar){
                    if(!empty($sidebar['title'])){
                        $id = strtolower(str_replace(' ', '-', $sidebar['title']));
                        $custom_add_sidebar = array(
                            'name' => $sidebar['title'],
                            'id' => $id,
                            'description' => esc_html__( 'SideBar created by add sidebar in theme options.', '7upframework'),
                            'before_title' => '<'.$sidebar['widget_title_heading'].' class="widget-title">',
                            'after_title' => '</'.$sidebar['widget_title_heading'].'>',
                            'before_widget' => '<div id="%1$s" class="sidebar-widget widget %2$s">',
                            'after_widget'  => '</div>',
                        );
                        register_sidebar($custom_add_sidebar);
                        unset($custom_add_sidebar);
                    }
                }
            }

        }


        /**
         * Set up author data
         *
         * */
        static function _setup_author() {
            global $wp_query;

            if ( $wp_query->is_author() && isset( $wp_query->post ) ) {
                $GLOBALS['authordata'] = get_userdata( $wp_query->post->post_author );
            }
        }


        /**
         * Hook to wp_title
         *
         * */
        static function _wp_title($title,$sep)
        {
            return $title;
        }

        static function _add_admin_scripts()
        {
            $admin_url = get_template_directory_uri().'/assets/admin/';
            wp_enqueue_script('jquery-ui-datepicker');
            wp_enqueue_script('sv-customjs',$admin_url.'/js/custom.js',array('jquery'),null,true);
            wp_enqueue_script('sv-iconpicker',$admin_url.'/js/fontawesome-iconpicker.js',array('jquery'),null,true);
            wp_enqueue_style( 'sv-fontawesome',$admin_url.'css/font-awesome.css');
            wp_enqueue_style( 'sv-custom-admin',$admin_url.'css/custom.css');
            wp_enqueue_style( 'sv-iconpicker',$admin_url.'css/fontawesome-iconpicker.min.css');
        }

        static function _remove_enqueue_ver($src)    {
            if (strpos($src, '?ver='))
                $src = remove_query_arg('ver', $src);
            return $src;
        }

        static function _register_buttons($buttons) {
            $buttons[] = 'fontselect';
            $buttons[] = 'fontsizeselect';
            $buttons[] = 'backcolor';
            return $buttons;
        }

        static function _add_tinymce_settings( $settings ) {
            $google_fonts = sv_get_option('google_fonts');
            $font_formats = "Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats";
            $font_string = '';
            if(is_array($google_fonts)){
                foreach ($google_fonts as $font) {
                    if($font['family']) $font_string .= ucwords($font['family']).'='.$font['family'].';';
                }
            }
            $settings['font_formats'] =  $font_string . $font_formats;
            // $settings['theme_advanced_fonts'] = $font_string;
            $settings['fontsize_formats'] = "9px 10px 12px 13px 14px 16px 18px 21px 24px 28px 30px 32px 36px 40px 60px 70px 80px 85px";
            return $settings;
        }

    }

    SV_BaseController::_init();
}
