<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 13/08/15
 * Time: 10:20 AM
 */
global $config;
$config['theme-option'] = array(
	'sections' => array(
		array(
            'id' => 'option_general',
            'title' => '<i class="fa fa-cog"></i>'.esc_html__(' General Settings', '7upframework')
        ),
        array(
            'id' => 'option_logo',
            'title' => '<i class="fa fa-image"></i>'.esc_html__(' Logo Settings', '7upframework')
        ),
        array(
            'id' => 'option_menu',
            'title' => '<i class="fa fa-align-justify"></i>'.esc_html__(' Menu Settings', '7upframework')
        ),
        array(
            'id' => 'option_layout',
            'title' => '<i class="fa fa-columns"></i>'.esc_html__(' Layout Settings', '7upframework')
        ),
        array(
            'id' => 'option_typography',
            'title' => '<i class="fa fa-font"></i>'.esc_html__(' Typography', '7upframework')
        )
	),
	'settings' => array(
		 /*----------------Begin General --------------------*/
        array(
	        'id'          => 'sv_header_page',
	        'label'       => esc_html__( 'Header Page', '7upframework' ),
	        'desc'        => esc_html__( 'Include page to Header', '7upframework' ),
	        'type'        => 'select',
	        'section'     => 'option_general',
	        'choices'     => sv_list_header_page()
        ),
        array(
	        'id'          => 'sv_footer_page',
	        'label'       => esc_html__( 'Footer Page', '7upframework' ),
	        'desc'        => esc_html__( 'Include page to Footer', '7upframework' ),
	        'type'        => 'page-select',
	        'section'     => 'option_general'
        ),
        array(
	        'id'          => 'sv_404_page',
	        'label'       => esc_html__( '404 Page', 'theme-text-domain' ),
	        'desc'        => esc_html__( 'Include page to 404 page', '7upframework' ),
	        'type'        => 'page-select',
	        'section'     => 'option_general'
        ),
        // array(
        //     'id' => 'sv_show_breadrumb',
        //     'label' => esc_html__('Show BreadCrumb', '7upframework'),
        //     'desc' => esc_html__('This allow you to show or hide BreadCrumb', '7upframework'),
        //     'type' => 'on-off',
        //     'section' => 'option_general',
        //     'std' => 'on'
        // ),
        // array(
        //     'id'          => 'sv_bg_breadcrumb',
        //     'label'       => esc_html__('Background Breadcrumb','7upframework'),
        //     'type'        => 'background',
        //     'section'     => 'option_general',
        //     'condition'   => 'sv_show_breadrumb:is(on)',
        // ),
        array(
	        'id'          => 'body_background',
	        'label'       => esc_html__('Body Background','7upframework'),
	        'type'        => 'upload',
	        'section'     => 'option_general',
        ),
        array(
            'id'          => 'main_color',
            'label'       => esc_html__('Main color','7upframework'),
            'type'        => 'colorpicker',
            'section'     => 'option_general',
        ),
        array(
            'id' => 'sv_show_scroll_top',
            'label' => esc_html__('Show Scroll top Button', '7upframework'),
            'type' => 'on-off',
            'section' => 'option_general',
            'std' => 'on'
        ),
        array(
            'id'          => 'custom_css',
            'label'       => esc_html__('Custom CSS','7upframework'),
            'type'        => 'textarea-simple',
            'section'     => 'option_general',
        ),
        /*----------------End General ----------------------*/

        /*----------------Begin Logo --------------------*/
        array(
            'id' => 'logo',
            'label' => esc_html__('Logo', '7upframework'),
            'desc' => esc_html__('This allow you to change logo', '7upframework'),
            'type' => 'upload',
            'section' => 'option_logo',
        ),        
        array(
            'id' => 'favicon',
            'label' => esc_html__('Favicon', '7upframework'),
            'desc' => esc_html__('This allow you to change favicon of your website', '7upframework'),
            'type' => 'upload',
            'section' => 'option_logo'
        ),
        /*----------------End Logo ----------------------*/

        /*----------------Begin Menu --------------------*/
        // array(
        //     'id'          => 'sv_menu_fixed',
        //     'label'       => esc_html__('Menu Fixed','7upframework'),
        //     'desc'        => 'Menu change to fixed when scroll',
        //     'type'        => 'on-off',
        //     'section'     => 'option_menu',
        // ),
        array(
            'id'          => 'sv_menu_color',
            'label'       => esc_html__('Menu style','7upframework'),
            'type'        => 'typography',
            'section'     => 'option_menu',
        ),
        array(
            'id'          => 'sv_menu_color_hover',
            'label'       => esc_html__('Hover color','7upframework'),
            'desc'        => esc_html__('Choose color','7upframework'),
            'type'        => 'colorpicker',
            'section'     => 'option_menu',
        ),
        array(
            'id'          => 'sv_menu_color_active',
            'label'       => esc_html__('Active color','7upframework'),
            'desc'        => esc_html__('Choose color','7upframework'),
            'type'        => 'colorpicker',
            'section'     => 'option_menu',
        ),
        /*----------------End Menu ----------------------*/
        

        /*----------------Begin Layout --------------------*/
        array(
            'id'          => 'sv_sidebar_position_blog',
            'label'       => esc_html__('Sidebar Blog','7upframework'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','7upframework'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','7upframework'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','7upframework'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_blog',
            'label'       => esc_html__('Sidebar select display in blog','7upframework'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_blog:not(no)',
        ),
        /****end blog****/
        array(
            'id'          => 'sv_sidebar_position_page',
            'label'       => esc_html__('Sidebar Page','7upframework'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','7upframework'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','7upframework'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','7upframework'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_page',
            'label'       => esc_html__('Sidebar select display in page','7upframework'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_page:not(no)',
        ),
        /****end page****/
        array(
            'id'          => 'sv_sidebar_position_page_archive',
            'label'       => esc_html__('Sidebar Position on Page Archives:','7upframework'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'desc'=>esc_html__('Left, or Right, or Center','7upframework'),
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','7upframework'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','7upframework'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','7upframework'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_page_archive',
            'label'       => esc_html__('Sidebar select display in page Archives','7upframework'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_page_archive:not(no)',
        ),
        // END
        array(
            'id'          => 'sv_sidebar_position_post',
            'label'       => esc_html__('Sidebar Single Post','7upframework'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','7upframework'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','7upframework'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','7upframework'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_post',
            'label'       => esc_html__('Sidebar select display in single post','7upframework'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_post:not(no)',
        ),
        array(
            'id'          => 'sv_add_sidebar',
            'label'       => esc_html__('Add SideBar','7upframework'),
            'type'        => 'list-item',
            'section'     => 'option_layout',
            'settings'    => array( 
                array(
                    'id'          => 'widget_title_heading',
                    'label'       => esc_html__('Choose heading title widget','7upframework'),
                    'type'        => 'select',
                    'std'        => 'h3',
                    'choices'     => array(
                        array(
                            'value'=>'h1',
                            'label'=>esc_html__('H1','7upframework'),
                        ),
                        array(
                            'value'=>'h2',
                            'label'=>esc_html__('H2','7upframework'),
                        ),
                        array(
                            'value'=>'h3',
                            'label'=>esc_html__('H3','7upframework'),
                        ),
                        array(
                            'value'=>'h4',
                            'label'=>esc_html__('H4','7upframework'),
                        ),
                        array(
                            'value'=>'h5',
                            'label'=>esc_html__('H5','7upframework'),
                        ),
                        array(
                            'value'=>'h6',
                            'label'=>esc_html__('H6','7upframework'),
                        ),
                    )
                ),
            ),
        ),
        /*----------------End Layout ----------------------*/

        /*----------------Begin Blog ----------------------*/       
        

        /*----------------End BLOG----------------------*/

        /*----------------Begin Typography ----------------------*/
        array(
            'id'          => 'sv_custom_typography',
            'label'       => esc_html__('Add Settings','7upframework'),
            'type'        => 'list-item',
            'section'     => 'option_typography',
            'settings'    => array(
                array(
                    'id'          => 'typo_area',
                    'label'       => esc_html__('Choose Area to style','7upframework'),
                    'type'        => 'select',
                    'std'        => 'main',
                    'choices'     => array(
                        array(
                            'value'=>'body',
                            'label'=>esc_html__('Body','7upframework'),
                        ),
                        array(
                            'value'=>'header',
                            'label'=>esc_html__('Header','7upframework'),
                        ),
                        array(
                            'value'=>'main',
                            'label'=>esc_html__('Main Content','7upframework'),
                        ),
                        array(
                            'value'=>'widget',
                            'label'=>esc_html__('Widget','7upframework'),
                        ),
                        array(
                            'value'=>'footer',
                            'label'=>esc_html__('Footer','7upframework'),
                        ),
                    )
                ),
                array(
                    'id'          => 'typo_heading',
                    'label'       => esc_html__('Choose heading Area','7upframework'),
                    'type'        => 'select',
                    'std'        => 'h3',
                    'choices'     => array(
                        array(
                            'value'=>'',
                            'label'=>esc_html__('All','7upframework'),
                        ),
                        array(
                            'value'=>'h1',
                            'label'=>esc_html__('H1','7upframework'),
                        ),
                        array(
                            'value'=>'h2',
                            'label'=>esc_html__('H2','7upframework'),
                        ),
                        array(
                            'value'=>'h3',
                            'label'=>esc_html__('H3','7upframework'),
                        ),
                        array(
                            'value'=>'h4',
                            'label'=>esc_html__('H4','7upframework'),
                        ),
                        array(
                            'value'=>'h5',
                            'label'=>esc_html__('H5','7upframework'),
                        ),
                        array(
                            'value'=>'h6',
                            'label'=>esc_html__('H6','7upframework'),
                        ),
                        array(
                            'value'=>'a',
                            'label'=>esc_html__('a','7upframework'),
                        ),
                        array(
                            'value'=>'p',
                            'label'=>esc_html__('p','7upframework'),
                        ),
                    )
                ),
                array(
                    'id'          => 'typography_style',
                    'label'       => esc_html__('Add Style','7upframework'),
                    'type'        => 'typography',
                    'section'     => 'option_typography',
                ),
            ),
        ),        
        array(
            'id'          => 'google_fonts',
            'label'       => esc_html__('Add Google Fonts','7upframework'),
            'type'        => 'google-fonts',
            'section'     => 'option_typography',
        ),
        /*----------------End Typography ----------------------*/
	)
);
if(class_exists( 'WooCommerce' )){
    array_push($config['theme-option']['sections'], array(
                                                'id' => 'option_woo',
                                                'title' => '<i class="fa fa-shopping-cart"></i>'.esc_html__(' Shop Settings', '7upframework')
                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_position_woo',
                                                'label'       => esc_html__('Sidebar Position WooCommerce page','7upframework'),
                                                'type'        => 'select',
                                                'section'     => 'option_woo',
                                                'desc'=>esc_html__('Left, or Right, or Center','7upframework'),
                                                'choices'     => array(
                                                    array(
                                                        'value'=>'no',
                                                        'label'=>esc_html__('No Sidebar','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'left',
                                                        'label'=>esc_html__('Left','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'right',
                                                        'label'=>esc_html__('Right','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'both',
                                                        'label'=>esc_html__('Both are Left and Right','7upframework'),
                                                    )
                                                )
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_woo',
                                                'label'       => esc_html__('Sidebar on WooCommerce page','7upframework'),
                                                'type'        => 'sidebar-select',
                                                'section'     => 'option_woo',
                                                'condition'   => 'sv_sidebar_position_woo:not(no)',
                                                'desc'        => esc_html__('Choose one style of sidebar for WooCommerce page','7upframework')
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_woo_right',
                                                'label'       => esc_html__('Sidebar Right on Shop page','7upframework'),
                                                'type'        => 'sidebar-select',
                                                'section'     => 'option_woo',
                                                'condition'   => 'sv_sidebar_position_woo:is(both)',
                                                'desc'        => esc_html__('Choose one style of right sidebar for shop page','7upframework')
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_position_woo_single',
                                                'label'       => esc_html__('Sidebar Position Single Product','7upframework'),
                                                'type'        => 'select',
                                                'section'     => 'option_woo',
                                                'desc'        =>esc_html__('Left, or Right, or No Sidebar','7upframework'),
                                                'choices'     => array(
                                                    array(
                                                        'value'=>'no',
                                                        'label'=>esc_html__('No Sidebar','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'left',
                                                        'label'=>esc_html__('Left','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'right',
                                                        'label'=>esc_html__('Right','7upframework'),
                                                    )
                                                )
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_woo_single',
                                                'label'       => esc_html__('Sidebar on WooCommerce page','7upframework'),
                                                'type'        => 'sidebar-select',
                                                'section'     => 'option_woo',
                                                'condition'   => 'sv_sidebar_position_woo_single:not(no)',
                                                'desc'        => esc_html__('Choose one style of sidebar for single product','7upframework')
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'set_shop_col',
                                                'label'       => esc_html__('Column List Product','7upframework'),
                                                'type'        => 'select',
                                                'section'     => 'option_woo',
                                                'choices'     => array(
                                                    array(
                                                        'value'=>'6',
                                                        'label'=>esc_html__('2 Column','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'4',
                                                        'label'=>esc_html__('3 Column','7upframework'),
                                                    ),
                                                    array(
                                                        'value'=>'3',
                                                        'label'=>esc_html__('4 Column','7upframework'),
                                                    )
                                                )
                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_set_time_woo',
                                                'label'       => esc_html__('Product new in(days)','7upframework'),
                                                'type'        => 'text',
                                                'section'     => 'option_woo',
                                                'desc'        => esc_html__('Enter number to set time for product is new. Unit day. Default is 30.','7upframework')
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'show_header',
                                                'label'       => esc_html__('Show header shop','7upframework'),
                                                'type'        => 'on-off',
                                                'section'     => 'option_woo',
                                                'std'         => 'on'
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'header_bg',
                                                'label'       => esc_html__('Header Image','7upframework'),
                                                'type'        => 'upload',
                                                'section'     => 'option_woo',
                                                'condition'   => 'show_header:is(on)',
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'header_url',
                                                'label'       => esc_html__('Header Link','7upframework'),
                                                'type'        => 'Text',
                                                'section'     => 'option_woo',
                                                'condition'   => 'show_header:is(on)',
                                            ));

    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'header_title',
                                                'label'       => esc_html__('Header title','7upframework'),
                                                'type'        => 'Text',
                                                'section'     => 'option_woo',
                                                'condition'   => 'show_header:is(on)',
                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'single_advantages',
                                                'label'       => esc_html__('Advantages Content','7upframework'),
                                                'type'        => 'Textarea',
                                                'section'     => 'option_woo',
                                            ));
}