<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Twenty_Fifteen
 * @since Twenty Fifteen 1.0
 */

get_header(); 
$sidebar=sv_get_sidebar();
$sidebar_pos=$sidebar['position'];
$main_class = 'col-md-12';
if($sidebar_pos != 'no') $main_class = 'col-lg-9 col-md-8 col-sm-8 col-xs-12';
?>
<div id="main-content" class="sv-default">
    <div class="container">
        <div class="row">
	        <?php if(!wp_is_mobile()) echo '<div class="row">';?>
	        <?php if($sidebar_pos=='left'){ get_sidebar(); }?>
	        	<?php 
	                $page_id = sv_get_option('st_404_page');
	                if(!empty($page_id)) echo SV_Template::get_vc_pagecontent($page_id);
	                else{ ?>
	                	<div class="<?php echo esc_attr($main_class); ?>">
							<section class="error-404 not-found">
								<header class="page-header">
									<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', '7upframework' ); ?></h1>
								</header>

								<div class="page-content">
									<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', '7upframework' ); ?></p>

									<?php get_search_form(); ?>
								</div>
							</section>
						</div>
				<?php }?>
			<?php if($sidebar_pos=='right'){ get_sidebar(); }?>
			<?php if(!wp_is_mobile()) echo '</div>';?>
		</div>
	</div>
</div>
<?php get_footer(); ?>
