<?php
/*
settings function here
*/
if ( ! function_exists('cmb_settings') ) {
	function cmb_settings() {
		wp_enqueue_media();
		$alert = 'none';
		$form_action = 'admin.php?page=cmb_settings&post=cmb_settings';
		if (get_option('cmb_setting_options') == false) {
			$save_cmb_settings = array(
				'cmb_act_popup'						=> '1',
				'cmb_popup_top_text'				=> 'Request a callback',
				'cmb_popup_top_html'				=> 'Please fill out the form below and we will call you back.',
				'cmb_popup_name_text'				=> 'Name',
				'cmb_popup_email_text'				=> 'Email',
				'cmb_popup_phone_text'				=> 'Phone',
				'cmb_popup_message_text'			=> 'Message',
				'cmb_popup_from_text'				=> 'From',
				'cmb_popup_to_text'					=> 'To',
				'cmb_popup_required_text'			=> 'required!',
				'cmb_popup_button_text'				=> 'Call me',
				'cmb_popup_call_text'				=> 'QUESTIONS? SCHEDULE A CALL',
				'cmb_popup_success_text'			=> 'Sent call request successfully.',
				'cmb_themes'						=> 'C',
				'cmb_fields'						=> array(0=>'name',1=>'phone',2=>'email',3=>'message'),
				'cmb_r_fields'						=> array(0=>'name',1=>'phone',2=>'email',3=>'message'),
				'cmb_admin_notification_email'		=> get_option('admin_email'),
				'cmb_act_not_email'					=> '1',
				'cmb_btn_position'					=> 'bottomleft',
				'cmb_button_image'					=> plugins_url().'/call-me-back/icon/girl.gif'
			);
			update_option('cmb_setting_options', $save_cmb_settings);
		}
		if(isset($_GET['post']) && $_GET['post']=='cmb_settings' && $_POST['submit']=='Save All Settings') {
			$save_cmb_settings = array(
				'cmb_act_popup'					=> $_POST['cmb_act_popup'],
				'cmb_popup_top_text'			=> $_POST['cmb_popup_top_text'],
				'cmb_popup_top_html'			=> $_POST['cmb_popup_top_html'],
				'cmb_popup_name_text'			=> $_POST['cmb_popup_name_text'],
				'cmb_popup_email_text'			=> $_POST['cmb_popup_email_text'],
				'cmb_popup_phone_text'			=> $_POST['cmb_popup_phone_text'],
				'cmb_popup_message_text'		=> $_POST['cmb_popup_message_text'],
				'cmb_popup_from_text'			=> $_POST['cmb_popup_from_text'],
				'cmb_popup_to_text'				=> $_POST['cmb_popup_to_text'],
				'cmb_popup_required_text'		=> $_POST['cmb_popup_required_text'],
				'cmb_popup_button_text'			=> $_POST['cmb_popup_button_text'],
				'cmb_popup_call_text'			=> $_POST['cmb_popup_call_text'],
				'cmb_popup_success_text'		=> $_POST['cmb_popup_success_text'],
				'cmb_themes'					=> $_POST['cmb_themes'],
				'cmb_fields'					=> $_POST['cmb_fields'],
				'cmb_r_fields'					=> $_POST['cmb_r_fields'],
				'cmb_admin_notification_email'	=> $_POST['cmb_admin_notification_email'],
				'cmb_act_not_email'				=> $_POST['cmb_act_not_email'],
				'cmb_btn_position'				=> $_POST['cmb_btn_position'],
				'cmb_button_image'				=> $_POST['cmb-btn-image']
			);
			$alert = 'block';
			update_option('cmb_setting_options', $save_cmb_settings);
		}
		$get_options_val = get_option('cmb_setting_options');
		displayCMBSettingHtml($form_action,$alert,$get_options_val);
	}
	function cmb_data_exist($array = array(), $data) {
		if(!empty($array)) {
			foreach($array as $arr) {
				if($arr==$data){
					return true;
					break;
				}
			}
		}
		return false;
	}
?>
<?php function displayCMBSettingHtml($form_action,$alert,$settings){ ?>

<div>
  <h2>Call Me Back Settings</h2>
</div>
<div class="woocommerce-message top_success_message" style="display:<?php echo $alert; ?>;"><b>Settings Save Successfully</b></div>
<form method="post" action="<?php echo $form_action; ?>" name="settings" enctype="multipart/form-data">
  <div id="formatdiv" class="postbox ">
    <h2 class="hndle ui-sortable-handle" style="padding:10px;"><span>Popup Settings</span></h2>
    <div class="inside">
      <div id="post-formats-select">
        <table cellpadding="3" id="call_request_settings">
          <tr>
            <td>Activate Popup ?</td>
            <td valign="top"><input type="radio" value="1" name="cmb_act_popup" <?php if(isset($settings['cmb_act_popup']) && $settings['cmb_act_popup'] == '1') {echo "checked=checked";} ?> />
              Yes&nbsp;&nbsp;
              <input type="radio" value="0" <?php if(!isset($settings['cmb_act_popup']) || $settings['cmb_act_popup'] == '0') {echo "checked=checked";} ?> name="cmb_act_popup" />
              No</td>
          </tr>
          <tr>
            <td>Popup Themes:</td>
            <td><select name="cmb_themes">
                <option <?php if($settings['cmb_themes'] == 'A'){echo 'selected';} ?> value="A">Theme A</option>
                <option <?php if($settings['cmb_themes'] == 'B'){echo 'selected';} ?> value="B">Theme B</option>
                <option <?php if($settings['cmb_themes'] == 'C'){echo 'selected';} ?> value="C">Theme C</option>
                <option <?php if($settings['cmb_themes'] == 'D'){echo 'selected';} ?> value="D">Theme D</option>
                <option <?php if($settings['cmb_themes'] == 'E'){echo 'selected';} ?> value="E">Theme E</option>
                <option <?php if($settings['cmb_themes'] == 'F'){echo 'selected';} ?> value="F">Theme F</option>
              </select>
            </td>
          </tr>
          <tr>
            <td>Popup Header Text:</td>
            <td><input type="text" name="cmb_popup_top_text" value="<?php echo $settings['cmb_popup_top_text']; ?>" /></td>
          </tr>
          <tr>
            <td>Popup Top Text:</td>
            <td><input type="text" name="cmb_popup_top_html" value="<?php echo $settings['cmb_popup_top_html']; ?>" /></td>
          </tr>
          <tr>
            <td>Call Me Bottom Left Button Text:</td>
            <td><input type="text" name="cmb_popup_call_text" value="<?php echo $settings['cmb_popup_call_text']; ?>" /></td>
          </tr>
          <tr>
            <td valign="top">Enable Fields:</td>
            <td><input type="checkbox" <?php if(cmb_data_exist($settings['cmb_fields'],'name')){echo 'checked';}?> name="cmb_fields[]" value="name" />
              Name Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_fields'],'phone')){echo 'checked';}?> name="cmb_fields[]" value="phone" />
              Phone Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_fields'],'email')){echo 'checked';}?> name="cmb_fields[]" value="email" />
              Email Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_fields'],'message')){echo 'checked';}?> name="cmb_fields[]" value="message" />
              Message Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_fields'],'from_to')){echo 'checked';}?> name="cmb_fields[]" value="from_to" />
              From and To time ? </td>
          </tr>
          <tr>
            <td valign="top">Required Fields:</td>
            <td><input type="checkbox" <?php if(cmb_data_exist($settings['cmb_r_fields'],'name')){echo 'checked';}?> name="cmb_r_fields[]" value="name" />
              Name Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_r_fields'],'phone')){echo 'checked';}?> name="cmb_r_fields[]" value="phone" />
              Phone Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_r_fields'],'email')){echo 'checked';}?> name="cmb_r_fields[]" value="email" />
              Email Field ?<br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_r_fields'],'message')){echo 'checked';}?> name="cmb_r_fields[]" value="message" />
              Message Field ? <br/>
              <input type="checkbox" <?php if(cmb_data_exist($settings['cmb_r_fields'],'from_to')){echo 'checked';}?> name="cmb_r_fields[]" value="from_to" />
              From and To time ? </td>
          </tr>
		  <tr>
            <td>Call Me Back Button Possition:</td>
            <td><select name="cmb_btn_position">
                <option <?php if($settings['cmb_btn_position'] == 'bottomleft'){echo 'selected';} ?> value="bottomleft">Left</option>
                <option <?php if($settings['cmb_btn_position'] == 'bottomright'){echo 'selected';} ?> value="bottomright">Right</option>
              </select>
            </td>
          </tr>
        </table>
      </div>
    </div>
    <div>
      <h2 class="hndle ui-sortable-handle" style="padding:10px;"><span>Common Settings</span></h2>
      <div class="inside">
        <div id="post-formats-select">
          <table cellpadding="3">
            <tr>
              <td>Name Text:</td>
              <td><input type="text" name="cmb_popup_name_text" value="<?php echo $settings['cmb_popup_name_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Email Text:</td>
              <td><input type="text" name="cmb_popup_email_text" value="<?php echo $settings['cmb_popup_email_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Phone Text:</td>
              <td><input type="text" name="cmb_popup_phone_text" value="<?php echo $settings['cmb_popup_phone_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Message:</td>
              <td><input type="text" name="cmb_popup_message_text" value="<?php echo $settings['cmb_popup_message_text']; ?>" /></td>
            </tr>
            <tr>
              <td>From Text:</td>
              <td><input type="text" name="cmb_popup_from_text" value="<?php echo $settings['cmb_popup_from_text']; ?>" /></td>
            </tr>
            <tr>
              <td>To Text:</td>
              <td><input type="text" name="cmb_popup_to_text" value="<?php echo $settings['cmb_popup_to_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Required Text:</td>
              <td><input type="text" name="cmb_popup_required_text" value="<?php echo $settings['cmb_popup_required_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Button Text:</td>
              <td><input type="text" name="cmb_popup_button_text" value="<?php echo $settings['cmb_popup_button_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Success Text:</td>
              <td><input type="text" name="cmb_popup_success_text" value="<?php echo $settings['cmb_popup_success_text']; ?>" /></td>
            </tr>
            <tr>
              <td>Email Notification ?</td>
              <td valign="top"><input type="radio" value="1" name="cmb_act_not_email" <?php if(isset($settings['cmb_act_not_email']) && $settings['cmb_act_not_email'] == '1') {echo "checked=checked";} ?> />
                Yes&nbsp;&nbsp;
                <input type="radio" value="0" <?php if(!isset($settings['cmb_act_not_email']) || $settings['cmb_act_not_email'] == '0') {echo "checked=checked";} ?> name="cmb_act_not_email" />
                No</td>
            </tr>
            <tr>
              <td>Notification email:</td>
              <td><input type="text" name="cmb_admin_notification_email" value="<?php echo $settings['cmb_admin_notification_email']; ?>" /></td>
            </tr>
            <tr valign="top">
              <td>Button Image (96X96 px)</td>
              <td><label for="upload_image">
                <div><img id="cmb-preview" src="<?php echo $settings['cmb_button_image']; ?>" style="width:96px;height:96px;" /></div>
				<input type="hidden" name="cmb-btn-image" value="<?php echo $settings['cmb_button_image']; ?>" id="image-url" />
                <input id="upload-button" type="button" class="button-primary" value="Upload Image" />
                </label>
              </td>
            </tr>
          </table>
        </div>
      </div>
    </div>
    <div>
      <div class="inside">
        <div id="post-formats-select">
          <table cellpadding="3">
            <tr>
              <td>&nbsp;</td>
              <td align="right"><input type="submit" name="submit" style="margin-top:10px;" class="button-primary" id="submit" value="Save All Settings"></td>
            </tr>
          </table>
        </div>
      </div>
    </div>
  </div>
</form>
<script type="text/javascript">
jQuery(document).ready(function($){
  var mediaUploader;
  jQuery('#upload-button').click(function(e) {
    e.preventDefault();
    // If the uploader object has already been created, reopen the dialog
      if (mediaUploader) {
      mediaUploader.open();
      return;
    }
    // Extend the wp.media object
    mediaUploader = wp.media.frames.file_frame = wp.media({
      title: 'Choose Image',
      button: {
      text: 'Choose Image'
    }, multiple: false });

    // When a file is selected, grab the URL and set it as the text field's value
    mediaUploader.on('select', function() {
      var attachment = mediaUploader.state().get('selection').first().toJSON();
      jQuery('#image-url').val(attachment.url);
	  jQuery('#cmb-preview').attr('src',attachment.url);
    });
    // Open the uploader dialog
    mediaUploader.open();
  });
});
</script>
<?php }?>
<?php } ?>
