<?php
/*
Plugin Name: Wordpress Call Me Back
Plugin URI:
Description: Customer Can send message to website Call Me Back
Version: 2.0
Author: اسکریپت دات کام
Author URI: http://www.اسکریپت.com
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! class_exists( 'bbCMBFilter' ) ) {
	require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "call-me-back" . DIRECTORY_SEPARATOR . "include" . DIRECTORY_SEPARATOR . "cmb_engine.php";
	require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "call-me-back" . DIRECTORY_SEPARATOR . "include" . DIRECTORY_SEPARATOR . "call_request.php";
	require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "call-me-back" . DIRECTORY_SEPARATOR . "include" . DIRECTORY_SEPARATOR . "cmb_settings.php";
	require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "call-me-back" . DIRECTORY_SEPARATOR . "include" . DIRECTORY_SEPARATOR . "cmb_popup.php";
	require_once WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "call-me-back" . DIRECTORY_SEPARATOR . "include" . DIRECTORY_SEPARATOR . "cmb_widget.php";
}
class bigbossCMBCore {
	public function __construct() {
		register_activation_hook( __FILE__, array( $this, 'ob_install' ) );
		register_deactivation_hook( __FILE__, array( $this, 'ob_uninstall' ) );
		add_action('admin_init', array( $this, 'obScriptInit' ) );
		add_action('init', array( $this, 'obScriptInitFrontend' ) );
		add_action('admin_menu', array( $this, 'cmb_custom_menu_page'));
		add_action( 'widgets_init', array( $this, 'bbCMBFilter_register_widgets'));
		add_action('wp_footer', 'CMB_popup');
		add_action('wp_ajax_nopriv_cmb_data_post',array( $this, 'cmb_data_post'));
		add_action('wp_ajax_cmb_data_post', array( $this, 'cmb_data_post'));
		add_action( 'wp_ajax_nopriv_delete_request_data','delete_request_data' );
		add_action( 'wp_ajax_delete_request_data', 'delete_request_data' );
		add_action( 'wp_ajax_nopriv_call_request_success','call_request_success' );
		add_action( 'wp_ajax_call_request_success', 'call_request_success' );
	}
	function ob_install() {
		global $wp_version;
		If ( version_compare( $wp_version, "2.9", "<" ) ) {
			deactivate_plugins( basename( __FILE__ ) ); // Deactivate our plugin
			wp_die( "This plugin requires WordPress version 2.9 or higher." );
		} else {
			$this->bbcmb_create_custom_table();
		}
	}
	function bbCMBFilter_register_widgets() {
		register_widget( 'bbCMB_list_widget' );
	}
	function ob_uninstall() {
		$this->removeCMBTable();
		delete_option('cmb_setting_options');
	}
	function obScriptInit() {
		//wp_enqueue_script( 'bbMMY-script-mmy', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/js/core.js', array(), false, true );
		//wp_enqueue_media();
		//wp_register_script( 'media-lib-uploader-js', plugins_url( 'media-lib-uploader.js' , __FILE__ ), array('jquery') );
		//wp_enqueue_script( 'media-lib-uploader-js' );
		wp_enqueue_style( 'bbCMB-style-admin', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/css/alert.css' );
	}
	function obScriptInitFrontend() {
		wp_enqueue_script( 'bbCMB-script-frontend', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/js/cmb_popup.js', array(), false, true );
		wp_enqueue_script( 'bbCMB-script-timepicker-frontend', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/js/jquery.timepicker.js', array(), false, true );
		wp_enqueue_script( 'bbCMB-script-cmb', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/js/cmb.js', array(), false, true );
		wp_enqueue_style( 'bbCMB-style-popup', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/css/cmb_popup.css' );
		wp_enqueue_style( 'bbCMB-style-cmb', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/css/cmb_style.css' );
		wp_enqueue_style( 'bbCMB-style-timepicker-cmb', plugin_dir_url( '' ) . basename( dirname( __FILE__ ) ) . '/css/jquery.timepicker.css' );
	}
	
	function cmb_custom_menu_page(){
		add_object_page('Call Request', 'Call Request', 'edit_themes','call_request', 'cmd_admin_call_list','dashicons-phone');
		add_submenu_page('call_request', 'Settings', 'Settings', 'edit_themes', 'cmb_settings', 'cmb_settings' );
	}
	function bbcmb_create_custom_table(){
		global $wpdb;
		$table = $wpdb->prefix ."ss_call_request";
		$sql = "CREATE TABLE IF NOT EXISTS $table (`call_id` int(10) NOT NULL AUTO_INCREMENT,`name` varchar(250) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,`phone_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,`email` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,`message` varchar(500) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,`from_time` varchar(10) CHARACTER SET utf8 NOT NULL,`to_time` varchar(10) CHARACTER SET utf8 NOT NULL,`status` int(1) NOT NULL DEFAULT '0',`requested_date` datetime NOT NULL, PRIMARY KEY (`call_id`)) ";
		$wpdb->query($sql);
	}
	function removeCMBTable(){
		global $wpdb;
		$table = $wpdb->prefix ."ss_call_request";
		$sql = "DROP TABLE IF EXISTS $table;";
		$wpdb->query($sql);
	}
	function sendEmailNotification($post_data) {
		$get_cmb_options = get_option('cmb_setting_options');
		if($get_cmb_options['cmb_act_not_email'] == '1') {
			$name = '';
			$phone = '';
			$email = '';
			$details = '';
			if(isset($post_data['name']) && !empty($post_data['name'])) {
				$name = $post_data['name'];
			}
			if(isset($post_data['phone']) && !empty($post_data['phone'])) {
				$phone = $post_data['phone'];
			}
			if(isset($post_data['email']) && !empty($post_data['email'])) {
				$email = $post_data['email'];
			}
			if(isset($post_data['message']) && !empty($post_data['message'])) {
				$details = $post_data['message'];
			}
			$from = $get_cmb_options['cmb_admin_notification_email'];
			$to = $from;
			$subject = 'Call me back notification';
			$headers[] = "From: " . strip_tags($from) . "\r\n";
			$headers[] = "Reply-To: ". strip_tags($from) . "\r\n";
			$headers[] = "MIME-Version: 1.0\r\n";
			$headers[] = "Content-Type: text/html; charset=ISO-8859-1\r\n";
			$message = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head><body>';
			$message .= '<div><h2>You have one call back notification.</h2></div>';
			$message .= '<p><b>Name:&nbsp;</b>'.$name.'</p>';
			$message .= '<p><b>Phone:&nbsp;</b>'.$phone. '</p>';
			$message .= '<p><b>Email:&nbsp;</b>'.$email. '</p>';
			$message .= '<p><b>Message:&nbsp;</b>'.$details. '</p>';
			$message .= '</body></html>';
			wp_mail($to, $subject, $message, $headers);
		}
	}
	function cmb_data_post(){
		global $wpdb;
		$name = '';
		$phone = '';
		$email = '';
		$message = '';
		$from = '00:00';
		$to = '00:00';
		
		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])) {
			$name = $_REQUEST['name'];
		}
		if(isset($_REQUEST['phone']) && !empty($_REQUEST['phone'])) {
			$phone = $_REQUEST['phone'];
		}
		if(isset($_REQUEST['email']) && !empty($_REQUEST['email'])) {
			$email = $_REQUEST['email'];
		}
		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])) {
			$message = $_REQUEST['message'];
		}
		if(isset($_REQUEST['from']) && !empty($_REQUEST['from'])) {
			$from = $_REQUEST['from'];
		}
		if(isset($_REQUEST['to']) && !empty($_REQUEST['to'])) {
			$to = $_REQUEST['to'];
		}
		if($wpdb->insert( 
			$wpdb->prefix.'ss_call_request', 
			array( 
				'name' 				=>$name, 
				'phone_no' 			=>$phone, 
				'email' 			=> $email,
				'message' 			=>$message,
				'from_time'			=>$from,
				'to_time'			=>$to,
				'requested_date' 	=> date('Y-m-d H:i:s'),
			), 
			array( 
				'%s', 
				'%s',
				'%s', 
				'%s',
				'%s',
				'%s',
				'%s',
			) 
		));
		$this->sendEmailNotification($_REQUEST);
	}
}
$bbCMBFilter = new bigbossCMBCore();
?>