<?php
/**
 * Button X
 *
 * This file is used social buttons functionality.
 *
 * @package Buttons X
 * @since 0.1
 */
// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'Btnsx_Social_Counter' ) ) {
	
	class Btnsx_Social_Counter {

		private static $instance;

		/**
		 * Initiator
		 * @since 0.1
		 */
		public static function init(){
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 0.1
		 */
		public function __construct() {
			global $wp_version;
			// execute code if minimum wp version is 4 n above else throw notice
			if ( $wp_version >= BTNSX__MIN_WP_VERSION ) {
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.design.php' );
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.php' );
				// admin functionality
					add_action( 'init', array( $this, 'register_cpt' ), 19 );
					add_action( 'init', array( $this, 'register_taxonomies' ) );
					add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
	            	add_action( 'do_meta_boxes', array( $this, 'remove_extra_meta_boxes' ) );
	            	add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) , 50 );
	            	// add_action( 'admin_head', array( $this, 'admin_head' ) );
	            	add_action( 'manage_buttons-x-social_posts_custom_column', array( $this, 'column_preview' ), 10, 2);
	   				add_action( 'save_post_buttons-x-social', array( $this, 'save_data' ) );
	   				add_action( 'save_post', array( $this, 'save_post_metabox_data' ) );
	            	add_filter( 'post_updated_messages', array( $this, 'updated_messages' ) );
					add_filter( 'post_row_actions', array( $this, 'row_actions' ), 10, 2 );
					add_filter( 'manage_buttons-x-social_posts_columns', array( $this, 'columns' ) );
	   				add_shortcode( 'btnsx_social' , array( $this, 'shortcode' ) );
	   			// public functionality
	   				add_filter( 'the_content', array( $this, 'content_filter' ) );
	   				add_filter( 'views_edit-buttons-x-social', array( $this, 'screen_meta_view' ) );
			} else {
				add_action( 'admin_notices', array( $this, 'dependency_notice' ) );
			}
		}

		/**
		 * Add packs and tags links on social buttons list page
		 * @since  1.7.3
		 * @param  array    $views
		 * @return array
		 */
		public function screen_meta_view( $views ){
		    $packs = count(get_terms('btnsx_social_pack'));
		    $tags = count(get_terms('btnsx_social_tag'));
		    $views['packs'] = "<a href='edit-tags.php?taxonomy=btnsx_social_pack&post_type=buttons-x-social'>".__('Packs','btnsx')." <span class='count'>(".$packs.")</span></a>";
		    $views['tags'] = "<a href='edit-tags.php?taxonomy=btnsx_social_tag&post_type=buttons-x-social'>".__('Tags','btnsx')." <span class='count'>(".$tags.")</span></a>";
		    return $views;
		}

		/**
		 * Filter content to output social buttons
		 * @since  0.1
		 * @param  string    $content
		 * @return string
		 */
		public function content_filter( $content ) {

			global $post;
			global $btnsx_settings;
			$before_content = '';
			$after_content = '';

			$btnsx_settings[ 'social' ] = isset( $btnsx_settings[ 'social' ] ) ? $btnsx_settings[ 'social' ] : array();

		    if ( in_the_loop() && in_array( $post->post_type, $btnsx_settings[ 'social' ] )  ) {
		    	$buttons_meta = get_post_meta( $post->ID, 'btnsx_social_post_meta', true );
		    	if( $buttons_meta != '' ) {
			    	// Social buttons to be displayed
			    	foreach( $buttons_meta as $key => $value ) {
			    		$value = maybe_unserialize( $value );
			    		if( $key === 'before_content' && is_array( $value ) ) {
				    		foreach ( $value as $option => $id ) {
				    			if( $id != '' ) {
					    			$before_content .= do_shortcode( '[btnsx_social id="' . $id . '"]' );
				    			}
				    		}
				    	}
				    	if ( $key === 'after_content' && is_array( $value ) ) {
				    		foreach ( $value as $option => $id ) {
				    			if( $id != '' ) {
					    			$after_content .= do_shortcode( '[btnsx_social id="' . $id . '"]' );
				    			}
				    		}
				    	}
			    	}
			    }
		    }
		    // Returns the content.
		    return $before_content . $content . $after_content;
		}

		/**
		 * When the post is saved, saves our custom data.
		 *
		 * @param int $post_id The ID of the post being saved.
		 */
		public function save_post_metabox_data( $post_id ) {

			/*
			 * We need to verify this came from our screen and with proper authorization,
			 * because the save_post action can be triggered at other times.
			 */

			// Check if our nonce is set.
			if ( ! isset( $_POST[ 'btnsx_social_post_meta_nonce' ] ) ) {
				return;
			}

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( $_POST[ 'btnsx_social_post_meta_nonce' ], 'btnsx_social_post_meta' ) ) {
				return;
			}

			// If this is an autosave, our form has not been submitted, so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			global $btnsx_settings;

			// Check the user's permissions.
			if ( isset( $_POST[ 'post_type' ] ) && 'page' == $_POST[ 'post_type' ] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			/* OK, it's safe for us to save the data now. */

			// Sanitize user input.
			$data = array();
			$data['before_content'] = sanitize_text_field( isset( $_POST[ 'btnsx_social_before_content' ] ) ? maybe_serialize( $_POST[ 'btnsx_social_before_content' ] ) : '' );
			$data['after_content'] = sanitize_text_field( isset( $_POST[ 'btnsx_social_after_content' ] ) ? maybe_serialize( $_POST[ 'btnsx_social_after_content' ] ) : '' );

			// Update the meta field in the database.
			update_post_meta( $post_id, 'btnsx_social_post_meta', $data );
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 */
		public function post_metabox_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_social_post_meta', 'btnsx_social_post_meta_nonce' );

			global $wpdb;
			$btnsx_post = 'buttons-x-social';
	  		$btnsx_post_status = 'publish';
	        $btnsx = $wpdb->get_results( $wpdb->prepare(
	        	"SELECT post_title, ID 
	        	FROM $wpdb->posts 
	        	WHERE post_type = %s AND post_status = %s
	        	ORDER BY ID DESC"
	        , $btnsx_post, $btnsx_post_status ) );

	        foreach ( $btnsx as $btn ) {
				$btn_id = $btn->ID;
				$btn_title = $btn->post_title;
				$buttons[ $btn_id ] = $btn_title;
			}

			/*
			 * Use get_post_meta() to retrieve an existing value
			 * from the database and use the value for the form.
			 */
			$value = get_post_meta( $post->ID, 'btnsx_social_post_meta', true );
			$btnsx_form = new BtnsxFormElements();

			?>
				<script type="text/javascript">
				jQuery( document ).ready( function($) {
					$( '#btnsx-reset-social-options' ).on( 'click', function() {
						$( '#btnsx-reset-social-options-spinner' ).addClass( 'is-active' );
						$( '#btnsx_social_before_title option:selected' ).removeAttr( 'selected' );
						$( '#btnsx_social_after_title option:selected' ).removeAttr( 'selected' );
						$( '#btnsx_social_before_content option:selected' ).removeAttr( 'selected' );
						$( '#btnsx_social_after_content option:selected' ).removeAttr( 'selected' );
						$( '#btnsx-reset-social-options-spinner' ).removeClass( 'is-active' );
					});
				});
				</script>
			<?php
        	echo $btnsx_form->input( array(
	        		'type'			=>	'select',
					'size'			=>	'12',
					'id'			=>	'btnsx_social_before_content',
					'name'			=>	'btnsx_social_before_content[]',
					'class'			=>	'btnsx-select',
					'multiselect'	=>	true,
					'label'			=>	__( 'Display before Content', 'btnsx' ),
					'tooltip'		=>	'',
					'value'			=>	isset( $value['before_content'] ) ? $value['before_content'] : '',
					'options'		=>	$buttons
				)
        	);
        	echo '<br/>';
        	echo $btnsx_form->input( array(
	        		'type'			=>	'select',
					'size'			=>	'12',
					'id'			=>	'btnsx_social_after_content',
					'name'			=>	'btnsx_social_after_content[]',
					'class'			=>	'btnsx-select',
					'multiselect'	=>	true,
					'label'			=>	__( 'Display after Content', 'btnsx' ),
					'tooltip'		=>	'',
					'value'			=>	isset( $value['after_content'] ) ? $value['after_content'] : '',
					'options'		=>	$buttons
				)
        	);
        	echo '<br/>';
        	echo '<input type="button" name="btnsx-reset-social-options" id="btnsx-reset-social-options" value="' . __( 'Reset','btnsx' ) . '" class="button" style="float:left;"><span id="btnsx-reset-social-options-spinner" class="spinner" style="float:left;"></span><div style="clear:both;"></div>';
		}

		/**
		 * Function to remove view link to row actions on buttons X post type
		 * @since  0.1
		 * @param  string    $actions default actions
		 * @param  WP_Post   $post post object
		 * @return string
		 */
		public function row_actions( $actions, WP_Post $post ) {
	        if ( $post->post_type != 'buttons-x-social' ) {
	            return $actions;
	        }
	        unset( $actions['view'] );
	        return $actions;
	    }

	    /**
	     * [columns description]
	     * @since  0.1
	     * @param  [type]    $defaults
	     * @return [type]
	     */
	    public function columns( $defaults ) {
			$defaults['btnsx_shortcode'] 	= __( 'Shortcode', 'btnsx' );
		    $defaults['btnsx_preview'] 	= __( 'Preview', 'btnsx' );
		    unset( $defaults['date'] );
		    return $defaults;
		}

		/**
		 * [column_preview description]
		 * @since  0.1
		 * @param  [type]    $column_name
		 * @param  [type]    $id
		 * @return [type]
		 */
		public function column_preview( $column_name, $id ) {
		    if ( $column_name == 'btnsx_preview' ) {
		        $meta = get_post_meta( $id, 'btnsx-social', true);
		        ?>
		        <div class="btnsx">
			        <!-- Modal Trigger -->
					<a class="waves-effect waves-light btn modal-trigger" href="#modal<?php echo sanitize_text_field( $id ); ?>"><?php _e( 'Preview', 'btnsx' ); ?></a>
					<!-- Modal Structure -->
					<div id="modal<?php echo $id; ?>" class="modal preview-modal">
					    <div class="modal-content">
					    	<?php 
					    		echo $this->shortcode( array ( 'id' => $id, 'admin_style' => '1' ) ); 
					    	?>
					    </div>
					    <div class="modal-footer">
					      	<a href="javascript:void(0)" class="modal-action modal-close"><i class="fa fa-close"></i></a>
					    </div>
					</div>
				</div>
				<?php
		        // echo $this->shortcode( array ( 'id' => $id, 'css_inline' => '1' ) );
		    }
		    if ( $column_name == 'btnsx_shortcode' ) {
		        echo '[btnsx_social id="' . sanitize_text_field( $id ) . '"]';
		    }
		}

		/**
		 * [columns_order description]
		 * @since  0.1
		 * @param  [type]    $columns
		 * @return [type]
		 */
		public function columns_order( $columns ) {
		    return array(
		        'cb' 					=> '<input type="checkbox" />',
		        'title' 				=> __( 'Title', 'btnsx' ),
		        'taxonomy-btnsx_pack' 	=> __( 'Packs', 'btnsx' ),
		        'taxonomy-btnsx_tag' 	=> __( 'Tags', 'btnsx' ),
		        'btnsx_shortcode' 		=> __( 'Shortcode', 'btnsx' ),
		        'btnsx_preview' 		=> __( 'Preview', 'btnsx' ),
		    );
		}
		
		/**
		 *  Enqueue Public Scripts
		 *  @since 0.1
		 */
		public function public_enqueue_scripts() {
			// Public scripts
			wp_register_script(
				'btnsx',
				BTNSX__PLUGIN_URL . 'assets/js/public/btnsx.js',
				array('jquery'),
				BTNSX__VERSION,
				true
			);
			wp_enqueue_script( 'btnsx' );

			// Public styles
			wp_enqueue_style(
				'btnsx',
				BTNSX__PLUGIN_URL . 'assets/css/common/button.css',
				array(),
				BTNSX__VERSION
			);
			$upload_dir = wp_upload_dir();
			global $btnsx_settings; global $wp_filesystem;
			if( isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] === 'external' ){
				wp_enqueue_style(
					'btnsx' . '-dynamic',
					trailingslashit( $upload_dir['baseurl'] ) . 'btnsx/dynamic.css',
					array(),
					BTNSX__VERSION
				);
			}
		}

	    /**
	     * Button short code
	     * @param $atts 
	     * @since 0.1
	     */
	    public function shortcode( $atts, $content = '' ) {

	    	extract( shortcode_atts( array(
			
			// General
				'id'								=> '',
				'social_facebook' 					=> '',
	        	'social_twitter' 					=> '',
	        	'social_googleplus' 				=> '',
	        	'social_linkedin' 					=> '',

	        // Facebook
	        	'fb_type' 							=> '',
	        	'fb_url' 							=> '',
	        	'fb_width' 							=> '',
	        	'fb_height' 						=> '',
	        	'fb_layout' 						=> '',
	        	'fb_action' 						=> '',
	        	'fb_colorscheme' 					=> '',
	        	'fb_show_faces' 					=> '',
	        	'fb_share' 							=> '',
	        	'fb_kid_directed_site' 				=> '',

	        // Twitter
	        	'tw_type' 							=> '',
	        	'tw_url' 							=> '',
	        	'tw_text' 							=> '',
	        	'tw_username' 						=> '',
	        	'tw_related' 						=> '',
	        	'tw_hashtag' 						=> '',
	        	'tw_count' 							=> '',
	        	'tw_size' 							=> '',
	        	'tw_dnt' 							=> '',
	        	'tw_screen_name' 					=> '',

	        // Google Plus
	        	'gp_type' 							=> '',
	        	'gp_one_size' 						=> '',
	        	'gp_one_layout' 					=> '',
	        	'gp_url' 							=> '',
	        	'gp_user' 							=> '',
	        	'gp_size' 							=> '',
	        	'gp_follow_layout' 					=> '',
	        	'gp_share_layout' 					=> '',
	        	'gp_width' 							=> '',

	        // Linked IN
	        	'li_url' 							=> '',
	        	'li_counter_type' 					=> '',

	        // For Backend use Only
	        	'admin_style'						=> '',
	        	'li_title_fix'						=> ''

			
			), $atts ) );

			// Backend stuff
				$admin_css = '';
	        	if( $admin_style === '1' ) {
	        		$admin_css = 'float:none;';
	        	}

			// General
				// 'id'								= '', (required to be defined)
				$social_facebook 					= $social_facebook != '' ? sanitize_text_field( $social_facebook ) : $this->meta_values( $id, array( 'field' => 'btnsx_social_facebook' ) );
				$social_twitter 					= $social_twitter != '' ? sanitize_text_field( $social_twitter ) : $this->meta_values( $id, array( 'field' => 'btnsx_social_twitter' ) );
				$social_googleplus 					= $social_googleplus != '' ? sanitize_text_field( $social_googleplus ) : $this->meta_values( $id, array( 'field' => 'btnsx_social_googleplus' ) );
				$social_linkedin 					= $social_linkedin != '' ? sanitize_text_field( $social_linkedin ) : $this->meta_values( $id, array( 'field' => 'btnsx_social_linkedin' ) );

	        // Facebook
	        	$fb_type 							= $fb_type != '' ? sanitize_text_field( $fb_type ) : $this->meta_values( $id, array( 'field' => 'btnsx_fb_type' ) );
	        	$fb_class							= '';
	        	if( $fb_type === 'like' ) {
	        		$fb_class = 'fb-like';
	        	} elseif( $fb_type === 'follow' ) {
	        		$fb_class = 'fb-follow';
	        	} elseif( $fb_type === 'share' ) {
	        		$fb_class = 'fb-share-button';
	        	} else {
	        		$fb_class = 'fb-send';
	        	}
	        	$fb_url								= $fb_url != '' ? $fb_url : $this->meta_values( $id, array( 'field' => 'btnsx_fb_url' ) );
	        	$fb_width							= $fb_width != '' ? $fb_width : $this->meta_values( $id, array( 'field' => 'btnsx_fb_width' ) );
	        	$fb_height 							= $fb_height != '' ? $fb_height : $this->meta_values( $id, array( 'field' => 'btnsx_fb_height' ) );
	        	$fb_layout							= $fb_layout != '' ? $fb_layout : $this->meta_values( $id, array( 'field' => 'btnsx_fb_layout' ) );
	        	$fb_action							= $fb_action != '' ? $fb_action : $this->meta_values( $id, array( 'field' => 'btnsx_fb_action' ) );
	        	$fb_colorscheme						= $fb_colorscheme != '' ? $fb_colorscheme : $this->meta_values( $id, array( 'field' => 'btnsx_fb_colorscheme' ) );
	        	$fb_show_faces						= $fb_show_faces != '' ? $fb_show_faces : $this->meta_values( $id, array( 'field' => 'btnsx_fb_show_faces' ) );
	        	if( $fb_show_faces === '1' ) {
	        		$fb_show_faces = 'true';
	        	}
	        	$fb_share							= $fb_share != '' ? $fb_share : $this->meta_values( $id, array( 'field' => 'btnsx_fb_share' ) );
	        	if( $fb_share === '1' ) {
	        		$fb_share = 'true';
	        	}
	        	$fb_kid_directed_site				= $fb_kid_directed_site != '' ? $fb_kid_directed_site : $this->meta_values( $id, array( 'field' => 'btnsx_fb_kid_directed_site' ) );

	        	$fb_btn = '';
	        	if( $social_facebook == '1' ) {
	        		$fb_btn = '<div id="btnsx-' . esc_attr( $id ) . '-fb-container" class="btnsx-social-buttons btnsx-social-fb" style="display:inline-block;' . $admin_css . '"><div class="' . sanitize_html_class( $fb_class ) . '" data-href="'. esc_url( $fb_url ) .'" data-width="'. esc_attr( $fb_width ) .'" data-height="'. esc_attr( $fb_height ) .'" data-layout="'. esc_attr( $fb_layout ) .'" data-action="'. esc_attr( $fb_action ) .'" data-colorscheme="'. esc_attr( $fb_colorscheme ) .'" data-show-faces="'. esc_attr( $fb_show_faces ) .'" data-share="'. esc_attr( $fb_share ) .'" data-kid-directed-site="'. esc_attr( $fb_kid_directed_site ) .'"></div></div>';
	        	}

	        // Twitter
	        	$tw_type 							= $tw_type != '' ? $tw_type : $this->meta_values( $id, array( 'field' => 'btnsx_tw_type' ) );
	        	$tw_url 							= $tw_url != '' ? $tw_url : $this->meta_values( $id, array( 'field' => 'btnsx_tw_url' ) );
	        	$tw_text							= $tw_text != '' ? $tw_text : $this->meta_values( $id, array( 'field' => 'btnsx_tw_text' ) );
	        	$tw_username						= $tw_username != '' ? $tw_username : $this->meta_values( $id, array( 'field' => 'btnsx_tw_username' ) );
	        	if( $tw_username === '' ) {
	        		$tw_username = 'twitter';
	        	}
	        	$tw_related							= $tw_related != '' ? $tw_related : $this->meta_values( $id, array( 'field' => 'btnsx_tw_related' ) );
	        	$tw_hashtag							= $tw_hashtag != '' ? $tw_hashtag : $this->meta_values( $id, array( 'field' => 'btnsx_tw_hashtag' ) );
	        	if( $tw_hashtag === '' ) {
	        		$tw_hashtag = 'ButtonsX';
	        	}
	        	$tw_count							= $tw_count != '' ? $tw_count : $this->meta_values( $id, array( 'field' => 'btnsx_tw_count' ) );
	        	$tw_size 							= $tw_size != '' ? $tw_size : $this->meta_values( $id, array( 'field' => 'btnsx_tw_size' ) );
	        	if( $tw_size === '1' ) {
	        		$tw_size = 'large';
	        	} else {
	        		$tw_size = '';
	        	}
	        	$tw_dnt 							= $tw_dnt != '' ? $tw_dnt : $this->meta_values( $id, array( 'field' => 'btnsx_tw_dnt' ) );
	        	if( $tw_dnt === '1' ) {
	        		$tw_dnt = 'true';
	        	} else {
	        		$tw_dnt = '';
	        	}
	        	$tw_screen_name						= $tw_screen_name != '' ? $tw_screen_name : $this->meta_values( $id, array( 'field' => 'btnsx_tw_screen_name' ) );
	        	if( $tw_screen_name === '1' ) {
	        		$tw_screen_name = 'true';
	        	} else {
	        		$tw_screen_name = '';
	        	}

	        	$tw_btn = '';$tw_href = '';$tw_class = '';

	        	if( $tw_type === 'tweet' ) {
	        		$tw_href = 'https://twitter.com/share';
	        		$tw_class = 'twitter-share-button';
	        	} elseif( $tw_type === 'follow' ) {
	        		$tw_href = 'https://twitter.com/' . $tw_username;
	        		$tw_class = 'twitter-follow-button';
	        	} elseif( $tw_type === 'hashtag' ) {
	        		$tw_href = 'https://twitter.com/intent/tweet?button_hashtag=' . $tw_hashtag;
	        		$tw_class = 'twitter-hashtag-button';
	        	} else {
	        		$tw_href = 'https://twitter.com/intent/tweet?screen_name=' . $tw_username;
	        		$tw_class = 'twitter-mention-button';
	        	}
	        	if( $social_twitter == '1' ) {
	        		$tw_btn = '<div id="btnsx-' . sanitize_text_field( $id ) . '-tw-container" class="btnsx-social-buttons btnsx-social-tw" style="display:inline-block;' . $admin_css . '"><a class="' . sanitize_html_class( $tw_class ) . '" href="' . esc_url( $tw_href ) . '" data-url="' . esc_url( $tw_url ) . '" data-text="' . esc_attr( $tw_text ) . '" data-size="' . esc_attr( $tw_size ) . '" data-count="' . esc_attr( $tw_count ) . '" data-count-url="' . esc_url( $tw_url ) . '" data-via="' . esc_attr( $tw_username ) . '" data-related="' . esc_attr( $tw_related ) . '" data-hashtags="' . esc_attr( $tw_hashtag ) . '" data-dnt="' . esc_attr( $tw_dnt ) . '" data-show-screen-name="' . esc_attr( $tw_screen_name ) . '"></a></div>';
	        	}

	        // Google Plus
	        	$gp_type 							= $gp_type != '' ? $gp_type : $this->meta_values( $id, array( 'field' => 'btnsx_gp_type' ) );
	        	$gp_class							= '';
	        	if( $gp_type === 'one' ) {
	        		$gp_class = 'g-plusone';
	        	} elseif( $gp_type === 'follow' ) {
	        		$gp_class = 'g-follow';
	        	} else {
	        		$gp_class = 'g-plus';
	        	}
	        	$gp_one_size 						= $gp_one_size != '' ? $gp_one_size : $this->meta_values( $id, array( 'field' => 'btnsx_gp_one_size' ) );
	        	$gp_one_layout 						= $gp_one_layout != '' ? $gp_one_layout : $this->meta_values( $id, array( 'field' => 'btnsx_gp_one_layout' ) );
	        	$gp_url 							= $gp_url != '' ? $gp_url : $this->meta_values( $id, array( 'field' => 'btnsx_gp_url' ) );
	        	$gp_user 							= $gp_user != '' ? $gp_user : $this->meta_values( $id, array( 'field' => 'btnsx_gp_user' ) );
	        	$gp_size 							= $gp_size != '' ? $gp_size : $this->meta_values( $id, array( 'field' => 'btnsx_gp_size' ) );
	        	$gp_follow_layout 					= $gp_follow_layout != '' ? $gp_follow_layout : $this->meta_values( $id, array( 'field' => 'btnsx_gp_follow_layout' ) );
	        	$gp_share_layout 					= $gp_share_layout != '' ? $gp_share_layout : $this->meta_values( $id, array( 'field' => 'btnsx_gp_share_layout' ) );
	        	$gp_width 							= $gp_width != '' ? $gp_width : $this->meta_values( $id, array( 'field' => 'btnsx_gp_width' ) );

	        	$gp_annotation = '';$gp_rel = 'author';$gp_height = '15';

	        	if( $gp_type === 'one' ) {
	        		$gp_annotation = $gp_one_layout;
	        		$gp_size = $gp_one_size;
	        	} elseif( $gp_type === 'follow' ) {
	        		$gp_annotation = $gp_follow_layout;
	        		$gp_url = $gp_user;
	        		$gp_rel = 'publisher';
	        		if( $gp_size == 'medium' ) {
	        			$gp_height = '20';
	        		} else if( $gp_size == 'large' ) {
	        			$gp_height = '24';
	        		} else {
	        			$gp_height = '15';
	        		}
	        	} else {
	        		$gp_annotation = $gp_share_layout;
	        		$gp_rel = 'author';
	        		if( $gp_size == 'medium' ) {
	        			$gp_height = '20';
	        		} else if( $gp_size == 'large' ) {
	        			$gp_height = '24';
	        		} else {
	        			$gp_height = '15';
	        		}
	        	}

	        	if( $gp_width != '' ) {
	        		$gp_width = 'data-width="'. esc_attr( $gp_width ) .'"';
	        	}

	        	if( $gp_type === 'share' ) {
	        		$gp_type = 'data-action="'. esc_attr( $gp_type ) .'"';
	        		$gp_width = '';
	        	} else {
	        		$gp_type = '';
	        	}

	        	if( $gp_type === 'share' || $gp_type === 'follow' ) {
	        		$data_height = 'data-height:' . $gp_height . ';';
	        	} else {
	        		$data_height = '';
	        	}

	        	$gp_btn = '';
	        	if( $social_googleplus == '1' ) {
	        		$gp_btn = '<div id="btnsx-' . sanitize_text_field( $id ) . '-gp-container" class="btnsx-social-buttons btnsx-social-gp" style="display:inline-block;' . $admin_css . '"><div class="'. esc_attr( $gp_class ) .'" '. $gp_type .'  data-size="'. esc_attr( $gp_size ) .'" data-annotation="'. esc_attr( $gp_annotation ) .'" '. $gp_width .' data-href="'. esc_attr( $gp_url ) .'" '. $data_height .'></div></div>';
	        	}

	        // Linked IN
	        	$li_url 							= $li_url != '' ? $li_url : $this->meta_values( $id, array( 'field' => 'btnsx_li_url' ) );
	        	$li_counter_type 					= $li_counter_type != '' ? $li_counter_type : $this->meta_values( $id, array( 'field' => 'btnsx_li_counter_type' ) );

	        	if( $li_counter_type === 'top' && $li_title_fix === '1' ) {
	        		$li_title_fix = 'btnsx-li-height';
	        	} else {
	        		$li_title_fix = '';
	        	}

	        	$li_btn = '';
	        	if( $social_linkedin == '1' ) {
	        		$li_btn = '<div id="btnsx-' . sanitize_text_field( $id ) . '-li-container" class="btnsx-social-buttons btnsx-social-li ' . sanitize_html_class( $li_title_fix ) . '" style="display:inline-block;' . $admin_css . '"><script type="IN/Share" data-url="'. esc_attr( $li_url ) .'" data-counter="'. esc_attr( $li_counter_type ) .'"></script></div>';
	        	}

			return 
			'
			<!-- Buttons X Social - Start -->
			<div class="btnsx-social-container btnsx-social-horizontal">' . $fb_btn . $tw_btn . $li_btn . $gp_btn . '</div>
			<!-- Buttons X Social - End -->
			';
	    }

	    /**
	     * When the post is saved, saves our custom data.
	     * @param int $post->ID_id The ID of the post being saved.
	     * @since 0.1
	     */
	    public function save_data( $post_id ) {

	    	// wp_die('working');

	        /*
	         * We need to verify this came from our screen and with proper authorization,
	         * because the save_post action can be triggered at other times.
	         */

	        // Check if our nonce is set.
	        if ( !isset( $_POST[ 'btnsx_options_nonce' ] ) ) {
	            return;
	        }

	        // Verify that the nonce is valid.
	        if ( !wp_verify_nonce( $_POST[ 'btnsx_options_nonce' ], 'btnsx-social' ) ) {
	            return;
	        }

	        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
	        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
	            return;
	        }

	        // Check the user's permissions.
	        if ( isset( $_POST[ 'post_type' ] ) && 'page' == $_POST[ 'post_type' ] ) {
	            if ( !current_user_can( 'edit_page', $post_id ) ) {
	                return;
	            }
	        } else {
	            if ( !current_user_can( 'edit_post', $post_id ) ) {
	                return;
	            }
	        }

	        /* OK, its safe for us to save the data now. */

	        $btnsx_data = array();

	        // Sanitize user input.
	        $btnsx_data = array(
	        	// General
		        	'btnsx_id' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_id'] ) ? $_POST['btnsx_opt_id'] : '' ),
		        	'btnsx_social_facebook' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_social_facebook'] ) ? $_POST['btnsx_opt_social_facebook'] : '' ),
		        	'btnsx_social_twitter' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_social_twitter'] ) ? $_POST['btnsx_opt_social_twitter'] : '' ),
		        	'btnsx_social_googleplus' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_social_googleplus'] ) ? $_POST['btnsx_opt_social_googleplus'] : '' ),
		        	'btnsx_social_linkedin' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_social_linkedin'] ) ? $_POST['btnsx_opt_social_linkedin'] : '' ),

		        // Facebook
		        	'btnsx_fb_type' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_type'] ) ? $_POST['btnsx_opt_fb_type'] : '' ),
		        	'btnsx_fb_url' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_url'] ) ? $_POST['btnsx_opt_fb_url'] : '' ),
		        	'btnsx_fb_width' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_width'] ) ? $_POST['btnsx_opt_fb_width'] : '' ),
		        	'btnsx_fb_height' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_height'] ) ? $_POST['btnsx_opt_fb_height'] : '' ),
		        	'btnsx_fb_layout' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_layout'] ) ? $_POST['btnsx_opt_fb_layout'] : '' ),
		        	'btnsx_fb_action' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_action'] ) ? $_POST['btnsx_opt_fb_action'] : '' ),
		        	'btnsx_fb_colorscheme' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_colorscheme'] ) ? $_POST['btnsx_opt_fb_colorscheme'] : '' ),
		        	'btnsx_fb_show_faces' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_show_faces'] ) ? $_POST['btnsx_opt_fb_show_faces'] : '' ),
		        	'btnsx_fb_share' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_share'] ) ? $_POST['btnsx_opt_fb_share'] : '' ),
		        	'btnsx_fb_kid_directed_site' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_fb_kid_directed_site'] ) ? $_POST['btnsx_opt_fb_kid_directed_site'] : '' ),

		        // Twitter
		        	'btnsx_tw_type' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_type'] ) ? $_POST['btnsx_opt_tw_type'] : '' ),
		        	'btnsx_tw_url' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_url'] ) ? $_POST['btnsx_opt_tw_url'] : '' ),
		        	'btnsx_tw_text' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_text'] ) ? $_POST['btnsx_opt_tw_text'] : '' ),
		        	'btnsx_tw_username' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_username'] ) ? $_POST['btnsx_opt_tw_username'] : '' ),
		        	'btnsx_tw_related' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_related'] ) ? $_POST['btnsx_opt_tw_related'] : '' ),
		        	'btnsx_tw_hashtag' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_hashtag'] ) ? $_POST['btnsx_opt_tw_hashtag'] : '' ),
		        	'btnsx_tw_count' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_count'] ) ? $_POST['btnsx_opt_tw_count'] : '' ),
		        	'btnsx_tw_size' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_size'] ) ? $_POST['btnsx_opt_tw_size'] : '' ),
		        	'btnsx_tw_dnt' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_dnt'] ) ? $_POST['btnsx_opt_tw_dnt'] : '' ),
		        	'btnsx_tw_screen_name' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_tw_screen_name'] ) ? $_POST['btnsx_opt_tw_screen_name'] : '' ),

		        // Google Plus
		        	'btnsx_gp_type' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_type'] ) ? $_POST['btnsx_opt_gp_type'] : '' ),
		        	'btnsx_gp_one_size' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_one_size'] ) ? $_POST['btnsx_opt_gp_one_size'] : '' ),
		        	'btnsx_gp_one_layout' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_one_layout'] ) ? $_POST['btnsx_opt_gp_one_layout'] : '' ),
		        	'btnsx_gp_url' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_url'] ) ? $_POST['btnsx_opt_gp_url'] : '' ),
		        	'btnsx_gp_user' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_user'] ) ? $_POST['btnsx_opt_gp_user'] : '' ),
		        	'btnsx_gp_size' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_size'] ) ? $_POST['btnsx_opt_gp_size'] : '' ),
		        	'btnsx_gp_follow_layout' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_follow_layout'] ) ? $_POST['btnsx_opt_gp_follow_layout'] : '' ),
		        	'btnsx_gp_share_layout' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_share_layout'] ) ? $_POST['btnsx_opt_gp_share_layout'] : '' ),
		        	'btnsx_gp_width' 					=> sanitize_text_field( isset( $_POST['btnsx_opt_gp_width'] ) ? $_POST['btnsx_opt_gp_width'] : '' ),

	        	// Linked IN
	        		'btnsx_li_url' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_li_url'] ) ? $_POST['btnsx_opt_li_url'] : '' ),
	        		'btnsx_li_counter_type' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_li_counter_type'] ) ? $_POST['btnsx_opt_li_counter_type'] : '' ),
	            
	        );

	        // Update the meta field in the database.
	        update_post_meta( $post_id, 'btnsx-social', $btnsx_data );
	    }

	    /**
		 * Fetch meta values
		 * @since  0.1
		 * @param  int   	$post_id ID for the current post/page.
		 * @param  array    $params 
		 * @return string
		 */
		public function meta_values( $post_id, $params = array( 'field' => '', 'field2' => '', 'value' => '' ) ) {
			/*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        $meta_values = array();
	        $meta_values = get_post_meta( $post_id, 'btnsx-social', true );

	        // meta key value
	        $field = isset( $params['field'] ) ? $params['field'] : '';
	        // meta key value in case stored as an array
	        $field2 = isset( $params['field2'] ) ? $params['field2'] : '';
	        // value in case meta value is not defined
	        $value = isset( $params['value'] ) ? $params['value'] : '';

	        // Based on defined parameters set value
	        if ( $field != '' && $field2 == '' ){
	        	$meta_value = isset( $meta_values[$field] ) ? $meta_values[$field] : $value;
	        } elseif ( $field != '' && $field2 != '' ) {
	        	$meta_value = isset( $meta_values[$field][$field2] ) ? $meta_values[$field][$field2] : $value;
	        } else {
	        	$meta_value = '';
	        }

	        return $meta_value;
		}

		/**
		 * Function to output Google+ Script
		 * @since  0.1
		 * @return string
		 */
		public function admin_head() {
			$screen = get_current_screen();
			if ( in_array( $screen->id, array( 'buttons-x-social' ) ) ) {
				echo '<script src="https://apis.google.com/js/platform.js" async defer> {parsetags: "explicit"} </script>';
				?>
				<script type="text/javascript">
					jQuery( document ).ready( function($) {
						// Facebook Script
					        (function(d, s, id) {
					            var js, fjs = d.getElementsByTagName(s)[0];
					            if (d.getElementById(id)) return;
					            js = d.createElement(s); js.id = id;
					            js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.4";
					            fjs.parentNode.insertBefore(js, fjs);
					        }(document, 'script', 'facebook-jssdk'));
					    // Twitter Script
					        !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');
					    // Google Plus Script
					        (function() {
					            var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
					            po.src = 'https://apis.google.com/js/platform.js';
					            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
					        })();
					    // LinkedIn Script
					        $.getScript( 'https://platform.linkedin.com/in.js' );
					});
				</script>
				<?php
			}
		}

		/**
		 * Enqueue Admin Scripts
		 * @since 0.1
		 */
		public function admin_enqueue_scripts() {
			$screen = get_current_screen();
			// Admin Scripts
			if ( in_array( $screen->id, array( 'buttons-x-social', 'edit-buttons-x-social' ) ) ) {
				wp_register_script(
					'btnsx' . '-view-social-js',
					BTNSX__PLUGIN_URL . 'assets/js/admin/view-social.js',
					array('jquery'),
					BTNSX__VERSION,
					false
				);
				wp_enqueue_script( 'btnsx' . '-view-social-js' );
			}
		}

	    /**
         * Button update messages.
         * @since  0.1
         * @param  array    $messages
         * @return array
         */
		public function updated_messages( $messages ) {
			$post             = get_post();
			$post_type        = get_post_type( $post );
			$post_type_object = get_post_type_object( $post_type );
			$messages['buttons-x-social'] = array(
				0  => '', // Unused. Messages start at index 1.
				1  => __( 'Social button updated.', 'btnsx' ),
				2  => __( 'Custom field updated.', 'btnsx' ),
				3  => __( 'Custom field deleted.', 'btnsx' ),
				4  => __( 'Social button updated.', 'btnsx' ),
				/* translators: %s: date and time of the revision */
				5  => isset( $_GET['revision'] ) ? sprintf( __( 'Social button restored to revision from %s', 'btnsx' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
				6  => __( 'Social button published.', 'btnsx' ),
				7  => __( 'Social button saved.', 'btnsx' ),
				8  => __( 'Social button submitted.', 'btnsx' ),
				9  => sprintf(
					__( 'Social button scheduled for: <strong>%1$s</strong>.', 'btnsx' ),
					// translators: Publish box date format, see http://php.net/date
					date_i18n( __( 'M j, Y @ G:i', 'btnsx' ), strtotime( $post->post_date ) )
				),
				10 => __( 'Social button draft updated.', 'btnsx' )
			);

			// if ( $post_type_object->publicly_queryable ) {
			// 	$permalink = get_permalink( $post->ID );

			// 	$view_link = sprintf( ' <a href="%s">%s</a>', esc_url( $permalink ), __( 'View button', 'btnsx' ) );
			// 	$messages[ $post_type ][1] .= $view_link;
			// 	$messages[ $post_type ][6] .= $view_link;
			// 	$messages[ $post_type ][9] .= $view_link;

			// 	$preview_permalink = add_query_arg( 'preview', 'true', $permalink );
			// 	$preview_link = sprintf( ' <a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), __( 'Preview Button', 'btnsx' ) );
			// 	$messages[ $post_type ][8]  .= $preview_link;
			// 	$messages[ $post_type ][10] .= $preview_link;
			// }
			return $messages;
		}

		/**
		 * remove extra meta boxes on custom post page
		 * @since 0.1
		 */
		public function remove_extra_meta_boxes() {
		    if( get_post_type() == 'buttons-x-social' ){
		        $meta_boxes_advanced = $this->get_meta_boxes( 'buttons-x-social', 'advanced' );
		        $meta_boxes_normal = $this->get_meta_boxes( 'buttons-x-social', 'normal' );
		        $meta_boxes_side = $this->get_meta_boxes( 'buttons-x-social', 'side' );
		        $meta_advanced = array( '' );
		        $meta_normal = array( 'btnsx-preview', 'btnsx-options' );
		        $meta_side = array( 'submitdiv', 'btnsx_social_packdiv', 'tagsdiv-btnsx_social_tag', 'btnsx-shortcode' );
		        foreach ( $meta_boxes_advanced as $key => $value ) {
		            foreach ( $value as $k => $v ) {
		                if( !in_array( $v['id'], $meta_advanced )  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-social' , 'advanced' );
		                }
		            }
		        }
		        foreach ($meta_boxes_normal as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_normal)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-social' , 'normal' );
		                }
		            }
		        }
		        foreach ($meta_boxes_side as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_side)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-social' , 'side' );
		                }
		            }
		        }
		    }
		}

		/**
		 * Extract meta boxes information
		 * @param  string $screen  target page
		 * @param  string $context part of page where meta box is shown
		 * @return array          list of meta boxes on the target page
		 * @since 0.1
		 */
		public function get_meta_boxes( $screen = null, $context = 'advanced' ) {
		    global $wp_meta_boxes;
		    if ( empty( $screen ) ) {
		        $screen = get_current_screen();
		    } elseif ( is_string( $screen ) ) {
		        $screen = convert_to_screen( $screen );
		    }
		    $page = $screen->id;
		    if( isset( $wp_meta_boxes[ $page ][ $context ] ) ) {
		    	return $wp_meta_boxes[ $page ][ $context ];
		    } else {
		    	return array();
		    }
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function options_callback( $post ) {

	        // Add an nonce field so we can check for it later.
	        wp_nonce_field( 'btnsx-social', 'btnsx_options_nonce' );

	        /*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        $meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx-social', true );

        	$btnsx_form_design = new BtnsxFormDesign();
        	$btnsx_default_options = array(
        		array(
					'icon_class'	=>	'fa fa-power-off',
					'text'			=>	__( 'Enable', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'hidden',
							'id'			=>	'btnsx_opt_id',
							'name'			=>	'btnsx_opt_id',
							'label'			=>	__( 'ID', 'btnsx' ),
							'value'			=>	$post->ID
						),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_social_facebook',
						    'name'			=>	'btnsx_opt_social_facebook',
						    'label'			=>	__( 'Enable Facebook Button', 'btnsx' ),
						    'tooltip'		=>	__( 'Enables Facebook button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_social_facebook', 'value' => '1' ) )
					    ),
					    array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_social_twitter',
						    'name'			=>	'btnsx_opt_social_twitter',
						    'label'			=>	__( 'Enable Twitter Button', 'btnsx' ),
						    'tooltip'		=>	__( 'Enables Twitter button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_social_twitter', 'value' => '0' ) )
					    ),
					    array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_social_googleplus',
						    'name'			=>	'btnsx_opt_social_googleplus',
						    'label'			=>	__( 'Enable Google+ Button', 'btnsx' ),
						    'tooltip'		=>	__( 'Enables Google+ button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_social_googleplus', 'value' => '0' ) )
					    ),
					    array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_social_linkedin',
						    'name'			=>	'btnsx_opt_social_linkedin',
						    'label'			=>	__( 'Enable LinkedIn Button', 'btnsx' ),
						    'tooltip'		=>	__( 'Enables LinkedIn button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_social_linkedin', 'value' => '0' ) )
					    )
					)
				),
        		array(
					'icon_class'	=>	'fa fa-facebook',
					'text'			=>	__( 'Facebook', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_fb_type',
							'name'			=>	'btnsx_opt_fb_type',
							'placeholder'	=>	__( 'Choose button type', 'btnsx' ),
							'label'			=>	__( 'Button Type', 'btnsx' ),
							'tooltip'		=>	__( 'Select the type of Facebook button you require.', 'btnsx' ),
							'options'		=>	array(
								'like'			=> __( 'Like', 'btnsx' ),
								'follow'		=> __( 'Follow', 'btnsx' ),
								'share'			=> __( 'Share', 'btnsx' ),
								'send'			=> __( 'Send', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_type', 'value' => 'like' ) )
						),
					    array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_fb_url',
							'name'			=>	'btnsx_opt_fb_url',
							'label'			=>	__( 'URL', 'btnsx' ),
							'tooltip'		=>	__( 'Insert the URL which your site visitors should like for like button, Profile URL for follow button and Page URL for share button.', 'btnsx' ),
							'placeholder'	=>	__( 'https://www.button.sx', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_url', 'value' => 'https://developers.facebook.com/docs/plugins/' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_fb_width',
							'name'			=>	'btnsx_opt_fb_width',
							'label'			=>	__( 'Width', 'btnsx' ),
							'tooltip'		=>	__( 'Add width in pixels.', 'btnsx' ),
							'placeholder'	=>	__( 'The pixel width', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_width' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_fb_height',
							'name'			=>	'btnsx_opt_fb_height',
							'label'			=>	__( 'Height', 'btnsx' ),
							'tooltip'		=>	__( 'Add height in pixels.', 'btnsx' ),
							'placeholder'	=>	__( 'The pixel height', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_height' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_fb_layout',
							'name'			=>	'btnsx_opt_fb_layout',
							'placeholder'	=>	__( 'Choose layout', 'btnsx' ),
							'label'			=>	__( 'Layout', 'btnsx' ),
							'tooltip'		=>	__( 'Select the button layout type.', 'btnsx' ),
							'options'		=>	array(
								'standard'		=> __( 'Standard (Not For Share Button)', 'btnsx' ),
								'box_count'		=> __( 'Box Count', 'btnsx' ),
								'button_count'	=> __( 'Button Count', 'btnsx' ),
								'button'		=> __( 'Button', 'btnsx' ),
								'icon_link'		=> __( 'Icon Link (For Share Button Only)', 'btnsx' ),
								'icon'			=> __( 'Icon (For Share Button Only)', 'btnsx' ),
								'link'			=> __( 'Link (For Share Button Only)', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_layout', 'value' => 'button' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_fb_action',
							'name'			=>	'btnsx_opt_fb_action',
							'placeholder'	=>	__( 'Choose action type', 'btnsx' ),
							'label'			=>	__( 'Action Type', 'btnsx' ),
							'tooltip'		=>	__( 'Select the type of action button performs.', 'btnsx' ),
							'options'		=>	array(
								'like'			=> __( 'Like', 'btnsx' ),
								'recommend'		=> __( 'Recommend', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_action', 'value' => 'like' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_fb_colorscheme',
							'name'			=>	'btnsx_opt_fb_colorscheme',
							'placeholder'	=>	__( 'Choose color scheme', 'btnsx' ),
							'label'			=>	__( 'Color Scheme', 'btnsx' ),
							'tooltip'		=>	__( 'The color scheme used by the plugin for any text outside of the button itself. Can be light or dark.', 'btnsx' ),
							'options'		=>	array(
								'light'			=> __( 'Light', 'btnsx' ),
								'dark'			=> __( 'Dark', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_colorsheme', 'value' => 'light' ) )
						),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_fb_show_faces',
						    'name'			=>	'btnsx_opt_fb_show_faces',
						    'label'			=>	__( 'Show Friends\' Faces', 'btnsx' ),
						    'tooltip'		=>	__( 'Show profile photos when 2 or more friends like this.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_show_faces', 'value' => '1' ) )
					    ),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_fb_share',
						    'name'			=>	'btnsx_opt_fb_share',
						    'label'			=>	__( 'Include Share Button', 'btnsx' ),
						    'tooltip'		=>	__( 'Includes a share button beside the like button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_share', 'value' => '0' ) )
					    ),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_fb_kid_directed_site',
						    'name'			=>	'btnsx_opt_fb_kid_directed_site',
						    'label'			=>	__( 'Kid Directed Site', 'btnsx' ),
						    'tooltip'		=>	__( 'If your web site or online service, or a portion of your service, is directed to children under 13 you must enable this.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_fb_kid_directed_site', 'value' => '0' ) )
					    )
					)
				),
				array(
					'icon_class'	=>	'fa fa-twitter',
					'text'			=>	__( 'Twitter', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_tw_type',
							'name'			=>	'btnsx_opt_tw_type',
							'placeholder'	=>	__( 'Choose button type', 'btnsx' ),
							'label'			=>	__( 'Button Type', 'btnsx' ),
							'tooltip'		=>	__( 'Select the type of Twitter button you require.', 'btnsx' ),
							'options'		=>	array(
								'tweet'			=> __( 'Tweet', 'btnsx' ),
								'follow'		=> __( 'Follow', 'btnsx' ),
								'hashtag'		=> __( 'Hashtag', 'btnsx' ),
								'mention'		=> __( 'Mention', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_type', 'value' => 'tweet' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_tw_url',
							'name'			=>	'btnsx_opt_tw_url',
							'label'			=>	__( 'URL', 'btnsx' ),
							'tooltip'		=>	__( 'URL included with the Tweet. If left empty then current page URL will be added as URL.', 'btnsx' ),
							'placeholder'	=>	__( 'https://www.twitter.com', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_url', 'value' => 'https://twitter.com' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_tw_text',
							'name'			=>	'btnsx_opt_tw_text',
							'label'			=>	__( 'Text', 'btnsx' ),
							'tooltip'		=>	__( 'Pre-populated text highlighted in the Tweet composer. If left empty then current page title will be added as text.', 'btnsx' ),
							'placeholder'	=>	__( 'Custom share text', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_text' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_tw_username',
							'name'			=>	'btnsx_opt_tw_username',
							'label'			=>	__( 'Username', 'btnsx' ),
							'tooltip'		=>	__( 'Attribute the source of a Tweet to a Twitter username.', 'btnsx' ),
							'placeholder'	=>	' ',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_username', 'value' => 'twitter' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_tw_related',
							'name'			=>	'btnsx_opt_tw_related',
							'label'			=>	__( 'Recommend', 'btnsx' ),
							'tooltip'		=>	__( 'A comma-separated list of accounts related to the content of the shared URI.', 'btnsx' ),
							'placeholder'	=>	' ',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_related' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_tw_hashtag',
							'name'			=>	'btnsx_opt_tw_hashtag',
							'label'			=>	__( 'Hashtag', 'btnsx' ),
							'tooltip'		=>	__( 'A comma-separated list of hashtags to be appended to default Tweet text. When using hashtag as button type then add only ONE hashtag if you want to see hashtag on button.', 'btnsx' ),
							'placeholder'	=>	' ',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_hashtag', 'value' => 'ButtonsX' ) )
						),
						array(
						    'type'			=>	'select',
						    'id'			=>	'btnsx_opt_tw_count',
						    'name'			=>	'btnsx_opt_tw_count',
						    'label'			=>	__( 'Count Style', 'btnsx' ),
						    'tooltip'		=>	__( 'Choose button count type.', 'btnsx' ),
						    'class'			=> 'btnsx-select',
						    'options'		=>	array(
						    	'horizontal'	=>	__( 'Horizontal', 'btnsx' ),
						    	'vertical'		=>	__( 'Vertical', 'btnsx' ),
						    	'none'			=>	__( 'None', 'btnsx' )
						    ),
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_count', 'value' => 'none' ) )
					    ),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_tw_size',
						    'name'			=>	'btnsx_opt_tw_size',
						    'label'			=>	__( 'Large Button', 'btnsx' ),
						    'tooltip'		=>	__( 'When enabled, displays a larger version of the button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_count', 'value' => '0' ) )
					    ),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_tw_dnt',
						    'name'			=>	'btnsx_opt_tw_dnt',
						    'label'			=>	__( 'Opt-out of tailoring Twitter', 'btnsx' ),
						    'tooltip'		=>	__( 'When enabled, the Tweet and its embedded page do not influence Twitter targeting including suggested accounts.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_dnt', 'value' => '1' ) )
					    ),
						array(
						    'type'			=>	'checkbox',
						    'id'			=>	'btnsx_opt_tw_screen_name',
						    'name'			=>	'btnsx_opt_tw_screen_name',
						    'label'			=>	__( 'Display Username', 'btnsx' ),
						    'tooltip'		=>	__( 'When enabled, shows the username on button.', 'btnsx' ),
						    'class'			=> 'btnsx-checkbox',
						    'value' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_tw_screen_name', 'value' => '1' ) )
					    )
					)
				),
				array(
					'icon_class'	=>	'fa fa-google-plus',
					'text'			=>	__( 'Google+', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_type',
							'name'			=>	'btnsx_opt_gp_type',
							'placeholder'	=>	__( 'Choose button type', 'btnsx' ),
							'label'			=>	__( 'Button Type', 'btnsx' ),
							'tooltip'		=>	__( 'Select the type of Twitter button you require.', 'btnsx' ),
							'options'		=>	array(
								'one'			=> __( '+1', 'btnsx' ),
								'follow'		=> __( 'Follow', 'btnsx' ),
								'share'			=> __( 'Share', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_type', 'value' => 'one' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_gp_url',
							'name'			=>	'btnsx_opt_gp_url',
							'label'			=>	__( 'URL', 'btnsx' ),
							'tooltip'		=>	__( 'URL to +1 / Share.', 'btnsx' ),
							'placeholder'	=>	__( 'http://googleplus.com', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_url' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_one_size',
							'name'			=>	'btnsx_opt_gp_one_size',
							'placeholder'	=>	__( 'Choose +1 button size', 'btnsx' ),
							'label'			=>	__( '+1 Button Size', 'btnsx' ),
							'tooltip'		=>	__( 'Select the size of button you require.', 'btnsx' ),
							'options'		=>	array(
								'small'			=> __( 'Small', 'btnsx' ),
								'medium'		=> __( 'Medium', 'btnsx' ),
								'standard'		=> __( 'Standard', 'btnsx' ),
								'tall'			=> __( 'Tall', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_one_size', 'value' => 'medium' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_one_layout',
							'name'			=>	'btnsx_opt_gp_one_layout',
							'placeholder'	=>	__( 'Choose button layout', 'btnsx' ),
							'label'			=>	__( '+1 Button Layout', 'btnsx' ),
							'tooltip'		=>	__( 'Select the style of button you require.', 'btnsx' ),
							'options'		=>	array(
								'inline'		=> __( 'Inline', 'btnsx' ),
								'bubble'		=> __( 'Bubble', 'btnsx' ),
								'none'			=> __( 'None', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_one_layout', 'value' => 'none' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_gp_user',
							'name'			=>	'btnsx_opt_gp_user',
							'label'			=>	__( 'Google+ User', 'btnsx' ),
							'tooltip'		=>	__( 'Google plus user page or profile URL.', 'btnsx' ),
							'placeholder'	=>	__( 'Page, profile or community URL', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_user', 'value' => 'https://plus.google.com/116899029375914044550' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_size',
							'name'			=>	'btnsx_opt_gp_size',
							'placeholder'	=>	__( 'Choose button size', 'btnsx' ),
							'label'			=>	__( 'Button Size', 'btnsx' ),
							'tooltip'		=>	__( 'Select the size of button you require.', 'btnsx' ),
							'options'		=>	array(
								'small'			=> __( 'Small', 'btnsx' ),
								'medium'		=> __( 'Medium', 'btnsx' ),
								'large'			=> __( 'Large', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_size', 'value' => 'medium' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_follow_layout',
							'name'			=>	'btnsx_opt_gp_follow_layout',
							'placeholder'	=>	__( 'Choose button layout', 'btnsx' ),
							'label'			=>	__( 'Follow Button Layout', 'btnsx' ),
							'tooltip'		=>	__( 'Select the style of button you require.', 'btnsx' ),
							'options'		=>	array(
								'bubble'			=> __( 'Bubble (horizontal)', 'btnsx' ),
								'vertical-bubble'	=> __( 'Bubble (vertical)', 'btnsx' ),
								'none'				=> __( 'None', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_follow_layout', 'value' => 'bubble' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_gp_share_layout',
							'name'			=>	'btnsx_opt_gp_share_layout',
							'placeholder'	=>	__( 'Choose button layout', 'btnsx' ),
							'label'			=>	__( 'Share Button Layout', 'btnsx' ),
							'tooltip'		=>	__( 'Select the style of button you require.', 'btnsx' ),
							'options'		=>	array(
								'inline'			=> __( 'Inline', 'btnsx' ),
								'bubble'			=> __( 'Bubble (horizontal)', 'btnsx' ),
								'vertical-bubble'	=> __( 'Bubble (vertical)', 'btnsx' ),
								'none'				=> __( 'None', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_share_layout', 'value' => 'bubble' ) )
						),
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_gp_width',
							'name'			=>	'btnsx_opt_gp_width',
							'label'			=>	__( 'Width', 'btnsx' ),
							'tooltip'		=>	__( 'Inline button and text width.', 'btnsx' ),
							'placeholder'	=>	' ',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_gp_width' ) )
						),
					)
				),
				array(
					'icon_class'	=>	'fa fa-linkedin',
					'text'			=>	__( 'LinkedIn', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'text',
							'id'			=>	'btnsx_opt_li_url',
							'name'			=>	'btnsx_opt_li_url',
							'label'			=>	__( 'URL', 'btnsx' ),
							'tooltip'		=>	__( 'If left blank current page URL will be shared.', 'btnsx' ),
							'placeholder'	=>	__( 'URL to to be shared (optional)', 'btnsx' ),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_li_url', 'value' => 'https://developer.linkedin.com/plugins/share' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_li_counter_type',
							'name'			=>	'btnsx_opt_li_counter_type',
							'placeholder'	=>	__( 'Choose button type', 'btnsx' ),
							'label'			=>	__( 'Button Type', 'btnsx' ),
							'tooltip'		=>	__( 'Select the type of LinkedIn share button you require.', 'btnsx' ),
							'options'		=>	array(
								'none'			=> __( 'None', 'btnsx' ),
								'right'			=> __( 'Right', 'btnsx' ),
								'top'			=> __( 'Top', 'btnsx' )
							),
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_li_counter_type', 'value' => 'none' ) )
						),
					)
				)
	        );

			// filter to add custom options
        	$btnsx_filtered_options = apply_filters( 'btnsx_social_options_filter', array(), $btnsx_default_options );
        	$btnsx_options = wp_parse_args( $btnsx_filtered_options, $btnsx_default_options );
        	$btnsx_form_design->tabs(
        		array(
        			'id'			=>	'btnsx-tabs-0',
        			'outer_group'	=>	$btnsx_options
        		)
        	);
	    }

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function preview_callback( $post ) {
	    	$btnsx_settings = array(
	    		'material_admin_theme' => false,
	    		'wp_admin_theme' => true,
	    	);
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	    	if( $btnsx_settings['material_admin_theme'] == true ) :
	        ?>
	        <!-- Material Style For Admin Page -->
	        <style>
	        	/*#poststuff h3 {
				  background-color: #ee6e73;
				  color: #fff;
				}*/
				.accordion-section-title:after, .handlediv, .item-edit, .sidebar-name-arrow, .widget-action {
				  color: #fff;
				}
				.wp-core-ui .button-primary {
				  background: #26a69a;
				  border-color: #26a69a;
				  -webkit-box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  color: #fff;
				  text-decoration: none;
				}
				.wp-core-ui .button-primary.focus, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary:hover {
				  background: #2bbbad;
				  border-color: #2bbbad;
				  -webkit-box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  color: #fff;
				}
				.btnsx-tabs nav li.tab-current a {
				  color: #ee6e73;
				}
				#all-plugins-table .plugins a.delete, #media-items a.delete, #media-items a.delete-permanently, #nav-menu-footer .menu-delete, #search-plugins-table .plugins a.delete, .plugins a.delete, .row-actions span.delete a, .row-actions span.spam a, .row-actions span.trash a, .submitbox .submitdelete {
				  color: #ee6e73;
				}
	        </style>
	        <?php
	        endif;
	        if( $btnsx_settings['wp_admin_theme'] == true ) :
	        ?>
	        <style>
	        	/*#poststuff h3 {
				  background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[2]; ?>;
				  color: #fff;
				}*/
				.accordion-section-title:after, .handlediv, .item-edit, .sidebar-name-arrow, .widget-action {
				  color: #fff;
				}
				.btnsx-tabs nav li.tab-current a {
				  color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.ball-pulse>div {
				  background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.btnsx .collapsible-header.active i {
					color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
	        </style>
	        <?php 
	        endif;
	        ?>
	        <!-- Loader -->
	        <div id="btnsx-preview-container" class="btnsx">
	        	<div id="btnsx-preview-loader" class="loader-inner ball-pulse">
	        		<div></div>
	        		<div></div>
	        		<div></div>
	        	</div>
	        	<style type="text/css" id="btnsx-preview-btn-css"></style>
	        	<div id="btnsx-fb-container" class="btnsx-social-buttons btnsx-social-fb" style="display:inline-block;float:none;"><div id="btnsx-fb" class="fb-like" data-href="https://developers.facebook.com/docs/plugins/" data-layout="standard" data-action="like" data-show-faces="true" data-share="true"></div></div>
	        	<div id="btnsx-twitter-container" class="btnsx-social-buttons btnsx-social-tw" style="display:inline-block;float:none;"><a id="btnsx-tw" href="https://twitter.com/share" class="twitter-share-button" data-url="https://twitter.com" data-dnt="true"><?php _e( 'Tweet', 'btnsx' ); ?></a></div>
	        	<div id="btnsx-linkedin-container" class="btnsx-social-buttons btnsx-social-li" style="display:inline-block;float:none;"><script type="IN/Share" data-url="https://developer.linkedin.com/plugins/share" data-counter="right"></script></div>
	        	<div id="btnsx-googleplus-container" class="btnsx-social-buttons btnsx-social-gp" style="display:inline-block;float:none;"><div id="btnsx-gp" class="g-plusone" data-size="medium" data-annotation="inline"></div></div>
	        </div>
	       	
	    	<?php
	    }

	    /**
		* Adds the meta box container.
		* @since 0.1
		*/
		public function register_meta_boxes() {
			$screens = array( 'buttons-x-social' );
			foreach ( $screens as $screen ) {
			    add_meta_box(
			        'btnsx-preview',
			        __( 'Live Preview', 'btnsx' ),
			        array( $this, 'preview_callback' ),
			        $screen,
			        'normal',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-options',
			        __( 'Buttons X Options Panel', 'btnsx' ),
			        array( $this, 'options_callback' ),
			        $screen,
			        'normal',
			        'core'
			    );
			    add_meta_box(
			        'btnsx-shortcode',
			        __( 'Buttons X - Short Code', 'btnsx' ),
			        array( $this, 'shortcode_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			}
			global $btnsx_settings;
			$posts = isset( $btnsx_settings['social'] ) ? $btnsx_settings['social'] : '';
			if( isset( $btnsx_settings['social'] ) ) {
				foreach ( $posts as $post ) {
				    add_meta_box(
				        'btnsx-social',
				        __( 'Buttons X - Social Buttons', 'btnsx' ),
				        array( $this, 'post_metabox_callback' ),
				        $post,
				        'side',
				        'low'
				    );
				}
			}
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function shortcode_callback( $post ) {
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	        echo '<p style="font-weight:bold;color:'.$_wp_admin_css_colors[$current_color]->colors[2].';">[btnsx_social id="'.$post->ID.'"]</p>';
	    }

	    /**
         * Register custom taxonomies for button post type
         * @since  0.1
         * @return 
         */
        public function register_taxonomies() {
		    // Add new taxonomy, make it hierarchical (like categories)
		    $labels = array(
		        'name' 				=> _x( 'Packs', 'btnsx' ),
		        'singular_name' 	=> _x( 'Pack', 'btnsx' ),
		        'search_items' 		=> __( 'Search Pack', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Pack', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Pack:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Pack', 'btnsx' ),
		        'update_item' 		=> __( 'Update Pack', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Pack', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Pack Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Packs', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> true,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'rewrite' 			=> array( 'slug' => 'btnsx_social_pack' ),
		    );
		    register_taxonomy( 'btnsx_social_pack', array( 'buttons-x-social' ), $args );
		    // Add new taxonomy, not hierarchical (like tags)
		    $labels = array(
		        'name' 				=> _x( 'Tags', 'btnsx' ),
		        'singular_name' 	=> _x( 'Tag', 'btnsx' ),
		        'search_items' 		=> __( 'Search Tag', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Tag', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Tag:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Tag', 'btnsx' ),
		        'update_item' 		=> __( 'Update Tag', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Tag', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Tag Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Tags', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> false,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'rewrite' 			=> array( 'slug' => 'btnsx_social_tag' ),
		    );
		    register_taxonomy( 'btnsx_social_tag', array( 'buttons-x-social' ), $args );
		}

	    /**
        * Register the menu for the Dashboard.
        * @since 0.1
        */
        public function register_cpt() {
    		//	global $btnsx_settings;

            if( isset( $btnsx_settings['social_menu_name'] ) ){
                $button_menu_name = $btnsx_settings['social_menu_name'];
            } else {
                $button_menu_name = __('Social Buttons', 'admin menu', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_singular'] ) ){
                $button_name_singular = $btnsx_settings['social_name_singular'];
            } else {
                $button_name_singular = __('Social Button', 'post type singular name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_plural'] ) ){
                $button_name_plural = $btnsx_settings['social_name_plural'];
            } else {
                $button_name_plural = __('Social Buttons', 'post type general name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_admin_bar_name'] ) ){
                $button_admin_bar_name = $btnsx_settings['social_admin_bar_name'];
            } else {
                $button_admin_bar_name = __('Social Button', 'add new on admin bar', 'btnsx');
            }

            // Register buttons post
            register_post_type( 'buttons-x-social',
                array(
                    'labels' => array(
                        'name' => $button_name_plural,
                        'singular_name' => $button_name_singular,
                        'menu_name' => $button_menu_name,
                        'name_admin_bar' => $button_admin_bar_name,
                        'add_new' => _x('Add New', $button_name_singular, 'btnsx'),
                        'add_new_item' => __('Add New ', 'btnsx') . $button_name_singular,
                        'new_item' => __('New ', 'btnsx') . $button_name_singular,
                        'edit_item' => __('Edit ', 'btnsx') . $button_name_singular,
                        'view_item' => __('View ', 'btnsx') . $button_name_singular,
                        'all_items' => $button_name_plural,
                        'search_items' => __('Search ', 'btnsx') . $button_name_plural,
                        'parent_item_colon' => __('Parent ', 'btnsx') . $button_name_plural . ':',
                        'not_found' => __('No ', 'btnsx') . $button_name_plural . __(' found.', 'btnsx'),
                        'not_found_in_trash' => __('No ', 'btnsx') . $button_name_plural . __(' found in Trash.', 'btnsx'),
                    ),
                    'public'                => false,
                    'show_ui'				=> true,
                    'exclude_from_search'   => true,
                    'publicly_queryable'    => false,
                    'has_archive'           => false,
                    'menu_position'         => 80,
                    'show_in_admin_bar'     => true,
                    'show_in_nav_menus'		=> true,
                    'show_in_menu'			=> 'btnsx',
                    'supports'              => array( 'title', 'btnsx_pack', 'btnsx_tag' ),
                    'menu_icon'				=> 'dashicons-btnsx-logo'
                )
            );
        }

	} // Main Class

}

/**
 *  Kicking this off
 */

$btn = new Btnsx_Social_Counter();
$btn->init();