<?php

	function vc_btnsx_buttons( $settings, $value, $post_type ) {
		// $dependency = vc_generate_dependencies_attributes( $settings );
	   	global $wpdb;
	   	$btnsx_post = $post_type;
		$btnsx_post_status = 'publish';
        $btnsx = $wpdb->get_results( $wpdb->prepare(
            "SELECT ID, post_title
                FROM $wpdb->posts 
                WHERE $wpdb->posts.post_type = %s
                AND $wpdb->posts.post_status = %s
                ORDER BY ID DESC",
            $btnsx_post,
            $btnsx_post_status
        ) );

	   $param_line = '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value dropdown wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '">';
		foreach ( $btnsx as $btn ) {
			$selected = '';
			$btn_id = $btn->ID;
			if ( $btn_id == $value ) $selected = ' selected="selected"';
			$btn_name = $btn->post_title;
			$param_line .= '<option value="' . $btn_id . '"' . $selected . '>' . $btn_name . '</option>';
		}
		$param_line .= '</select>';

	   return $param_line;
	}

	// create custom param
	function btnsx_settings_field( $settings, $value ) {
	   	$output = vc_btnsx_buttons( $settings, $value, 'buttons-x' );
	   	return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx', 'btnsx_settings_field' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx', 'btnsx_settings_field' );
	}

	// create custom param for dual buttons
	function btnsx_dual_settings_field( $settings, $value ) {
	   	$output = vc_btnsx_buttons( $settings, $value, 'buttons-x-dual' );
	   	return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_dual', 'btnsx_dual_settings_field' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_dual', 'btnsx_dual_settings_field' );
	}

	// create custom param for dual buttons
	function btnsx_social_settings_field( $settings, $value ) {
	   	$output = vc_btnsx_buttons( $settings, $value, 'buttons-x-social' );
	   	return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_social', 'btnsx_social_settings_field' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_social', 'btnsx_social_settings_field' );
	}

	// create custom param for social counter buttons
	function btnsx_social_counters_settings_field( $settings, $value ) {
	   	$output = vc_btnsx_buttons( $settings, $value, 'buttons-x-cs' );
	   	return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_social_counter', 'btnsx_social_counters_settings_field' );
	}

	// create parameter for post related options
	function btnsx_vc_post_options( $settings, $value ) {
		// $dependency = vc_generate_dependencies_attributes( $settings );
		$btnsx_vc = new BtnsxFormElements();
		$output = '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value dropdown wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '">';
		$output .= '<option value="">' . __( 'Default', 'btnsx' ) . '</option>';
		$output .= $btnsx_vc->post_links( $value );
		$output .= '</select>';

		return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_post_options', 'btnsx_vc_post_options' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_post_options', 'btnsx_vc_post_options' );
	}

	// create parameter for menu related options
	function btnsx_vc_edd_options( $settings, $value ) {
		// $dependency = vc_generate_dependencies_attributes( $settings );
		$btnsx_vc = new BtnsxFormElements();
		$output = '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value dropdown wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '">';
		$output .= '<option value="">' . __( 'Default', 'btnsx' ) . '</option>';
		$output .= $btnsx_vc->edd_product_ids( $value );
		$output .= '</select>';

		return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_edd_options', 'btnsx_vc_edd_options' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_edd_options', 'btnsx_vc_edd_options' );
	}

	// create parameter for WooCommerce related options
	function btnsx_vc_woo_options( $settings, $value ) {
		// $dependency = vc_generate_dependencies_attributes( $settings );
		$btnsx_vc = new BtnsxFormElements();
		$output = '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value dropdown wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '">';
		$output .= '<option value="">' . __( 'Default', 'btnsx' ) . '</option>';
		$output .= $btnsx_vc->woocommerce_product_ids( $value );
		$output .= '</select>';

		return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_woo_options', 'btnsx_vc_woo_options' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_woo_options', 'btnsx_vc_woo_options' );
	}

	// create parameter for post related options
	function btnsx_vc_popup_maker_options( $settings, $value ) {
		// $dependency = vc_generate_dependencies_attributes( $settings );
		$btnsx_vc = new BtnsxFormElements();
		$output = '<select name="' . $settings['param_name'] . '" class="wpb_vc_param_value dropdown wpb-input wpb-select ' . $settings['param_name'] . ' ' . $settings['type'] . '">';
		$output .= '<option value="">' . __( 'Default', 'btnsx' ) . '</option>';
		$output .= $btnsx_vc->cpt_html( 'popup', $value );
		$output .= '</select>';

		return $output;
	}
	if( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'btnsx_popup_maker_options', 'btnsx_vc_popup_maker_options' );
	}
	if( function_exists( 'add_shortcode_param' ) ) {
		// add_shortcode_param( 'btnsx_popup_maker_options', 'btnsx_vc_popup_maker_options' );
	}

	$btnsx_vc_menus = get_terms('nav_menu'); $options = array();
	$btnsx_vc_menu_options[ '' ] = __( 'Default', 'btnsx' );
	foreach( $btnsx_vc_menus as $menu ){
		$btnsx_vc_menu_options[ $menu->name ] = $menu->name;
	}

	$btnsx_vc_default_options = array(
		array(
			'type' => 'btnsx',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Button', 'btnsx'),
			'param_name' => 'id',
			'value' => '',
			'description' => __( 'Select the desired button.', 'btnsx' )
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Text', 'btnsx'),
			'param_name' => 'text',
			'value' => '',
			'description' => __( 'Override button text parameter.', 'btnsx' )
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Custom CSS Class', 'btnsx'),
			'param_name' => 'class',
			'value' => '',
			'description' => __( 'Add custom class.', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Target', 'btnsx'),
			'param_name' => 'link_target',
			'value' => array_flip( array(
				''				=> __( 'Default', 'btnsx' ),
				'new_window'	=> __( 'New Window', 'btnsx' ),
				'same_window'	=> __( 'Same Window', 'btnsx' ),
				'iframe'		=> __( 'Iframe', 'btnsx' ),
			) ),
			'description' => __( 'Override button link target parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Relationship', 'btnsx'),
			'param_name' => 'link_relationship',
			'value' => array_flip( array(
				''				=> __( 'None', 'btnsx' ),
				'alternate'		=> __( 'Alternate', 'btnsx' ),
				'author'		=> __( 'Author', 'btnsx' ),
				'bookmark'		=> __( 'Bookmark', 'btnsx' ),
				'help'			=> __( 'Help', 'btnsx' ),
				'license'		=> __( 'License', 'btnsx' ),
				'next'			=> __( 'Next', 'btnsx' ),
				'nofollow'		=> __( 'Nofollow', 'btnsx' ),
				'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
				'prefetch'		=> __( 'Prefetch', 'btnsx' ),
				'prev'			=> __( 'Previous', 'btnsx' ),
				'search'		=> __( 'Search', 'btnsx' ),
				'tag'			=> __( 'Tag', 'btnsx' )
			) ),
			'description' => __( 'Override button link relationship parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Type', 'btnsx'),
			'param_name' => 'link_type',
			'value' => array_flip( array(
				''										=> __( 'Default', 'btnsx' ),
				'none'									=> __( 'None', 'btnsx' ),
				'admin_page'							=> __( 'Admin Page', 'btnsx' ),
				'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
				'buffer_share'							=> __( 'Buffer Share', 'btnsx' ),
				'delicious_share'						=> __( 'Delicious Share', 'btnsx' ),
				'digg_share'							=> __( 'Digg Share', 'btnsx' ),
				'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
				'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
				'evernote_share'						=> __( 'Evernote Share', 'btnsx' ),
				'facebook_share'						=> __( 'Facebook Share', 'btnsx' ),
				'google_share'							=> __( 'Google+ Share', 'btnsx' ),
				'google_bookmarks_share'				=> __( 'Google Bookmarks Share', 'btnsx' ),
				'home_page'								=> __( 'Home Page', 'btnsx' ),
				'linkedin_share'						=> __( 'LinkedIn Share', 'btnsx' ),
				'login'									=> __( 'Login Page', 'btnsx' ),
				'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
				'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
				'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
				'logout'								=> __( 'Logout Page', 'btnsx' ),
				'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
				'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
				'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
				'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
				'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
				'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
				'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
				'mailto'								=> __( 'Mail To', 'btnsx' ),
				'menu'									=> __( 'Menu', 'btnsx' ),
				'newsvine_share'						=> __( 'Newsvine Share', 'btnsx' ),
				'next_post'								=> __( 'Next Post', 'btnsx' ),
				'pinterest_share'						=> __( 'Pinterest Share', 'btnsx' ),
				'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
				'previous_page'							=> __( 'Previous Page', 'btnsx' ),
				'previous_post'							=> __( 'Previous Post', 'btnsx' ),
				'print'									=> __( 'Print', 'btnsx' ),
				'reddit_share'							=> __( 'Reddit Share', 'btnsx' ),
				'register'								=> __( 'Registration Page', 'btnsx' ),
				// 'slashdot_share'						=> __( 'Slashdot Share', 'btnsx' ),
				'skype_call'							=> __( 'Skype Call', 'btnsx' ),
				'skype_chat'							=> __( 'Skype Chat', 'btnsx' ),
				'skype_video_call'						=> __( 'Skype Video Call', 'btnsx' ),
				'sms'									=> __( 'SMS', 'btnsx' ),
				'stumbleupon_share'						=> __( 'StumbleUpon Share', 'btnsx' ),
				'tel'									=> __( 'Telephone', 'btnsx' ),
				'tumblr_share'							=> __( 'Tumblr Share', 'btnsx' ),
				'twitter_share'							=> __( 'Twitter Share', 'btnsx' ),
				'url'									=> __( 'URL', 'btnsx' ),
				'whatsapp_share'						=> __( 'Whatsapp Share', 'btnsx' ),
				'woocommerce_add_to_cart'				=> __( 'Woocommerce - Add to Cart', 'btnsx' ),
				'woocommerce_add_to_cart_auto_id'		=> __( 'Woocommerce - Add to Cart - Auto ID', 'btnsx' ),
			) ),
			'description' => __( 'Override button link parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' )
		),
		array(
			'type' => 'btnsx_post_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Post/Page/CPT', 'btnsx'),
			'param_name' => 'link_post',
			'description' => __( 'Override button link post parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'post'
			)
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Menu as Dropdown', 'btnsx'),
			'param_name' => 'link_menu',
			'value' => array_flip(
				$btnsx_vc_menu_options
			),
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'menu'
			)
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Menu Display', 'btnsx'),
			'param_name' => 'link_menu_display',
			'value' => array_flip( array(
				''			=> __( 'Default', 'btnsx' ),
				'on_click'	=> __( 'On Click', 'btnsx' ),
				'on_hover'	=> __( 'On Hover', 'btnsx' )
			) ),
			'description' => __( 'Override button link menu display parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'menu'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('URL', 'btnsx'),
			'param_name' => 'link',
			'value' => '',
			'description' => __( 'Override button URL parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'url'
			)
		),
		array(
			'type' => 'btnsx_edd_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('EDD Download ID', 'btnsx'),
			'param_name' => 'link_edd_id',
			'value' => '',
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'edd_checkout', 'edd_straight_to_gateway' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Redirect URL', 'btnsx'),
			'param_name' => 'link_redirect_url',
			'value' => '',
			'description' => __( 'Override button redirect URL parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'login_redirect_custom_page', 'logout_redirect_custom_page', 'lost_password_redirect_custom_page' )
			)
		),
		array(
			'type' => 'btnsx_woo_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('WooCommerce Product ID', 'btnsx'),
			'param_name' => 'link_woocommerce_id',
			'value' => '',
			'description' => __( 'Override WooCommerce product id parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'woocommerce_add_to_cart'
			)
		),
		array(
			'type' => 'btnsx_popup_maker_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Popup Maker', 'btnsx'),
			'param_name' => 'link_popup_maker',
			'description' => __( 'Override button link popup maker parameter.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => 'popup_maker'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Iframe Width', 'btnsx'),
			'param_name' => 'link_frame_width',
			'value' => '',
			'description' => __( 'Define iframe width in pixels.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_target',
				'value' => array( 'iframe' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Iframe Height', 'btnsx'),
			'param_name' => 'link_frame_height',
			'value' => '',
			'description' => __( 'Define iframe height in pixels.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_target',
				'value' => array( 'iframe' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Email', 'btnsx'),
			'param_name' => 'link_email',
			'value' => '',
			'description' => __( 'Add email address where the user should send email.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'mailto' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Email Subject', 'btnsx'),
			'param_name' => 'link_email_subject',
			'value' => '',
			'description' => __( 'Add subject for the email.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'mailto' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Skype ID', 'btnsx'),
			'param_name' => 'link_skype_id',
			'value' => '',
			'description' => __( 'Add your Skype ID.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'skype_call','skype_chat','skype_video_call' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Telephone Number', 'btnsx'),
			'param_name' => 'link_telephone',
			'value' => '',
			'description' => __( 'Add telephone number to be used for call or sms.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'sms' )
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('SMS', 'btnsx'),
			'param_name' => 'link_sms_content',
			'value' => '',
			'description' => __( 'Add content to be used for SMS.', 'btnsx' ),
			'group' => __( 'Link', 'btnsx' ),
			'dependency' => array( 
				'element' => 'link_type',
				'value' => array( 'sms' )
			)
		),
		array(
			'type' => 'checkbox',
			'class' => 'btnsx-vc-span',
			'heading' => __('Full Width', 'btnsx'),
			'param_name' => 'full_width',
			'value' => array_flip( array(
				'0'	=> __( 'No', 'btnsx' ),
				'1'	=> __( 'Yes', 'btnsx' ),
			) ),
			'description' => __( 'Override button full width parameter.', 'btnsx' ),
			'group' => __( 'Layout', 'btnsx' )
		),
		array(
			'type' => 'checkbox',
			'class' => 'btnsx-vc-span',
			'heading' => __('Wrap Center', 'btnsx'),
			'param_name' => 'wrap_center',
			'value' => array_flip( array(
				'0'	=> __( 'No', 'btnsx' ),
				'1'	=> __( 'Yes', 'btnsx' ),
			) ),
			'description' => __( 'Override button wrap center parameter.', 'btnsx' ),
			'group' => __( 'Layout', 'btnsx' )
		)
  	);

	$btnsx_vc_dual_default_options = array(
		array(
			'type' => 'btnsx_dual',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Button', 'btnsx'),
			'param_name' => 'id',
			'value' => '',
			'description' => __( 'Select the desired button.', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Target', 'btnsx'),
			'param_name' => 'button_first_link_target',
			'value' => array_flip( array(
				''				=> __( 'Default', 'btnsx' ),
				'new_window'	=> __( 'New Window', 'btnsx' ),
				'same_window'	=> __( 'Same Window', 'btnsx' ),
			) ),
			'description' => __( 'Override button link target parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Relationship', 'btnsx'),
			'param_name' => 'button_first_link_relationship',
			'value' => array_flip( array(
				''				=> __( 'None', 'btnsx' ),
				'alternate'		=> __( 'Alternate', 'btnsx' ),
				'author'		=> __( 'Author', 'btnsx' ),
				'bookmark'		=> __( 'Bookmark', 'btnsx' ),
				'help'			=> __( 'Help', 'btnsx' ),
				'license'		=> __( 'License', 'btnsx' ),
				'next'			=> __( 'Next', 'btnsx' ),
				'nofollow'		=> __( 'Nofollow', 'btnsx' ),
				'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
				'prefetch'		=> __( 'Prefetch', 'btnsx' ),
				'prev'			=> __( 'Previous', 'btnsx' ),
				'search'		=> __( 'Search', 'btnsx' ),
				'tag'			=> __( 'Tag', 'btnsx' )
			) ),
			'description' => __( 'Override button link relationship parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link', 'btnsx'),
			'param_name' => 'button_first_link_type',
			'value' => array_flip( array(
				''										=> __( 'Default', 'btnsx' ),
				'admin_page'							=> __( 'Admin Page', 'btnsx' ),
				'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
				'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
				'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
				'home_page'								=> __( 'Home Page', 'btnsx' ),
				'login'									=> __( 'Login Page', 'btnsx' ),
				'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
				'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
				'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
				'logout'								=> __( 'Logout Page', 'btnsx' ),
				'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
				'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
				'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
				'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
				'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
				'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
				'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
				'menu'									=> __( 'Menu', 'btnsx' ),
				'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
				'register'								=> __( 'Registration Page', 'btnsx' ),
				'url'									=> __( 'URL', 'btnsx' ),
				'woocommerce_add_to_cart'				=> __( 'Woocommerce -  Add to Cart', 'btnsx' )
			) ),
			'description' => __( 'Override button link parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' )
		),
		array(
			'type' => 'btnsx_post_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Post/Page/CPT', 'btnsx'),
			'param_name' => 'button_first_link_post',
			'description' => __( 'Override button link target parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => 'post'
			)
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Menu as Dropdown', 'btnsx'),
			'param_name' => 'button_first_link_menu',
			'value' => array_flip(
				$btnsx_vc_menu_options
			),
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => 'menu'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('URL', 'btnsx'),
			'param_name' => 'button_first_link',
			'value' => '',
			'description' => __( 'Override button URL parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => 'url'
			)
		),
		array(
			'type' => 'btnsx_edd_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('EDD Download ID', 'btnsx'),
			'param_name' => 'button_first_link_edd_id',
			'value' => '',
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => 'edd_checkout'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Redirect URL', 'btnsx'),
			'param_name' => 'button_first_link_redirect_url',
			'value' => '',
			'description' => __( 'Override button redirect URL parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => array( 'login_redirect_custom_page', 'logout_redirect_custom_page', 'lost_password_redirect_custom_page' )
			)
		),
		array(
			'type' => 'btnsx_woo_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('WooCommerce Product ID', 'btnsx'),
			'param_name' => 'button_first_link_woocommerce_id',
			'value' => '',
			'description' => __( 'Override WooCommerce product id parameter.', 'btnsx' ),
			'group' => __( 'First Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_first_link_type',
				'value' => 'woocommerce_add_to_cart'
			)
		),

		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Target', 'btnsx'),
			'param_name' => 'button_second_link_target',
			'value' => array_flip( array(
				''				=> __( 'Default', 'btnsx' ),
				'new_window'	=> __( 'New Window', 'btnsx' ),
				'same_window'	=> __( 'Same Window', 'btnsx' ),
			) ),
			'description' => __( 'Override button link target parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link Relationship', 'btnsx'),
			'param_name' => 'button_second_link_relationship',
			'value' => array_flip( array(
				''				=> __( 'None', 'btnsx' ),
				'alternate'		=> __( 'Alternate', 'btnsx' ),
				'author'		=> __( 'Author', 'btnsx' ),
				'bookmark'		=> __( 'Bookmark', 'btnsx' ),
				'help'			=> __( 'Help', 'btnsx' ),
				'license'		=> __( 'License', 'btnsx' ),
				'next'			=> __( 'Next', 'btnsx' ),
				'nofollow'		=> __( 'Nofollow', 'btnsx' ),
				'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
				'prefetch'		=> __( 'Prefetch', 'btnsx' ),
				'prev'			=> __( 'Previous', 'btnsx' ),
				'search'		=> __( 'Search', 'btnsx' ),
				'tag'			=> __( 'Tag', 'btnsx' )
			) ),
			'description' => __( 'Override button link relationship parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Link', 'btnsx'),
			'param_name' => 'button_second_link_type',
			'value' => array_flip( array(
				''										=> __( 'Default', 'btnsx' ),
				'admin_page'							=> __( 'Admin Page', 'btnsx' ),
				'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
				'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
				'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
				'home_page'								=> __( 'Home Page', 'btnsx' ),
				'login'									=> __( 'Login Page', 'btnsx' ),
				'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
				'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
				'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
				'logout'								=> __( 'Logout Page', 'btnsx' ),
				'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
				'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
				'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
				'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
				'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
				'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
				'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
				'menu'									=> __( 'Menu', 'btnsx' ),
				'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
				'register'								=> __( 'Registration Page', 'btnsx' ),
				'url'									=> __( 'URL', 'btnsx' ),
				'woocommerce_add_to_cart'				=> __( 'Woocommerce -  Add to Cart', 'btnsx' )
			) ),
			'description' => __( 'Override button link parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' )
		),
		array(
			'type' => 'btnsx_post_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Post/Page/CPT', 'btnsx'),
			'param_name' => 'button_second_link_post',
			'description' => __( 'Override button link target parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => 'post'
			)
		),
		array(
			'type' => 'dropdown',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Menu as Dropdown', 'btnsx'),
			'param_name' => 'button_second_link_menu',
			'value' => array_flip(
				$btnsx_vc_menu_options
			),
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => 'menu'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('URL', 'btnsx'),
			'param_name' => 'button_second_link',
			'value' => '',
			'description' => __( 'Override button URL parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => 'url'
			)
		),
		array(
			'type' => 'btnsx_edd_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('EDD Download ID', 'btnsx'),
			'param_name' => 'button_second_link_edd_id',
			'value' => '',
			'description' => __( 'Override button menu parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => 'edd_checkout'
			)
		),
		array(
			'type' => 'textfield',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('Redirect URL', 'btnsx'),
			'param_name' => 'button_second_link_redirect_url',
			'value' => '',
			'description' => __( 'Override button redirect URL parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => array( 'login_redirect_custom_page', 'logout_redirect_custom_page', 'lost_password_redirect_custom_page' )
			)
		),
		array(
			'type' => 'btnsx_woo_options',
			'holder' => 'span',
			'class' => 'btnsx-vc-span',
			'heading' => __('WooCommerce Product ID', 'btnsx'),
			'param_name' => 'button_second_link_woocommerce_id',
			'value' => '',
			'description' => __( 'Override WooCommerce product id parameter.', 'btnsx' ),
			'group' => __( 'Second Button', 'btnsx' ),
			'dependency' => array( 
				'element' => 'button_second_link_type',
				'value' => 'woocommerce_add_to_cart'
			)
		)
  	);

	$btnsx_vc_filtered_options = apply_filters( 'btnsx_vc_options', array(), $btnsx_vc_default_options );
    $btnsx_vc_options = wp_parse_args( $btnsx_vc_filtered_options, $btnsx_vc_default_options );

	// create element
	vc_map( array(
	    'name' 						=> __( 'Buttons X', 'btnsx' ),
	  	'base'						=> 'btnsx',
	  	'content_element' 			=> true,
    	'show_settings_on_create' 	=> true,
	  	'class' 					=> 'btnsx-vc',
	  	'controls' 					=> 'full',
	  	'icon' 						=> 'icon-wpb-vc_extend',
	  	'category' 					=> __( 'Buttons X', 'btnsx' ),
	  	'admin_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
	  	'admin_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
	  	'front_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
	  	'front_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
	  	'params' 					=> $btnsx_vc_options,
	  	'custom_markup' 			=> '',
	  	'js_view' 					=> 'BtnsxView'
	));

	global $btnsx_settings;
	if( isset( $btnsx_settings['dual_buttons'] ) && $btnsx_settings['dual_buttons'] === '1' ) {
		vc_map( array(
		    'name' 						=> __( 'Buttons X Dual', 'btnsx' ),
		  	'base'						=> 'btnsx_dual',
		  	'content_element' 			=> true,
	    	'show_settings_on_create' 	=> true,
		  	'class' 					=> 'btnsx-vc',
		  	'controls' 					=> 'full',
		  	'icon' 						=> 'icon-wpb-vc_extend',
		  	'category' 					=> __( 'Buttons X', 'btnsx' ),
		  	'admin_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'admin_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'front_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'front_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'params' 					=> $btnsx_vc_dual_default_options,
		  	'custom_markup' 			=> '',
		  	'js_view' 					=> 'BtnsxView'
		));
	}
	if( isset( $btnsx_settings['social_buttons'] ) && $btnsx_settings['social_buttons'] === '1' ) {
		vc_map( array(
		    'name' 						=> __( 'Buttons X Social', 'btnsx' ),
		  	'base'						=> 'btnsx_social',
		  	'content_element' 			=> true,
	    	'show_settings_on_create' 	=> true,
		  	'class' 					=> 'btnsx-vc',
		  	'controls' 					=> 'full',
		  	'icon' 						=> 'icon-wpb-vc_extend',
		  	'category' 					=> __( 'Buttons X', 'btnsx' ),
		  	'admin_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'admin_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'front_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'front_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'params' 					=> array(
				array(
					'type' => 'btnsx_social',
					'holder' => 'span',
					'class' => 'btnsx-vc-span',
					'heading' => __('Button', 'btnsx'),
					'param_name' => 'id',
					'value' => '',
					'description' => __( 'Select the desired button.', 'btnsx' )
				)
		  	),
		  	'custom_markup' 			=> '',
		  	'js_view' 					=> 'BtnsxView'
		));
	}
	if( isset( $btnsx_settings['social_counters'] ) && $btnsx_settings['social_counters'] === '1' ) {
		vc_map( array(
		    'name' 						=> __( 'Buttons X Counters', 'btnsx' ),
		  	'base'						=> 'btnsx_social_counter',
		  	'content_element' 			=> true,
	    	'show_settings_on_create' 	=> true,
		  	'class' 					=> 'btnsx-vc',
		  	'controls' 					=> 'full',
		  	'icon' 						=> 'icon-wpb-vc_extend',
		  	'category' 					=> __( 'Buttons X', 'btnsx' ),
		  	'admin_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'admin_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'front_enqueue_js' 			=> array( plugins_url( '../assets/vc_btnsx.js' , __FILE__ ) ),
		  	'front_enqueue_css' 		=> array( plugins_url( '../assets/vc_btnsx.css' , __FILE__ ) ),
		  	'params' 					=> array(
				array(
					'type' => 'btnsx_social_counter',
					'holder' => 'span',
					'class' => 'btnsx-vc-span',
					'heading' => __('Button', 'btnsx'),
					'param_name' => 'id',
					'value' => '',
					'description' => __( 'Select the desired button.', 'btnsx' )
				)
		  	),
		  	'custom_markup' 			=> '',
		  	'js_view' 					=> 'BtnsxView'
		));
	}

?>