<?php

/**
 * @class FLExampleModule
 */
class FLBtnsxModule extends FLBuilderModule {

    /** 
     * Constructor function for the module. You must pass the
     * name, description, dir and url in an array to the parent class.
     *
     * @method __construct
     */  
    public function __construct()
    {
        parent::__construct(array(
            'name'          => __('Buttons X', 'btnsx'),
            'description'   => __('A button module.', 'btnsx'),
            'category'		=> __('Advanced Modules', 'btnsx'),
            'dir'           => BTNSX__PLUGIN_DIR . 'builders/beaver-builder/',
            'url'           => BTNSX__PLUGIN_URL . 'builders/beaver-builder/',
            'editor_export' => true, // Defaults to true and can be omitted.
            'enabled'       => true, // Defaults to true and can be omitted.
        ));
        
        /** 
         * Use these methods to enqueue css and js already
         * registered or to register and enqueue your own.
         */
        // Already registered
        // $this->add_css('font-awesome');
    }

    /** 
     * Use this method to work with settings data before 
     * it is saved. You must return the settings object. 
     *
     * @method update
     * @param $settings {object}
     */      
    public function update($settings)
    {
        return $settings;
    }

    /** 
     * This method will be called by the builder
     * right before the module is deleted. 
     *
     * @method delete
     */      
    public function delete()
    {
    
    }

}

$fl_btnsx_form = new BtnsxFormElements();

$menus = get_terms('nav_menu'); 
$menu_opts = array();
foreach( $menus as $menu ){
    $menu_opts[ $menu->name ] = $menu->name;
}

/**
 * Register the module and its form settings.
 */
FLBuilder::register_module('FLBtnsxModule', array(
    'general'       => array( // Tab
        'title'         => __('General', 'btnsx'), // Tab title
        'sections'      => array( // Tab Sections
            'general'       => array( // Section
                'title'         => '', // Section Title
                'fields'        => array( // Section Fields
                    '_id' => array(
                        'type'          => 'select',
                        'label'         => __('Button', 'fl-builder'),
                        'options'       => $fl_btnsx_form->cpt( 'buttons-x', '' ),
                        'help'          => __('Select a button.', 'btnsx')
                    ),
                    '_class'     => array(
                        'type'          => 'text',
                        'label'         => __('Custom CSS Class', 'btnsx'),
                        'help'          => __('Add custom class to button.', 'btnsx')
                    ),
                )
            )
        )
    ),
    'primary_text'       => array( // Tab
        'title'         => __('Primary Text', 'btnsx'), // Tab title
        'sections'      => array( // Tab Sections
            'general'       => array( // Section
                'fields'        => array( // Section Fields
                    '_text'     => array(
                        'type'          => 'text',
                        'label'         => __('Text', 'btnsx'),
                        'help'          => __('Add main button text.', 'btnsx')
                    ),
                )
            )
        )
    ),
    'link'       => array( // Tab
        'title'         => __('Link', 'btnsx'), // Tab title
        'sections'      => array( // Tab Sections
            'general'       => array( // Section
                'fields'        => array( // Section Fields
                    '_link_target'     => array(
                        'type'          => 'select',
                        'label'         => __('Link Target', 'btnsx'),
                        'help'          => __('Where would you like to open the new link? New window or Same Window?', 'btnsx'),
                        'options'        => array(
                            ''              => __( 'Default', 'btnsx' ),
                            'new_window'    => __( 'New Window', 'btnsx' ),
                            'same_window'   => __( 'Same Window', 'btnsx' ),
                            'iframe'        => __( 'Iframe', 'btnsx' ),
                        ),
                        'toggle'        => array(
                            'iframe'      => array(
                                'fields'        => array('_link_frame_width','_link_frame_height')
                            ),
                        )
                    ),
                    '_link_relationship'     => array(
                        'type'          => 'select',
                        'label'         => __('Link Relationship', 'btnsx'),
                        'help'          => __('Override button link relationship parameter.', 'btnsx'),
                        'options'        => array(
                           ''               => __( 'None', 'btnsx' ),
                            'alternate'     => __( 'Alternate', 'btnsx' ),
                            'author'        => __( 'Author', 'btnsx' ),
                            'bookmark'      => __( 'Bookmark', 'btnsx' ),
                            'help'          => __( 'Help', 'btnsx' ),
                            'license'       => __( 'License', 'btnsx' ),
                            'next'          => __( 'Next', 'btnsx' ),
                            'nofollow'      => __( 'Nofollow', 'btnsx' ),
                            'noreferrer'    => __( 'No Referrer', 'btnsx' ),
                            'prefetch'      => __( 'Prefetch', 'btnsx' ),
                            'prev'          => __( 'Previous', 'btnsx' ),
                            'search'        => __( 'Search', 'btnsx' ),
                            'tag'           => __( 'Tag', 'btnsx' )
                        ),
                    ),
                    '_link_type'     => array(
                        'type'          => 'select',
                        'label'         => __('Link Type', 'btnsx'),
                        'help'          => __( 'Choose the type of link required for the button.', 'btnsx' ),
                        'options'        => array(
                            'none'                                  => __( 'None', 'btnsx' ),
                            'admin_page'                            => __( 'Admin Page', 'btnsx' ),
                            'back_to_top'                           => __( 'Back To Top', 'btnsx' ),
                            'buffer_share'                          => __( 'Buffer Share', 'btnsx' ),
                            'delicious_share'                       => __( 'Delicious Share', 'btnsx' ),
                            'digg_share'                            => __( 'Digg Share', 'btnsx' ),
                            'edd_checkout'                          => __( 'EDD - Checkout', 'btnsx' ),
                            'edd_straight_to_gateway'               => __( 'EDD - Straight to Gateway', 'btnsx' ),
                            'evernote_share'                        => __( 'Evernote Share', 'btnsx' ),
                            'facebook_share'                        => __( 'Facebook Share', 'btnsx' ),
                            'google_share'                          => __( 'Google+ Share', 'btnsx' ),
                            'google_bookmarks_share'                => __( 'Google Bookmarks Share', 'btnsx' ),
                            'home_page'                             => __( 'Home Page', 'btnsx' ),
                            'linkedin_share'                        => __( 'LinkedIn Share', 'btnsx' ),
                            'login'                                 => __( 'Login Page', 'btnsx' ),
                            'login_redirect_current_page'           => __( 'Login - Redirect to Current Page', 'btnsx' ),
                            'login_redirect_home_page'              => __( 'Login - Redirect to Home Page', 'btnsx' ),
                            'login_redirect_custom_page'            => __( 'Login - Redirect to Custom Page', 'btnsx' ),
                            'logout'                                => __( 'Logout Page', 'btnsx' ),
                            'logout_redirect_current_page'          => __( 'Logout - Redirect to Current Page', 'btnsx' ),
                            'logout_redirect_home_page'             => __( 'Logout - Redirect to Home Page', 'btnsx' ),
                            'logout_redirect_custom_page'           => __( 'Logout - Redirect to Custom Page', 'btnsx' ),
                            'lost_password'                         => __( 'Lost Password Page', 'btnsx' ),
                            'lost_password_redirect_current_page'   => __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
                            'lost_password_redirect_home_page'      => __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
                            'lost_password_redirect_custom_page'    => __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
                            'mailto'                                => __( 'Mail To', 'btnsx' ),
                            'menu'                                  => __( 'Menu', 'btnsx' ),
                            'newsvine_share'                        => __( 'Newsvine Share', 'btnsx' ),
                            'next_post'                             => __( 'Next Post', 'btnsx' ),
                            'pinterest_share'                       => __( 'Pinterest Share', 'btnsx' ),
                            'popup_maker'                           => __( 'Popup Maker', 'btnsx' ),
                            'post'                                  => __( 'Post/Page/CPT', 'btnsx' ),
                            'previous_page'                         => __( 'Previous Page', 'btnsx' ),
                            'previous_post'                         => __( 'Previous Post', 'btnsx' ),
                            'print'                                 => __( 'Print', 'btnsx' ),
                            'reddit_share'                          => __( 'Reddit Share', 'btnsx' ),
                            'register'                              => __( 'Registration Page', 'btnsx' ),
                            // 'slashdot_share'                     => __( 'Slashdot Share', 'btnsx' ),
                            'skype_call'                            => __( 'Skype Call', 'btnsx' ),
                            'skype_chat'                            => __( 'Skype Chat', 'btnsx' ),
                            'skype_video_call'                      => __( 'Skype Video Call', 'btnsx' ),
                            'sms'                                   => __( 'SMS', 'btnsx' ),
                            'stumbleupon_share'                     => __( 'StumbleUpon Share', 'btnsx' ),
                            'tel'                                   => __( 'Telephone', 'btnsx' ),
                            'tumblr_share'                          => __( 'Tumblr Share', 'btnsx' ),
                            'twitter_share'                         => __( 'Twitter Share', 'btnsx' ),
                            'url'                                   => __( 'URL', 'btnsx' ),
                            'whatsapp_share'                        => __( 'Whatsapp Share', 'btnsx' ),
                            'woocommerce_add_to_cart'               => __( 'Woocommerce - Add to Cart', 'btnsx' ),
                            'woocommerce_add_to_cart_auto_id'       => __( 'Woocommerce - Add to Cart - Auto ID', 'btnsx' ),
                        ),
                        'toggle'        => array(
                            'post'      => array(
                                'fields'        => array('_link_post')
                            ),
                            'menu'      => array(
                                'fields'        => array('_link_menu','_link_menu_display')
                            ),
                            'url'      => array(
                                'fields'        => array('_link')
                            ),
                            'edd_checkout' => array(
                                'fields'        => array('_link_edd_options')
                            ),
                            'edd_straight_to_gateway' => array(
                                'fields'        => array('_link_edd_options')
                            ),
                            'login_redirect_custom_page' => array(
                                'fields'        => array('_link_redirect_url')
                            ),
                            'logout_redirect_custom_page' => array(
                                'fields'        => array('_link_redirect_url')
                            ),
                            'lost_password_redirect_custom_page' => array(
                                'fields'        => array('_link_redirect_url')
                            ),
                            'woocommerce_add_to_cart' => array(
                                'fields'        => array('_link_woocommerce_options')
                            ),
                            'popup_maker' => array(
                                'fields'        => array('_link_popup_maker_options')
                            ),
                            'mailto' => array(
                                'fields'        => array('_link_email','_link_email_subject')
                            ),
                            'skype_call' => array(
                                'fields'        => array('_link_skype_id')
                            ),
                            'skype_chat' => array(
                                'fields'        => array('_link_skype_id')
                            ),
                            'skype_video_call' => array(
                                'fields'        => array('_link_skype_id')
                            ),
                            'sms' => array(
                                'fields'        => array('_link_telephone','_link_sms_content')
                            ),
                        )
                    ),
                    '_link_post'     => array(
                        'type'          => 'select',
                        'label'         => __('Link Post/Page/CPT', 'btnsx'),
                        'help'          => __('Select a post, page or custom post type.', 'btnsx'),
                        'options'       => fl_btnsx_post_links()
                    ),
                    '_link_menu'     => array(
                        'type'          => 'select',
                        'label'         => __('Menu as Dropdown', 'btnsx'),
                        'help'          => __('Select a menu. These are the menus created under Appearance -> Menu.', 'btnsx'),
                        'options'       => $menu_opts
                    ),
                    '_link_menu_display'     => array(
                        'type'          => 'select',
                        'label'         => __('Menu Display', 'btnsx'),
                        'help'          => __('Select whether to display menu <strong>on button click</strong> or <strong>on button hover</strong>.', 'btnsx'),
                        'options'       => array(
                            ''          => __( 'Default', 'btnsx' ),
                            'on_click'  => __( 'On Click', 'btnsx' ),
                            'on_hover'  => __( 'On Hover', 'btnsx' )
                        )
                    ),
                    '_link'     => array(
                        'type'          => 'text',
                        'label'         => __('URL', 'btnsx'),
                        'help'          => __('Add a custom URL.', 'btnsx')
                    ),
                    '_link_edd_options' => array(
                        'type'          => 'select',
                        'label'         => __('EDD Download ID', 'btnsx'),
                        'help'          => __('Select Easy Digital Downloads download ID.', 'btnsx'),
                        'options'       => $fl_btnsx_form->cpt('download','')
                    ),
                    '_link_redirect_url'=> array(
                        'type'          => 'text',
                        'label'         => __('Redirect URL', 'btnsx'),
                        'help'          => __('Only add the last part of the url where you would like to redirect user. If the full URL is http://wwww.example.com/my-page/ then only add /my-page/ in this field. The other part of the URL is computed automatically.', 'btnsx')
                    ),
                    '_link_woocommerce_options' => array(
                        'type'          => 'select',
                        'label'         => __('WooCommerce Product ID', 'btnsx'),
                        'help'          => __('Select a Woocommerce product ID.', 'btnsx'),
                        'options'       => $fl_btnsx_form->cpt('product','')
                    ),
                    '_link_popup_maker_options' => array(
                        'type'          => 'select',
                        'label'         => __('Popup Maker', 'btnsx'),
                        'help'          => __('Select a popup. These are the popup\'s created under Popup Maker -> All Popups.', 'btnsx'),
                        'options'       => $fl_btnsx_form->cpt('popup','')
                    ),
                    '_link_frame_width'     => array(
                        'type'          => 'text',
                        'label'         => __('Iframe Width', 'btnsx'),
                        'help'          => __('Define iframe width in pixels.', 'btnsx')
                    ),
                    '_link_frame_height'     => array(
                        'type'          => 'text',
                        'label'         => __('Iframe Height', 'btnsx'),
                        'help'          => __('Define iframe height in pixels.', 'btnsx')
                    ),
                    '_link_email'     => array(
                        'type'          => 'text',
                        'label'         => __('Email', 'btnsx'),
                        'help'          => __('Add email address where the user should send email.', 'btnsx')
                    ),
                    '_link_email_subject'     => array(
                        'type'          => 'text',
                        'label'         => __('Email Subject', 'btnsx'),
                        'help'          => __('Add subject for the email.', 'btnsx')
                    ),
                    '_link_skype_id'     => array(
                        'type'          => 'text',
                        'label'         => __('Skype ID', 'btnsx'),
                        'help'          => __('Add your Skype ID.', 'btnsx')
                    ),
                    '_link_telephone'     => array(
                        'type'          => 'text',
                        'label'         => __('Telephone Number', 'btnsx'),
                        'help'          => __('Add telephone number to be used for call or sms.', 'btnsx')
                    ),
                    '_link_sms_content'     => array(
                        'type'          => 'text',
                        'label'         => __('SMS Content', 'btnsx'),
                        'help'          => __('Add content to be used for SMS.', 'btnsx')
                    ),
                )
            )
        )
    ),
    'layout'       => array( // Tab
        'title'         => __('Layout', 'btnsx'), // Tab title
        'sections'      => array( // Tab Sections
            'general'       => array( // Section
                'fields'        => array( // Section Fields
                    '_full_width'     => array(
                        'type'          => 'select',
                        'label'         => __('Full Width', 'btnsx'),
                        'help'          => __('Make the button cover the entire width of the container.', 'btnsx'),
                        'options'        => array(
                            ''      => __( 'Default', 'btnsx' ),
                            'no'    => __( 'No', 'btnsx' ),
                            'yes'   => __( 'Yes', 'btnsx' )
                        )
                    ),
                    '_wrap_center'     => array(
                        'type'          => 'select',
                        'label'         => __('Wrap Center', 'btnsx'),
                        'help'          => __('Makes the button centered. Very helpful when you want the button to be centered inside a big container.', 'btnsx'),
                        'options'        => array(
                            ''      => __( 'Default', 'btnsx' ),
                            'no'    => __( 'No', 'btnsx' ),
                            'yes'   => __( 'Yes', 'btnsx' )
                        )
                    ),
                )
            )
        )
    )
));



/**
 * Register a settings form to use in the "form" field type above.
 */
FLBuilder::register_settings_form('btnsx_settings_form', array(
    'title' => __('Example Form Settings', 'btnsx'),
    'tabs'  => array(
        'general'      => array( // Tab
            'title'         => __('General', 'btnsx'), // Tab title
            'sections'      => array( // Tab Sections
                'general'       => array( // Section
                    'title'         => '', // Section Title
                    'fields'        => array( // Section Fields
                        'example'       => array(
                            'type'          => 'text',
                            'label'         => __('Example', 'btnsx'),
                            'default'       => 'Some example text'
                        )
                    )
                )
            )
        ),
        'another'       => array( // Tab
            'title'         => __('Another Tab', 'btnsx'), // Tab title
            'sections'      => array( // Tab Sections
                'general'       => array( // Section
                    'title'         => '', // Section Title
                    'fields'        => array( // Section Fields
                        'another_example' => array(
                            'type'          => 'text',
                            'label'         => __('Another Example', 'btnsx')
                        )
                    )
                )
            )
        )
    )
));

/**
 * Post/Page/CPT links as select options
 * @since  1.9.50
 * @return string
 */
function fl_btnsx_post_links(){
    $post_types = get_post_types( array( 'public' => true ) );
    $options = array();
    foreach ( $post_types as $key => $type ) {
        if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
            $args = array(
                'post_type' => $type,
                'post_status' => 'publish',
                'posts_per_page' => -1
            );
            $query = new WP_Query( $args );
            // The Loop
            $opts = array();
            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    $opts[get_permalink()] = get_the_title();
                }
                $options[] = array(
                    'label' => ucfirst( $type ),
                    'options' => $opts
                );
            } else {
                // no posts found
            }
            /* Restore original Post Data */
            wp_reset_postdata();
        }
    }
    return $options;
}