<?php
/*
Plugin Name: Buttons X
Plugin URI: https://www.button.sx
Description: Extremely powerful button builder for WordPress.
Version: 1.9.64
Author: اسکریپت دات کام
Author URI: https://www.اسکریپت.com
License: Envato Split License
Text Domain: btnsx
Domain Path: /languages
*/

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

define( 'BTNSX__VERSION', '1.9.64' );
define( 'BTNSX__MIN_WP_VERSION', '4.0' );
define( 'BTNSX__PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BTNSX__PLUGIN_DIR', plugin_dir_path( __FILE__ ) );

global $wp_version;
if ( $wp_version >= BTNSX__MIN_WP_VERSION ) {
    register_activation_hook( __FILE__, 'btnsx_activate' );
    register_activation_hook( __FILE__, 'network_activate' );
    add_action( 'wpmu_new_blog', 'btnsx_blog_activate', 100, 2 );
    add_action( 'activated_plugin', 'welcome_redirect', 10, 2 );
}
/**
 * Function to set the default settings
 * @since  0.1
 */
function btnsx_activate() {
    $value = array(
        'css' => 'inline',
        'social' => array( 'post', 'page' ),
        'social_counters_cache' => '24',
        'after_content_priority' => 10,
        'before_content_priority' => 10
    );
    add_option( 'btnsx_settings', $value );
}
/**
 * Redirect to welcome screen when plugin is activated
 * @since  0.1
 */
function welcome_redirect($plugin,$network_activate) {
    if( $network_activate === false ){
        if( $plugin == plugin_basename( __FILE__ ) ) {
            wp_redirect( admin_url('admin.php?page=btnsx') );
            exit;
        }
    }
}
/**
 * Function to set default options for every blog when olugin is network activated
 * @since  0.3
 * @param  boolean    $sitewide
 */
function network_activate( $sitewide ) {
    do_multisite( $sitewide, 'btnsx_activate' );
}
function do_multisite( $sitewide, $method, $args = array() ) {
    if ( is_multisite() && $sitewide ) {
        global $wpdb, $blog_id;
        $dbquery = 'SELECT blog_id FROM '.$wpdb->blogs;
        $ids = $wpdb->get_col( $dbquery );
        foreach ( $ids as $id ) {
            switch_to_blog( $id );
            call_user_func_array( $method, array( $args ) );
        }
        switch_to_blog( $blog_id );
    } else call_user_func_array( $method, array( $args ) );
}

/**
 * Function to set default options when a new blog is created
 * @since  0.3
 * @param  int    $blog_id
 * @param  int    $user_id
 */
function btnsx_blog_activate($blog_id, $user_id) {
    switch_to_blog( $blog_id );
    $value = array(
        'css' => 'inline',
        'dual_buttons' => '1',
        'social_buttons' => '1',
        'social' => array( 'post', 'page' ),
        'social_counters_cache' => '86400'
    );
    add_option( 'btnsx_settings', $value );
}

$btnsx_settings = get_option( 'btnsx_settings' );

/**
 * Include classes
 */
require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.clone.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.portation.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.widget.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.woo.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.mce.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.ajax.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.menu.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.wapi.php' );
require_once( BTNSX__PLUGIN_DIR . 'includes/class.external.plugins.php' );
if( isset( $btnsx_settings['social_buttons'] ) && $btnsx_settings['social_buttons'] === '1' ) {
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.social.php' );
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.widget.social.php' );
}
if( isset( $btnsx_settings['dual_buttons'] ) && $btnsx_settings['dual_buttons'] === '1' ) {
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.dual.php' );
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.widget.dual.php' );
}
if( isset( $btnsx_settings['social_counters'] ) && $btnsx_settings['social_counters'] === '1' ) {
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.counter.php' );
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.widget.social.counters.php' );
}
// Bulk export only if PHP version greater or equal to 5.4
if( version_compare( PHP_VERSION, '5.4.0', '>=' ) ){
    require_once( BTNSX__PLUGIN_DIR . 'includes/class.bulk.actions.php' );
}


/**
 * Include builder files
 */

// Visual Composer
require_once( BTNSX__PLUGIN_DIR . 'builders/composer/mappings.php' );

// Beaver Builder
function btnsx_beaver_builder_module() {
    if ( class_exists( 'FLBuilder' ) ) {
        require_once( BTNSX__PLUGIN_DIR . 'builders/beaver-builder/module.php' );
    }
}
add_action( 'init', 'btnsx_beaver_builder_module' );

/**
 * Plugin Updates
 */
require 'plugin_update_check.php';
if( isset( $btnsx_settings['purchase_code'] ) && $btnsx_settings['purchase_code'] != null ) {
    $btnsxUpdateChecker = new PluginUpdateChecker_2_0 (
       'https://kernl.us/api/v1/updates/56beec00cf04edb907fe1b7a/',
       __FILE__,
       'btnsx',
       1
    );
    $btnsxUpdateChecker->purchaseCode = str_replace(' ', '', $btnsx_settings['purchase_code']);
}

// if( !isset($btnsxUpdateChecker) || isset($btnsxUpdateChecker) && $btnsxUpdateChecker === NULL || isset($btnsxUpdateChecker) && $btnsxUpdateChecker->requestInfo() === NULL ) {
//     add_action( 'admin_notices', 'btnsx_license_notice' );
// }

/**
 * Admin notice on update fail
 */
function btnsx_license_notice() {
    ?>
    <div class="notice notice-error is-dismissible" style="padding:.75rem 1rem;margin-left: 0;">
        <div class="two-col" style="display:block;">
            <div class="col" style="display:inline-block;margin-right:10px;">
                <span class="dashicons-btnsx-logo" style="display:block;font-size:32px;color:#dc3232;"></span>
            </div>
            <div class="col" style="display:inline-block;">
                <p style="font-size:14px;margin:0;"><strong>Buttons X - Automatic Update Error!!!</strong></p>
                <p style="margin:0;">
                    <?php echo sprintf( 'Either your license (purchase code) has expired or you haven\'t added it on <a href="%1$s">settings</a> page.',
                        esc_url( get_admin_url(null,'admin.php?page=buttons-x-settings#btnsx-tabs-0-0-0') )
                    ); ?>
                </p>
            </div>
            <a target="_blank" class="button button-primary" href="http://codecanyon.net/item/buttons-x-powerful-button-builder-for-wordpress/12710619?ref=GautamThapar&license=regular&open_purchase_for_item_id=12710619&purchasable=source" style="float:right;margin:10px 15px 0 0;">Get a new license</a>
        </div>
    </div>
    <?php
}

/**
 * Function to output https if the page supports https.
 * @since  0.1
 * @param  array    $uploads
 * @return array
 */
function https_filter( $uploads ) {
	if( is_ssl() ){
  		$uploads['baseurl'] = str_ireplace('http', 'https', $uploads['baseurl']);
  	}
  	return $uploads;
}
// add_filter( 'upload_dir', 'https_filter' );


/**
 * Ajax script to dismiss auto responsive notice
 * @since  1.9.0
 * @return html
 */
function auto_responsive_style_notice_script() {
    $ajax_nonce = wp_create_nonce( 'auto-responsive-notice' );
    ?>
        <script type="text/javascript">
            jQuery(document).ready(function($){
                jQuery(document).on( 'click', '#btnsx-auto-responsive-notice .notice-dismiss', function() {
                    jQuery.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        data: {
                            action: 'btnsx_auto_responsive_style_notice',
                            security: '<?php echo $ajax_nonce; ?>'
                        }
                    });
                });
            });
        </script>
    <?php
}
add_action( 'admin_head', 'auto_responsive_style_notice_script' );

/**
 * Ajax callback for suto responsive style notice
 * @since  1.9.0
 */
function auto_responsive_style_notice_callback() {
    check_ajax_referer( 'auto-responsive-notice', 'security' );
    update_option( 'btnsx_auto_responsive_style_notice', true );
}
add_action( 'wp_ajax_btnsx_auto_responsive_style_notice', 'auto_responsive_style_notice_callback' );

/**
 * Auto Responsive Style Notice
 * @since  1.9.0
 * @return html
 */
// add_action( 'admin_notices', 'auto_responsive_style_notice' );
function auto_responsive_style_notice() {
    $dismiss = get_option('btnsx_auto_responsive_style_notice');
    if( !$dismiss ){
        $url = admin_url() . 'admin.php?page=buttons-x-settings';
        $link = sprintf( 
            wp_kses( 
                __( '<strong>Buttons X %1$s</strong> adds responsive style options for single buttons. You can find these on button edit screen under Buttons X - Options Panel > Advanced > Responsive. Automatic responsive style used in earlier verions is turned off by default. You can re-enable them from the <a href="%2$s">settings page</a> under general settings. Read more about this new feature <a href="%3$s">here</a>.', 'btnsx' )
                , array(  'a' => array( 'href' => array() ) ) ), BTNSX__VERSION, esc_url( $url ), esc_url( 'https://www.button.sx/responsive-button-styles/' ) );
    ?>
        <div id="btnsx-auto-responsive-notice" class="error notice is-dismissible">
            <p><?php echo $link; ?></p>
        </div>
    <?php
    }
}

/**
 * Solves ACF script conflict
 * @since  1.9.42
 * @return string
 */
function btnsx_acf() {
    if( class_exists( 'acf' ) ){
        $screen = get_current_screen();
        if ( in_array( $screen->id, array( 'buttons-x', 'edit-buttons-x', 'buttons-x_page_buttons-x-settings', 'buttons-x_page_buttons-x-import' ) ) ) {
        ?>
            <script type="text/javascript">var acf = {}; acf.postbox = {}; acf.postbox.render = function(){}; acf.media = {}; acf.media.init = function(){}; acf.fields = {}; acf.fields.wysiwyg = {}; acf.do_action = function(){}; acf.conditional_logic = {}; acf.conditional_logic.init = function(){}; acf.o = {}; acf.o.post_id = '1'; acf.screen = {}; acf.screen.post_id = '2'; acf.fields.tab = {}; acf.fields.tab.refresh = function(){}; acf.fields.google_map = {}; acf.helpers = {}; acf.helpers.get_atts = function(){}; acf.serialize = function(){}; acf.serialize_form = function(){};</script>
        <?php
        }
    }
}
add_action( 'admin_head', 'btnsx_acf', 9 );

function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

// disable confliciting scripts and styles of other plugins
add_action('wp_print_scripts', 'disable_pluginsjs_selectively', 100 );
function disable_pluginsjs_selectively( ) {
    wp_dequeue_style( 'materialize-components-css' ); // Swift Framework
    wp_dequeue_script( 'materialize' ); // Swift Framework
}