$(document).ready(function() {
    $('.tool').tooltip();

    var input = document.getElementById("images2");
    if (input) {
        var formdata = false;
        if (window.FormData) {
            formdata = new FormData();
        }
        input.addEventListener("change", function(evt) {
            var i = 0, len = this.files.length, img, reader, file;
            for (; i < len; i++) {
                file = this.files[i];
                if (!!file.type.match(/image.*/)) {
                    if (window.FileReader) {
                        reader = new FileReader();
                        reader.onloadend = function(e) {
                        };
                        reader.readAsDataURL(file);
                    }

                    if (formdata) {
                        formdata.append("images2", file);
                        var d = new Date();
                        var n = d.getTime();
                        var r = Math.floor((Math.random() * 100) + 1);
                        formdata.append("hash", n + "" + r);
                        formdata.append("extra", 'extra-data');
                        formdata.append("size", $('#images2').attr("data-bind"));
                    }

                    if (formdata) {
                        var http = new XMLHttpRequest();
                        var http_arr = new Array();
                        http_arr.push(http);
                        var ProgressGroup = document.getElementById('response2');
                        ProgressGroup.innerHTML = '';
                        var Progress = document.createElement('div');
                        Progress.className = 'progress';
                        var ProgressBar = document.createElement('div');
                        ProgressBar.className = 'progress-bar';
                        var ProgressText = document.createElement('div');
                        ProgressText.className = 'progress-text';
                        Progress.appendChild(ProgressBar);
                        Progress.appendChild(ProgressText);
                        ProgressGroup.appendChild(Progress);
                        var oldLoaded = 0;
                        var oldTime = 0;
                        http.upload.addEventListener('progress', function(event) {
                            if (oldTime == 0) {
                                oldTime = event.timeStamp;
                            }
                            var fileName = file.name;
                            var fileLoaded = event.loaded;
                            var fileTotal = event.total;
                            var fileProgress = parseInt((fileLoaded / fileTotal) * 100) || 0;
                            var speed = speedRate(oldTime, event.timeStamp, oldLoaded, event.loaded);
                            ProgressBar.innerHTML = fileName + ' uploading...';
                            ProgressBar.style.width = fileProgress + '%';
                            ProgressText.innerHTML = fileProgress + '% Upload Speed: ' + speed + 'KB/s';
                            oldTime = event.timeStamp;
                            oldLoaded = event.loaded;
                        }, false);

                        http.open('POST', "/upload/image", true);
                        http.send(formdata);
                        http.onreadystatechange = function(event) {
                            if (http.readyState == 4 && http.status == 200) {
                                ProgressBar.style.background = '';
                                try {
                                    var server = JSON.parse(http.responseText);
                                    if (server.status) {
                                        ProgressBar.className += ' progress-bar-success';
                                        ProgressBar.innerHTML = server.message;
                                        $('#upanh').attr("value", server.name);
                                        $('#small_img').attr("src", "/uploads/tmp/" + server.name);
                                    } else {
                                        ProgressBar.className += ' progress-bar-danger';
                                        ProgressBar.innerHTML = server.message;
                                    }
                                } catch (e) {
                                    ProgressBar.className += ' progress-bar-danger';
                                    ProgressBar.innerHTML = 'Error!';
                                }
                            }
                            http.removeEventListener('progress');
                        };
                    }
                }
                else
                {
                    var ProgressGroup = document.getElementById('response2');
                    ProgressGroup.innerHTML = "<h4 style='color: red'>Invalid File!</h4>";
                }
            }

        }, false);
    }


    var large_icon = document.getElementById("large_icon");

    if (large_icon) {
        var formdata = false;
        if (window.FormData) {
            formdata = new FormData();
        }

        large_icon.addEventListener("change", function(evt) {
            var i = 0, len = this.files.length, img, reader, file;

            for (; i < len; i++) {
                file = this.files[i];


                if (!!file.type.match(/image.*/)) {
                    if (window.FileReader) {
                        reader = new FileReader();
                        reader.onloadend = function(e) {
                        };
                        reader.readAsDataURL(file);
                    }

                    if (formdata) {
                        formdata.append("images2", file);
                        var d = new Date();
                        var n = d.getTime();
                        var r = Math.floor((Math.random() * 100) + 1);
                        formdata.append("hash", n + "" + r);
                        formdata.append("extra", 'extra-data');
                        formdata.append("size", $('#large_icon').attr("data-bind"));
                    }

                    if (formdata) {
                        var http = new XMLHttpRequest();
                        var http_arr = new Array();
                        http_arr.push(http);
                        var ProgressGroup = document.getElementById('response3');
                        ProgressGroup.innerHTML = '';
                        var Progress = document.createElement('div');
                        Progress.className = 'progress';
                        var ProgressBar = document.createElement('div');
                        ProgressBar.className = 'progress-bar';
                        var ProgressText = document.createElement('div');
                        ProgressText.className = 'progress-text';
                        Progress.appendChild(ProgressBar);
                        Progress.appendChild(ProgressText);
                        ProgressGroup.appendChild(Progress);
                        var oldLoaded = 0;
                        var oldTime = 0;
                        http.upload.addEventListener('progress', function(event) {
                            if (oldTime == 0) {
                                oldTime = event.timeStamp;
                            }
                            var fileName = file.name;
                            var fileLoaded = event.loaded;
                            var fileTotal = event.total;
                            var fileProgress = parseInt((fileLoaded / fileTotal) * 100) || 0;
                            var speed = speedRate(oldTime, event.timeStamp, oldLoaded, event.loaded);
                            ProgressBar.innerHTML = fileName + ' uploading...';
                            ProgressBar.style.width = fileProgress + '%';
                            ProgressText.innerHTML = fileProgress + '% Upload Speed: ' + speed + 'KB/s';
                            oldTime = event.timeStamp;
                            oldLoaded = event.loaded;
                        }, false);

                        http.open('POST', "/upload/image", true);
                        http.send(formdata);
                        http.onreadystatechange = function(event) {
                            if (http.readyState == 4 && http.status == 200) {
                                ProgressBar.style.background = '';
                                try {
                                    var server = JSON.parse(http.responseText);
                                    if (server.status) {
                                        ProgressBar.className += ' progress-bar-success';
                                        ProgressBar.innerHTML = server.message;
                                        $('#licon').attr("value", server.name);
                                        $('#large_img').attr("src", "/uploads/tmp/" + server.name);
                                    } else {
                                        ProgressBar.className += ' progress-bar-danger';
                                        ProgressBar.innerHTML = server.message;
                                    }
                                } catch (e) {
                                    ProgressBar.className += ' progress-bar-danger';
                                    ProgressBar.innerHTML = 'Error!';
                                }
                            }
                            http.removeEventListener('progress');
                        };
                    }
                }
                else
                {
                    var ProgressGroup = document.getElementById('response3');
                    ProgressGroup.innerHTML = "<h4 style='color: red'>Invalid File!</h4>";
                }
            }

        }, false);
    }


    var preview_file = document.getElementById("uploadScreenshot");
    if (preview_file) {
        var formdata = false;
        if (window.FormData) {
            formdata = new FormData();
        }

        preview_file.addEventListener("change", function(evt) {
            var i = 0, len = this.files.length, img, reader, file;

            for (; i < len; i++) {
                file = this.files[i];

                if (!!file.type.match(/zip.*/)) {
                    if (window.FileReader) {
                        reader = new FileReader();
                        reader.onloadend = function(e) {
                        };
                        reader.readAsDataURL(file);
                    }

                    if (formdata) {
                        formdata.append("images2", file);
                        var d = new Date();
                        var n = d.getTime();
                        var r = Math.floor((Math.random() * 100) + 1);
                        formdata.append("hash", n + "" + r);
                        formdata.append("extra", 'extra-data');
                        formdata.append("size", "preview");
                    }

                    if (formdata) {
                        var http = new XMLHttpRequest();
                        var http_arr = new Array();
                        http_arr.push(http);
                        var ProgressGroup = document.getElementById('response4');
                        ProgressGroup.innerHTML = '';
                        var Progress = document.createElement('div');
                        Progress.className = 'progress';
                        var ProgressBar = document.createElement('div');
                        ProgressBar.className = 'progress-bar';
                        var ProgressText = document.createElement('div');
                        ProgressText.className = 'progress-text';
                        Progress.appendChild(ProgressBar);
                        Progress.appendChild(ProgressText);
                        ProgressGroup.appendChild(Progress);
                        var oldLoaded = 0;
                        var oldTime = 0;
                        http.upload.addEventListener('progress', function(event) {
                            if (oldTime == 0) {
                                oldTime = event.timeStamp;
                            }
                            var fileName = file.name;
                            var fileLoaded = event.loaded;
                            var fileTotal = event.total;
                            var fileProgress = parseInt((fileLoaded / fileTotal) * 100) || 0;
                            var speed = speedRate(oldTime, event.timeStamp, oldLoaded, event.loaded);
                            ProgressBar.innerHTML = fileName + ' uploading...';
                            ProgressBar.style.width = fileProgress + '%';
                            ProgressText.innerHTML = fileProgress + '% Upload Speed: ' + speed + 'KB/s';
                            oldTime = event.timeStamp;
                            oldLoaded = event.loaded;
                        }, false);

                        http.open('POST', "/upload/file", true);
                        http.send(formdata);
                        http.onreadystatechange = function(event) {
                            if (http.readyState == 4 && http.status == 200) {
                                ProgressBar.style.background = '';
                                try {
                                    var server = JSON.parse(http.responseText);
                                    if (server.status) {
                                        ProgressBar.className += ' progress-bar-success';
                                        ProgressBar.innerHTML = server.message;
                                        $('#screenshot').children().attr("value", server.name);
                                        $('#screenshot').children().html(server.title);
                                    } else {
                                        ProgressBar.className += ' progress-bar-danger';
                                        ProgressBar.innerHTML = server.message;
                                    }
                                } catch (e) {
                                    ProgressBar.className += ' progress-bar-danger';
                                    ProgressBar.innerHTML = 'Error!';
                                }
                            }
                            http.removeEventListener('progress');
                        };
                    }
                }
                else
                {
                    var ProgressGroup = document.getElementById('response4');
                    ProgressGroup.innerHTML = "<h4 style='color: red'>Invalid File!</h4>";
                }
            }

        }, false);
    }


    var main_file = document.getElementById("uploadMainFile");
    if (main_file) {
        var formdata = false;
        if (window.FormData) {
            formdata = new FormData();
        }

        main_file.addEventListener("change", function(evt) {
            var i = 0, len = this.files.length, img, reader, file;

            for (; i < len; i++) {
                file = this.files[i];

                if (!!file.type.match(/zip.*/)) {
                    if (window.FileReader) {
                        reader = new FileReader();
                        reader.onloadend = function(e) {
                        };
                        reader.readAsDataURL(file);
                    }

                    if (formdata) {
                        formdata.append("images2", file);
                        var d = new Date();
                        var n = d.getTime();
                        var r = Math.floor((Math.random() * 100) + 1);
                        formdata.append("hash", n + "" + r);
                        formdata.append("extra", 'extra-data');
                        formdata.append("size", "main");
                    }

                    if (formdata) {
                        var http = new XMLHttpRequest();
                        var http_arr = new Array();
                        http_arr.push(http);
                        var ProgressGroup = document.getElementById('response5');
                        ProgressGroup.innerHTML = '';
                        var Progress = document.createElement('div');
                        Progress.className = 'progress';
                        var ProgressBar = document.createElement('div');
                        ProgressBar.className = 'progress-bar';
                        var ProgressText = document.createElement('div');
                        ProgressText.className = 'progress-text';
                        Progress.appendChild(ProgressBar);
                        Progress.appendChild(ProgressText);
                        ProgressGroup.appendChild(Progress);
                        var oldLoaded = 0;
                        var oldTime = 0;
                        http.upload.addEventListener('progress', function(event) {
                            if (oldTime == 0) {
                                oldTime = event.timeStamp;
                            }
                            var fileName = file.name;
                            var fileLoaded = event.loaded;
                            var fileTotal = event.total;
                            var fileProgress = parseInt((fileLoaded / fileTotal) * 100) || 0;
                            var speed = speedRate(oldTime, event.timeStamp, oldLoaded, event.loaded);
                            ProgressBar.innerHTML = fileName + ' uploading...';
                            ProgressBar.style.width = fileProgress + '%';
                            ProgressText.innerHTML = fileProgress + '% Upload Speed: ' + speed + 'KB/s';
                            oldTime = event.timeStamp;
                            oldLoaded = event.loaded;
                        }, false);

                        http.open('POST', "/upload/file", true);
                        http.send(formdata);
                        http.onreadystatechange = function(event) {
                            if (http.readyState == 4 && http.status == 200) {
                                ProgressBar.style.background = '';
                                try {
                                    var server = JSON.parse(http.responseText);
                                    if (server.status) {
                                        ProgressBar.className += ' progress-bar-success';
                                        ProgressBar.innerHTML = server.message;
                                        $('#main_file').children().attr("value", server.name);
                                        $('#main_file').children().html(server.title);
                                    } else {
                                        ProgressBar.className += ' progress-bar-danger';
                                        ProgressBar.innerHTML = server.message;
                                    }
                                } catch (e) {
                                    ProgressBar.className += ' progress-bar-danger';
                                    ProgressBar.innerHTML = 'Error!';
                                }
                            }
                            http.removeEventListener('progress');
                        };
                    }
                }
                else
                {
                    var ProgressGroup = document.getElementById('response5');
                    ProgressGroup.innerHTML = "<h4 style='color: red'>Invalid File!</h4>";
                }
            }

        }, false);
    }

});

$(window).on('resize', function() {
    if ($(window).width() > 768)
        $('#sidebar-collapse').collapse('show');
});
$(window).on('resize', function() {
    if ($(window).width() <= 767)
        $('#sidebar-collapse').collapse('hide');
});

function speedRate(oldTime, newTime, oldLoaded, newLoaded) {
    var timeProcess = newTime - oldTime;
    if (timeProcess != 0) {
        var currentLoadedPerMilisecond = (newLoaded - oldLoaded) / timeProcess;
        return parseInt((currentLoadedPerMilisecond * 1000) / 1024);
    } else {
        return parseInt(newLoaded / 1024);
    }
}